/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignBudgetEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.mapper.SubComActivityDesignBudgetMapper;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import jodd.util.StringUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignBudgetRepository
extends ServiceImpl<SubComActivityDesignBudgetMapper, SubComActivityDesignBudgetEntity> {
    public List<SubComActivityDesignBudgetEntity> findListByCode(String activityDesignCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignBudgetEntity::getActivityDesignCode, (Object)activityDesignCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignBudgetEntity> listByActivityDesignCodeList(List<String> activityDesignCodeList) {
        if (CollectionUtils.isEmpty(activityDesignCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignBudgetEntity::getActivityDesignCode, activityDesignCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByActivityCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(SubComActivityDesignBudgetEntity::getActivityDesignCode, codes);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignBudgetVo> findByActivityDesignDetailCode(String activityDesignDetailCode) {
        if (StringUtil.isEmpty((CharSequence)activityDesignDetailCode)) {
            return Collections.emptyList();
        }
        SubComActivityDesignBudgetDto dto = new SubComActivityDesignBudgetDto();
        dto.setActivityDesignDetailCode(activityDesignDetailCode);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((SubComActivityDesignBudgetMapper)this.baseMapper).findByActivityDesignDetailCodes(dto);
    }

    public List<SubComActivityDesignBudgetVo> findByActivityDesignDetailCodes(List<String> activityDesignDetailCodeList) {
        if (CollectionUtil.isEmpty(activityDesignDetailCodeList)) {
            return Collections.emptyList();
        }
        SubComActivityDesignBudgetDto dto = new SubComActivityDesignBudgetDto();
        dto.setActivityDesignDetailCodeList(activityDesignDetailCodeList);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((SubComActivityDesignBudgetMapper)this.baseMapper).findByActivityDesignDetailCodes(dto);
    }

    public List<SubComActivityDesignBudgetEntity> listByActivityCodes(List<String> activityDesignCodeList) {
        if (CollectionUtils.isEmpty(activityDesignCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(SubComActivityDesignBudgetEntity::getActivityDesignCode, activityDesignCodeList)).list();
    }

    public List<SubComActivityDesignBudgetEntity> listByActivityDetailCodes(List<String> activityDetailCodes) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignBudgetEntity::getActivityDesignDetailCode, activityDetailCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Page<SubComActivityDesignBudgetVo> findByActivityDesignCode(Page<SubComActivityDesignPlanVo> page, String activityDesignCode) {
        return ((SubComActivityDesignBudgetMapper)this.baseMapper).findByActivityDesignCode(page, activityDesignCode, TenantUtils.getTenantCode());
    }

    public BigDecimal findBudgetUsedAmountSum(SubComActivityDesignBudgetDto dto) {
        return ((SubComActivityDesignBudgetMapper)this.baseMapper).findBudgetUsedAmountSum(dto);
    }

    public Page<SubComActivityDesignBudgetVo> findBudgetByProcessNoConditionsCreate(Page<SubComActivityDesignBudgetVo> page, SubComActivityDesignBudgetDto dto) {
        return ((SubComActivityDesignBudgetMapper)this.baseMapper).findBudgetByProcessNoConditionsCreate(page, dto);
    }
}

