/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanRollbackBudgetEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.mapper.SubComActivityDesignDetailMapper;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignDetailModifyVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.RelationPolicySelectVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SpecialCostVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignDetailRepository
extends ServiceImpl<SubComActivityDesignDetailMapper, SubComActivityDesignDetailEntity> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<SubComActivityDesignDetailEntity> findListByCodeList(List<String> activityDesignCodeList) {
        if (CollectionUtil.isEmpty(activityDesignCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignDetailEntity::getActivityDesignCode, activityDesignCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SubComActivityDesignDetailEntity> findListByCode(String activityDesignCode) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignDetailEntity::getActivityDesignCode, (Object)activityDesignCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SubComActivityDesignDetailDto> findDtoList(SubComActivityDesignDetailDto dto) {
        List<SubComActivityDesignDetailEntity> list = this.findList(dto);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, SubComActivityDesignDetailEntity.class, SubComActivityDesignDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        return dtoList;
    }

    public List<SubComActivityDesignDetailEntity> findList(SubComActivityDesignDetailDto dto) {
        if (null == dto) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)dto.getActivityDesignCode()), SubComActivityDesignDetailEntity::getActivityDesignCode, (Object)dto.getActivityDesignCode())).eq(com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)dto.getTemplateConfigCode()), SubComActivityDesignDetailEntity::getTemplateConfigCode, (Object)dto.getTemplateConfigCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignDetailEntity> listByActivityDesignCodeList(List<String> activityDesignCodeList) {
        if (CollectionUtils.isEmpty(activityDesignCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignDetailEntity::getActivityDesignCode, activityDesignCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SpecialCostVo> findSpecialCost(SubComActivityDesignDetailDto subComActivityDesignDetailDto) {
        return ((SubComActivityDesignDetailMapper)this.getBaseMapper()).findSpecialCost(subComActivityDesignDetailDto);
    }

    public List<SubComActivityDesignDetailVo> findBudgetDetailByConditions(SubComActivityDesignDetailDto subComActivityDesignDetailDto) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)subComActivityDesignDetailDto.getProcessNo())) {
            Validate.notNull((Object)subComActivityDesignDetailDto.getFeeYearMonth(), (String)"\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)subComActivityDesignDetailDto.getOrgCodeSet()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        return ((SubComActivityDesignDetailMapper)this.getBaseMapper()).findBudgetDetailByConditions(subComActivityDesignDetailDto);
    }

    public List<SubComActivityDesignDetailVo> findApportionDetailByConditions(SubComActivityDesignDetailDto subComActivityDesignDetailDto) {
        Validate.notNull((Object)subComActivityDesignDetailDto.getFeeYearMonth(), (String)"\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)subComActivityDesignDetailDto.getOrgCodeSet()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return ((SubComActivityDesignDetailMapper)this.getBaseMapper()).findApportionDetailByConditions(subComActivityDesignDetailDto);
    }

    public void deleteByActivityCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(SubComActivityDesignDetailEntity::getActivityDesignCode, codes);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignDetailEntity> findDesignDetailByCodeList(Set<String> activityDetailCodes) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignDetailEntity::getActivityDesignDetailCode, activityDetailCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Page<SubComActivityDesignDetailVo> closeFindDetail(Page<SubComActivityDesignDetailVo> page, SubComActivityDesignDetailDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return ((SubComActivityDesignDetailMapper)this.baseMapper).closeFindDetail(page, dto);
    }

    public List<SubComActivityDesignDetailVo> findByIds(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        SubComActivityDesignDetailDto detailDto = new SubComActivityDesignDetailDto();
        detailDto.setIds(ids);
        detailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailDto.setTenantCode(TenantUtils.getTenantCode());
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findByIds(detailDto);
    }

    public SubComActivityDesignDetailVo findById(String id) {
        if (StringUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        SubComActivityDesignDetailDto detailDto = new SubComActivityDesignDetailDto();
        detailDto.setId(id);
        detailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailDto.setTenantCode(TenantUtils.getTenantCode());
        List<SubComActivityDesignDetailVo> designDetailVos = ((SubComActivityDesignDetailMapper)this.baseMapper).findByIds(detailDto);
        if (CollectionUtil.isNotEmpty(designDetailVos)) {
            return designDetailVos.get(0);
        }
        return null;
    }

    public List<SubComActivityDesignDetailVo> findByActivityNumber(String activityNumber) {
        SubComActivityDesignDetailDto detailDto = new SubComActivityDesignDetailDto();
        detailDto.setActivityNumber(activityNumber);
        detailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailDto.setTenantCode(TenantUtils.getTenantCode());
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findByActivityNumber(detailDto);
    }

    public BigDecimal findActivityLowestPrice(SubComActivityDesignDetailVo subComActivityDesignDetailVo) {
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findActivityLowestPrice(subComActivityDesignDetailVo);
    }

    public List<SubComActivityDesignDetailVo> findActivityLowestPriceByKeyList(List<String> keyList) {
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findActivityLowestPriceByKeyList(keyList);
    }

    public void close(String activityDesignDetailCode, String activityStatus, String activityItemStatus, String rollbackBudgetTag, BigDecimal refundAmount) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)activityDesignDetailCode)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(SubComActivityDesignDetailEntity::getActivityStatus, (Object)activityStatus);
        updateWrapper.set(SubComActivityDesignDetailEntity::getRefundAmount, (Object)refundAmount);
        updateWrapper.set(SubComActivityDesignDetailEntity::getRollbackBudgetTag, (Object)rollbackBudgetTag);
        updateWrapper.set(SubComActivityDesignDetailEntity::getActivityDetailStatus, (Object)activityItemStatus);
        updateWrapper.in(SubComActivityDesignDetailEntity::getActivityDesignDetailCode, new Object[]{activityDesignDetailCode});
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignDetailVo> findDetailByDetailCodes(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findDetailByDetailCodes(detailCodes, TenantUtils.getTenantCode());
    }

    public List<SubComActivityDesignDetailVo> findActivityLowestPriceByConditions(SubComActivityDesignDetailVo conditionVo) {
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findActivityLowestPriceByConditions(conditionVo);
    }

    public void updateBatchProcessStatus(String processNo, String processStatus) {
        if (StringUtils.isEmpty((CharSequence)processNo) || StringUtils.isEmpty((CharSequence)processStatus)) {
            return;
        }
        String activityDetailStatus = null;
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            activityDetailStatus = ActivityStatusEnum.PASS.getCode();
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            activityDetailStatus = ActivityStatusEnum.REJECT_AND_BUDGET.getCode();
        }
        if (ProcessStatusEnum.COMMIT.getDictCode().equals(processStatus)) {
            activityDetailStatus = ActivityStatusEnum.IN_APPROVAL_AND_BUDGET.getCode();
        }
        if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)activityDetailStatus)) {
            ((SubComActivityDesignDetailMapper)this.baseMapper).updateBatchProcessStatus(processNo, activityDetailStatus);
        }
    }

    public void autoUpdateActivityDetailStatus(String processStatus, String activityStatus) {
        ((SubComActivityDesignDetailMapper)this.baseMapper).autoUpdateActivityDetailStatus(processStatus, activityStatus, TenantUtils.getTenantCode());
    }

    public List<SubComActivityDesignDetailEntity> findByDetailProcessNo(String processNo) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(SubComActivityDesignDetailEntity::getActivityDetailStatus, (Object)ActivityStatusEnum.CLOSE_IN_APPROVAL.getCode())).eq(SubComActivityDesignDetailEntity::getDetailProcessNo, (Object)processNo)).list();
    }

    public Page<SubComActivityDesignDetailVo> findByConditionsWithDetailProcessNo(Page<SubComActivityDesignDetailVo> page, String processNo, String tenantCode) {
        tenantCode = Optional.ofNullable(tenantCode).orElse(TenantUtils.getTenantCode());
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findByConditionsWithDetailProcessNo(page, processNo, tenantCode);
    }

    public void updateDetailActivityStatus(String processNo, String processStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(SubComActivityDesignDetailEntity::getActivityDetailStatus, (Object)processStatus)).set(SubComActivityDesignDetailEntity::getWillRefundAmount, (Object)BigDecimal.ZERO)).eq(SubComActivityDesignDetailEntity::getDetailProcessNo, (Object)processNo)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public List<SubComActivityDesignDetailVo> findSubComActivityDetailItemStatus(List<String> activityDesignDetailCodeList) {
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findSubComActivityDetailItemStatus(activityDesignDetailCodeList);
    }

    public Page<SubComActivityDesignDetailVo> findByProcessNoConditionsCreate(Page<SubComActivityDesignDetailVo> page, SubComActivityDesignDetailDto dto) {
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findByProcessNoConditionsCreate(page, dto);
    }

    public Page<SubComActivityDesignDetailVo> findToModifyList(Page<SubComActivityDesignDetailVo> page, SubComActivityDesignDetailDto dto) {
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findToModifyList(page, dto);
    }

    public List<RelationPolicySelectVo> hasRelationPolicy(List<String> promotionCodes, String tenantCode) {
        return ((SubComActivityDesignDetailMapper)this.baseMapper).hasRelationPolicy(promotionCodes, tenantCode);
    }

    public List<SubComActivityDesignDetailModifyVo> findSameModifyActivityByDesignDetailCode(List<String> activityDetailCodes) {
        return ((SubComActivityDesignDetailMapper)this.baseMapper).findSameModifyActivityByDesignDetailCode(activityDetailCodes, TenantUtils.getTenantCode());
    }

    public SubComActivityDesignDetailEntity getOneByCode(String activityDesignCode) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return null;
        }
        return (SubComActivityDesignDetailEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(SubComActivityDesignDetailEntity::getActivityDesignCode, (Object)activityDesignCode)).last("limit 1")).one());
    }

    public List<SubComActivityDesignDetailEntity> findCloseNoRollbackDetailList(SubComActivityDesignDetailDto dto) {
        LambdaQueryChainWrapper wrapper = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)dto.getActivityDesignDetailCode()), SubComActivityDesignDetailEntity::getActivityDesignDetailCode, (Object)dto.getActivityDesignDetailCode())).eq(SubComActivityDesignDetailEntity::getRollbackBudgetTag, (Object)ActivityDetailPlanRollbackBudgetEnum.NO_ROLLBACK.getCode());
        if (!CollectionUtils.isEmpty((Collection)dto.getActivityDesignDetailCodeList())) {
            wrapper.in(SubComActivityDesignDetailEntity::getActivityDesignDetailCode, (Collection)dto.getActivityDesignDetailCodeList());
        }
        return wrapper.list();
    }

    public SubComActivityDesignApproveSubmitDto getProcessBusinessForm(List<String> activityDesignCodeList) {
        if (CollectionUtils.isEmpty(activityDesignCodeList)) {
            return new SubComActivityDesignApproveSubmitDto();
        }
        return ((SubComActivityDesignDetailMapper)this.baseMapper).getProcessBusinessForm(activityDesignCodeList, TenantUtils.getTenantCode());
    }

    public List<SubComActivityDesignDetailVo> getInfoByActivityDesignDetailCodes(List<String> activityDesignDetailCodeList) {
        if (CollectionUtils.isEmpty(activityDesignDetailCodeList)) {
            return Collections.emptyList();
        }
        return ((SubComActivityDesignDetailMapper)this.baseMapper).getInfoByActivityDesignDetailCodes(activityDesignDetailCodeList, TenantUtils.getTenantCode());
    }

    public List<SubComActivityDesignDetailEntity> listByActivityNumberList(Set<String> activityNumberSet) {
        if (CollectionUtils.isEmpty(activityNumberSet)) {
            return Collections.emptyList();
        }
        return this.listByActivityNumberList(activityNumberSet, null);
    }

    public List<SubComActivityDesignDetailEntity> listByActivityNumberList(Set<String> activityNumberSet, String isSupplyAmount) {
        if (CollectionUtils.isEmpty(activityNumberSet)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtil.isNotEmpty((CharSequence)isSupplyAmount), SubComActivityDesignDetailEntity::getIsSupplyAmount, (Object)isSupplyAmount)).in(SubComActivityDesignDetailEntity::getActivityNumber, activityNumberSet)).list();
    }
}

