/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignFeeDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.mapper.SubComActivityDesignFeeDetailMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignFeeDetailRepository
extends ServiceImpl<SubComActivityDesignFeeDetailMapper, SubComActivityDesignFeeDetailEntity> {
    public List<SubComActivityDesignFeeDetailEntity> findListByCode(String activityDesignCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignFeeDetailEntity::getActivityDesignCode, (Object)activityDesignCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByActivityCode(String activityDesignCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(SubComActivityDesignFeeDetailEntity::getActivityDesignCode, (Object)activityDesignCode);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignFeeDetailEntity> listByActivityDesignCodeList(List<String> activityDesignCodeList) {
        if (CollectionUtils.isEmpty(activityDesignCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignFeeDetailEntity::getActivityDesignCode, activityDesignCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void deleteByActivityCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(SubComActivityDesignFeeDetailEntity::getActivityDesignCode, codes);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignFeeDetailEntity> findListByDetailCodes(List<String> designDetailCodes) {
        if (CollectionUtils.isEmpty(designDetailCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignFeeDetailEntity::getActivityDesignDetailCode, designDetailCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SubComActivityDesignFeeDetailEntity> listByDesignCodeList(List<String> designCodes) {
        if (CollectionUtils.isEmpty(designCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignFeeDetailEntity::getActivityDesignCode, designCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }
}

