/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignPlanEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.mapper.SubComActivityDesignPlanMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignPlanRepository
extends ServiceImpl<SubComActivityDesignPlanMapper, SubComActivityDesignPlanEntity> {
    public List<SubComActivityDesignPlanEntity> findListByCode(String activityDesignCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignPlanEntity::getActivityDesignCode, (Object)activityDesignCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignPlanEntity> findListByCodes(List<String> activityDesignCodeList) {
        if (CollectionUtils.isEmpty(activityDesignCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignPlanEntity::getActivityDesignCode, activityDesignCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByActivityCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(SubComActivityDesignPlanEntity::getActivityDesignCode, codes);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignPlanEntity> findListByDetailCodes(List<String> detailCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(SubComActivityDesignPlanEntity::getActivityDesignDetailCode, detailCodes)).list();
    }
}

