/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignProductEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.mapper.SubComActivityDesignProductMapper;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignProductRepository
extends ServiceImpl<SubComActivityDesignProductMapper, SubComActivityDesignProductEntity> {
    public List<SubComActivityDesignProductEntity> findListByCode(String activityDesignCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignProductEntity::getActivityDesignCode, (Object)activityDesignCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<SubComActivityDesignProductEntity> findListByCodes(List<String> activityDesignCodeList) {
        if (CollectionUtils.isEmpty(activityDesignCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComActivityDesignProductEntity::getActivityDesignCode, activityDesignCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByActivityCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(SubComActivityDesignProductEntity::getActivityDesignCode, codes);
        this.update((Wrapper)updateWrapper);
    }
}

