/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.mapper.SubComActivityDesignMapper;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.SubComActivityDesignProcessTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SubComActivityDesignRepository
extends ServiceImpl<SubComActivityDesignMapper, SubComActivityDesignEntity> {
    @Resource
    private SubComActivityDesignMapper subComActivityDesignMapper;

    public List<SubComActivityDesignEntity> listByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignEntity::getProcessNo, (Object)processNo)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SubComActivityDesignEntity> listByActivityDesignCode(String activityDesignCode) {
        if (StringUtils.isEmpty((CharSequence)activityDesignCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignEntity::getActivityDesignCode, (Object)activityDesignCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public SubComActivityDesignEntity findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (SubComActivityDesignEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<SubComActivityDesignEntity> listByYearMonthAndOrg(Date feeYearMonth, String orgCode) {
        if (StringUtils.isEmpty((CharSequence)orgCode) || feeYearMonth == null) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignEntity::getFeeYearMonth, (Object)feeYearMonth)).eq(SubComActivityDesignEntity::getOrgCode, (Object)orgCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SubComActivityDesignEntity> listByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids) || StringUtils.isEmpty((CharSequence)delFlag)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).list();
    }

    public void updateBatchProcessStatus(String processNo, String processStatus) {
        if (StringUtils.isEmpty((CharSequence)processNo) || StringUtils.isEmpty((CharSequence)processStatus)) {
            return;
        }
        this.subComActivityDesignMapper.updateBatchProcessStatus(processNo, processStatus);
    }

    public SubComActivityDesignVo summationAmount(SubComActivityDesignDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return this.subComActivityDesignMapper.summationAmount(dto);
    }

    public SubComActivityDesignVo findByActivityDesignCode(String activityDesignCode) {
        SubComActivityDesignDto dto = new SubComActivityDesignDto();
        dto.setActivityDesignCode(activityDesignCode);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return ((SubComActivityDesignMapper)this.baseMapper).findByActivityDesignCode(dto);
    }

    public void updateProcessStatusAndProcessNo(List<String> ids, String processStatus, String processNo, String isOverBudgetAndSpecial, BigDecimal remainderAmount) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SubComActivityDesignEntity.class).set(SubComActivityDesignEntity::getProcessStatus, (Object)processStatus)).set(SubComActivityDesignEntity::getProcessType, (Object)SubComActivityDesignProcessTypeEnum.design.getCode())).set(SubComActivityDesignEntity::getProcessNo, (Object)processNo)).set(SubComActivityDesignEntity::getIsOverBudgetAndSpecial, (Object)isOverBudgetAndSpecial)).set(SubComActivityDesignEntity::getBpmRemainderAmount, (Object)remainderAmount)).in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void updateProcessStatusAndProcessNoByTable(List<String> designCodes, String processStatus, String processNo) {
        if (org.springframework.util.CollectionUtils.isEmpty(designCodes)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SubComActivityDesignEntity.class).set(SubComActivityDesignEntity::getProcessStatus, (Object)processStatus)).set(SubComActivityDesignEntity::getProcessType, (Object)SubComActivityDesignProcessTypeEnum.plan_table.getCode())).set(SubComActivityDesignEntity::getProcessNo, (Object)processNo)).in(SubComActivityDesignEntity::getActivityDesignCode, designCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public List<SubComActivityDesignEntity> findByDesignCodes(List<String> designCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(SubComActivityDesignEntity::getActivityDesignCode, designCodes)).list();
    }
}

