/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class AsyncConfig {
    @Value(value="${custom.pool.core-pool-size:16}")
    private Integer corePoolSize;
    @Value(value="${custom.pool.max-pool-size:32}")
    private Integer maxPoolSize;
    @Value(value="${custom.pool.keep-Alive-seconds:60}")
    private Integer keepAliveSeconds;
    @Value(value="${custom.pool.queue-capacity:800}")
    private Integer queueCapacity;

    @Bean
    public ThreadPoolTaskExecutor asyncThread() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize.intValue());
        executor.setMaxPoolSize(this.maxPoolSize.intValue());
        executor.setKeepAliveSeconds(this.keepAliveSeconds.intValue());
        executor.setQueueCapacity(this.queueCapacity.intValue());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    public Integer getCorePoolSize() {
        return this.corePoolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Integer getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public Integer getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setCorePoolSize(Integer corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setKeepAliveSeconds(Integer keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public void setQueueCapacity(Integer queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncConfig)) {
            return false;
        }
        AsyncConfig other = (AsyncConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$corePoolSize = this.getCorePoolSize();
        Integer other$corePoolSize = other.getCorePoolSize();
        if (this$corePoolSize == null ? other$corePoolSize != null : !((Object)this$corePoolSize).equals(other$corePoolSize)) {
            return false;
        }
        Integer this$maxPoolSize = this.getMaxPoolSize();
        Integer other$maxPoolSize = other.getMaxPoolSize();
        if (this$maxPoolSize == null ? other$maxPoolSize != null : !((Object)this$maxPoolSize).equals(other$maxPoolSize)) {
            return false;
        }
        Integer this$keepAliveSeconds = this.getKeepAliveSeconds();
        Integer other$keepAliveSeconds = other.getKeepAliveSeconds();
        if (this$keepAliveSeconds == null ? other$keepAliveSeconds != null : !((Object)this$keepAliveSeconds).equals(other$keepAliveSeconds)) {
            return false;
        }
        Integer this$queueCapacity = this.getQueueCapacity();
        Integer other$queueCapacity = other.getQueueCapacity();
        return !(this$queueCapacity == null ? other$queueCapacity != null : !((Object)this$queueCapacity).equals(other$queueCapacity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $corePoolSize = this.getCorePoolSize();
        result = result * 59 + ($corePoolSize == null ? 43 : ((Object)$corePoolSize).hashCode());
        Integer $maxPoolSize = this.getMaxPoolSize();
        result = result * 59 + ($maxPoolSize == null ? 43 : ((Object)$maxPoolSize).hashCode());
        Integer $keepAliveSeconds = this.getKeepAliveSeconds();
        result = result * 59 + ($keepAliveSeconds == null ? 43 : ((Object)$keepAliveSeconds).hashCode());
        Integer $queueCapacity = this.getQueueCapacity();
        result = result * 59 + ($queueCapacity == null ? 43 : ((Object)$queueCapacity).hashCode());
        return result;
    }

    public String toString() {
        return "AsyncConfig(corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", keepAliveSeconds=" + this.getKeepAliveSeconds() + ", queueCapacity=" + this.getQueueCapacity() + ")";
    }
}

