/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.config;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.SubComMonthBudgetEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionBudgetService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemMainItemService;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetPlanBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetPlanBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignBudgetEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignForecastEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignPlanEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignProductEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignForecastRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignProductRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ShareTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.ActivityPlanTableEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SubComActivityEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailBudgetShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignProductVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Component
@EnableAsync
public class GenerateDataAsync {
    private static final Logger log = LoggerFactory.getLogger(GenerateDataAsync.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private List<ActivityPlanTableEventListener> activityPlanTableEventListeners;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DimensionBudgetService dimensionBudgetService;
    @Autowired(required=false)
    private BudgetItemMainItemService budgetItemMainItemService;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;
    @Autowired(required=false)
    private SubComActivityDesignRepository subComActivityDesignRepository;
    @Autowired(required=false)
    private SubComActivityDesignDetailRepository subComActivityDesignDetailRepository;
    @Autowired(required=false)
    private SubComActivityDesignBudgetRepository subComActivityDesignBudgetRepository;
    @Autowired(required=false)
    private SubComActivityDesignForecastRepository subComActivityDesignForecastRepository;
    @Autowired(required=false)
    private List<SubComActivityEventListener> subComActivityEventListeners;
    @Autowired(required=false)
    private SubComActivityDesignProductRepository subComActivityDesignProductRepository;
    @Autowired(required=false)
    private SubComActivityDesignPlanRepository subComActivityDesignPlanRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void generateData(String processNo, UserIdentity loginUser, String tableId) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return;
        }
        if (Objects.nonNull(loginUser)) {
            this.loginUserService.refreshAuthentication((Object)loginUser);
        }
        boolean lockFlag = false;
        try {
            lockFlag = this.redisLockService.tryLock("sub_com_activity_design:lock:approve:" + Optional.ofNullable(tableId).orElse("default"), TimeUnit.MINUTES, 10L);
            if (!lockFlag) {
                return;
            }
            this.generateDetailAndBudget(processNo, loginUser, tableId);
        }
        finally {
            if (lockFlag) {
                this.redisLockService.unlock("sub_com_activity_design:lock:approve:" + Optional.ofNullable(tableId).orElse("default"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void generateData(String processNo, UserIdentity loginUser) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return;
        }
        if (Objects.nonNull(loginUser)) {
            this.loginUserService.refreshAuthentication((Object)loginUser);
        }
        boolean lockFlag = false;
        try {
            lockFlag = this.redisLockService.tryLock("sub_com_activity_design:lock:approve:" + Optional.ofNullable(processNo).orElse("default"), TimeUnit.MINUTES, 10L);
            if (!lockFlag) {
                return;
            }
            this.generateDetailAndBudget(processNo);
        }
        finally {
            if (lockFlag) {
                this.redisLockService.unlock("sub_com_activity_design:lock:approve:" + Optional.ofNullable(processNo).orElse("default"));
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void generateDetailAndBudget(String processNo) {
        List<SubComActivityDesignEntity> subComActivityDesignEntities = this.subComActivityDesignRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComActivityDesignEntities)) {
            throw new RuntimeException("\u672a\u627e\u5230" + processNo + "\u5bf9\u5e94\u6d3b\u52a8\u89c4\u5212\u6570\u636e\uff01");
        }
        List<String> activityDesignCodeList = subComActivityDesignEntities.stream().map(SubComActivityDesignEntity::getActivityDesignCode).collect(Collectors.toList());
        StopWatch queryStopWatch = new StopWatch();
        queryStopWatch.start();
        Map<String, SubComActivityDesignEntity> designMap = subComActivityDesignEntities.stream().collect(Collectors.toMap(SubComActivityDesignEntity::getActivityDesignCode, Function.identity()));
        List<SubComActivityDesignDetailEntity> designDetailList = this.subComActivityDesignDetailRepository.listByActivityDesignCodeList(activityDesignCodeList);
        Map<String, SubComActivityDesignDetailEntity> designDetailMap = designDetailList.stream().collect(Collectors.toMap(SubComActivityDesignDetailEntity::getActivityDesignDetailCode, Function.identity()));
        List<SubComActivityDesignBudgetEntity> budgetList = this.subComActivityDesignBudgetRepository.listByActivityDesignCodeList(activityDesignCodeList);
        List<SubComActivityDesignForecastEntity> forecastList = this.subComActivityDesignForecastRepository.listByActivityDesignCodeList(activityDesignCodeList);
        HashMap<String, List<SubComActivityDesignBudgetEntity>> detailBudgetMap = new HashMap<String, List<SubComActivityDesignBudgetEntity>>(8);
        HashMap<String, List<SubComActivityDesignForecastEntity>> detailForecastMap = new HashMap<String, List<SubComActivityDesignForecastEntity>>(8);
        queryStopWatch.stop();
        log.info("----\u6d3b\u52a8\u89c4\u5212\u6279\u91cf\u5ba1\u6279\u901a\u8fc7----\u5f00\u59cb\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u6570\u636e\uff0c\u8017\u65f6\uff1a" + DateUtil.millisecondToStr((long)queryStopWatch.getLastTaskTimeMillis()));
        StopWatch buildStopWatch = new StopWatch();
        buildStopWatch.start();
        List<Object> subComMonthBudgetVos = new ArrayList();
        if (!CollectionUtils.isEmpty(budgetList)) {
            subComMonthBudgetVos = this.buildSubComMonthBudget(budgetList, designMap, designDetailMap, detailBudgetMap);
        }
        if (!CollectionUtils.isEmpty(forecastList)) {
            subComMonthBudgetVos = this.buildSubComMonthBudgetByForecast(forecastList, designMap, designDetailMap, detailForecastMap);
        }
        buildStopWatch.stop();
        log.info("----\u6d3b\u52a8\u89c4\u5212\u6279\u91cf\u5ba1\u6279\u901a\u8fc7----\u5f00\u59cb\u7ec4\u88c5\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u6570\u636e\uff0c\u8017\u65f6\uff1a" + DateUtil.millisecondToStr((long)buildStopWatch.getLastTaskTimeMillis()));
        subComMonthBudgetVos.forEach(subComMonthBudgetVo -> subComMonthBudgetVo.setDesignDetailCodeList(subComMonthBudgetVo.getPlanBudgetList().stream().map(SubComMonthBudgetPlanBudgetVo::getActivityDesignDetailCode).collect(Collectors.toList())));
        List<Object> finalSubComMonthBudgetVos = subComMonthBudgetVos;
        StopWatch detailStopWatch = new StopWatch();
        detailStopWatch.start();
        this.generateSubCompanyActivityDetail(subComActivityDesignEntities, finalSubComMonthBudgetVos);
        detailStopWatch.stop();
        log.info("----\u6d3b\u52a8\u89c4\u5212\u6279\u91cf\u5ba1\u6279\u901a\u8fc7----\u751f\u6210\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u6570\u636e\uff0c\u8017\u65f6\uff1a" + DateUtil.millisecondToStr((long)detailStopWatch.getLastTaskTimeMillis()));
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateDetailAndBudget(String processNo, UserIdentity loginUser, String tableId) {
        List<SubComActivityDesignEntity> subComActivityDesignEntities = this.subComActivityDesignRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComActivityDesignEntities)) {
            throw new RuntimeException("\u672a\u627e\u5230" + processNo + "\u5bf9\u5e94\u6d3b\u52a8\u89c4\u5212\u6570\u636e\uff01");
        }
        this.generateDetailAndBudget(subComActivityDesignEntities);
        this.activityPlanTableEventListeners.forEach(activityPlanTableEventListener -> activityPlanTableEventListener.updateGenerateStatus(tableId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateDetailAndBudgetByDesignCode(String activityDesignCode) {
        List<SubComActivityDesignEntity> subComActivityDesignEntities = this.subComActivityDesignRepository.listByActivityDesignCode(activityDesignCode);
        this.generateDetailAndBudget(subComActivityDesignEntities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateDetailAndBudget(List<SubComActivityDesignEntity> subComActivityDesignEntities) {
        if (CollectionUtils.isEmpty(subComActivityDesignEntities)) {
            return;
        }
        List<String> activityDesignCodeList = subComActivityDesignEntities.stream().map(SubComActivityDesignEntity::getActivityDesignCode).collect(Collectors.toList());
        StopWatch queryStopWatch = new StopWatch();
        queryStopWatch.start();
        Map<String, SubComActivityDesignEntity> designMap = subComActivityDesignEntities.stream().collect(Collectors.toMap(SubComActivityDesignEntity::getActivityDesignCode, Function.identity()));
        List<SubComActivityDesignDetailEntity> designDetailList = this.subComActivityDesignDetailRepository.listByActivityDesignCodeList(activityDesignCodeList);
        Map<String, SubComActivityDesignDetailEntity> designDetailMap = designDetailList.stream().collect(Collectors.toMap(SubComActivityDesignDetailEntity::getActivityDesignDetailCode, Function.identity()));
        List<SubComActivityDesignBudgetEntity> budgetList = this.subComActivityDesignBudgetRepository.listByActivityDesignCodeList(activityDesignCodeList);
        List<SubComActivityDesignForecastEntity> forecastList = this.subComActivityDesignForecastRepository.listByActivityDesignCodeList(activityDesignCodeList);
        HashMap<String, List<SubComActivityDesignBudgetEntity>> detailBudgetMap = new HashMap<String, List<SubComActivityDesignBudgetEntity>>(8);
        HashMap<String, List<SubComActivityDesignForecastEntity>> detailForecastMap = new HashMap<String, List<SubComActivityDesignForecastEntity>>(8);
        queryStopWatch.stop();
        log.info("----\u6d3b\u52a8\u89c4\u5212\u5957\u8868\u5ba1\u6279\u901a\u8fc7----\u5f00\u59cb\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u6570\u636e\uff0c\u8017\u65f6\uff1a" + DateUtil.millisecondToStr((long)queryStopWatch.getLastTaskTimeMillis()));
        StopWatch buildStopWatch = new StopWatch();
        buildStopWatch.start();
        List<Object> subComMonthBudgetVos = new ArrayList();
        if (!CollectionUtils.isEmpty(budgetList)) {
            subComMonthBudgetVos = this.buildSubComMonthBudget(budgetList, designMap, designDetailMap, detailBudgetMap);
        }
        if (!CollectionUtils.isEmpty(forecastList)) {
            subComMonthBudgetVos = this.buildSubComMonthBudgetByForecast(forecastList, designMap, designDetailMap, detailForecastMap);
        }
        buildStopWatch.stop();
        log.info("----\u6d3b\u52a8\u89c4\u5212\u5957\u8868\u5ba1\u6279\u901a\u8fc7----\u5f00\u59cb\u7ec4\u88c5\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u6570\u636e\uff0c\u8017\u65f6\uff1a" + DateUtil.millisecondToStr((long)buildStopWatch.getLastTaskTimeMillis()));
        subComMonthBudgetVos.forEach(subComMonthBudgetVo -> subComMonthBudgetVo.setDesignDetailCodeList(subComMonthBudgetVo.getPlanBudgetList().stream().map(SubComMonthBudgetPlanBudgetVo::getActivityDesignDetailCode).collect(Collectors.toList())));
        List<Object> finalSubComMonthBudgetVos = subComMonthBudgetVos;
        StopWatch detailStopWatch = new StopWatch();
        detailStopWatch.start();
        this.generateSubCompanyActivityDetail(subComActivityDesignEntities, finalSubComMonthBudgetVos);
        detailStopWatch.stop();
        log.info("----\u6d3b\u52a8\u89c4\u5212\u5957\u8868\u5ba1\u6279\u901a\u8fc7----\u5f00\u59cb\u751f\u6210\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u6570\u636e\uff0c\u8017\u65f6\uff1a" + DateUtil.millisecondToStr((long)detailStopWatch.getLastTaskTimeMillis()));
    }

    private void generateSubCompanyActivityDetail(List<SubComActivityDesignEntity> subComActivityDesignEntities, List<SubComMonthBudgetVo> subComMonthBudgetVos) {
        if (CollectionUtils.isEmpty(this.subComActivityEventListeners)) {
            return;
        }
        List<String> activityDesignCodeList = subComActivityDesignEntities.stream().map(SubComActivityDesignEntity::getActivityDesignCode).collect(Collectors.toList());
        List<SubComActivityDesignDetailEntity> subComActivityDesignDetailEntities = this.subComActivityDesignDetailRepository.listByActivityDesignCodeList(activityDesignCodeList);
        Map<Object, Object> subComActivityDesignDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(subComActivityDesignDetailEntities)) {
            subComActivityDesignDetailMap = subComActivityDesignDetailEntities.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailEntity::getActivityDesignCode));
        }
        List<SubComActivityDesignProductEntity> subComActivityDesignProductList = this.subComActivityDesignProductRepository.findListByCodes(activityDesignCodeList);
        Map<Object, Object> subComActivityDesignProductMap = new HashMap();
        if (CollectionUtils.isNotEmpty(subComActivityDesignProductList)) {
            subComActivityDesignProductMap = subComActivityDesignProductList.stream().collect(Collectors.groupingBy(o -> o.getActivityDesignCode() + "-" + o.getActivityDesignDetailCode()));
        }
        List<SubComActivityDesignPlanEntity> subComActivityDesignPlanList = this.subComActivityDesignPlanRepository.findListByCodes(activityDesignCodeList);
        Map<Object, Object> subComActivityDesignPlanMap = new HashMap();
        if (CollectionUtils.isNotEmpty(subComActivityDesignPlanList)) {
            subComActivityDesignPlanMap = subComActivityDesignPlanList.stream().collect(Collectors.groupingBy(o -> o.getActivityDesignCode() + "-" + o.getActivityDesignDetailCode()));
        }
        for (SubComActivityEventListener subComActivityEventListener : this.subComActivityEventListeners) {
            List vos = (List)this.nebulaToolkitService.copyCollectionByBlankList(subComActivityDesignEntities, SubComActivityDesignEntity.class, SubComActivityDesignVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            for (SubComActivityDesignVo vo : vos) {
                UrlAddressVo mdmUser = new UrlAddressVo();
                mdmUser.setUserName(vo.getCreateAccount());
                mdmUser.setFullName(vo.getCreateName());
                this.loginUserService.refreshAuthentication((Object)mdmUser);
                List subComActivityDesignDetailEntities1 = (List)subComActivityDesignDetailMap.get(vo.getActivityDesignCode());
                if (CollectionUtils.isEmpty((Collection)subComActivityDesignDetailEntities1)) continue;
                Collection subComActivityDesignDetailVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)subComActivityDesignDetailEntities1, SubComActivityDesignDetailEntity.class, SubComActivityDesignDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                for (SubComActivityDesignDetailVo subComActivityDesignDetailVo : subComActivityDesignDetailVos) {
                    List subComActivityDesignPlanEntities;
                    List subComActivityDesignProductEntities = (List)subComActivityDesignProductMap.get(vo.getActivityDesignCode() + "-" + subComActivityDesignDetailVo.getActivityDesignDetailCode());
                    if (CollectionUtils.isNotEmpty((Collection)subComActivityDesignProductEntities)) {
                        Collection subComActivityDesignProductVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)subComActivityDesignProductEntities, SubComActivityDesignProductEntity.class, SubComActivityDesignProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        subComActivityDesignDetailVo.setProductList((List)subComActivityDesignProductVos);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(subComActivityDesignPlanEntities = (List)subComActivityDesignPlanMap.get(vo.getActivityDesignCode() + "-" + subComActivityDesignDetailVo.getActivityDesignDetailCode())))) {
                        Collection subComActivityDetailPlanPlanDtos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)subComActivityDesignPlanEntities, SubComActivityDesignPlanEntity.class, SubComActivityDesignPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        subComActivityDesignDetailVo.setPlanList((List)subComActivityDetailPlanPlanDtos);
                    }
                    List<SubComMonthBudgetVo> subComMonthBudgetVoList = subComMonthBudgetVos.stream().filter(subComMonthBudgetVo -> subComMonthBudgetVo.getDesignDetailCodeList().contains(subComActivityDesignDetailVo.getActivityDesignDetailCode())).collect(Collectors.toList());
                    ArrayList<SubComActivityDesignDetailBudgetShareVo> budgetShareVos = new ArrayList<SubComActivityDesignDetailBudgetShareVo>();
                    AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    subComMonthBudgetVoList.forEach(subComMonthBudgetVo -> {
                        SubComActivityDesignDetailBudgetShareVo subComActivityDesignDetailBudgetShareVo = (SubComActivityDesignDetailBudgetShareVo)this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetVo, SubComActivityDesignDetailBudgetShareVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        List planBudgetVos = subComMonthBudgetVo.getPlanBudgetList().stream().filter(planBudgetVo -> subComActivityDesignDetailVo.getActivityDesignDetailCode().equals(planBudgetVo.getActivityDesignDetailCode())).collect(Collectors.toList());
                        subComActivityDesignDetailBudgetShareVo.setFeeDate(subComMonthBudgetVo.getYearMonthLy());
                        subComActivityDesignDetailBudgetShareVo.setMarketOrganization(subComMonthBudgetVo.getSalesInstitutionCode());
                        subComActivityDesignDetailBudgetShareVo.setCanUseAmount(subComMonthBudgetVo.getCurrentBalanceAmount());
                        subComActivityDesignDetailBudgetShareVo.setUseAmount(((SubComMonthBudgetPlanBudgetVo)planBudgetVos.get(0)).getBudgetAmount());
                        totalAmount.set(((BigDecimal)totalAmount.get()).add(subComActivityDesignDetailBudgetShareVo.getUseAmount()));
                        subComActivityDesignDetailBudgetShareVo.setShareType(ShareTypeEnum.priorityLevel.getCode());
                        budgetShareVos.add(subComActivityDesignDetailBudgetShareVo);
                    });
                    budgetShareVos.sort(Comparator.comparing(budgetShareVo -> {
                        if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budgetShareVo.getFeeSourceCode())) {
                            return 0;
                        }
                        if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budgetShareVo.getFeeSourceCode())) {
                            return 1;
                        }
                        if (FeeSourceEnum.AUTO_FEE.getCode().equals(budgetShareVo.getFeeSourceCode())) {
                            return 2;
                        }
                        return 3;
                    }));
                    int priorityLevel = 1;
                    for (SubComActivityDesignDetailBudgetShareVo budgetShareVo2 : budgetShareVos) {
                        budgetShareVo2.setPriorityLevel(priorityLevel++ + "");
                    }
                    subComActivityDesignDetailVo.setBudgetShares(budgetShareVos);
                }
                vo.setSubComActivityDesignDetailList((List)subComActivityDesignDetailVos);
                vo.setValidateFlag(BooleanEnum.FALSE.getCapital());
            }
            subComActivityEventListener.create(vos);
        }
    }

    private List<SubComMonthBudgetVo> buildSubComMonthBudget(List<SubComActivityDesignBudgetEntity> budgetList, Map<String, SubComActivityDesignEntity> designMap, Map<String, SubComActivityDesignDetailEntity> designDetailMap, Map<String, List<SubComActivityDesignBudgetEntity>> detailBudgetMap) {
        if (CollectionUtils.isEmpty(budgetList)) {
            return Lists.newArrayList();
        }
        Set mainBudgetItemCodeSet = budgetList.stream().filter(budget -> !RelationTypeEnum.NO_RELATION.getCode().equals(budget.getAssociationType())).map(SubComActivityDesignBudgetEntity::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemMainItemVoList = this.budgetItemMainItemService.listByMainBudgetItemCodeList(new ArrayList(mainBudgetItemCodeSet));
        Set budgetItemSet = budgetItemMainItemVoList.stream().map(BudgetItemMainItemVo::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByCodes(new ArrayList(budgetItemSet));
        Map budgetItemVoMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        Map<String, String> mainMap = budgetItemMainItemVoList.stream().collect(Collectors.toMap(BudgetItemMainItemVo::getMainBudgetItemCode, BudgetItemMainItemVo::getBudgetItemCode));
        List dimensionVos = this.dimensionBudgetService.listByMenuCode(MenuCodeEnum.SUB_COM_MONTH_BUDGET.getCode());
        if (CollectionUtils.isEmpty((Collection)dimensionVos)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u7684\u7ef4\u5ea6\u914d\u7f6e\u672a\u67e5\u8be2\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Map<String, List<DimensionBudgetVo>> dimensionMap = dimensionVos.stream().collect(Collectors.groupingBy(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode()));
        HashMap<String, List<SubComMonthBudgetDto>> monthBudgetMap = new HashMap<String, List<SubComMonthBudgetDto>>(8);
        budgetList.forEach(budget -> {
            SubComActivityDesignEntity subComActivityDesignEntity = (SubComActivityDesignEntity)((Object)((Object)designMap.get(budget.getActivityDesignCode())));
            SubComActivityDesignDetailEntity subComActivityDesignDetailEntity = (SubComActivityDesignDetailEntity)((Object)((Object)designDetailMap.get(budget.getActivityDesignDetailCode())));
            if (!(RelationTypeEnum.NO_RELATION.getCode().equals(subComActivityDesignDetailEntity.getAssociationType()) || "AUTO_BUDGET_ITEM".equals(budget.getBudgetItemCode()) || "A023".equals(budget.getBudgetItemCode()))) {
                if (mainMap.containsKey(budget.getBudgetItemCode())) {
                    budget.setBudgetItemCode((String)mainMap.get(budget.getBudgetItemCode()));
                    budget.setBudgetItemName(((BudgetItemVo)budgetItemVoMap.get(budget.getBudgetItemCode())).getBudgetItemName());
                } else {
                    throw new RuntimeException("\u9884\u7b97\u9879\u76ee" + budget.getBudgetItemCode() + "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            if (!dimensionMap.containsKey(subComActivityDesignEntity.getBusinessFormatCode() + subComActivityDesignEntity.getBusinessUnitCode())) {
                throw new RuntimeException("\u672a\u7ef4\u62a4\u4e1a\u6001" + subComActivityDesignEntity.getBusinessFormatCode() + "\u4e1a\u52a1\u5355\u5143" + subComActivityDesignEntity.getBusinessUnitCode() + "\u5bf9\u5e94\u7ef4\u5ea6\u914d\u7f6e\u6570\u636e\uff01");
            }
            String salesInstitutionCode = subComActivityDesignDetailEntity.getSalesInstitutionCode();
            if (StringUtils.isEmpty((CharSequence)salesInstitutionCode)) {
                throw new RuntimeException("\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6[" + subComActivityDesignDetailEntity.getActivityDesignDetailCode() + "]\u672a\u7ef4\u62a4\u9500\u552e\u673a\u6784\uff01");
            }
            List dimensionBudgetVos = (List)dimensionMap.get(subComActivityDesignEntity.getBusinessFormatCode() + subComActivityDesignEntity.getBusinessUnitCode());
            List collect = dimensionBudgetVos.stream().filter(dimensionBudgetVo -> !CollectionUtils.isEmpty((Collection)dimensionBudgetVo.getSalesOrgList()) && dimensionBudgetVo.getSalesOrgList().contains(salesInstitutionCode)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                throw new RuntimeException("\u9500\u552e\u673a\u6784[" + salesInstitutionCode + "]\u5728\u7ef4\u5ea6\u914d\u7f6e\u8303\u56f4\u5185\uff01");
            }
            DimensionBudgetVo dimensionBudgetVo2 = (DimensionBudgetVo)collect.get(0);
            this.divideBudget((SubComActivityDesignBudgetEntity)((Object)budget), dimensionBudgetVo2, (Map<String, List<SubComMonthBudgetDto>>)monthBudgetMap, detailBudgetMap, subComActivityDesignEntity, subComActivityDesignDetailEntity);
        });
        if (MapUtils.isEmpty(monthBudgetMap)) {
            return Lists.newArrayList();
        }
        return this.sumBudget(monthBudgetMap, detailBudgetMap);
    }

    private List<SubComMonthBudgetVo> sumBudget(Map<String, List<SubComMonthBudgetDto>> monthBudgetMap, Map<String, List<SubComActivityDesignBudgetEntity>> detailBudgetMap) {
        ArrayList monthBudgetDtoList = new ArrayList();
        monthBudgetMap.forEach((key, value) -> {
            BigDecimal reduce = value.stream().map(SubComMonthBudgetDto::getBudgetAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            SubComMonthBudgetDto monthBudgetDto = (SubComMonthBudgetDto)value.get(0);
            monthBudgetDto.setBudgetAmount(reduce);
            monthBudgetDto.setApprovedAmount(reduce);
            monthBudgetDto.setCurrentBalanceAmount(BigDecimal.ZERO);
            List subComActivityDesignBudgetEntities = (List)detailBudgetMap.get(key);
            if (CollectionUtils.isNotEmpty((Collection)subComActivityDesignBudgetEntities)) {
                monthBudgetDto.setPlanBudgetList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)subComActivityDesignBudgetEntities, SubComActivityDesignBudgetEntity.class, SubComMonthBudgetPlanBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            }
            monthBudgetDtoList.add(monthBudgetDto);
        });
        return this.subComMonthBudgetService.designMonthBudget(monthBudgetDtoList);
    }

    private void divideBudget(SubComActivityDesignBudgetEntity budget, DimensionBudgetVo dimensionBudgetVo, Map<String, List<SubComMonthBudgetDto>> monthBudgetMap, Map<String, List<SubComActivityDesignBudgetEntity>> detailBudgetMap, SubComActivityDesignEntity subComActivityDesignEntity, SubComActivityDesignDetailEntity subComActivityDesignDetailEntity) {
        StringBuilder key = new StringBuilder();
        log.error("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u751f\u6210\u5206\u5b50\u6708\u5ea6\u9884\u7b97\uff0c\u9884\u7b97\u7ef4\u5ea6={},\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6={}", (Object)JSONObject.toJSONString((Object)dimensionBudgetVo), (Object)JSONObject.toJSONString((Object)((Object)subComActivityDesignEntity)));
        List informationList = dimensionBudgetVo.getInformationList();
        SubComMonthBudgetDto subComMonthBudgetDto = new SubComMonthBudgetDto();
        subComMonthBudgetDto.setBusinessFormatCode(subComActivityDesignEntity.getBusinessFormatCode());
        subComMonthBudgetDto.setBusinessUnitCode(subComActivityDesignEntity.getBusinessUnitCode());
        subComMonthBudgetDto.setOrgCode(subComActivityDesignEntity.getOrgCode());
        subComMonthBudgetDto.setOrgName(subComActivityDesignEntity.getOrgName());
        subComMonthBudgetDto.setYearMonthLy(DateUtil.format((Date)subComActivityDesignDetailEntity.getFeeYearMonth(), (String)"yyyy-MM"));
        subComMonthBudgetDto.setBudgetItemCode(budget.getBudgetItemCode());
        subComMonthBudgetDto.setBudgetItemName(budget.getBudgetItemName());
        subComMonthBudgetDto.setFeeSourceCode(budget.getFeeSourceCode());
        subComMonthBudgetDto.setBudgetAmount(budget.getBudgetAmount());
        subComMonthBudgetDto.setCurrentBalanceAmount(BigDecimal.ZERO);
        key.append(subComMonthBudgetDto.getBusinessFormatCode()).append(";").append(subComMonthBudgetDto.getBusinessUnitCode()).append(";").append(subComMonthBudgetDto.getOrgCode()).append(";").append(subComMonthBudgetDto.getYearMonthLy()).append(";").append(subComMonthBudgetDto.getBudgetItemCode()).append(";").append(subComMonthBudgetDto.getFeeSourceCode());
        if (informationList.contains(SubComMonthBudgetEnum.SALES_INSTITUTION_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getSalesInstitutionCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getSalesInstitutionCode());
            subComMonthBudgetDto.setSalesInstitutionCode(subComActivityDesignDetailEntity.getSalesInstitutionCode());
            subComMonthBudgetDto.setSalesInstitutionCode(subComActivityDesignDetailEntity.getSalesInstitutionName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.SALES_REGION_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getSalesOrgCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getSalesOrgCode());
            subComMonthBudgetDto.setSalesRegionCode(subComActivityDesignDetailEntity.getSalesOrgCode());
            subComMonthBudgetDto.setSalesRegionName(subComActivityDesignDetailEntity.getSalesOrgName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.SALES_ORG_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getSalesGroupCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getSalesGroupCode());
            subComMonthBudgetDto.setSalesOrgCode(subComActivityDesignDetailEntity.getSalesGroupCode());
            subComMonthBudgetDto.setSalesOrgName(subComActivityDesignDetailEntity.getSalesGroupName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.CHANNEL_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getDistributionChannelCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getDistributionChannelCode());
            subComMonthBudgetDto.setChannelCode(subComActivityDesignDetailEntity.getDistributionChannelCode());
            subComMonthBudgetDto.setChannelName(subComActivityDesignDetailEntity.getDistributionChannelName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.CUSTOMER_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getCustomerCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getCustomerCode());
            subComMonthBudgetDto.setCustomerCode(subComActivityDesignDetailEntity.getCustomerCode());
            subComMonthBudgetDto.setCustomerName(subComActivityDesignDetailEntity.getCustomerName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.PRODUCT_BRAND_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getProductBrandCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getProductBrandCode());
            subComMonthBudgetDto.setProductBrandCode(subComActivityDesignDetailEntity.getProductBrandCode());
            subComMonthBudgetDto.setProductBrandName(subComActivityDesignDetailEntity.getProductBrandName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.PRODUCT_CATEGORY_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getProductCategoryCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getProductCategoryCode());
            subComMonthBudgetDto.setProductCategoryCode(subComActivityDesignDetailEntity.getProductCategoryCode());
            subComMonthBudgetDto.setProductCategoryName(subComActivityDesignDetailEntity.getProductCategoryName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.PRODUCT_ITEM_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getProductItemCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getProductItemCode());
            subComMonthBudgetDto.setProductItemCode(subComActivityDesignDetailEntity.getProductItemCode());
            subComMonthBudgetDto.setProductItemName(subComActivityDesignDetailEntity.getProductItemName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.PRODUCT_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getProductCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getProductCode());
            subComMonthBudgetDto.setProductCode(subComActivityDesignDetailEntity.getProductCode());
            subComMonthBudgetDto.setProductName(subComActivityDesignDetailEntity.getProductName());
            List subComMonthBudgetList = Optional.ofNullable(monthBudgetMap.get(key.toString())).orElse(new ArrayList());
            List subComActivityDesignBudgetEntities = Optional.ofNullable(detailBudgetMap.get(key.toString())).orElse(new ArrayList());
            subComMonthBudgetList.add(subComMonthBudgetDto);
            monthBudgetMap.put(key.toString(), subComMonthBudgetList);
            subComActivityDesignBudgetEntities.add(budget);
            detailBudgetMap.put(key.toString(), subComActivityDesignBudgetEntities);
        } else {
            key.append(";");
            List subComMonthBudgetList = Optional.ofNullable(monthBudgetMap.get(key.toString())).orElse(new ArrayList());
            List subComActivityDesignBudgetEntities = Optional.ofNullable(detailBudgetMap.get(key.toString())).orElse(new ArrayList());
            subComMonthBudgetList.add(subComMonthBudgetDto);
            monthBudgetMap.put(key.toString(), subComMonthBudgetList);
            subComActivityDesignBudgetEntities.add(budget);
            detailBudgetMap.put(key.toString(), subComActivityDesignBudgetEntities);
        }
    }

    private List<SubComMonthBudgetVo> buildSubComMonthBudgetByForecast(List<SubComActivityDesignForecastEntity> forecastList, Map<String, SubComActivityDesignEntity> designMap, Map<String, SubComActivityDesignDetailEntity> designDetailMap, Map<String, List<SubComActivityDesignForecastEntity>> detailForecastMap) {
        if (CollectionUtils.isEmpty(forecastList)) {
            return Lists.newArrayList();
        }
        Set mainBudgetItemCodeSet = forecastList.stream().map(SubComActivityDesignForecastEntity::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemMainItemVoList = this.budgetItemMainItemService.listByMainBudgetItemCodeList(new ArrayList(mainBudgetItemCodeSet));
        Set budgetItemSet = budgetItemMainItemVoList.stream().map(BudgetItemMainItemVo::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByCodes(new ArrayList(budgetItemSet));
        Map budgetItemVoMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        Map<String, String> mainMap = budgetItemMainItemVoList.stream().collect(Collectors.toMap(BudgetItemMainItemVo::getMainBudgetItemCode, BudgetItemMainItemVo::getBudgetItemCode));
        forecastList.forEach(forecast -> {
            if (!mainMap.containsKey(forecast.getBudgetItemCode())) {
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee" + forecast.getBudgetItemCode() + "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            forecast.setBudgetItemCode((String)mainMap.get(forecast.getBudgetItemCode()));
            forecast.setBudgetItemName(((BudgetItemVo)budgetItemVoMap.get(forecast.getBudgetItemCode())).getBudgetItemName());
        });
        List dimensionVos = this.dimensionBudgetService.listByMenuCode(MenuCodeEnum.SUB_COM_MONTH_BUDGET.getCode());
        if (CollectionUtils.isEmpty((Collection)dimensionVos)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u7684\u7ef4\u5ea6\u914d\u7f6e\u672a\u67e5\u8be2\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Map<String, List<DimensionBudgetVo>> dimensionMap = dimensionVos.stream().collect(Collectors.groupingBy(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode()));
        HashMap<String, List<SubComMonthBudgetDto>> monthBudgetMap = new HashMap<String, List<SubComMonthBudgetDto>>(8);
        forecastList.forEach(forecast -> {
            SubComActivityDesignEntity subComActivityDesignEntity = (SubComActivityDesignEntity)((Object)((Object)designMap.get(forecast.getActivityDesignCode())));
            SubComActivityDesignDetailEntity subComActivityDesignDetailEntity = (SubComActivityDesignDetailEntity)((Object)((Object)designDetailMap.get(forecast.getActivityDesignDetailCode())));
            if (!dimensionMap.containsKey(subComActivityDesignEntity.getBusinessFormatCode() + subComActivityDesignEntity.getBusinessUnitCode())) {
                throw new RuntimeException("\u672a\u7ef4\u62a4\u4e1a\u6001" + subComActivityDesignEntity.getBusinessFormatCode() + "\u4e1a\u52a1\u5355\u5143" + subComActivityDesignEntity.getBusinessUnitCode() + "\u5bf9\u5e94\u7ef4\u5ea6\u914d\u7f6e\u6570\u636e\uff01");
            }
            String salesInstitutionCode = subComActivityDesignDetailEntity.getSalesInstitutionCode();
            if (StringUtils.isEmpty((CharSequence)subComActivityDesignDetailEntity.getSalesInstitutionCode())) {
                throw new RuntimeException("\u660e\u7ec6[" + subComActivityDesignDetailEntity.getActivityDesignDetailCode() + "]\u65e0\u9500\u552e\u673a\u6784\u4fe1\u606f\uff01");
            }
            List dimensionBudgetVos = (List)dimensionMap.get(subComActivityDesignEntity.getBusinessFormatCode() + subComActivityDesignEntity.getBusinessUnitCode());
            List collect = dimensionBudgetVos.stream().filter(dimensionBudgetVo -> !CollectionUtils.isEmpty((Collection)dimensionBudgetVo.getSalesOrgList()) && dimensionBudgetVo.getSalesOrgList().contains(salesInstitutionCode)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                throw new RuntimeException("\u9500\u552e\u673a\u6784[" + salesInstitutionCode + "]\u4e0d\u5728\u7ef4\u5ea6\u914d\u7f6e\u8303\u56f4\u5185\uff01");
            }
            DimensionBudgetVo dimensionBudgetVo2 = (DimensionBudgetVo)collect.get(0);
            this.divideForecast((SubComActivityDesignForecastEntity)((Object)forecast), mainMap, dimensionBudgetVo2, (Map<String, List<SubComMonthBudgetDto>>)monthBudgetMap, detailForecastMap, subComActivityDesignEntity, subComActivityDesignDetailEntity);
        });
        if (MapUtils.isEmpty(monthBudgetMap)) {
            return Lists.newArrayList();
        }
        return this.sumBudgetByForecast(monthBudgetMap, detailForecastMap);
    }

    private void divideForecast(SubComActivityDesignForecastEntity forecast, Map<String, String> mainMap, DimensionBudgetVo dimensionBudgetVo, Map<String, List<SubComMonthBudgetDto>> monthBudgetMap, Map<String, List<SubComActivityDesignForecastEntity>> detailForecastMap, SubComActivityDesignEntity subComActivityDesignEntity, SubComActivityDesignDetailEntity subComActivityDesignDetailEntity) {
        AtomicBoolean flag = new AtomicBoolean(true);
        StringBuilder key = new StringBuilder();
        List informationList = dimensionBudgetVo.getInformationList();
        SubComMonthBudgetDto subComMonthBudgetDto = new SubComMonthBudgetDto();
        subComMonthBudgetDto.setBusinessFormatCode(subComActivityDesignEntity.getBusinessFormatCode());
        subComMonthBudgetDto.setBusinessUnitCode(subComActivityDesignEntity.getBusinessUnitCode());
        subComMonthBudgetDto.setOrgCode(subComActivityDesignEntity.getOrgCode());
        subComMonthBudgetDto.setYearMonthLy(DateUtil.format((Date)subComActivityDesignDetailEntity.getFeeYearMonth(), (String)"yyyy-MM"));
        subComMonthBudgetDto.setBudgetItemCode(forecast.getBudgetItemCode());
        subComMonthBudgetDto.setBudgetItemName(forecast.getBudgetItemName());
        subComMonthBudgetDto.setFeeSourceCode(forecast.getFeeSourceCode());
        subComMonthBudgetDto.setBudgetAmount(forecast.getThisUseAmount());
        subComMonthBudgetDto.setCurrentBalanceAmount(BigDecimal.ZERO);
        key.append(subComMonthBudgetDto.getBusinessFormatCode()).append(";").append(subComMonthBudgetDto.getBusinessUnitCode()).append(";").append(subComMonthBudgetDto.getOrgCode()).append(";").append(subComMonthBudgetDto.getYearMonthLy()).append(";").append(subComMonthBudgetDto.getBudgetItemCode()).append(";").append(subComMonthBudgetDto.getFeeSourceCode());
        List subComMonthBudgetList = Optional.ofNullable(monthBudgetMap.get(key.toString())).orElse(new ArrayList());
        List forecastEntityList = Optional.ofNullable(detailForecastMap.get(key.toString())).orElse(new ArrayList());
        if (informationList.contains(SubComMonthBudgetEnum.SALES_INSTITUTION_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getSalesInstitutionCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getSalesInstitutionCode());
            subComMonthBudgetDto.setSalesInstitutionCode(subComActivityDesignDetailEntity.getSalesInstitutionCode());
            subComMonthBudgetDto.setSalesInstitutionCode(subComActivityDesignDetailEntity.getSalesInstitutionName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.SALES_REGION_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getSalesOrgCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getSalesOrgCode());
            subComMonthBudgetDto.setSalesRegionCode(subComActivityDesignDetailEntity.getSalesOrgCode());
            subComMonthBudgetDto.setSalesRegionName(subComActivityDesignDetailEntity.getSalesOrgName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.SALES_ORG_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getSalesGroupCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getSalesGroupCode());
            subComMonthBudgetDto.setSalesOrgCode(subComActivityDesignDetailEntity.getSalesGroupCode());
            subComMonthBudgetDto.setSalesOrgName(subComActivityDesignDetailEntity.getSalesGroupName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.CHANNEL_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getDistributionChannelCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getDistributionChannelCode());
            subComMonthBudgetDto.setChannelCode(subComActivityDesignDetailEntity.getDistributionChannelCode());
            subComMonthBudgetDto.setChannelName(subComActivityDesignDetailEntity.getDistributionChannelName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.CUSTOMER_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getCustomerCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getCustomerCode());
            subComMonthBudgetDto.setCustomerCode(subComActivityDesignDetailEntity.getCustomerCode());
            subComMonthBudgetDto.setCustomerName(subComActivityDesignDetailEntity.getCustomerName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.PRODUCT_BRAND_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getProductBrandCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getProductBrandCode());
            subComMonthBudgetDto.setProductBrandCode(subComActivityDesignDetailEntity.getProductBrandCode());
            subComMonthBudgetDto.setProductBrandName(subComActivityDesignDetailEntity.getProductBrandName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.PRODUCT_CATEGORY_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getProductCategoryCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getProductCategoryCode());
            subComMonthBudgetDto.setProductCategoryCode(subComActivityDesignDetailEntity.getProductCategoryCode());
            subComMonthBudgetDto.setProductCategoryName(subComActivityDesignDetailEntity.getProductCategoryName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.BUDGET_ITEM_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getProductItemCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getProductItemCode());
            subComMonthBudgetDto.setProductItemCode(subComActivityDesignDetailEntity.getProductItemCode());
            subComMonthBudgetDto.setProductItemName(subComActivityDesignDetailEntity.getProductItemName());
        } else {
            key.append(";");
        }
        if (informationList.contains(SubComMonthBudgetEnum.PRODUCT_CODE.getFieldCoding()) && StringUtils.isNotEmpty((CharSequence)subComActivityDesignDetailEntity.getProductCode())) {
            key.append(";").append(subComActivityDesignDetailEntity.getProductCode());
            subComMonthBudgetDto.setProductCode(subComActivityDesignDetailEntity.getProductCode());
            subComMonthBudgetDto.setProductName(subComActivityDesignDetailEntity.getProductName());
            subComMonthBudgetList.add(subComMonthBudgetDto);
            monthBudgetMap.put(key.toString(), subComMonthBudgetList);
            forecastEntityList.add(forecast);
            detailForecastMap.put(key.toString(), forecastEntityList);
        } else {
            key.append(";");
            subComMonthBudgetList.add(subComMonthBudgetDto);
            monthBudgetMap.put(key.toString(), subComMonthBudgetList);
            forecastEntityList.add(forecast);
            detailForecastMap.put(key.toString(), forecastEntityList);
        }
    }

    private List<SubComMonthBudgetVo> sumBudgetByForecast(Map<String, List<SubComMonthBudgetDto>> monthBudgetMap, Map<String, List<SubComActivityDesignForecastEntity>> detailForecastMap) {
        ArrayList monthBudgetDtoList = new ArrayList();
        monthBudgetMap.forEach((key, value) -> {
            List<String> list = Arrays.asList(key.split(";"));
            SubComMonthBudgetDto monthBudgetDto = new SubComMonthBudgetDto();
            BigDecimal reduce = value.stream().map(SubComMonthBudgetDto::getBudgetAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            monthBudgetDto.setBudgetAmount(reduce);
            monthBudgetDto.setApprovedAmount(reduce);
            monthBudgetDto.setCurrentBalanceAmount(BigDecimal.ZERO);
            List forecastEntityList = (List)detailForecastMap.get(key);
            if (CollectionUtils.isNotEmpty((Collection)forecastEntityList)) {
                monthBudgetDto.setPlanBudgetList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)forecastEntityList, SubComActivityDesignForecastEntity.class, SubComMonthBudgetPlanBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            }
            monthBudgetDtoList.add(monthBudgetDto);
        });
        return this.subComMonthBudgetService.designMonthBudget(monthBudgetDtoList);
    }
}

