/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignBudgetEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubComActivityDesignBudgetServiceImpl
implements SubComActivityDesignBudgetService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignBudgetServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignBudgetRepository subComActivityDesignBudgetRepository;
    @Resource
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    public void saveSubComActivityDesignBudgetList(SubComActivityDesignDto dto, boolean updateFlag, List<SubComActivityDesignDetailDto> itemCacheList) {
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (updateFlag) {
            List<SubComActivityDesignBudgetEntity> oldList = this.subComActivityDesignBudgetRepository.findListByCode(dto.getActivityDesignCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList budgetList = Lists.newArrayList();
        itemCacheList.forEach(itemCache -> {
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)itemCache.getBudgetList())) {
                budgetList.addAll(itemCache.getBudgetList());
            }
        });
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)budgetList)) {
            return;
        }
        List activityBudgets = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)budgetList, SubComActivityDesignBudgetDto.class, SubComActivityDesignBudgetEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDesignBudgetEntity item : activityBudgets) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setId(null);
            saveList.add(item);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDesignBudgetRepository.saveBatch(saveList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDesignBudgetRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityDesignBudgetRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    public List<SubComActivityDesignBudgetVo> listByDesignCode(String activityDesignCode) {
        if (StringUtils.isEmpty((CharSequence)activityDesignCode)) {
            return null;
        }
        List<SubComActivityDesignBudgetEntity> subComActivityDesignBudgetEntities = this.subComActivityDesignBudgetRepository.findListByCode(activityDesignCode);
        if (org.springframework.util.CollectionUtils.isEmpty(subComActivityDesignBudgetEntities)) {
            return null;
        }
        Collection subComActivityDesignBudgetVos = this.nebulaToolkitService.copyCollectionByWhiteList(subComActivityDesignBudgetEntities, SubComActivityDesignBudgetEntity.class, SubComActivityDesignBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)subComActivityDesignBudgetVos;
    }

    public void useSubComBudgetForecastByCode(List<String> activityDesignCodeList) {
        List<SubComActivityDesignBudgetEntity> subComActivityDesignBudgetEntities = this.subComActivityDesignBudgetRepository.listByActivityDesignCodeList(activityDesignCodeList);
        this.useSubComBudgetForecast(subComActivityDesignBudgetEntities);
    }

    public void returnSubComBudgetForecastByCode(List<String> activityDesignCodeList) {
        List<SubComActivityDesignBudgetEntity> subComActivityDesignBudgetEntities = this.subComActivityDesignBudgetRepository.listByActivityDesignCodeList(activityDesignCodeList);
        this.returnSubComBudgetForecast(subComActivityDesignBudgetEntities);
    }

    public List<SubComActivityDesignBudgetVo> listByActivityDetailCodes(List<String> activityDetailCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignBudgetEntity> subComActivityDesignBudgetEntities = this.subComActivityDesignBudgetRepository.listByActivityDetailCodes(activityDetailCodes);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(subComActivityDesignBudgetEntities, SubComActivityDesignBudgetEntity.class, SubComActivityDesignBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public void returnSubComBudgetForecast(List<SubComActivityDesignBudgetEntity> designBudgetEntities) {
        ArrayList operationBudgetForecastList = Lists.newArrayList();
        ArrayList operatePlanBudgetList = Lists.newArrayList();
        ArrayList operateDetailPlanBudgetList = Lists.newArrayList();
        for (SubComActivityDesignBudgetEntity designBudgetEntity : designBudgetEntities) {
            if (designBudgetEntity.getBudgetAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            SubComBudgetForecastDetailDto subComBudgetForecastDto = new SubComBudgetForecastDetailDto();
            subComBudgetForecastDto.setBudgetForecastCode(designBudgetEntity.getBudgetForecastCode());
            subComBudgetForecastDto.setBusinessCode(designBudgetEntity.getActivityDesignDetailCode());
            subComBudgetForecastDto.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
            subComBudgetForecastDto.setUndertakingMode(designBudgetEntity.getUndertakingMode());
            subComBudgetForecastDto.setCurOperationAmount(designBudgetEntity.getBudgetAmount());
            operationBudgetForecastList.add(subComBudgetForecastDto);
            if (RelationTypeEnum.UP_RELATION_PLAN.getCode().equals(designBudgetEntity.getAssociationType())) {
                if (FeeSourceEnum.AUTO_FEE.getCode().equals(designBudgetEntity.getFeeSourceCode())) {
                    return;
                }
                ActivityPlanBudgetDto activityPlanBudgetDto = new ActivityPlanBudgetDto();
                activityPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).add(designBudgetEntity.getBudgetAmount()));
                activityPlanBudgetDto.setPlanItemCode(designBudgetEntity.getPlanDetailCode());
                operatePlanBudgetList.add(activityPlanBudgetDto);
            }
            if (!RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(designBudgetEntity.getAssociationType())) continue;
            if (FeeSourceEnum.AUTO_FEE.getCode().equals(designBudgetEntity.getFeeSourceCode())) {
                return;
            }
            ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto = new ActivityDetailPlanBudgetDto();
            activityDetailPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityDetailPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).add(designBudgetEntity.getBudgetAmount()));
            activityDetailPlanBudgetDto.setDetailPlanItemCode(designBudgetEntity.getPlanDetailCode());
            operateDetailPlanBudgetList.add(activityDetailPlanBudgetDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)operationBudgetForecastList)) {
            this.subComBudgetForecastService.operationBudgetForecast((List)operationBudgetForecastList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)operatePlanBudgetList)) {
            operatePlanBudgetList.forEach(item -> item.setThisDownAmount(item.getThisDownAmount().negate()));
            this.activityPlanItemSdkService.operationBudget((List)operatePlanBudgetList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)operateDetailPlanBudgetList)) {
            operateDetailPlanBudgetList.forEach(item -> item.setThisDownAmount(item.getThisDownAmount().negate()));
            this.activityDetailPlanItemSdkService.operationBudget((List)operateDetailPlanBudgetList);
        }
    }

    public void useSubComBudgetForecast(List<SubComActivityDesignBudgetEntity> designBudgetEntities) {
        ArrayList operationBudgetForecastList = Lists.newArrayList();
        ArrayList operatePlanBudgetList = Lists.newArrayList();
        ArrayList operateDetailPlanBudgetList = Lists.newArrayList();
        for (SubComActivityDesignBudgetEntity designBudgetEntity : designBudgetEntities) {
            String key;
            if (designBudgetEntity.getBudgetAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            SubComBudgetForecastDetailDto subComBudgetForecastDto = new SubComBudgetForecastDetailDto();
            subComBudgetForecastDto.setBudgetForecastCode(designBudgetEntity.getBudgetForecastCode());
            subComBudgetForecastDto.setOperationType(ForecastOperationTypeEnum.USE.getCode());
            subComBudgetForecastDto.setUndertakingMode(designBudgetEntity.getUndertakingMode());
            subComBudgetForecastDto.setBusinessCode(designBudgetEntity.getActivityDesignDetailCode());
            subComBudgetForecastDto.setCurOperationAmount(designBudgetEntity.getBudgetAmount());
            operationBudgetForecastList.add(subComBudgetForecastDto);
            if (RelationTypeEnum.UP_RELATION_PLAN.getCode().equals(designBudgetEntity.getAssociationType())) {
                if (FeeSourceEnum.AUTO_FEE.getCode().equals(designBudgetEntity.getFeeSourceCode())) {
                    return;
                }
                key = designBudgetEntity.getPlanDetailCode() + designBudgetEntity.getFeeSourceCode();
                ActivityPlanBudgetDto activityPlanBudgetDto = new ActivityPlanBudgetDto();
                activityPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).add(designBudgetEntity.getBudgetAmount()));
                activityPlanBudgetDto.setPlanItemCode(designBudgetEntity.getPlanDetailCode());
                operatePlanBudgetList.add(activityPlanBudgetDto);
            }
            if (!RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(designBudgetEntity.getAssociationType())) continue;
            if (FeeSourceEnum.AUTO_FEE.getCode().equals(designBudgetEntity.getFeeSourceCode())) {
                return;
            }
            key = designBudgetEntity.getPlanDetailCode() + designBudgetEntity.getFeeSourceCode();
            ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto = new ActivityDetailPlanBudgetDto();
            activityDetailPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityDetailPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).add(designBudgetEntity.getBudgetAmount()));
            activityDetailPlanBudgetDto.setDetailPlanItemCode(designBudgetEntity.getPlanDetailCode());
            operateDetailPlanBudgetList.add(activityDetailPlanBudgetDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)operationBudgetForecastList)) {
            this.subComBudgetForecastService.operationBudgetForecast((List)operationBudgetForecastList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)operatePlanBudgetList)) {
            this.activityPlanItemSdkService.operationBudget((List)operatePlanBudgetList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)operateDetailPlanBudgetList)) {
            this.activityDetailPlanItemSdkService.operationBudget((List)operateDetailPlanBudgetList);
        }
    }

    public BigDecimal findBudgetUsedAmountSum(SubComActivityDesignBudgetDto dto) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getBudgetItemCode()) || StringUtils.isBlank((CharSequence)dto.getYearMonthLy()) || StringUtils.isBlank((CharSequence)dto.getOrgCode()) || StringUtils.isBlank((CharSequence)dto.getFeeSourceCode()) || StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return BigDecimal.ZERO;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        BigDecimal amount = this.subComActivityDesignBudgetRepository.findBudgetUsedAmountSum(dto);
        if (Objects.isNull(amount)) {
            return BigDecimal.ZERO;
        }
        return amount;
    }

    public List<SubComActivityDesignBudgetVo> findByDesignDetailCode(String activityDesignDetailCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignDetailCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignBudgetVo> list = this.subComActivityDesignBudgetRepository.findByActivityDesignDetailCode(activityDesignDetailCode);
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

