/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignFeeDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignFeeDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignPlanService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignProductService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignFeeDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignDetailPageCacheHelper
extends MnPageCacheHelper<SubComActivityDesignDetailVo, SubComActivityDesignDetailDto> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private OrgPositionVoService orgPositionVoService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private SubComActivityDesignProductService subComActivityDesignProductService;
    @Autowired(required=false)
    private SubComActivityDesignDetailService subComActivityDesignDetailService;
    @Autowired(required=false)
    private SubComActivityDesignFeeDetailService subComActivityDesignFeeDetailService;
    @Autowired(required=false)
    private SubComActivityDesignPlanService subComActivityDesignPlanService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;

    public String getCacheKeyPrefix() {
        return "sub_com_activity_design_cache:new:";
    }

    public Class<SubComActivityDesignDetailDto> getDtoClass() {
        return SubComActivityDesignDetailDto.class;
    }

    public Class<SubComActivityDesignDetailVo> getVoClass() {
        return SubComActivityDesignDetailVo.class;
    }

    public List<SubComActivityDesignDetailDto> findDtoListFromRepository(SubComActivityDesignDetailDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getActivityDesignCode())) {
            return Lists.newArrayList();
        }
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List allDtoList = this.subComActivityDesignDetailService.findDtoList(dto);
        allDtoList.forEach(all -> {
            if (StringUtils.isBlank((CharSequence)all.getCustomerName())) {
                all.setCustomerName("more...");
            }
        });
        Map<String, List<SubComActivityDesignDetailDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailDto::getTemplateConfigCode));
        for (Map.Entry<String, List<SubComActivityDesignDetailDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode, entry.getKey());
            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode, entry.getKey());
            Map newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            this.redisService.lPushAll(thisRedisIdCacheKey, Long.valueOf(this.getExpireTime()), entry.getValue().stream().map(this::getDtoKey).toArray());
            this.redisTemplate.opsForHash().putAll((Object)thisRedisDataCacheKey, newItemMap);
            this.redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }
        return allMap.get(templateCode);
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<SubComActivityDesignDetailDto> newItem(String cacheKey, List<SubComActivityDesignDetailDto> itemList) {
        SubComActivityDesignDetailDto newItem = new SubComActivityDesignDetailDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        newItem.setTemplateConfigCode(templateCode);
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setActivityDesignDetailCode(null);
        return Lists.newArrayList((Object[])new SubComActivityDesignDetailDto[]{newItem});
    }

    public void importNewItem(String cacheKey, List<SubComActivityDesignDetailDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        for (SubComActivityDesignDetailDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTemplateConfigCode(templateCode);
            this.validateTotalQuantityOrNot(newItem);
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    private void validateTotalQuantityOrNot(SubComActivityDesignDetailDto newItem) {
        if (TotalQuantityOrNotEnum.N.getCode().equals(newItem.getIsSupplyAmount()) || TotalQuantityOrNotEnum.Y.getCode().equals(newItem.getIsSupplyAmount())) {
            String[] split;
            if (StringUtils.isNotBlank((CharSequence)newItem.getCustomerCode())) {
                split = newItem.getCustomerCode().split(",");
                newItem.setCustomerCode(split[0]);
            }
            if (StringUtils.isNotBlank((CharSequence)newItem.getCustomerName())) {
                split = newItem.getCustomerName().split(",");
                newItem.setCustomerName(split[0]);
            }
        }
    }

    public void updateItem(String cacheKey, List<SubComActivityDesignDetailDto> itemList) {
        this.buildDownAmount(itemList);
        itemList.forEach(item -> {
            List listByItem = this.subComActivityDesignProductService.findListByItem(item);
            item.setProductList(listByItem);
        });
    }

    public void buildDownAmount(List<SubComActivityDesignDetailDto> newList) {
        ArrayList planList = Lists.newArrayList();
        newList.forEach(item -> {
            if (StringUtils.isEmpty((CharSequence)item.getAssociationType())) {
                throw new IllegalArgumentException("\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)item.getUndertakingMode())) {
                throw new IllegalArgumentException("\u627f\u63a5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (RelationTypeEnum.NO_RELATION.getCode().equals(item.getAssociationType())) {
                Validate.notBlank((CharSequence)item.getBudgetItemCode(), (String)"\u4e0d\u627f\u63a5\u65f6\uff0c\u672a\u9009\u62e9\u9884\u7b97\u9879\u76ee", (Object[])new Object[0]);
                Validate.notNull((Object)item.getTotalCost(), (String)"\u8d39\u7528\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)item.getFeeYearMonth(), (String)"\u8d39\u7528\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                return;
            }
            if (RelationTypeEnum.UP_SUB_PLAN.getCode().equals(item.getAssociationType())) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)item.getPlanList())) {
                throw new IllegalArgumentException("\u65b9\u6848\u7ec6\u6848\u4e0d\u80fd\u4e3a\u7a7a");
            }
            item.getPlanList().forEach(plan -> plan.setAssociationType(item.getAssociationType()));
            planList.addAll(item.getPlanList());
        });
        if (!CollectionUtils.isEmpty((Collection)planList)) {
            this.validatePlanList(planList);
            Set planItemCodeList = planList.stream().filter(plan -> RelationTypeEnum.UP_RELATION_PLAN.getCode().equals(plan.getAssociationType())).map(SubComActivityDesignPlanDto::getPlanDetailCode).collect(Collectors.toSet());
            List activityPlanItemVos = this.activityPlanItemSdkService.listByItemCodeList(new ArrayList(planItemCodeList));
            Map<String, ActivityPlanItemVo> planItemMap = activityPlanItemVos.stream().collect(Collectors.toMap(ActivityPlanItemBase::getPlanItemCode, Function.identity()));
            HashSet monthBudgetCodeSet = new HashSet();
            activityPlanItemVos.forEach(activityPlanItemVo -> {
                if (BooleanEnum.TRUE.getCapital().equals(activityPlanItemVo.getIsClose())) {
                    throw new IllegalArgumentException("\u65b9\u6848\u660e\u7ec6[" + activityPlanItemVo.getPlanItemCode() + "]\u5df2\u5173\u95ed\uff01\u4e0d\u53ef\u5173\u8054\u3002");
                }
                monthBudgetCodeSet.addAll(((List)Optional.ofNullable(activityPlanItemVo.getBudgetShares()).orElse(new ArrayList())).stream().map(ActivityPlanBudgetVo::getMonthBudgetCode).collect(Collectors.toSet()));
            });
            Set detailPlanItemCodeList = planList.stream().filter(plan -> RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(plan.getAssociationType())).map(SubComActivityDesignPlanDto::getPlanDetailCode).collect(Collectors.toSet());
            List activityDetailPlanItemVos = this.activityDetailPlanItemSdkService.listByItemCodeList(new ArrayList(detailPlanItemCodeList));
            activityDetailPlanItemVos.forEach(activityDetailPlanItemVo -> {
                if (BooleanEnum.TRUE.getCapital().equals(activityDetailPlanItemVo.getIsClose())) {
                    throw new IllegalArgumentException("\u7ec6\u6848\u660e\u7ec6[" + activityDetailPlanItemVo.getDetailPlanItemCode() + "]\u5df2\u5173\u95ed\uff01\u4e0d\u53ef\u5173\u8054\u3002");
                }
                monthBudgetCodeSet.addAll(((List)Optional.ofNullable(activityDetailPlanItemVo.getBudgetShares()).orElse(new ArrayList())).stream().map(ActivityDetailPlanBudgetVo::getMonthBudgetCode).collect(Collectors.toSet()));
            });
            Map<String, ActivityDetailPlanItemVo> detailPlanItemMap = activityDetailPlanItemVos.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
            List monthBudgetVoList = this.monthBudgetService.listByCodes(new ArrayList(monthBudgetCodeSet));
            Map<String, MonthBudgetVo> monthBudgetVoMap = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            Set customerCodeSet = monthBudgetVoList.stream().map(MonthBudgetVo::getCustomerCode).collect(Collectors.toSet());
            List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList(new ArrayList(customerCodeSet));
            Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap = salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity()));
            this.refreshDownAmount(newList, planItemMap, detailPlanItemMap, monthBudgetVoMap, salesOrgSubComOrgVoMap);
        }
    }

    private void validatePlanList(List<SubComActivityDesignPlanDto> planList) {
        planList.forEach(plan -> {
            Validate.notEmpty((CharSequence)plan.getPlanCode(), (String)"\u5173\u8054\u65b9\u6848\u3001\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)plan.getPlanName(), (String)"\u5173\u8054\u65b9\u6848\u3001\u7ec6\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)plan.getPlanDetailCode(), (String)"\u5173\u8054\u65b9\u6848\u3001\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }

    private void refreshDownAmount(List<SubComActivityDesignDetailDto> newList, Map<String, ActivityPlanItemVo> planItemMap, Map<String, ActivityDetailPlanItemVo> detailPlanItemMap, Map<String, MonthBudgetVo> monthBudgetVoMap, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        for (int index = newList.size() - 1; index >= 0; --index) {
            if (!RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(newList.get(index).getAssociationType())) continue;
            if (newList.get(index).getTotalCost() == null) {
                throw new IllegalArgumentException("\u8d39\u7528\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AtomicReference<BigDecimal> totalCostAmount = new AtomicReference<BigDecimal>(newList.get(index).getTotalCost());
            AtomicReference<BigDecimal> internalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> offAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            SubComActivityDesignFeeDetailDto subComActivityDesignFeeDetailDto = new SubComActivityDesignFeeDetailDto();
            subComActivityDesignFeeDetailDto.setThisUseAmount(totalCostAmount.get());
            newList.get(index).setFeeDetail(subComActivityDesignFeeDetailDto);
            newList.get(index).getPlanList().forEach(plan -> {
                if (RelationTypeEnum.UP_RELATION_PLAN.getCode().equals(plan.getAssociationType())) {
                    if (!planItemMap.containsKey(plan.getPlanDetailCode())) {
                        throw new RuntimeException("\u65b9\u6848\u660e\u7ec6" + plan.getPlanDetailCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    ActivityPlanItemVo activityPlanItemVo = (ActivityPlanItemVo)planItemMap.get(plan.getPlanDetailCode());
                    BigDecimal off = Optional.ofNullable(activityPlanItemVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(activityPlanItemVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(activityPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO));
                    offAmount.set(((BigDecimal)offAmount.get()).add(off));
                }
                if (RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(plan.getAssociationType())) {
                    if (!detailPlanItemMap.containsKey(plan.getPlanDetailCode())) {
                        throw new RuntimeException("\u7ec6\u6848\u660e\u7ec6" + plan.getPlanDetailCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    ActivityDetailPlanItemVo activityDetailPlanItemVo = (ActivityDetailPlanItemVo)detailPlanItemMap.get(plan.getPlanDetailCode());
                    if (BooleanEnum.TRUE.getCapital().equals(activityDetailPlanItemVo.getIsAllDown())) {
                        return;
                    }
                    BigDecimal downAmount = Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal offPointAmount = Optional.ofNullable(activityDetailPlanItemVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(activityDetailPlanItemVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(activityDetailPlanItemVo.getIntraCompanyAmount()).orElse(BigDecimal.ZERO));
                    BigDecimal intraCompanyAmount = Optional.ofNullable(activityDetailPlanItemVo.getIntraCompanyAmount()).orElse(BigDecimal.ZERO);
                    if (offPointAmount.compareTo(downAmount) >= 0) {
                        offAmount.set(((BigDecimal)offAmount.get()).add(offPointAmount.subtract(downAmount)));
                        internalAmount.set(((BigDecimal)internalAmount.get()).add(intraCompanyAmount));
                    } else {
                        internalAmount.set(((BigDecimal)internalAmount.get()).add(intraCompanyAmount).add(offPointAmount.subtract(downAmount)));
                    }
                }
            });
            this.refreshDownAmount(newList, index, planItemMap, detailPlanItemMap, totalCostAmount, offAmount, internalAmount, salesOrgSubComOrgVoMap);
        }
    }

    private void refreshDownAmount(List<SubComActivityDesignDetailDto> newList, int index, Map<String, ActivityPlanItemVo> planItemMap, Map<String, ActivityDetailPlanItemVo> detailPlanItemMap, AtomicReference<BigDecimal> totalCostAmount, AtomicReference<BigDecimal> offAmount, AtomicReference<BigDecimal> internalAmount, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        AtomicReference<BigDecimal> offOccAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> internalOccAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> autoOccAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (totalCostAmount.get().compareTo(offAmount.get()) >= 0) {
            newList.get(index).getFeeDetail().setOffAmount(offAmount.get());
            totalCostAmount.set(totalCostAmount.get().subtract(offAmount.get()));
        } else {
            newList.get(index).getFeeDetail().setOffAmount(totalCostAmount.get());
            totalCostAmount.set(BigDecimal.ZERO);
        }
        offOccAmount.set(newList.get(index).getFeeDetail().getOffAmount());
        if (totalCostAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            if (totalCostAmount.get().compareTo(internalAmount.get()) >= 0) {
                newList.get(index).getFeeDetail().setInternalAmount(internalAmount.get());
                totalCostAmount.set(totalCostAmount.get().subtract(internalAmount.get()));
            } else {
                newList.get(index).getFeeDetail().setInternalAmount(totalCostAmount.get());
                totalCostAmount.set(BigDecimal.ZERO);
            }
        } else {
            newList.get(index).getFeeDetail().setInternalAmount(BigDecimal.ZERO);
        }
        internalOccAmount.set(newList.get(index).getFeeDetail().getInternalAmount());
        if (totalCostAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            newList.get(index).getFeeDetail().setAutoAmount(totalCostAmount.get());
        } else {
            newList.get(index).getFeeDetail().setAutoAmount(BigDecimal.ZERO);
        }
        autoOccAmount.set(newList.get(index).getFeeDetail().getAutoAmount());
        ArrayList designBudgetList = new ArrayList();
        int finalIndex = index;
        newList.get(index).getPlanList().forEach(plan -> {
            if (RelationTypeEnum.UP_RELATION_PLAN.getCode().equals(plan.getAssociationType())) {
                this.refreshDownPlanAmount(newList, finalIndex, (SubComActivityDesignPlanDto)plan, planItemMap, designBudgetList, offOccAmount, internalOccAmount, autoOccAmount, salesOrgSubComOrgVoMap);
            }
            if (RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(plan.getAssociationType())) {
                this.refreshDownDetailPlanAmount(newList, finalIndex, (SubComActivityDesignPlanDto)plan, detailPlanItemMap, designBudgetList, offOccAmount, internalOccAmount, autoOccAmount, salesOrgSubComOrgVoMap);
            }
        });
        newList.get(index).setBudgetList(designBudgetList);
    }

    private void refreshDownDetailPlanAmount(List<SubComActivityDesignDetailDto> newList, int finalIndex, SubComActivityDesignPlanDto plan, Map<String, ActivityDetailPlanItemVo> detailPlanItemMap, List<SubComActivityDesignBudgetDto> designBudgetList, AtomicReference<BigDecimal> offOccAmount, AtomicReference<BigDecimal> internalOccAmount, AtomicReference<BigDecimal> autoOccAmount, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        String yearMonthLy;
        SubComActivityDesignBudgetDto subComActivityDesignBudgetDto;
        String yearMonthLy2;
        SubComActivityDesignBudgetDto subComActivityDesignBudgetDto2;
        ActivityDetailPlanItemVo activityDetailPlanItemVo = detailPlanItemMap.get(plan.getPlanDetailCode());
        BigDecimal headFeeAmount = Optional.ofNullable(activityDetailPlanItemVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO);
        plan.setApplyAmount(headFeeAmount.add(Optional.ofNullable(activityDetailPlanItemVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)));
        plan.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO));
        plan.setReminderDownAmount(plan.getApplyAmount().subtract(plan.getDownAmount()));
        BigDecimal planOffpointAmount = Optional.ofNullable(activityDetailPlanItemVo.getOffPointAmount()).orElse(BigDecimal.ZERO);
        if (offOccAmount.get().compareTo(BigDecimal.ZERO) >= 0) {
            if (offOccAmount.get().compareTo(BigDecimal.ZERO) == 0) {
                subComActivityDesignBudgetDto2 = new SubComActivityDesignBudgetDto();
                subComActivityDesignBudgetDto2.setBudgetAmount(offOccAmount.get());
                subComActivityDesignBudgetDto2.setAssociationType(RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode());
                subComActivityDesignBudgetDto2.setFeeSourceCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
                if (StringUtils.isNotBlank((CharSequence)activityDetailPlanItemVo.getHeadBudgetItemCode())) {
                    subComActivityDesignBudgetDto2.setBudgetItemCode(activityDetailPlanItemVo.getHeadBudgetItemCode());
                    subComActivityDesignBudgetDto2.setBudgetItemName(activityDetailPlanItemVo.getHeadBudgetItemName());
                } else if (StringUtils.isNotBlank((CharSequence)activityDetailPlanItemVo.getBudgetItemCode())) {
                    subComActivityDesignBudgetDto2.setBudgetItemCode(activityDetailPlanItemVo.getBudgetItemCode());
                    subComActivityDesignBudgetDto2.setBudgetItemName(activityDetailPlanItemVo.getBudgetItemName());
                }
                subComActivityDesignBudgetDto2.setPlanCode(activityDetailPlanItemVo.getDetailPlanCode());
                subComActivityDesignBudgetDto2.setPlanName(plan.getPlanName());
                subComActivityDesignBudgetDto2.setPlanDetailCode(activityDetailPlanItemVo.getDetailPlanItemCode());
                subComActivityDesignBudgetDto2.setDownAmount(activityDetailPlanItemVo.getDownAmount());
                subComActivityDesignBudgetDto2.setIsAllDown(activityDetailPlanItemVo.getIsAllDown());
                yearMonthLy2 = DateUtil.format((Date)newList.get(finalIndex).getFeeYearMonth(), (String)"yyyy-MM");
                subComActivityDesignBudgetDto2.setYearMonthLy(yearMonthLy2);
                designBudgetList.add(subComActivityDesignBudgetDto2);
            } else if (headFeeAmount.compareTo(BigDecimal.ZERO) > 0) {
                subComActivityDesignBudgetDto2 = new SubComActivityDesignBudgetDto();
                if (offOccAmount.get().compareTo(headFeeAmount) > 0) {
                    offOccAmount.set(offOccAmount.get().subtract(headFeeAmount));
                    subComActivityDesignBudgetDto2.setBudgetAmount(headFeeAmount);
                    activityDetailPlanItemVo.setIsAllDown(BooleanEnum.TRUE.getCapital());
                    activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(headFeeAmount));
                } else {
                    subComActivityDesignBudgetDto2.setBudgetAmount(offOccAmount.get());
                    subComActivityDesignBudgetDto2.setDownAmount(planOffpointAmount.add(offOccAmount.get()));
                    subComActivityDesignBudgetDto2.setIsAllDown(BooleanEnum.FALSE.getCapital());
                    offOccAmount.set(BigDecimal.ZERO);
                    activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(offOccAmount.get()));
                }
                subComActivityDesignBudgetDto2.setAssociationType(RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode());
                subComActivityDesignBudgetDto2.setFeeSourceCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
                subComActivityDesignBudgetDto2.setBudgetItemCode(activityDetailPlanItemVo.getHeadBudgetItemCode());
                subComActivityDesignBudgetDto2.setBudgetItemName(activityDetailPlanItemVo.getHeadBudgetItemName());
                subComActivityDesignBudgetDto2.setPlanCode(activityDetailPlanItemVo.getDetailPlanCode());
                subComActivityDesignBudgetDto2.setPlanName(plan.getPlanName());
                subComActivityDesignBudgetDto2.setPlanDetailCode(activityDetailPlanItemVo.getDetailPlanItemCode());
                subComActivityDesignBudgetDto2.setDownAmount(activityDetailPlanItemVo.getDownAmount());
                subComActivityDesignBudgetDto2.setIsAllDown(activityDetailPlanItemVo.getIsAllDown());
                yearMonthLy2 = DateUtil.format((Date)newList.get(finalIndex).getFeeYearMonth(), (String)"yyyy-MM");
                subComActivityDesignBudgetDto2.setYearMonthLy(yearMonthLy2);
                designBudgetList.add(subComActivityDesignBudgetDto2);
            }
        }
        if (offOccAmount.get().compareTo(BigDecimal.ZERO) > 0 && offOccAmount.get().compareTo(BigDecimal.ZERO) != 0 && planOffpointAmount.compareTo(BigDecimal.ZERO) > 0) {
            subComActivityDesignBudgetDto2 = new SubComActivityDesignBudgetDto();
            if (offOccAmount.get().compareTo(planOffpointAmount) > 0) {
                offOccAmount.set(offOccAmount.get().subtract(planOffpointAmount));
                subComActivityDesignBudgetDto2.setBudgetAmount(planOffpointAmount);
                activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(planOffpointAmount).orElse(BigDecimal.ZERO).add(planOffpointAmount));
                activityDetailPlanItemVo.setIsAllDown(BooleanEnum.TRUE.getCapital());
                activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(planOffpointAmount));
            } else {
                subComActivityDesignBudgetDto2.setBudgetAmount(offOccAmount.get());
                subComActivityDesignBudgetDto2.setDownAmount(Optional.ofNullable(planOffpointAmount).orElse(BigDecimal.ZERO).add(offOccAmount.get()));
                subComActivityDesignBudgetDto2.setIsAllDown(BooleanEnum.FALSE.getCapital());
                offOccAmount.set(BigDecimal.ZERO);
                activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(offOccAmount.get()));
            }
            subComActivityDesignBudgetDto2.setAssociationType(RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode());
            subComActivityDesignBudgetDto2.setFeeSourceCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
            subComActivityDesignBudgetDto2.setBudgetItemCode(activityDetailPlanItemVo.getBudgetItemCode());
            subComActivityDesignBudgetDto2.setBudgetItemName(activityDetailPlanItemVo.getBudgetItemName());
            subComActivityDesignBudgetDto2.setPlanCode(activityDetailPlanItemVo.getDetailPlanCode());
            subComActivityDesignBudgetDto2.setPlanName(plan.getPlanName());
            subComActivityDesignBudgetDto2.setPlanDetailCode(activityDetailPlanItemVo.getDetailPlanItemCode());
            subComActivityDesignBudgetDto2.setDownAmount(activityDetailPlanItemVo.getDownAmount());
            subComActivityDesignBudgetDto2.setIsAllDown(activityDetailPlanItemVo.getIsAllDown());
            yearMonthLy2 = DateUtil.format((Date)newList.get(finalIndex).getFeeYearMonth(), (String)"yyyy-MM");
            subComActivityDesignBudgetDto2.setYearMonthLy(yearMonthLy2);
            designBudgetList.add(subComActivityDesignBudgetDto2);
        }
        BigDecimal planIntraCompanyAmount = Optional.ofNullable(activityDetailPlanItemVo.getIntraCompanyAmount()).orElse(BigDecimal.ZERO);
        if (internalOccAmount.get().compareTo(BigDecimal.ZERO) >= 0 && planIntraCompanyAmount.compareTo(BigDecimal.ZERO) > 0) {
            subComActivityDesignBudgetDto = new SubComActivityDesignBudgetDto();
            if (internalOccAmount.get().compareTo(planIntraCompanyAmount) > 0) {
                internalOccAmount.set(internalOccAmount.get().subtract(planIntraCompanyAmount));
                subComActivityDesignBudgetDto.setBudgetAmount(planIntraCompanyAmount);
                activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(planIntraCompanyAmount));
                activityDetailPlanItemVo.setIsAllDown(BooleanEnum.TRUE.getCapital());
            } else {
                subComActivityDesignBudgetDto.setBudgetAmount(internalOccAmount.get());
                activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(internalOccAmount.get()));
                activityDetailPlanItemVo.setIsAllDown(BooleanEnum.FALSE.getCapital());
                internalOccAmount.set(BigDecimal.ZERO);
            }
            subComActivityDesignBudgetDto.setAssociationType(RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode());
            subComActivityDesignBudgetDto.setBudgetItemCode(activityDetailPlanItemVo.getBudgetItemCode());
            subComActivityDesignBudgetDto.setBudgetItemName(activityDetailPlanItemVo.getBudgetItemName());
            subComActivityDesignBudgetDto.setPlanCode(activityDetailPlanItemVo.getDetailPlanCode());
            subComActivityDesignBudgetDto.setPlanName(plan.getPlanName());
            subComActivityDesignBudgetDto.setPlanDetailCode(activityDetailPlanItemVo.getDetailPlanItemCode());
            subComActivityDesignBudgetDto.setDownAmount(activityDetailPlanItemVo.getDownAmount());
            subComActivityDesignBudgetDto.setIsAllDown(activityDetailPlanItemVo.getIsAllDown());
            subComActivityDesignBudgetDto.setFeeSourceCode(FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
            yearMonthLy = DateUtil.format((Date)newList.get(finalIndex).getFeeYearMonth(), (String)"yyyy-MM");
            subComActivityDesignBudgetDto.setYearMonthLy(yearMonthLy);
            designBudgetList.add(subComActivityDesignBudgetDto);
        }
        if (autoOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            subComActivityDesignBudgetDto = new SubComActivityDesignBudgetDto();
            subComActivityDesignBudgetDto.setAssociationType(RelationTypeEnum.NO_RELATION.getCode());
            subComActivityDesignBudgetDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
            subComActivityDesignBudgetDto.setBudgetItemCode("A023");
            subComActivityDesignBudgetDto.setBudgetItemName("\u5206\u516c\u53f8\u81ea\u6295");
            subComActivityDesignBudgetDto.setBudgetAmount(autoOccAmount.get());
            yearMonthLy = DateUtil.format((Date)newList.get(finalIndex).getFeeYearMonth(), (String)"yyyy-MM");
            subComActivityDesignBudgetDto.setYearMonthLy(yearMonthLy);
            designBudgetList.add(subComActivityDesignBudgetDto);
        }
        yearMonthLy2 = DateUtil.format((Date)newList.get(finalIndex).getFeeYearMonth(), (String)"yyyy-MM");
        designBudgetList.forEach(item -> item.setYearMonthLy(yearMonthLy2));
        BigDecimal downAmount = Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO);
        if (planOffpointAmount.add(planIntraCompanyAmount).compareTo(downAmount) <= 0) {
            activityDetailPlanItemVo.setIsAllDown(BooleanEnum.TRUE.getCapital());
        }
        if (offOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            throw new IllegalArgumentException("\u5173\u8054\u7ec6\u6848\u70b9\u5916\u8d39\u7528\u4e0d\u8db3\uff01");
        }
        if (internalOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            throw new IllegalArgumentException("\u5173\u8054\u7ec6\u6848\u70b9\u5185\u8d39\u7528\u4e0d\u8db3\uff01");
        }
        detailPlanItemMap.put(plan.getPlanDetailCode(), activityDetailPlanItemVo);
    }

    private void refreshDownPlanAmount(List<SubComActivityDesignDetailDto> newList, int finalIndex, SubComActivityDesignPlanDto plan, Map<String, ActivityPlanItemVo> planItemMap, List<SubComActivityDesignBudgetDto> designBudgetList, AtomicReference<BigDecimal> offOccAmount, AtomicReference<BigDecimal> internalOccAmount, AtomicReference<BigDecimal> autoOccAmount, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        SubComActivityDesignBudgetDto subComActivityDesignBudgetDto;
        ActivityPlanItemVo activityPlanItemVo = planItemMap.get(plan.getPlanDetailCode());
        plan.setApplyAmount(Optional.ofNullable(activityPlanItemVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(activityPlanItemVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)));
        plan.setDownAmount(Optional.ofNullable(activityPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO));
        plan.setReminderDownAmount(plan.getApplyAmount().subtract(plan.getDownAmount()));
        if (offOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            if (BooleanEnum.TRUE.getCapital().equals(activityPlanItemVo.getIsAllDown())) {
                return;
            }
            if (offOccAmount.get().compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            subComActivityDesignBudgetDto = new SubComActivityDesignBudgetDto();
            if (offOccAmount.get().compareTo(plan.getApplyAmount()) > 0) {
                offOccAmount.set(offOccAmount.get().subtract(plan.getApplyAmount()));
                subComActivityDesignBudgetDto.setBudgetAmount(plan.getApplyAmount());
                activityPlanItemVo.setDownAmount(Optional.ofNullable(activityPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(plan.getApplyAmount()));
            } else {
                subComActivityDesignBudgetDto.setBudgetAmount(offOccAmount.get());
                activityPlanItemVo.setDownAmount(Optional.ofNullable(activityPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(offOccAmount.get()));
                offOccAmount.set(BigDecimal.ZERO);
            }
            subComActivityDesignBudgetDto.setAssociationType(RelationTypeEnum.UP_RELATION_PLAN.getCode());
            subComActivityDesignBudgetDto.setFeeSourceCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
            subComActivityDesignBudgetDto.setBudgetItemCode(activityPlanItemVo.getBudgetItemCode());
            subComActivityDesignBudgetDto.setBudgetItemName(activityPlanItemVo.getBudgetItemName());
            subComActivityDesignBudgetDto.setPlanCode(activityPlanItemVo.getPlanCode());
            subComActivityDesignBudgetDto.setPlanName(plan.getPlanName());
            subComActivityDesignBudgetDto.setPlanDetailCode(activityPlanItemVo.getPlanItemCode());
            subComActivityDesignBudgetDto.setDownAmount(activityPlanItemVo.getDownAmount());
            designBudgetList.add(subComActivityDesignBudgetDto);
        }
        if (autoOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            subComActivityDesignBudgetDto = new SubComActivityDesignBudgetDto();
            subComActivityDesignBudgetDto.setAssociationType(RelationTypeEnum.NO_RELATION.getCode());
            subComActivityDesignBudgetDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
            subComActivityDesignBudgetDto.setBudgetItemCode("A023");
            subComActivityDesignBudgetDto.setBudgetItemName("\u5206\u516c\u53f8\u81ea\u6295");
            subComActivityDesignBudgetDto.setBudgetAmount(autoOccAmount.get());
            designBudgetList.add(subComActivityDesignBudgetDto);
        }
        String yearMonthLy = DateUtil.format((Date)newList.get(finalIndex).getFeeYearMonth(), (String)"yyyy-MM");
        designBudgetList.forEach(item -> item.setYearMonthLy(yearMonthLy));
        planItemMap.put(plan.getPlanDetailCode(), activityPlanItemVo);
    }

    public List<SubComActivityDesignDetailDto> copyItem(String cacheKey, List<SubComActivityDesignDetailDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, SubComActivityDesignDetailDto.class, SubComActivityDesignDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (SubComActivityDesignDetailDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setActivityDesignDetailCode(null);
        }
        return newItemList;
    }

    public Object getDtoKey(SubComActivityDesignDetailDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(SubComActivityDesignDetailDto dto) {
        return dto.getChecked();
    }

    public void fillVoListProperties(List<SubComActivityDesignDetailVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List subComActivityDesignFeeDetailVos = this.subComActivityDesignFeeDetailService.listByDesignCodeList(records.get(0).getActivityDesignCode());
        List subComActivityDesignPlanVos = this.subComActivityDesignPlanService.listByDesignCodeList(records.get(0).getActivityDesignCode());
        List subComActivityDesignProductVos = this.subComActivityDesignProductService.listByDesignCodeList(records.get(0).getActivityDesignCode());
        Map feeDetailMap = subComActivityDesignFeeDetailVos.stream().collect(Collectors.toMap(SubComActivityDesignFeeDetailVo::getActivityDesignDetailCode, Function.identity()));
        Map<String, List<SubComActivityDesignPlanVo>> planMap = subComActivityDesignPlanVos.stream().collect(Collectors.groupingBy(SubComActivityDesignPlanVo::getActivityDesignDetailCode));
        Map<String, List<SubComActivityDesignProductVo>> productMap = subComActivityDesignProductVos.stream().collect(Collectors.groupingBy(SubComActivityDesignProductVo::getActivityDesignDetailCode));
        records.forEach(record -> {
            if (feeDetailMap.containsKey(record.getActivityDesignDetailCode())) {
                record.setFeeDetail((SubComActivityDesignFeeDetailVo)feeDetailMap.get(record.getActivityDesignDetailCode()));
            }
            if (planMap.containsKey(record.getActivityDesignDetailCode())) {
                record.setPlanList((List)planMap.get(record.getActivityDesignDetailCode()));
            }
            if (productMap.containsKey(record.getActivityDesignDetailCode())) {
                record.setProductList((List)productMap.get(record.getActivityDesignDetailCode()));
            }
        });
    }

    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        return redisCacheInitKey.replace(templateCode, "");
    }
}

