/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanRollbackBudgetEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.enums.SubComActivityValidationFormCodeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanStatusEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastLockService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignFeeDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.helper.SubComActivityDesignHelper;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignFeeDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignCloseApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignNetEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignSapEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.SubComActivityDesignDetailAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SubComActivityDesignNetEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SubComActivityDesignSapEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.RelationPolicySelectVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SpecialCostVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignSapEventResponse;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityDesignDetailServiceImpl
implements SubComActivityDesignDetailService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignDetailServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignDetailRepository subComActivityDesignDetailRepository;
    @Autowired(required=false)
    private MnPageCacheHelper<SubComActivityDesignDetailVo, SubComActivityDesignDetailDto> helper;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Resource
    private SubComActivityDesignHelper subComActivityDesignHelper;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private SubComActivityPlanItemService subComActivityPlanItemService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SubComActivityDesignFeeDetailRepository subComActivityDesignFeeDetailRepository;
    @Autowired(required=false)
    private SubComActivityDesignBudgetRepository subComActivityDesignBudgetRepository;
    @Autowired(required=false)
    private SubComBudgetForecastLockService subComBudgetForecastLockService;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public List<SubComActivityDesignDetailDto> findDtoList(SubComActivityDesignDetailDto dto) {
        List<String> activityDesignDetailCodeList;
        List<SubComActivityDesignDetailVo> statusList;
        List<SubComActivityDesignDetailDto> dtoList = this.subComActivityDesignDetailRepository.findDtoList(dto);
        if (!CollectionUtils.isEmpty(dtoList) && !CollectionUtils.isEmpty(statusList = this.subComActivityDesignDetailRepository.findSubComActivityDetailItemStatus(activityDesignDetailCodeList = dtoList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).collect(Collectors.toList())))) {
            Map statusMap = statusList.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity()));
            for (SubComActivityDesignDetailDto subComActivityDesignDetailDto : dtoList) {
                if (!statusMap.containsKey(subComActivityDesignDetailDto.getActivityDesignDetailCode())) continue;
                SubComActivityDesignDetailVo statusVo = (SubComActivityDesignDetailVo)statusMap.get(subComActivityDesignDetailDto.getActivityDesignDetailCode());
                subComActivityDesignDetailDto.setOrderShareInterfaceState(statusVo.getOrderShareInterfaceState());
                subComActivityDesignDetailDto.setSapInterfaceState(statusVo.getSapInterfaceState());
            }
        }
        return dtoList;
    }

    public void saveSubComActivityDesignDetailList(SubComActivityDesignDto dto, boolean updateFlag, List<SubComActivityDesignDetailDto> itemCacheList) {
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (updateFlag) {
            List<SubComActivityDesignDetailEntity> oldList = this.subComActivityDesignDetailRepository.findListByCode(dto.getActivityDesignCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        List activityPlanItems = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemCacheList, SubComActivityDesignDetailDto.class, SubComActivityDesignDetailEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDesignDetailEntity item : activityPlanItems) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDesignDetailRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDesignDetailRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityDesignDetailRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    public List<SpecialCostVo> findSpecialCost(SubComActivityDesignDetailDto subComActivityDesignDetailDto) {
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)subComActivityDesignDetailDto.getActivityDesignDetailCodeList()) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.subComActivityDesignDetailRepository.findSpecialCost(subComActivityDesignDetailDto);
    }

    public List<SubComActivityDesignDetailVo> findBudgetDetailByConditions(SubComActivityDesignDetailDto subComActivityDesignDetailDto) {
        return this.subComActivityDesignDetailRepository.findBudgetDetailByConditions(subComActivityDesignDetailDto);
    }

    public List<SubComActivityDesignDetailVo> findApportionDetailByConditions(SubComActivityDesignDetailDto subComActivityDesignDetailDto) {
        return this.subComActivityDesignDetailRepository.findApportionDetailByConditions(subComActivityDesignDetailDto);
    }

    public BigDecimal getApplyAmount(String cacheKey, String activityDesignCode) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        Set idKeys = this.redisTemplate.keys((Object)(redisCacheIdKey + "*"));
        ArrayList dataList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)idKeys)) {
            for (String idKey : idKeys) {
                String dataKey = idKey.replace("id:", "data:");
                List idList = this.redisService.lRange(idKey, 0L, -1L);
                dataList.addAll(this.redisTemplate.opsForHash().multiGet((Object)dataKey, (Collection)idList));
            }
            ArrayList dtoList = new ArrayList();
            dataList.forEach(data -> {
                SubComActivityDesignDetailDto subComActivityDesignDetailDto = (SubComActivityDesignDetailDto)data;
                dtoList.add(subComActivityDesignDetailDto);
            });
            if (!CollectionUtils.isEmpty(dtoList)) {
                BigDecimal reduce = dtoList.stream().map(SubComActivityDesignDetailDto::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                return reduce;
            }
        } else if (!StringUtils.isEmpty((CharSequence)activityDesignCode)) {
            List<SubComActivityDesignDetailEntity> listByCode = this.subComActivityDesignDetailRepository.findListByCode(activityDesignCode);
            if (CollectionUtils.isEmpty(listByCode)) {
                return BigDecimal.ZERO;
            }
            BigDecimal reduce = listByCode.stream().map(SubComActivityDesignDetailEntity::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            return reduce;
        }
        return BigDecimal.ZERO;
    }

    public void generatePromotionNo(List<SubComActivityDesignDetailDto> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        List itemNList = detailList.stream().filter(k -> TotalQuantityOrNotEnum.N.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        List itemYList = detailList.stream().filter(k -> TotalQuantityOrNotEnum.Y.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        List itemZList = detailList.stream().filter(k -> TotalQuantityOrNotEnum.Z.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        Map<String, List<SubComActivityDesignDetailDto>> detailMap = detailList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailDto::getActivityNumber));
        for (String key : detailMap.keySet()) {
            List<SubComActivityDesignDetailDto> subComActivityDesignDetailDtos = detailMap.get(key);
            if (CollectionUtils.isEmpty(subComActivityDesignDetailDtos) || subComActivityDesignDetailDtos.size() <= 1) continue;
            subComActivityDesignDetailDtos.forEach(d -> Validate.isTrue((boolean)TotalQuantityOrNotEnum.Y.getCode().equals(d.getIsSupplyAmount()), (String)"\u4fbf\u7b7e\u53f7\u76f8\u540c\u65f6\uff0c\u5171\u7528\u91cf\u53ea\u80fd\u4e3aY", (Object[])new Object[0]));
            Set collect = subComActivityDesignDetailDtos.stream().map(SubComActivityDesignDetailDto::getIsSupplyAmount).filter(Objects::nonNull).collect(Collectors.toSet());
            Validate.isTrue((collect.size() == 1 ? 1 : 0) != 0, (String)"\u4fbf\u7b7e\u53f7\u76f8\u540c\u65f6\uff0c\u5171\u7528\u91cf\u4e5f\u5e94\u76f8\u540c!", (Object[])new Object[0]);
            if (!collect.contains(TotalQuantityOrNotEnum.Y.getCode()) || subComActivityDesignDetailDtos.size() <= 1) continue;
            Set vaStrSet = subComActivityDesignDetailDtos.stream().map(i -> i.getActivityFormCode() + DateUtil.format((Date)i.getActivityBeginTime(), (String)"yyyyMMdd") + DateUtil.format((Date)i.getActivityEndTime(), (String)"yyyyMMdd")).collect(Collectors.toSet());
            Validate.isTrue((vaStrSet.size() == 1 ? 1 : 0) != 0, (String)"'Y'\u7c7b\u578b\u5171\u7528\u91cf\u4e14\u4fbf\u7b7e\u53f7\u76f8\u540c\u7684\u6d3b\u52a8\uff0c\u6d3b\u52a8\u5f62\u5f0f\u3001\u6d3b\u52a8\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\uff0c\u987b\u76f8\u540c\uff0c\u8bf7\u6ce8\u610f\u3002", (Object[])new Object[0]);
        }
        String rule = "P-";
        Date currentDate = DateUtil.getDate((SimpleDateFormat)DateUtil.date_yyyy_MM_dd);
        if (!CollectionUtils.isEmpty(itemNList)) {
            List activityNumbers = itemNList.stream().map(SubComActivityDesignDetailDto::getActivityNumber).filter(Objects::nonNull).collect(Collectors.toList());
            Validate.isTrue((activityNumbers.size() == itemNList.size() ? 1 : 0) != 0, (String)"N\u5171\u7528\u91cf\u6d3b\u52a8\u7684\u4fbf\u7b7e\u53f7\u4e0d\u53ef\u76f8\u540c\uff01", (Object[])new Object[0]);
            List nPromotionNoList = this.generateCodeService.generateCode(rule, itemNList.size(), Integer.valueOf(8), -1L, TimeUnit.DAYS);
            for (int i2 = 0; i2 < nPromotionNoList.size(); ++i2) {
                String promotionNo = (String)nPromotionNoList.get(i2);
                SubComActivityDesignDetailDto nItem = (SubComActivityDesignDetailDto)itemNList.get(i2);
                if (SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(nItem.getAuditType())) {
                    Validate.isTrue((currentDate.compareTo(nItem.getActivityBeginTime()) <= 0 ? 1 : 0) != 0, (String)"\u4e8b\u4e2d\u6d3b\u52a8\uff0c\u6d3b\u52a8\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5bfc\u5165\u5f53\u5929\u65e5\u671f", (Object[])new Object[0]);
                }
                nItem.setPromotionNo(promotionNo);
                nItem.setConstituentDetailPlanItemCode(promotionNo + String.format("%04d", i2));
                nItem.setActivityDesignDetailCode(nItem.getConstituentDetailPlanItemCode());
            }
        }
        if (!CollectionUtils.isEmpty(itemYList)) {
            List yPromotionNoList = this.generateCodeService.generateCode(rule, itemYList.size(), Integer.valueOf(8), -1L, TimeUnit.DAYS);
            for (int i3 = 0; i3 < yPromotionNoList.size(); ++i3) {
                String promotionNo = (String)yPromotionNoList.get(i3);
                SubComActivityDesignDetailDto yItem = (SubComActivityDesignDetailDto)itemYList.get(i3);
                if (SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(yItem.getAuditType())) {
                    Validate.isTrue((currentDate.compareTo(yItem.getActivityBeginTime()) <= 0 ? 1 : 0) != 0, (String)"\u4e8b\u4e2d\u6d3b\u52a8\uff0c\u6d3b\u52a8\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5bfc\u5165\u5f53\u5929\u65e5\u671f", (Object[])new Object[0]);
                } else {
                    Validate.isTrue((boolean)false, (String)"\u6838\u9500\u65b9\u5f0f\u4e3a\u4e8b\u540e\u7c7b\u578b\uff0c\u5171\u7528\u91cf\u7c7b\u578b\u5fc5\u987b\u4e3a'N'", (Object[])new Object[0]);
                }
                yItem.setPromotionNo(promotionNo);
                yItem.setConstituentDetailPlanItemCode(promotionNo + String.format("%04d", i3));
                yItem.setActivityDesignDetailCode(yItem.getConstituentDetailPlanItemCode());
            }
        }
        if (!CollectionUtils.isEmpty(itemZList)) {
            List zPromotionNoList = this.generateCodeService.generateCode(rule, itemZList.size(), Integer.valueOf(8), -1L, TimeUnit.DAYS);
            for (int i4 = 0; i4 < zPromotionNoList.size(); ++i4) {
                String promotionNo = (String)zPromotionNoList.get(i4);
                SubComActivityDesignDetailDto zItem = (SubComActivityDesignDetailDto)itemZList.get(i4);
                Validate.isTrue(("ZS03".equals(zItem.getActivityFormCode()) || "ZS02".equals(zItem.getActivityFormCode()) ? 1 : 0) != 0, (String)"'Z'\u5171\u7528\u91cf\uff0c\u53ea\u9002\u7528\u4e8e'ZS03'\u7279\u4ef7\u6d3b\u52a8\u548c'ZS02'\u642d\u8d60\u6d3b\u52a8\uff01", (Object[])new Object[0]);
                if (SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(zItem.getAuditType())) {
                    Validate.isTrue((currentDate.compareTo(zItem.getActivityBeginTime()) <= 0 ? 1 : 0) != 0, (String)"\u4e8b\u4e2d\u6d3b\u52a8\uff0c\u6d3b\u52a8\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5bfc\u5165\u5f53\u5929\u65e5\u671f", (Object[])new Object[0]);
                } else {
                    Validate.isTrue((boolean)false, (String)"Z\u5171\u7528\u91cf\u6d3b\u52a8\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2018\u4e8b\u4e2d\u2019", (Object[])new Object[0]);
                }
                if (BooleanEnum.TRUE.getCapital().equals(zItem.getIsAssPromotion())) {
                    if (StringUtils.isBlank((CharSequence)zItem.getPromotionCode())) {
                        throw new RuntimeException("\u662f\u5426\u5173\u8054\u4fc3\u9500\u653f\u7b56\u4e3a\u662f\uff0c\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!TotalQuantityOrNotEnum.Z.getCode().equals(zItem.getIsSupplyAmount())) {
                        throw new RuntimeException("\u662f\u5426\u5173\u8054\u4fc3\u9500\u653f\u7b56\u4e3a\u662f\uff0c\u662f\u5426\u5171\u7528\u91cf\u5fc5\u987b\u4e3aZ");
                    }
                } else if (TotalQuantityOrNotEnum.Z.getCode().equals(zItem.getIsSupplyAmount())) {
                    if (SubComActivityValidationFormCodeEnum.ZS03.name().equals(zItem.getActivityFormCode())) {
                        Validate.notBlank((CharSequence)zItem.getProductCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u7279\u4ef7\uff08ZS03\uff09\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)zItem.getProductName(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u7279\u4ef7\uff08ZS03\uff09\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notNull((Object)zItem.getOriginalProductPrice(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u7279\u4ef7\uff08ZS03\uff09\uff0c\u539f\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notNull((Object)zItem.getActivityPrice(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u7279\u4ef7\uff08ZS03\uff09\uff0c\u6d3b\u52a8\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)zItem.getUnitCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u7279\u4ef7\uff08ZS03\uff09\uff0c\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)zItem.getUnit(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u7279\u4ef7\uff08ZS03\uff09\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(zItem.getActivityFormCode())) {
                        Validate.notBlank((CharSequence)zItem.getProductCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)zItem.getProductName(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notNull((Object)zItem.getOriginalProductPrice(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u539f\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notNull((Object)zItem.getOriginalProductNumber(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u539f\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)zItem.getGiftProductCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notNull((Object)zItem.getGiftProductPrice(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u8d60\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notNull((Object)zItem.getGiftProductNumber(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u8d60\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)zItem.getUnitCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)zItem.getUnit(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u642d\u8d60\uff08ZS02\uff09\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                }
                zItem.setPromotionNo(promotionNo);
                zItem.setConstituentDetailPlanItemCode(promotionNo + String.format("%04d", i4));
                zItem.setActivityDesignDetailCode(zItem.getConstituentDetailPlanItemCode());
            }
        }
    }

    public Integer getTotal(String cacheKey) {
        String redisCacheKey = "sub_com_activity_design:item_cache:id:" + cacheKey;
        return this.redisService.lSize(redisCacheKey).intValue();
    }

    public List<SubComActivityDesignDetailVo> findDesignDetailByCodeList(Set<String> activityDetailCodes) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignDetailEntity> designDetailByCodeList = this.subComActivityDesignDetailRepository.findDesignDetailByCodeList(activityDetailCodes);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(designDetailByCodeList, SubComActivityDesignDetailEntity.class, SubComActivityDesignDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Page<SubComActivityDesignDetailVo> closeFindDetail(Pageable pageable, SubComActivityDesignDetailDto dto) {
        Page<SubComActivityDesignDetailVo> pageResult;
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)dto.getActivityDesignCodeList(), (String)"\u6d3b\u52a8\u89c4\u5212\u7f16\u7801\u96c6\u5408\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtil.isNotEmpty((CharSequence)dto.getPromotionNo())) {
            dto.setPromotionNoList(Arrays.asList(dto.getPromotionNo().split(" ")));
            dto.setPromotionNo("");
        }
        if (StringUtil.isNotEmpty((CharSequence)dto.getActivityNumber())) {
            dto.setActivityNumberList(Arrays.asList(dto.getActivityNumber().split(" ")));
            dto.setActivityNumber("");
        }
        if (CollectionUtil.isEmpty((Collection)(pageResult = this.subComActivityDesignDetailRepository.closeFindDetail((Page<SubComActivityDesignDetailVo>)page, dto)).getRecords())) {
            return pageResult;
        }
        List<String> itemCodes = pageResult.getRecords().stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).collect(Collectors.toList());
        Set<String> activityNumberTotalSet = pageResult.getRecords().stream().map(SubComActivityDesignDetailVo::getActivityNumber).collect(Collectors.toSet());
        List<SubComActivityDesignDetailEntity> activityNumberList = this.subComActivityDesignDetailRepository.listByActivityNumberList(activityNumberTotalSet);
        HashMap sapAmountTotalMap = Maps.newHashMap();
        HashMap sapQuantityTotalMap = Maps.newHashMap();
        Map<String, String> sapKeyValueMap = activityNumberList.stream().collect(Collectors.toMap(SubComActivityDesignDetailEntity::getActivityDesignDetailCode, SubComActivityDesignDetailEntity::getActivityNumber, (n, o) -> n));
        if (CollectionUtil.isNotEmpty(activityNumberList)) {
            List itemTotalCodes = activityNumberList.stream().map(SubComActivityDesignDetailEntity::getActivityDesignDetailCode).collect(Collectors.toList());
            SubComActivityDesignSapEventDto sapDto = new SubComActivityDesignSapEventDto();
            sapDto.setActivityNos(itemTotalCodes);
            SerializableBiConsumer & Serializable getSapAmountAndQuantity = SubComActivityDesignSapEventListener::getSapAmountAndQuantity;
            SubComActivityDesignSapEventResponse eventResponse = (SubComActivityDesignSapEventResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)sapDto, SubComActivityDesignSapEventListener.class, (SerializableBiConsumer)getSapAmountAndQuantity);
            if (null != eventResponse.getSapAmountMap() && !eventResponse.getSapAmountMap().isEmpty()) {
                eventResponse.getSapAmountMap().forEach((activityDesignDetailCode, amount) -> {
                    String activityNumber = sapKeyValueMap.getOrDefault(activityDesignDetailCode, "");
                    if (StringUtil.isNotEmpty((CharSequence)activityNumber)) {
                        BigDecimal decimal = sapAmountTotalMap.getOrDefault(activityNumber, BigDecimal.ZERO);
                        sapAmountTotalMap.put(activityNumber, decimal.add((BigDecimal)amount));
                    }
                });
            }
            if (null != eventResponse.getSapQuantityMap() && !eventResponse.getSapQuantityMap().isEmpty()) {
                eventResponse.getSapQuantityMap().forEach((activityDesignDetailCode, quantity) -> {
                    String activityNumber = sapKeyValueMap.getOrDefault(activityDesignDetailCode, "");
                    if (StringUtil.isNotEmpty((CharSequence)activityNumber)) {
                        BigDecimal decimal = sapQuantityTotalMap.getOrDefault(activityNumber, BigDecimal.ZERO);
                        sapQuantityTotalMap.put(activityNumber, decimal.add((BigDecimal)quantity));
                    }
                });
            }
        }
        List<SubComActivityDesignDetailVo> designDetailVos = this.subComActivityDesignDetailRepository.getInfoByActivityDesignDetailCodes(itemCodes);
        HashMap designDetailVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(designDetailVos)) {
            designDetailVoMap.putAll(designDetailVos.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, v -> v, (n, o) -> n)));
        }
        SubComActivityDesignSapEventDto sapDto = new SubComActivityDesignSapEventDto();
        sapDto.setActivityNos(itemCodes);
        SerializableBiConsumer & Serializable getSapAmountAndQuantity = SubComActivityDesignSapEventListener::getSapAmountAndQuantity;
        SubComActivityDesignSapEventResponse eventResponse = (SubComActivityDesignSapEventResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)sapDto, SubComActivityDesignSapEventListener.class, (SerializableBiConsumer)getSapAmountAndQuantity);
        Validate.notNull((Object)eventResponse, (String)"\u83b7\u53d6SAP\u6267\u884c\u6570\u636e\u65f6\uff0c\u4e8b\u4ef6\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Map sapAmountMap = Maps.newHashMap();
        if (null != eventResponse.getSapAmountMap() && !eventResponse.getSapAmountMap().isEmpty()) {
            sapAmountMap = eventResponse.getSapAmountMap();
        }
        Map sapQuantityMap = Maps.newHashMap();
        if (null != eventResponse.getSapQuantityMap() && !eventResponse.getSapQuantityMap().isEmpty()) {
            sapQuantityMap = eventResponse.getSapQuantityMap();
        }
        HashSet activityNumberSet = Sets.newHashSet();
        for (SubComActivityDesignDetailVo record : pageResult.getRecords()) {
            String activityDesignDetailCode2 = record.getActivityDesignDetailCode();
            SubComActivityDesignDetailVo detailVo = (SubComActivityDesignDetailVo)designDetailVoMap.get(activityDesignDetailCode2);
            if (Objects.nonNull(detailVo)) {
                record.setIsSupplyAmount(detailVo.getIsSupplyAmount());
            }
            if (YesOrNoEnum.YES.getCode().equals(record.getIsSupplyAmount())) {
                activityNumberSet.add(record.getActivityNumber());
            }
            record.setAuditTypeName(record.getAuditType());
            record.setExecutedAmount(sapAmountMap.getOrDefault(record.getActivityDesignDetailCode(), BigDecimal.ZERO));
            record.setExecutedQuantity(sapQuantityMap.getOrDefault(record.getActivityDesignDetailCode(), BigDecimal.ZERO));
            record.setTotalCost(Optional.ofNullable(record.getTotalCost()).orElse(BigDecimal.ZERO));
            record.setPromoteSales(Optional.ofNullable(record.getPromoteSales()).orElse(BigDecimal.ZERO));
            record.setReturnAmount(record.getTotalCost().subtract(record.getExecutedAmount()));
            record.setWillRefundQuantity(record.getPromoteSales().subtract(record.getExecutedQuantity()));
            record.setMaxCloseAmount(record.getReturnAmount());
            record.setMaxCloseQuantity(record.getWillRefundQuantity());
            if (ActivityStatusEnum.PASS.getCode().equals(record.getActivityDetailStatus()) || ActivityStatusEnum.CLOSE_REJECT.getCode().equals(record.getActivityDetailStatus()) || ActivityStatusEnum.CLOSE_RECOVER.getCode().equals(record.getActivityDetailStatus())) {
                record.setCanPick(BooleanEnum.TRUE.getCapital());
            } else {
                record.setCanPick(BooleanEnum.FALSE.getCapital());
            }
            if (YesOrNoEnum.YES.getCode().equals(record.getIsSupplyAmount())) continue;
            if (null != record.getPromoteSales() && record.getPromoteSales().compareTo(BigDecimal.ZERO) != 0) {
                record.setReleaseRatio(Optional.ofNullable(record.getTotalCost()).orElse(BigDecimal.ZERO).divide(record.getPromoteSales(), 2, RoundingMode.HALF_UP));
                continue;
            }
            record.setReleaseRatio(BigDecimal.ZERO);
        }
        List<SubComActivityDesignDetailEntity> designDetailEntityList = this.subComActivityDesignDetailRepository.listByActivityNumberList(activityNumberSet);
        if (CollectionUtil.isEmpty(designDetailEntityList)) {
            return pageResult;
        }
        Map<String, List<SubComActivityDesignDetailEntity>> designDetailEntityMap = designDetailEntityList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailEntity::getActivityNumber));
        Map recordMap = pageResult.getRecords().stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity()));
        for (Map.Entry<String, List<SubComActivityDesignDetailEntity>> entry : designDetailEntityMap.entrySet()) {
            String activityNumber = entry.getKey();
            List<SubComActivityDesignDetailEntity> detailEntityList = entry.getValue();
            detailEntityList.sort(Comparator.comparing(item -> Optional.ofNullable(item.getPromoteSales()).orElse(BigDecimal.ZERO)));
            BigDecimal noteApplyAmount = detailEntityList.stream().map(SubComActivityDesignDetailEntity::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal noteApplyQuantity = detailEntityList.stream().map(SubComActivityDesignDetailEntity::getPromoteSales).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal noteOccurAmount = sapAmountTotalMap.getOrDefault(activityNumber, BigDecimal.ZERO);
            BigDecimal noteOccurQuantity = sapQuantityTotalMap.getOrDefault(activityNumber, BigDecimal.ZERO);
            BigDecimal noteCanReleaseQuantity = noteApplyQuantity.subtract(noteOccurQuantity);
            BigDecimal noteCanReleaseAmount = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(noteApplyQuantity) != 0) {
                noteCanReleaseAmount = noteApplyAmount.divide(noteApplyQuantity, 2, 5).multiply(noteCanReleaseQuantity).setScale(2, 5);
            }
            BigDecimal releaseRatio = BigDecimal.ZERO;
            if (noteApplyQuantity.compareTo(BigDecimal.ZERO) != 0) {
                releaseRatio = noteApplyAmount.divide(noteApplyQuantity, 2, RoundingMode.HALF_UP);
            }
            BigDecimal leaveNoteCanReleaseQuantity = noteCanReleaseQuantity;
            BigDecimal leaveNoteCanReleaseAmount = noteCanReleaseAmount;
            SubComActivityDesignDetailVo lastRecord = null;
            for (SubComActivityDesignDetailEntity designDetailEntity : detailEntityList) {
                if (!recordMap.containsKey(designDetailEntity.getActivityDesignDetailCode())) continue;
                SubComActivityDesignDetailVo record = (SubComActivityDesignDetailVo)recordMap.get(designDetailEntity.getActivityDesignDetailCode());
                if (!YesOrNoEnum.YES.getCode().equals(record.getIsSupplyAmount())) continue;
                lastRecord = record;
                record.setNoteApplyAmount(noteApplyAmount);
                record.setNoteApplyQuantity(noteApplyQuantity);
                record.setNoteOccurAmount(noteOccurAmount);
                record.setNoteOccurQuantity(noteOccurQuantity);
                record.setNoteCanReleaseQuantity(noteCanReleaseQuantity);
                record.setNoteCanReleaseAmount(noteCanReleaseAmount);
                record.setReleaseRatio(releaseRatio);
                BigDecimal promoteSales = Optional.ofNullable(record.getPromoteSales()).orElse(BigDecimal.ZERO);
                if (leaveNoteCanReleaseQuantity.compareTo(promoteSales) >= 0) {
                    record.setWillRefundQuantity(promoteSales);
                } else {
                    record.setWillRefundQuantity(leaveNoteCanReleaseQuantity);
                }
                leaveNoteCanReleaseQuantity = leaveNoteCanReleaseQuantity.subtract(record.getWillRefundQuantity());
                BigDecimal totalCost = Optional.ofNullable(record.getTotalCost()).orElse(BigDecimal.ZERO);
                if (leaveNoteCanReleaseAmount.compareTo(totalCost) >= 0) {
                    record.setWillRefundAmount(totalCost);
                } else {
                    record.setWillRefundAmount(leaveNoteCanReleaseAmount);
                }
                record.setReturnAmount(record.getWillRefundAmount());
                leaveNoteCanReleaseAmount = leaveNoteCanReleaseAmount.subtract(record.getWillRefundAmount());
                record.setMaxCloseAmount(record.getReturnAmount());
                record.setMaxCloseQuantity(record.getWillRefundQuantity());
            }
            if (leaveNoteCanReleaseQuantity.compareTo(BigDecimal.ZERO) != 0 && null != lastRecord) {
                lastRecord.setWillRefundQuantity(lastRecord.getWillRefundQuantity().add(leaveNoteCanReleaseQuantity));
                lastRecord.setMaxCloseQuantity(lastRecord.getWillRefundQuantity());
            }
            if (leaveNoteCanReleaseAmount.compareTo(BigDecimal.ZERO) == 0 || null == lastRecord) continue;
            lastRecord.setWillRefundAmount(lastRecord.getWillRefundAmount().add(leaveNoteCanReleaseAmount));
            lastRecord.setReturnAmount(lastRecord.getWillRefundAmount());
            lastRecord.setMaxCloseAmount(lastRecord.getReturnAmount());
        }
        return pageResult;
    }

    @Transactional(rollbackFor={Exception.class})
    public void close(List<SubComActivityDesignDetailDto> detailDtos) {
        this.close(detailDtos, false);
    }

    @Transactional(rollbackFor={Exception.class})
    public void close(List<SubComActivityDesignDetailDto> detailDtos, boolean dealThings) {
        Assert.notEmpty(detailDtos, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.subComActivityDesignHelper.buildByActivityNumberDetail(detailDtos);
        ArrayList subPlanItemFeeDtoList = new ArrayList(detailDtos.size());
        List<String> designDetailCodes = detailDtos.stream().filter(item -> dealThings || !Objects.equals(item.getAuditType(), SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode())).map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> feeDetailList = Lists.newArrayList();
        Map<Object, Object> feeDetailMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(designDetailCodes)) {
            feeDetailList = this.subComActivityDesignFeeDetailRepository.findListByDetailCodes(designDetailCodes);
            feeDetailMap = feeDetailList.stream().collect(Collectors.toMap(SubComActivityDesignFeeDetailEntity::getActivityDesignDetailCode, Function.identity(), (v1, v2) -> v2));
        }
        HashMap dtoMap = Maps.newHashMap();
        detailDtos.forEach(dto -> {
            String id = dto.getId();
            Assert.hasText((String)id, (String)"\u9009\u62e9\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            dtoMap.put(id, dto);
        });
        List<SubComActivityDesignDetailVo> designDetailVoList = this.subComActivityDesignDetailRepository.findByIds(new ArrayList<String>(dtoMap.keySet()));
        Assert.notEmpty(designDetailVoList, (String)"\u660e\u7ec6\u672a\u627e\u5230,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        List<String> activityDesignDetailCodeList = designDetailVoList.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getActivityDesignDetailCode())).map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).distinct().collect(Collectors.toList());
        List<SubComActivityDesignBudgetVo> designBudgetVos = this.subComActivityDesignBudgetRepository.findByActivityDesignDetailCodes(activityDesignDetailCodeList);
        Assert.notEmpty(designBudgetVos, (String)("\u672a\u627e\u7684\u660e\u7ec6" + activityDesignDetailCodeList + "\u9884\u7b97\u9884\u6d4b\u6263\u51cf\u4fe1\u606f"));
        Map<String, List<SubComActivityDesignBudgetVo>> groupMap = designBudgetVos.stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetVo::getActivityDesignDetailCode));
        designDetailVoList.forEach(designDetailVo -> {
            Assert.notNull((Object)designDetailVo, (String)"\u4e3a\u67e5\u8be2\u89c4\u5212\u660e\u7ec6\u6570\u636e\u4fe1\u606f");
            SubComActivityDesignDetailDto dto = (SubComActivityDesignDetailDto)dtoMap.get(designDetailVo.getId());
            Assert.notNull((Object)dto, (String)("\u660e\u7ec6[" + designDetailVo.getId() + "]\u672a\u627e\u5230,\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
            Assert.notEmpty((Collection)((Collection)groupMap.get(designDetailVo.getActivityDesignDetailCode())), (String)("\u660e\u7ec6[" + designDetailVo.getActivityDesignDetailCode() + "]\u672a\u627e\u5230\u9884\u7b97\u9884\u6d4b\u6263\u51cf\u4fe1\u606f!"));
            if (!dealThings && (ActivityPlanStatusEnum.allClose.getCode().equals(designDetailVo.getActivityStatus()) || ActivityPlanStatusEnum.partialClose.getCode().equals(designDetailVo.getActivityStatus()) || ActivityPlanStatusEnum.closed.getCode().equals(designDetailVo.getActivityStatus()))) {
                throw new RuntimeException("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6[" + designDetailVo.getActivityDesignDetailCode() + "]\u5df2\u5173\u95ed\uff01");
            }
        });
        List budgetForecastCodeList = designBudgetVos.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getBudgetForecastCode())).map(SubComActivityDesignBudgetVo::getBudgetForecastCode).distinct().collect(Collectors.toList());
        boolean lockSuccess = this.subComBudgetForecastLockService.lock(budgetForecastCodeList, TimeUnit.MINUTES, 10);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            Map<Object, Object> finalFeeDetailMap = feeDetailMap;
            designDetailVoList.forEach(designDetailVo -> {
                SubComActivityPlanItemFeeDto subPlanItemFeeDto;
                SubComActivityDesignDetailDto dto = (SubComActivityDesignDetailDto)dtoMap.get(designDetailVo.getId());
                String activityDesignDetailCode = designDetailVo.getActivityDesignDetailCode();
                designDetailVo.setReturnAmount(dto.getReturnAmount());
                if (!dealThings && Objects.equals(designDetailVo.getAuditType(), SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode())) {
                    dto.setRefundAmount(BigDecimal.ZERO);
                    dto.setReturnAmount(BigDecimal.ZERO);
                    this.subComActivityDesignHelper.updateCloseStatus((SubComActivityDesignDetailVo)designDetailVo, ActivityDetailPlanRollbackBudgetEnum.NO_ROLLBACK.getCode());
                    return;
                }
                SubComActivityDesignFeeDetailEntity fee = (SubComActivityDesignFeeDetailEntity)((Object)((Object)finalFeeDetailMap.get(designDetailVo.getActivityDesignDetailCode())));
                this.subComActivityDesignHelper.releaseAmount((SubComActivityDesignDetailVo)designDetailVo, fee, dealThings);
                dto.setActivityDesignDetailCode(activityDesignDetailCode);
                dto.setRefundAmount(designDetailVo.getRefundAmount());
                dto.setReturnAmount(designDetailVo.getReturnAmount());
                if (RelationTypeEnum.UP_SUB_PLAN.getCode().equals(designDetailVo.getAssociationType()) && !Objects.isNull(subPlanItemFeeDto = this.generateSubPlanItemFeeNotes((SubComActivityDesignDetailVo)designDetailVo, dto.getRefundAmount()))) {
                    subPlanItemFeeDtoList.add(subPlanItemFeeDto);
                }
            });
            if (!CollectionUtils.isEmpty(feeDetailList)) {
                this.subComActivityDesignFeeDetailRepository.updateBatchById(feeDetailList);
            }
            this.subComActivityPlanItemService.generateItemFeeByDesignClosed(subPlanItemFeeDtoList);
            SerializableBiConsumer & Serializable onClose = SubComActivityDesignNetEventListener::onClose;
            SubComActivityDesignNetEventDto netEventDto = new SubComActivityDesignNetEventDto();
            netEventDto.setDesignDetailDtos(detailDtos);
            netEventDto.setDealThings(true);
            this.nebulaNetEventClient.publish((NebulaEventDto)netEventDto, SubComActivityDesignNetEventListener.class, (SerializableBiConsumer)onClose);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (lockSuccess) {
                this.subComBudgetForecastLockService.unLock(budgetForecastCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeThingsNoRollbackDetailList(SubComActivityDesignDetailDto dto) {
        boolean lockSuccess = false;
        String lockKey = "tpm:sub_com_activity_design:lock:close_things";
        try {
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 2L);
            if (!lockSuccess) {
                throw new RuntimeException("\u4e8b\u4e2d\u6d3b\u52a8\u56de\u9000\u9884\u7b97\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            List<SubComActivityDesignDetailEntity> list = this.subComActivityDesignDetailRepository.findCloseNoRollbackDetailList(dto);
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityDesignDetailEntity.class, SubComActivityDesignDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            List activityNumberList = dtoList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).collect(Collectors.toList());
            List indicatorList = this.auditExecuteIndicatorService.findByCodeList(activityNumberList, IndicatorNameEnum.SAP_INCURRED.getCode());
            Map<String, BigDecimal> sapIncurredMap = indicatorList.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getActiveNumber, AuditExecuteIndicatorVo::getIndicatorValue, (o, n) -> n));
            for (SubComActivityDesignDetailDto subComActivityDesignDetailDto : dtoList) {
                BigDecimal sapIncurred = sapIncurredMap.getOrDefault(subComActivityDesignDetailDto.getActivityDesignDetailCode(), BigDecimal.ZERO);
                subComActivityDesignDetailDto.setReturnAmount(subComActivityDesignDetailDto.getTotalCost().subtract(sapIncurred));
            }
            this.close(dtoList, true);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    private SubComActivityPlanItemFeeDto generateSubPlanItemFeeNotes(SubComActivityDesignDetailVo designDetailVo, BigDecimal refundAmount) {
        if (Objects.isNull(designDetailVo)) {
            return null;
        }
        refundAmount = Optional.ofNullable(refundAmount).orElse(BigDecimal.ZERO);
        SubComActivityPlanItemFeeDto planFee = new SubComActivityPlanItemFeeDto();
        planFee.setSubActivityPlanItemCode(designDetailVo.getAssociatedDateCode());
        planFee.setBudgetItemCode(designDetailVo.getBudgetItemCode());
        planFee.setBudgetItemName(designDetailVo.getBudgetItemName());
        planFee.setCurOperationAmount(refundAmount);
        planFee.setBusinessCode(designDetailVo.getActivityDesignDetailCode());
        planFee.setActivityDesignCode(designDetailVo.getActivityDesignCode());
        planFee.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
        return planFee;
    }

    public BigDecimal findActivityLowestPrice(SubComActivityDesignDetailVo subComActivityDesignDetailVo) {
        return this.subComActivityDesignDetailRepository.findActivityLowestPrice(subComActivityDesignDetailVo);
    }

    public List<SubComActivityDesignDetailVo> findActivityLowestPriceByKeyList(List<String> keyList) {
        ArrayList<SubComActivityDesignDetailVo> result = new ArrayList<SubComActivityDesignDetailVo>();
        int pageNum = 0;
        int pageSize = 500;
        while (pageNum * pageSize < keyList.size()) {
            if (pageNum * pageSize + pageSize >= keyList.size()) {
                result.addAll(this.subComActivityDesignDetailRepository.findActivityLowestPriceByKeyList(keyList.subList(pageNum * pageSize, keyList.size())));
            } else {
                result.addAll(this.subComActivityDesignDetailRepository.findActivityLowestPriceByKeyList(keyList.subList(pageNum * pageSize, pageNum * pageSize + pageSize)));
            }
            ++pageNum;
        }
        return result;
    }

    public List<SubComActivityDesignDetailVo> findDetailByDetailCodes(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        return this.subComActivityDesignDetailRepository.findDetailByDetailCodes(detailCodes);
    }

    public List<SubComActivityDesignDetailVo> findActivityLowestPriceByConditions(SubComActivityDesignDetailVo conditionVo) {
        return this.subComActivityDesignDetailRepository.findActivityLowestPriceByConditions(conditionVo);
    }

    public void autoUpdateActivityDetailStatus(String processStatus, String activityStatus) {
        this.subComActivityDesignDetailRepository.autoUpdateActivityDetailStatus(processStatus, activityStatus);
    }

    public void closeSubmitApproval(List<String> ids, SubComActivityDesignCloseApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        List designDetailList = this.subComActivityDesignDetailRepository.listByIds(ids);
        Assert.notEmpty((Collection)designDetailList, (String)"\u8981\u5173\u95ed\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        Set<String> activityNumberSet = designDetailList.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getActivityNumber())).map(SubComActivityDesignDetailEntity::getActivityNumber).collect(Collectors.toSet());
        long activityNumberCount = designDetailList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsSupplyAmount())).count();
        List<SubComActivityDesignDetailEntity> designDetailNumberList = this.subComActivityDesignDetailRepository.listByActivityNumberList(activityNumberSet, BooleanEnum.TRUE.getCapital());
        Set tipList = designDetailNumberList.stream().map(SubComActivityDesignDetailEntity::getActivityDesignCode).collect(Collectors.toSet());
        Assert.isTrue(((long)designDetailNumberList.size() == activityNumberCount ? 1 : 0) != 0, (String)("\u516c\u7528\u91cf\u4e3aY\u65f6,\u76f8\u540c\u6d3b\u52a8\u4fbf\u7b7e\u53f7\u7684\u89c4\u5212" + tipList + "\u9700\u8981\u540c\u65f6\u63d0\u4ea4\uff01"));
        designDetailList.forEach(detail -> {
            if (ActivityStatusEnum.CREATE_AND_BUDGET.getCode().equals(detail.getActivityDetailStatus()) || ActivityStatusEnum.REJECT_AND_BUDGET.getCode().equals(detail.getActivityDetailStatus()) || ActivityStatusEnum.CLOSE_SOME_REBUDGET.getCode().equals(detail.getActivityDetailStatus()) || ActivityStatusEnum.CLOSE_FULL_REBUDGET.getCode().equals(detail.getActivityDetailStatus()) || ActivityStatusEnum.IN_APPROVAL_AND_BUDGET.getCode().equals(detail.getActivityDetailStatus()) || ActivityStatusEnum.END.getCode().equals(detail.getActivityDetailStatus()) || ActivityStatusEnum.CLOSE_IN_APPROVAL.getCode().equals(detail.getActivityDetailStatus())) {
                throw new IllegalArgumentException("\u6d3b\u52a8[" + detail.getActivityDesignCode() + "]-[" + detail.getActivityDesignDetailCode() + "],\u53ea\u6709'\u5ba1\u6279\u901a\u8fc7/\u5173\u95ed\u9a73\u56de/\u5173\u95ed\u8ffd\u56de'\u7684\u72b6\u6001\u7684\u6d3b\u52a8\uff0c\u624d\u53ef\u5173\u95ed\uff01");
            }
            SubComActivityDesignDetailDto submitDetailDto = dto.getDetailDtos().stream().filter(d -> detail.getId().equals(d.getId())).findFirst().orElse(new SubComActivityDesignDetailDto());
            BigDecimal willRefundAmount = Optional.ofNullable(submitDetailDto.getWillRefundAmount()).orElse(BigDecimal.ZERO);
            BigDecimal willRefundQuantity = Optional.ofNullable(submitDetailDto.getWillRefundQuantity()).orElse(BigDecimal.ZERO);
            detail.setWillRefundAmount(willRefundAmount);
            detail.setWillRefundQuantity(willRefundQuantity);
            detail.setReleaseRatio(submitDetailDto.getReleaseRatio());
        });
        processBusiness.setBusinessNoList(ids);
        String businessNo = UuidCrmUtil.general();
        processBusiness.setBusinessNo(businessNo);
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("ACTIVITY_CONST_DESGIN_CLOSE_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        designDetailList.forEach(detail -> {
            detail.setDetailProcessNo(processBusinessVo.getProcessNo());
            detail.setActivityDetailStatus(ActivityStatusEnum.CLOSE_IN_APPROVAL.getCode());
        });
        this.subComActivityDesignDetailRepository.updateBatchById(designDetailList);
    }

    public void closeByProcess(String processNo) {
        List<SubComActivityDesignDetailEntity> list = this.subComActivityDesignDetailRepository.findByDetailProcessNo(processNo);
        if (CollectionUtils.isEmpty(list)) {
            throw new IllegalArgumentException("\u66f4\u636e\u6d41\u7a0b\u7f16\u7801[" + processNo + "],\u672a\u67e5\u8be2\u5230\u5904\u4e8e\u5173\u95ed\u5ba1\u6279\u4e2d\u7684\u6d3b\u52a8");
        }
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityDesignDetailEntity.class, SubComActivityDesignDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        dtoList.forEach(d -> d.setReturnAmount(d.getWillRefundAmount()));
        this.close(dtoList);
    }

    public Page<SubComActivityDesignDetailVo> findByConditionsWithDetailProcessNo(Pageable pageable, String processNo) {
        Validate.notBlank((CharSequence)processNo, (String)"\u67e5\u8be2\u65f6\uff0c\u4f20\u5165\u7684\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SubComActivityDesignDetailVo> pageResult = this.subComActivityDesignDetailRepository.findByConditionsWithDetailProcessNo((Page<SubComActivityDesignDetailVo>)page, processNo, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            for (SubComActivityDesignDetailVo record : pageResult.getRecords()) {
                record.setReturnAmount(record.getWillRefundAmount());
            }
        }
        return pageResult;
    }

    public void closeByProcessFail(String processNo, String processStatus) {
        if (StringUtils.isBlank((CharSequence)processNo) || StringUtils.isBlank((CharSequence)processStatus)) {
            return;
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
            processStatus = ActivityStatusEnum.CLOSE_REJECT.getCode();
        }
        if (ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            processStatus = ActivityStatusEnum.CLOSE_RECOVER.getCode();
        }
        this.subComActivityDesignDetailRepository.updateDetailActivityStatus(processNo, processStatus);
    }

    public Page<SubComActivityDesignDetailVo> findByProcessNoConditionsCreate(Pageable pageable, SubComActivityDesignDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getProcessNo())) {
            return null;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SubComActivityDesignDetailVo> resultPage = this.subComActivityDesignDetailRepository.findByProcessNoConditionsCreate((Page<SubComActivityDesignDetailVo>)page, dto);
        if (Objects.isNull(resultPage) || CollectionUtils.isEmpty((Collection)resultPage.getRecords())) {
            return resultPage;
        }
        List detailList = resultPage.getRecords();
        detailList.forEach(detail -> {
            if (Objects.isNull(detail.getPromotionAmount()) || BigDecimal.ZERO.compareTo(detail.getPromotionAmount()) == 0) {
                detail.setCostSalesRatio(BigDecimal.ZERO);
            } else {
                BigDecimal totalCost = Optional.ofNullable(detail.getTotalCost()).orElse(BigDecimal.ZERO);
                detail.setCostSalesRatio(totalCost.divide(detail.getPromotionAmount(), 2, 4));
            }
        });
        return resultPage;
    }

    public Page<SubComActivityDesignDetailVo> findToModifyList(Pageable pageable, SubComActivityDesignDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (Objects.isNull(dto)) {
            dto = new SubComActivityDesignDetailDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getOrgCode())) {
            FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            Validate.notNull((Object)loginUserDetails, (String)"\u66f4\u636e\u5f53\u524d\u767b\u5f55\u4eba\uff0c\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\uff01", (Object[])new Object[0]);
            dto.setOrgCode(loginUserDetails.getOrgCode());
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SubComActivityDesignDetailVo> toModifyList = this.subComActivityDesignDetailRepository.findToModifyList((Page<SubComActivityDesignDetailVo>)page, dto);
        if (Objects.isNull(toModifyList) || CollectionUtils.isEmpty((Collection)toModifyList.getRecords())) {
            return toModifyList;
        }
        List productsCodes = toModifyList.getRecords().stream().map(SubComActivityDesignDetailVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List productVoList = this.productVoService.findByCodes(productsCodes);
        Map<Object, Object> productVoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)productVoList)) {
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        for (SubComActivityDesignDetailVo detail : toModifyList.getRecords()) {
            detail.setId(null);
            ProductVo productVo = (ProductVo)productVoMap.get(detail.getProductCode());
            if (Objects.isNull(productVo)) continue;
            detail.setProductBrandCode(productVo.getProductBrandCode());
            detail.setProductBrandName(productVo.getProductBrandName());
            detail.setProductCategoryCode(productVo.getProductCategoryCode());
            detail.setProductCategoryName(productVo.getProductCategoryName());
            detail.setProductItemCode(productVo.getProductLevelCode());
            detail.setProductItemName(productVo.getProductLevelName());
            detail.setBrandOrg(productVo.getBrandOrgCode());
            detail.setSpec(productVo.getSpec());
        }
        return toModifyList;
    }

    public SubComActivityDesignApproveSubmitDto getProcessBusinessForm(List<String> activityDesignCodeList) {
        return this.subComActivityDesignDetailRepository.getProcessBusinessForm(activityDesignCodeList);
    }

    public Map<String, Boolean> hasRelationPolicy(List<String> promotionCodes) {
        if (CollectionUtils.isEmpty(promotionCodes)) {
            return Maps.newHashMap();
        }
        List<RelationPolicySelectVo> list = this.subComActivityDesignDetailRepository.hasRelationPolicy(promotionCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (RelationPolicySelectVo vo : list) {
            boolean flag = false;
            Integer total = Optional.ofNullable(vo.getTotal()).orElse(0);
            if (total > 0) {
                flag = true;
            }
            map.put(vo.getPromotionCode(), flag);
        }
        return map;
    }
}

