/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignFeeDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignFeeDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignFeeDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignFeeDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignFeeDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityDesignFeeDetailServiceImpl
implements SubComActivityDesignFeeDetailService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignFeeDetailServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignFeeDetailRepository subComActivityDesignFeeDetailRepository;

    public void saveSubComActivityDesignFeeDetailList(SubComActivityDesignDto dto, boolean updateFlag, List<SubComActivityDesignDetailDto> itemCacheList) {
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (updateFlag) {
            List<SubComActivityDesignFeeDetailEntity> oldList = this.subComActivityDesignFeeDetailRepository.findListByCode(dto.getActivityDesignCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList feeDetailList = Lists.newArrayList();
        itemCacheList.forEach(itemCache -> {
            if (ObjectUtils.isEmpty((Object)itemCache.getFeeDetail())) {
                return;
            }
            feeDetailList.add(itemCache.getFeeDetail());
        });
        if (CollectionUtils.isEmpty((Collection)feeDetailList)) {
            return;
        }
        List feeDetailEntityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)feeDetailList, SubComActivityDesignFeeDetailDto.class, SubComActivityDesignFeeDetailEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDesignFeeDetailEntity item : feeDetailEntityList) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDesignFeeDetailRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDesignFeeDetailRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityDesignFeeDetailRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    public List<SubComActivityDesignFeeDetailVo> listByDesignCodeList(String designCode) {
        if (StringUtils.isEmpty((CharSequence)designCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignFeeDetailEntity> listByCode = this.subComActivityDesignFeeDetailRepository.findListByCode(designCode);
        if (CollectionUtils.isEmpty(listByCode)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(listByCode, SubComActivityDesignFeeDetailEntity.class, SubComActivityDesignFeeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }
}

