/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignForecastEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignForecastRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignForecastDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignForecastService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignForecastVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityDesignForecastServiceImpl
implements SubComActivityDesignForecastService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignForecastServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignForecastRepository subComActivityDesignForecastRepository;

    public void saveSubComActivityDesignBudgetList(SubComActivityDesignDto dto, boolean updateFlag, List<SubComActivityDesignDetailDto> itemCacheList) {
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (updateFlag) {
            List<SubComActivityDesignForecastEntity> oldList = this.subComActivityDesignForecastRepository.findListByCode(dto.getActivityDesignCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList forecastList = Lists.newArrayList();
        itemCacheList.forEach(itemCache -> forecastList.addAll(itemCache.getForecastList()));
        if (CollectionUtils.isEmpty((Collection)forecastList)) {
            return;
        }
        List forecastEntityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)forecastList, SubComActivityDesignForecastDto.class, SubComActivityDesignForecastEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDesignForecastEntity item : forecastEntityList) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDesignForecastRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDesignForecastRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityDesignForecastRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    public List<SubComActivityDesignForecastVo> listByDesignCode(String activityDesignCode) {
        if (StringUtils.isEmpty((CharSequence)activityDesignCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignForecastEntity> subComActivityDesignForecastEntities = this.subComActivityDesignForecastRepository.findListByCode(activityDesignCode);
        if (CollectionUtils.isEmpty(subComActivityDesignForecastEntities)) {
            return Lists.newArrayList();
        }
        Collection subComActivityDesignForecastVos = this.nebulaToolkitService.copyCollectionByWhiteList(subComActivityDesignForecastEntities, SubComActivityDesignForecastEntity.class, SubComActivityDesignForecastVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)subComActivityDesignForecastVos;
    }
}

