/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignPlanEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignPlanService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityDesignPlanServiceImpl
implements SubComActivityDesignPlanService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignPlanServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignPlanRepository subComActivityDesignPlanRepository;

    public void saveSubComActivityDesignPlanList(SubComActivityDesignDto dto, boolean updateFlag, List<SubComActivityDesignDetailDto> itemCacheList) {
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (updateFlag) {
            List<SubComActivityDesignPlanEntity> oldList = this.subComActivityDesignPlanRepository.findListByCode(dto.getActivityDesignCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList planList = Lists.newArrayList();
        itemCacheList.forEach(itemCache -> {
            if (!CollectionUtils.isEmpty((Collection)itemCache.getPlanList())) {
                planList.addAll(itemCache.getPlanList());
            }
        });
        if (CollectionUtils.isEmpty((Collection)planList)) {
            return;
        }
        List activityPlanItems = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planList, SubComActivityDesignPlanDto.class, SubComActivityDesignPlanEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDesignPlanEntity item : activityPlanItems) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDesignPlanRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDesignPlanRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityDesignPlanRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    public List<SubComActivityDesignPlanVo> listByDesignCodeList(String activityDesignCode) {
        if (StringUtils.isEmpty((CharSequence)activityDesignCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignPlanEntity> listByCode = this.subComActivityDesignPlanRepository.findListByCode(activityDesignCode);
        if (CollectionUtils.isEmpty(listByCode)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(listByCode, SubComActivityDesignPlanEntity.class, SubComActivityDesignPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<SubComActivityDesignPlanDto> listByDesignDetailCodes(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignPlanEntity> listByCode = this.subComActivityDesignPlanRepository.findListByDetailCodes(detailCodes);
        if (CollectionUtils.isEmpty(listByCode)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(listByCode, SubComActivityDesignPlanEntity.class, SubComActivityDesignPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }
}

