/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignProductEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignProductRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignProductDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignProductService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityDesignProductServiceImpl
implements SubComActivityDesignProductService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignProductServiceImpl.class);
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignProductRepository subComActivityDesignProductRepository;

    public void saveSubComActivityDesignProductList(SubComActivityDesignDto dto, boolean updateFlag, List<SubComActivityDesignDetailDto> itemCacheList) {
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (updateFlag) {
            List<SubComActivityDesignProductEntity> oldList = this.subComActivityDesignProductRepository.findListByCode(dto.getActivityDesignCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList productList = Lists.newArrayList();
        itemCacheList.forEach(itemCache -> {
            if (!CollectionUtils.isEmpty((Collection)itemCache.getProductList())) {
                productList.addAll(itemCache.getProductList());
            }
        });
        if (CollectionUtils.isEmpty((Collection)productList)) {
            return;
        }
        List productEntityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)productList, SubComActivityDesignProductDto.class, SubComActivityDesignProductEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDesignProductEntity item : productEntityList) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDesignProductRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDesignProductRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityDesignProductRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    public List<SubComActivityDesignProductDto> findListByItem(SubComActivityDesignDetailDto item) {
        if (item != null) {
            // empty if block
        }
        return new ArrayList<SubComActivityDesignProductDto>();
    }

    private void calDtoAmount(List<SubComActivityDesignProductDto> shareVos, SubComActivityDesignDetailDto item) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)item.getBudgetList())) {
            Map<String, List<SubComActivityDesignBudgetDto>> budgetGroup = item.getBudgetList().stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetDto::getFeeSourceCode));
            BigDecimal internalFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.INTERNAL_POINT_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDesignBudgetDto::getBudgetAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal offFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.OFF_POINT_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDesignBudgetDto::getBudgetAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal autoFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.AUTO_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDesignBudgetDto::getBudgetAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (SubComActivityDesignProductDto shareVo : shareVos) {
                if (!ObjectUtils.isEmpty((Object)shareVo.getProductRatio())) continue;
                BigDecimal ratio = NumberUtil.div((Number)shareVo.getProductRatio(), (Number)new BigDecimal(100));
                shareVo.setOffAmount(NumberUtil.mul((Number)offFee, (Number)ratio));
                shareVo.setInternalAmount(NumberUtil.mul((Number)internalFee, (Number)ratio));
                shareVo.setAutoAmount(NumberUtil.mul((Number)autoFee, (Number)ratio));
                shareVo.setTotalAmount(NumberUtil.add((BigDecimal[])new BigDecimal[]{shareVo.getOffAmount(), shareVo.getInternalAmount(), shareVo.getAutoAmount()}));
            }
        }
    }

    private void getProductShareDtoRatio(List<SubComActivityDesignProductDto> shareVos, SubComActivityDesignDetailDto item) {
        List productCodes = shareVos.stream().map(SubComActivityDesignProductDto::getProductCode).filter(Objects::nonNull).collect(Collectors.toList());
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setSalesProductCodeList(productCodes);
        List salesPlanVos = this.salesPlanService.findByConditions(salesPlanDto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)salesPlanVos)) {
            String thisSalesOrganizationCode = this.findSalesOrganizationCode(item.getOrgCode());
            if (StringUtils.isEmpty((CharSequence)thisSalesOrganizationCode)) {
                return;
            }
            BigDecimal totalSalesPlanAmount = salesPlanVos.stream().map(SalesPlanVo::getPlanAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            Map<String, List<SalesPlanVo>> salesGroup = salesPlanVos.stream().collect(Collectors.groupingBy(x -> x.getProductCode() + x.getYearMonthLy() + x.getCustomerCode() + x.getSalesInstitutionCode()));
            for (SubComActivityDesignProductDto shareVo : shareVos) {
                String key = shareVo.getProductCode() + DateUtil.format((Date)item.getFeeYearMonth(), (String)"yyyy-MM") + item.getCustomerCode() + thisSalesOrganizationCode;
                Optional<List<SalesPlanVo>> optionalSalesPlanVos = Optional.ofNullable(salesGroup.get(key));
                optionalSalesPlanVos.ifPresent(planVos -> {
                    BigDecimal thisProductPlanAmount = planVos.stream().map(SalesPlanVo::getPlanAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    shareVo.setProductRatio(NumberUtil.div((BigDecimal)totalSalesPlanAmount, (BigDecimal)thisProductPlanAmount, (int)6, (RoundingMode)RoundingMode.HALF_UP));
                });
            }
            NumberUtil.div((Number)item.getTotalCost(), (Number)totalSalesPlanAmount, (int)2);
        }
    }

    private String findSalesOrganizationCode(String orgCode) {
        if (StringUtils.isEmpty((CharSequence)orgCode)) {
            return "";
        }
        OrgVo orgVo = this.orgVoService.findByOrgCode(orgCode);
        if (orgVo == null) {
            return "";
        }
        SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(orgVo.getSalesOrgCode());
        if (salesOrgVo == null) {
            return "";
        }
        if (Objects.equals(salesOrgVo.getSalesOrgLevel(), SalesOrgLevelTypeEnum.MECHANISM.getCode())) {
            return salesOrgVo.getSalesOrgCode();
        }
        if (orgVo.getParent() == null) {
            return "";
        }
        return this.findSalesOrganizationCode(orgVo.getParent().getOrgCode());
    }

    private List<SubComActivityDesignProductDto> buildPlanItemDtoByProduct(List<ProductVo> productVoList) {
        ArrayList<SubComActivityDesignProductDto> shareVos = new ArrayList<SubComActivityDesignProductDto>(productVoList.size());
        productVoList.forEach(productVo -> {
            SubComActivityDesignProductDto subComActivityDesignProductDto = new SubComActivityDesignProductDto();
            subComActivityDesignProductDto.setProductCode(productVo.getProductCode());
            subComActivityDesignProductDto.setProductName(productVo.getProductName());
            shareVos.add(subComActivityDesignProductDto);
        });
        return shareVos;
    }

    public Page<SubComActivityDesignProductVo> findProductShareList(Pageable pageable, SubComActivityDesignDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u4ea7\u54c1\u884c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page();
        ProductPaginationDto productDto = new ProductPaginationDto();
        productDto.setProductBrandCode(dto.getProductBrandCode());
        productDto.setProductCategoryCode(dto.getProductCategoryCode());
        productDto.setProductLevelCode(dto.getProductItemCode());
        productDto.setProductCode(dto.getProductCode());
        Page productVoPage = this.productVoService.findByConditions(pageable, productDto);
        page.setTotal(productVoPage.getTotal());
        page.setPages(productVoPage.getPages());
        page.setSize(productVoPage.getSize());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)productVoPage.getRecords())) {
            page.setRecords(this.fullShareVos(productVoPage.getRecords(), dto));
        }
        return page;
    }

    public List<SubComActivityDesignProductVo> listByDesignCodeList(String activityDesignCode) {
        if (StringUtils.isEmpty((CharSequence)activityDesignCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignProductEntity> listByCode = this.subComActivityDesignProductRepository.findListByCode(activityDesignCode);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(listByCode, SubComActivityDesignProductEntity.class, SubComActivityDesignProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private List<SubComActivityDesignProductVo> fullShareVos(List<ProductVo> records, SubComActivityDesignDetailDto dto) {
        List<SubComActivityDesignProductVo> shareVos = this.buildPlanItemVoByProduct(records);
        this.getProductShareVoRatio(shareVos, dto);
        this.calVoAmount(shareVos, dto);
        return shareVos;
    }

    private void calVoAmount(List<SubComActivityDesignProductVo> shareVos, SubComActivityDesignDetailDto dto) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getBudgetList())) {
            Map<String, List<SubComActivityDesignBudgetDto>> budgetGroup = dto.getBudgetList().stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetDto::getFeeSourceCode));
            BigDecimal internalFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.INTERNAL_POINT_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDesignBudgetDto::getBudgetAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal offFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.OFF_POINT_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDesignBudgetDto::getBudgetAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal autoFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.AUTO_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDesignBudgetDto::getBudgetAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (SubComActivityDesignProductVo shareVo : shareVos) {
                if (!ObjectUtils.isEmpty((Object)shareVo.getProductRatio())) continue;
                BigDecimal ratio = NumberUtil.div((Number)shareVo.getProductRatio(), (Number)new BigDecimal(100));
                shareVo.setOffAmount(NumberUtil.mul((Number)offFee, (Number)ratio));
                shareVo.setInternalAmount(NumberUtil.mul((Number)internalFee, (Number)ratio));
                shareVo.setAutoAmount(NumberUtil.mul((Number)autoFee, (Number)ratio));
                shareVo.setTotalAmount(NumberUtil.add((BigDecimal[])new BigDecimal[]{shareVo.getOffAmount(), shareVo.getInternalAmount(), shareVo.getAutoAmount()}));
            }
        }
    }

    private void getProductShareVoRatio(List<SubComActivityDesignProductVo> shareVos, SubComActivityDesignDetailDto dto) {
        List productCodes = shareVos.stream().map(SubComActivityDesignProductVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toList());
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setSalesProductCodeList(productCodes);
        List salesPlanVos = this.salesPlanService.findByConditions(salesPlanDto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)salesPlanVos)) {
            String thisSalesOrganizationCode = this.findSalesOrganizationCode(dto.getOrgCode());
            if (StringUtils.isEmpty((CharSequence)thisSalesOrganizationCode)) {
                return;
            }
            BigDecimal totalSalesPlanAmount = salesPlanVos.stream().map(SalesPlanVo::getPlanAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            Map<String, List<SalesPlanVo>> salesGroup = salesPlanVos.stream().collect(Collectors.groupingBy(x -> x.getProductCode() + x.getYearMonthLy() + x.getCustomerCode() + x.getSalesInstitutionCode()));
            for (SubComActivityDesignProductVo shareVo : shareVos) {
                String key = shareVo.getProductCode() + DateUtil.format((Date)dto.getFeeYearMonth(), (String)"yyyy-MM") + dto.getCustomerCode() + thisSalesOrganizationCode;
                Optional<List<SalesPlanVo>> optionalSalesPlanVos = Optional.ofNullable(salesGroup.get(key));
                optionalSalesPlanVos.ifPresent(planVos -> {
                    BigDecimal thisProductPlanAmount = planVos.stream().map(SalesPlanVo::getPlanAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    shareVo.setProductRatio(NumberUtil.div((BigDecimal)totalSalesPlanAmount, (BigDecimal)thisProductPlanAmount, (int)6, (RoundingMode)RoundingMode.HALF_UP));
                });
            }
            NumberUtil.div((Number)dto.getTotalCost(), (Number)totalSalesPlanAmount, (int)2);
        }
    }

    private List<SubComActivityDesignProductVo> buildPlanItemVoByProduct(List<ProductVo> records) {
        ArrayList<SubComActivityDesignProductVo> shareVos = new ArrayList<SubComActivityDesignProductVo>(records.size());
        shareVos.forEach(productVo -> {
            SubComActivityDesignProductVo subComActivityDesignProductVo = new SubComActivityDesignProductVo();
            subComActivityDesignProductVo.setProductCode(productVo.getProductCode());
            subComActivityDesignProductVo.setProductName(productVo.getProductName());
            shareVos.add(subComActivityDesignProductVo);
        });
        return shareVos;
    }
}

