/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityPlanRelationTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.enums.SubComActivityValidationFormCodeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastDetailSdkService;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemMainItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignBudgetEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignFeeDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignForecastEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignFeeDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignForecastRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignProductRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.service.SubComActivityDesignDetailCacheService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.service.config.GenerateDataAsync;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.ActivityPlanTableListenDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SelectActivityPlanTableEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignFeeDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignLogEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SummationAmountForSubmitApprovalDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.AuditConditionEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TableVersionEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.UndertakingModeTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.ActivityPlanTableEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SelectActivityPlanTableEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SubComActivityDesignLogEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignFeeDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignLockSdkService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignPlanService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignProductService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SelectActivityPlanTableEventVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SummationAmountForSubmitApprovaVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemFeeService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;

@Service
public class SubComActivityDesignServiceImpl
implements SubComActivityDesignService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignServiceImpl.class);
    @Autowired(required=false)
    private GenerateDataAsync generateDataAsync;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Resource
    private SubComActivityDesignRepository subComActivityDesignRepository;
    @Resource
    private SubComActivityDesignPlanService subComActivityDesignPlanService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Resource
    private SubComActivityDesignDetailService subComActivityDesignDetailService;
    @Resource
    private SubComActivityDesignDetailCacheService subComActivityDesignDetailCacheService;
    @Resource
    private SubComActivityDesignDetailRepository subComActivityDesignDetailRepository;
    @Resource
    private SubComActivityDesignBudgetRepository subComActivityDesignBudgetRepository;
    @Resource
    private SubComActivityDesignBudgetService subComActivityDesignBudgetService;
    @Resource
    private SubComActivityDesignProductService subComActivityDesignProductService;
    @Resource
    private SubComActivityDesignLockSdkService subComActivityDesignLockSdkService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SubComActivityDesignForecastRepository subComActivityDesignForecastRepository;
    @Resource
    private SubComActivityDesignFeeDetailService subComActivityDesignFeeDetailService;
    @Resource
    private SubComActivityDesignFeeDetailRepository subComActivityDesignFeeDetailRepository;
    @Autowired(required=false)
    private List<ActivityPlanTableEventListener> activityPlanTableEventListeners;
    @Autowired(required=false)
    private SubComActivityDesignProductRepository subComActivityDesignProductRepository;
    @Autowired(required=false)
    private SubComActivityDesignPlanRepository subComActivityDesignPlanRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private BudgetItemMainItemService budgetItemMainItemService;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SubComBudgetForecastDetailSdkService subComBudgetForecastDetailSdkService;
    @Autowired(required=false)
    private SubComActivityPlanItemService subComActivityPlanItemService;
    @Autowired(required=false)
    private SubComActivityPlanItemFeeService subComActivityPlanItemFeeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void saveSubComActivityDesign(SubComActivityDesignDto dto, String cacheKey) {
        this.validate(dto);
        List itemCacheList = StringUtils.isNotEmpty((CharSequence)cacheKey) ? this.subComActivityDesignDetailCacheService.findCacheList(cacheKey) : dto.getDetailList();
        this.validationList(dto, itemCacheList);
        boolean updateFlag = !StringUtils.isBlank((CharSequence)dto.getId());
        ArrayList<String> codeList = new ArrayList<String>();
        boolean lockBudgetSuccess = false;
        boolean lockEditSuccess = false;
        String lockKey = null;
        try {
            if (updateFlag) {
                lockKey = "sub_com_activity_design:lock:approve:" + dto.getId();
                lockEditSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 3L);
                Assert.isTrue((boolean)lockEditSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                codeList.add(dto.getActivityDesignCode());
                lockBudgetSuccess = this.subComActivityDesignLockSdkService.lock(codeList, TimeUnit.MINUTES, 3);
                Assert.isTrue((boolean)lockBudgetSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                this.subComActivityDesignBudgetService.returnSubComBudgetForecastByCode(codeList);
                this.returnSubPlanItemFeeByUpdateDesign(dto.getActivityDesignCode());
            }
            this.subComActivityDesignDetailService.generatePromotionNo(itemCacheList);
            this.buildNoRelationAmount(dto, itemCacheList);
            List<SubComActivityPlanItemFeeDto> subPlanItemFeeList = this.buildRelationSubPlanBudgetAmount(dto, itemCacheList);
            this.divideExpenses(dto, itemCacheList);
            this.sumAmount(dto, itemCacheList);
            this.saveSubComActivityDesignAndDetail(dto, itemCacheList, subPlanItemFeeList);
            for (ActivityPlanTableEventListener activityPlanTableEventListener : this.activityPlanTableEventListeners) {
                ActivityPlanTableListenDto activityPlanTableListenDto = new ActivityPlanTableListenDto();
                activityPlanTableListenDto.setOrgCode(dto.getOrgCode());
                activityPlanTableListenDto.setOrgName(dto.getOrgName());
                activityPlanTableListenDto.setYearAndMonth(DateUtil.format((Date)dto.getFeeYearMonth(), (String)"yyyy-MM"));
                activityPlanTableListenDto.setTenantCode(TenantUtils.getTenantCode());
                activityPlanTableListenDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                log.info("\u5f00\u59cb\u4f20\u8f93\u5230\u6d3b\u52a8\u89c4\u5212\u5957\u8868");
                activityPlanTableEventListener.save(activityPlanTableListenDto);
            }
        }
        finally {
            if (lockBudgetSuccess && CollectionUtil.isNotEmpty(codeList)) {
                this.subComActivityDesignLockSdkService.unlock(codeList);
            }
            if (lockEditSuccess && StringUtils.isNotEmpty((CharSequence)lockKey)) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    private void sumAmount(SubComActivityDesignDto dto, List<SubComActivityDesignDetailDto> itemCacheList) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        BigDecimal subComAutoAmountTotal = BigDecimal.ZERO;
        BigDecimal headquartersSupportedAmountTotal = BigDecimal.ZERO;
        BigDecimal applyAmount = BigDecimal.ZERO;
        for (SubComActivityDesignDetailDto detailDto : itemCacheList) {
            if (detailDto.getTotalCost() != null) {
                applyAmount = applyAmount.add(detailDto.getTotalCost());
            }
            if (CollectionUtils.isEmpty((Collection)detailDto.getBudgetList())) continue;
            BigDecimal subComAutoAmount = BigDecimal.ZERO;
            BigDecimal headquartersSupportedAmount = BigDecimal.ZERO;
            for (SubComActivityDesignBudgetDto budget : detailDto.getBudgetList()) {
                if (FeeSourceEnum.AUTO_FEE.getCode().equals(budget.getFeeSourceCode()) && budget.getBudgetAmount() != null) {
                    subComAutoAmountTotal = subComAutoAmountTotal.add(budget.getBudgetAmount());
                    subComAutoAmount = subComAutoAmount.add(budget.getBudgetAmount());
                }
                if (!FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budget.getFeeSourceCode()) && (!FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budget.getFeeSourceCode()) || budget.getBudgetAmount() == null)) continue;
                headquartersSupportedAmountTotal = headquartersSupportedAmountTotal.add(budget.getBudgetAmount());
                headquartersSupportedAmount = headquartersSupportedAmount.add(budget.getBudgetAmount());
            }
            detailDto.setSubComAutoAmount(subComAutoAmount);
            detailDto.setHeadquartersSupportedAmount(headquartersSupportedAmount);
        }
        dto.setApplyAmount(applyAmount);
        dto.setSubComAutoAmountTotal(subComAutoAmountTotal);
        dto.setHeadquartersSupportedAmountTotal(headquartersSupportedAmountTotal);
    }

    private void returnSubPlanItemFeeByUpdateDesign(String activityDesignCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return;
        }
        List itemFeeVoList = this.subComActivityPlanItemFeeService.findUsedByActivityDesignCode(activityDesignCode);
        if (CollectionUtils.isEmpty((Collection)itemFeeVoList)) {
            return;
        }
        ArrayList returnItemFeeList = new ArrayList();
        Map<String, List<SubComActivityPlanItemFeeVo>> itemFeeVoMap = itemFeeVoList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemFeeVo::getSubActivityPlanItemCode));
        ArrayList updateSubPlanItemList = new ArrayList();
        itemFeeVoMap.forEach((k, v) -> {
            SubComActivityPlanItemFeeVo lastItemFee = this.subComActivityPlanItemFeeService.findLastByItemCode(k);
            BigDecimal beforeAmount = Optional.ofNullable(lastItemFee.getBalanceAmount()).orElse(BigDecimal.ZERO);
            Date date = new Date();
            BigDecimal residueAmount = BigDecimal.ZERO;
            for (int i = 0; i < v.size(); ++i) {
                SubComActivityPlanItemFeeVo oldItemFee = (SubComActivityPlanItemFeeVo)v.get(i);
                SubComActivityPlanItemFeeDto returnItemFee = (SubComActivityPlanItemFeeDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldItemFee, SubComActivityPlanItemFeeDto.class, HashSet.class, ArrayList.class, new String[0]);
                BigDecimal curOperationAmount = oldItemFee.getCurOperationAmount();
                returnItemFee.setBeforeAmount(beforeAmount);
                returnItemFee.setCurOperationAmount(BigDecimal.ZERO.subtract(curOperationAmount));
                beforeAmount = beforeAmount.add(curOperationAmount);
                returnItemFee.setBalanceAmount(beforeAmount);
                returnItemFee.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
                returnItemFee.setSortAsc(Long.valueOf(Long.parseLong(DateUtil.format((Date)date, (String)"yyyyMMddHHmmss") + i)));
                residueAmount = residueAmount.add(returnItemFee.getCurOperationAmount());
                returnItemFeeList.add(returnItemFee);
            }
            SubComActivityPlanItemDto planItemDto = new SubComActivityPlanItemDto();
            planItemDto.setResidueAmount(planItemDto.getResidueAmount().add(residueAmount));
            planItemDto.setUsedAmount(planItemDto.getUsedAmount().subtract(planItemDto.getResidueAmount()));
            planItemDto.setSubActivityPlanItemCode(k);
            updateSubPlanItemList.add(planItemDto);
        });
        this.subComActivityPlanItemService.updateReturnAmount(updateSubPlanItemList);
        this.subComActivityPlanItemFeeService.saveBatch(returnItemFeeList);
    }

    private List<SubComActivityPlanItemFeeDto> buildRelationSubPlanBudgetAmount(SubComActivityDesignDto dto, List<SubComActivityDesignDetailDto> newList) {
        if (org.springframework.util.CollectionUtils.isEmpty(newList)) {
            return null;
        }
        log.info("\u5206\u5b50\u89c4\u5212\u5173\u8054\u5206\u5b50\u65b9\u6848\u5212\u52061");
        List designDetailList = newList.stream().filter(n -> RelationTypeEnum.UP_SUB_PLAN.getCode().equals(n.getAssociationType()) && UndertakingModeTypeEnum.FULL_ACCEPT.getCode().equals(n.getUndertakingMode())).collect(Collectors.toList());
        if (org.springframework.util.CollectionUtils.isEmpty(designDetailList)) {
            return null;
        }
        log.info("\u5206\u5b50\u89c4\u5212\u5173\u8054\u5206\u5b50\u65b9\u6848\u5212\u52062");
        List associatedDateCodes = designDetailList.stream().map(SubComActivityDesignDetailDto::getAssociatedDateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Validate.isTrue((designDetailList.size() == associatedDateCodes.size() ? 1 : 0) != 0, (String)"\u5411\u4e0a\u5173\u8054\u5206\u5b50\u65b9\u6848\u65f6,\u5173\u8054\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List subActivityPlanItemList = this.subComActivityPlanItemService.findByItemCodes(associatedDateCodes);
        Validate.notEmpty((Collection)subActivityPlanItemList, (String)"\u672a\u67e5\u8be2\u5230\u5206\u5b50\u516c\u53f8\u65b9\u6848\u4fe1\u606f!", (Object[])new Object[0]);
        FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        Validate.notNull((Object)loginUserDetails, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loginUserDetails.getOrgCode(), (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u4eba\u7684\u7ec4\u7ec7\u4fe1\u606f", (Object[])new Object[0]);
        String designTime = DateUtil.format((Date)dto.getFeeYearMonth(), (String)"yyyy-MM");
        subActivityPlanItemList.forEach(planItem -> {
            Validate.isTrue((boolean)SubPlanStatusEnum.EXECUTING.getCode().equals(planItem.getActivityStatus()), (String)("\u5206\u5b50\u65b9\u6848\u3010" + planItem.getSubActivityPlanCode() + "\u3011\u3010" + planItem.getSubActivityPlanItemCode() + "\u3011,\u72b6\u6001\u672a\u5728\u6267\u884c\u4e2d\uff01"), (Object[])new Object[0]);
            Validate.isTrue((boolean)loginUserDetails.getOrgCode().equals(planItem.getOrgCode()), (String)("\u5206\u5b50\u65b9\u6848\u3010" + planItem.getSubActivityPlanCode() + "\u3011\u3010" + planItem.getSubActivityPlanItemCode() + "\u3011,\u6267\u884c\u90e8\u95e8\u3010" + planItem.getOrgCode() + "\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u4eba\u7684\u90e8\u95e8\u3010" + loginUserDetails.getOrgCode() + "\u3011\u4e0d\u7b26\uff01"), (Object[])new Object[0]);
            Validate.isTrue((boolean)designTime.equals(planItem.getFeeYearMonth()), (String)("\u5206\u5b50\u65b9\u6848\u3010" + planItem.getSubActivityPlanCode() + "\u3011\u3010" + planItem.getSubActivityPlanItemCode() + "\u3011,\u5e74\u6708\u4e3a" + planItem.getFeeYearMonth() + ",\u4e0e\u6d3b\u52a8\u89c4\u5212\u5e74\u6708\u4e0d\u540c,\u4e0d\u53ef\u7528\uff01"), (Object[])new Object[0]);
        });
        Map subPlanItemMap = subActivityPlanItemList.stream().collect(Collectors.toMap(SubComActivityPlanItemVo::getSubActivityPlanItemCode, Function.identity()));
        List budgetItemCodes = subActivityPlanItemList.stream().map(SubComActivityPlanItemVo::getBudgetItemCode).distinct().collect(Collectors.toList());
        SubComBudgetForecastDto subBudgetDto = new SubComBudgetForecastDto();
        subBudgetDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subBudgetDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        subBudgetDto.setOrgCode(dto.getOrgCode());
        subBudgetDto.setYearMonthLy(designTime);
        subBudgetDto.setBudgetItemCodeList(budgetItemCodes);
        List subComBudgetForecastVos = this.subComBudgetForecastService.listByConditions(subBudgetDto);
        if (subComBudgetForecastVos == null || subComBudgetForecastVos.size() == 0) {
            log.info("\u5173\u8054\u5206\u5b50\u65b9\u6848\u65f6\uff0c\u67e5\u8be2\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9884\u7b97\u9884\u6d4b\uff01\u67e5\u8be2\u6761\u4ef6:{}", (Object)subBudgetDto);
            throw new RuntimeException("\u89c4\u5212\u5173\u8054\u5206\u5b50\u65b9\u6848\u67e5\u8be2\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9884\u7b97\u9884\u6d4b");
        }
        Map subComBudgetForecastMap = subComBudgetForecastVos.stream().collect(Collectors.toMap(b -> b.getFeeSourceCode() + "-" + b.getBudgetItemCode(), Function.identity()));
        HashMap<String, BigDecimal> planCostMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> forecastCostMap = new HashMap<String, BigDecimal>();
        ArrayList<SubComActivityPlanItemFeeDto> planItemFeeList = new ArrayList<SubComActivityPlanItemFeeDto>();
        log.info("\u5206\u5b50\u89c4\u5212\u5173\u8054\u5206\u5b50\u65b9\u6848\u5212\u52062\uff0c\u89c4\u5212\u660e\u7ec6\u6761\u6570:{}", (Object)designDetailList.size());
        for (SubComActivityDesignDetailDto detail : designDetailList) {
            BigDecimal detailCost = Optional.ofNullable(detail.getTotalCost()).orElse(BigDecimal.ZERO);
            SubComActivityPlanItemVo subPlanItem = (SubComActivityPlanItemVo)subPlanItemMap.get(detail.getAssociatedDateCode());
            Validate.notNull((Object)subPlanItem, (String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u5206\u5b50\u516c\u53f8\u65b9\u6848\uff0c\u5173\u8054\u7f16\u7801:{}", (Object[])new Object[]{detail.getAssociatedDateCode()});
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)detail.getActivityFormCode()) && detail.getActivityFormCode().equals(subPlanItem.getActivityFormCode()) ? 1 : 0) != 0, (String)("\u5173\u8054\u5206\u5b50\u516c\u53f8\u65b9\u6848\u3010" + subPlanItem.getSubActivityPlanCode() + "\u3011\u3010" + subPlanItem.getSubActivityPlanItemCode() + "\u3011,\u6d3b\u52a8\u5f62\u5f0f\u9700\u76f8\u540c\uff01"), (Object[])new Object[0]);
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)detail.getBudgetItemCode()) && detail.getBudgetItemCode().equals(subPlanItem.getBudgetItemCode()) ? 1 : 0) != 0, (String)("\u5173\u8054\u5206\u5b50\u516c\u53f8\u65b9\u6848\u3010" + subPlanItem.getSubActivityPlanCode() + "\u3011\u3010" + subPlanItem.getSubActivityPlanItemCode() + "\u3011,\u9884\u7b97\u9879\u76ee\u9700\u76f8\u540c\uff01"), (Object[])new Object[0]);
            BigDecimal planCost = BigDecimal.ZERO;
            if (planCostMap.containsKey(subPlanItem.getSubActivityPlanItemCode())) {
                planCost = (BigDecimal)planCostMap.get(subPlanItem.getSubActivityPlanItemCode());
            } else {
                planCostMap.put(subPlanItem.getSubActivityPlanItemCode(), subPlanItem.getResidueAmount());
                planCost = subPlanItem.getResidueAmount();
            }
            Validate.isTrue((detailCost.compareTo(planCost) <= 0 ? 1 : 0) != 0, (String)("\u89c4\u5212\u4f7f\u7528\u9884\u7b97\u9879\u76ee" + subPlanItem.getSubActivityPlanItemCode() + ",\u8d39\u7528\u8d85\u8fc7\u4e86\u5206\u5b50\u65b9\u6848\u3010" + subPlanItem.getSubActivityPlanCode() + "\u3011\u3010" + subPlanItem.getSubActivityPlanItemCode() + "\u3011\u89c4\u5b9a\u989d\u5ea6\uff01"), (Object[])new Object[0]);
            SubComBudgetForecastVo budgetForecast = (SubComBudgetForecastVo)subComBudgetForecastMap.get(subPlanItem.getFeeSourceCode() + "-" + detail.getBudgetItemCode());
            Validate.notNull((Object)budgetForecast, (String)("\u672a\u67e5\u8be2\u5230\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u4fe1\u606f\uff0c\u5173\u8054\u9884\u7b97\u7f16\u7801:" + detail.getBudgetItemCode()), (Object[])new Object[0]);
            BigDecimal remainderAmount = BigDecimal.ZERO;
            if (forecastCostMap.containsKey(budgetForecast.getBudgetForecastCode())) {
                remainderAmount = (BigDecimal)forecastCostMap.get(budgetForecast.getBudgetForecastCode());
            } else {
                forecastCostMap.put(budgetForecast.getBudgetForecastCode(), budgetForecast.getRemainderAmount());
            }
            if (detailCost.compareTo(budgetForecast.getRemainderAmount()) <= 0) {
                SubComActivityDesignBudgetDto designBudgetDto = new SubComActivityDesignBudgetDto();
                designBudgetDto.setBudgetForecastCode(budgetForecast.getBudgetForecastCode());
                designBudgetDto.setBudgetAmount(detailCost);
                designBudgetDto.setIsAllDown(detailCost.compareTo(budgetForecast.getRemainderAmount()) == 0 ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
                designBudgetDto.setBusinessFormatCode(budgetForecast.getBusinessFormatCode());
                designBudgetDto.setYearMonthLy(budgetForecast.getYearMonthLy());
                designBudgetDto.setBudgetItemCode(budgetForecast.getBudgetItemCode());
                designBudgetDto.setBudgetItemName(budgetForecast.getBudgetItemName());
                designBudgetDto.setFeeSourceCode(budgetForecast.getFeeSourceCode());
                ArrayList<SubComActivityDesignBudgetDto> budgetList = new ArrayList<SubComActivityDesignBudgetDto>();
                budgetList.add(designBudgetDto);
                detail.setBudgetList(budgetList);
                SubComActivityDesignFeeDetailDto feeDetail = new SubComActivityDesignFeeDetailDto();
                feeDetail.setAssociationType(detail.getAssociationType());
                feeDetail.setThisUseAmount(detailCost);
                if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budgetForecast.getFeeSourceCode())) {
                    feeDetail.setInternalAmount(detailCost);
                } else if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budgetForecast.getFeeSourceCode())) {
                    feeDetail.setOffAmount(detailCost);
                } else if (FeeSourceEnum.AUTO_FEE.getCode().equals(budgetForecast.getFeeSourceCode())) {
                    feeDetail.setAutoAmount(detailCost);
                }
                detail.setFeeDetail(feeDetail);
                SubComActivityPlanItemFeeDto planFee = new SubComActivityPlanItemFeeDto();
                planFee.setSubActivityPlanItemCode(subPlanItem.getSubActivityPlanItemCode());
                planFee.setSubActivityPlanItemName(subPlanItem.getSubActivityPlanItemName());
                planFee.setSubActivityPlanCode(subPlanItem.getSubActivityPlanCode());
                planFee.setSubActivityPlanName(subPlanItem.getSubActivityPlanName());
                planFee.setTenantCode(TenantUtils.getTenantCode());
                planFee.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                planFee.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                planFee.setBusinessUnitCode(budgetForecast.getBusinessUnitCode());
                planFee.setBudgetItemCode(budgetForecast.getBudgetItemCode());
                planFee.setBudgetItemName(budgetForecast.getBudgetItemName());
                planFee.setInitialAmount(subPlanItem.getTotalCost());
                planFee.setBeforeAmount(planCost);
                planFee.setCurOperationAmount(detailCost);
                BigDecimal balanceAmount = planCost.subtract(detailCost);
                planFee.setBalanceAmount(balanceAmount);
                planFee.setBusinessCode(detail.getActivityDesignDetailCode());
                planFee.setOperationType(ForecastOperationTypeEnum.USE.getCode());
                planItemFeeList.add(planFee);
                forecastCostMap.put(budgetForecast.getBudgetForecastCode(), budgetForecast.getRemainderAmount().subtract(detailCost));
                planCostMap.put(subPlanItem.getSubActivityPlanItemCode(), balanceAmount);
                continue;
            }
            throw new IllegalArgumentException("\u9884\u7b97\u9879\u76ee[" + detail.getBudgetItemCode() + "]\uff0c\u5269\u4f59\u8d39\u7528\u4e0d\u8db3\uff01");
        }
        Date date = new Date();
        String sortAsc = DateUtil.format((Date)date, (String)"yyyyMMddHHmmss");
        for (int i = 0; i <= planItemFeeList.size(); ++i) {
            ((SubComActivityPlanItemFeeDto)planItemFeeList.get(i)).setSortAsc(Long.valueOf(Long.parseLong(sortAsc + i)));
            ++i;
        }
        log.info("\u5206\u5b50\u89c4\u5212\u5173\u8054\u5206\u5b50\u65b9\u6848\u5212\u52063,\u65b9\u6848\u4f7f\u7528\u8bb0\u5f55\u6761\u6570:{}", (Object)planItemFeeList.size());
        return planItemFeeList;
    }

    private void divideExpenses(SubComActivityDesignDto dto, List<SubComActivityDesignDetailDto> itemCacheList) {
        if (CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        List<SubComActivityDesignDetailDto> upList = itemCacheList.stream().filter(n -> RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(n.getAssociationType()) && !UndertakingModeTypeEnum.NO_ACCEPT.getCode().equals(n.getUndertakingMode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(upList)) {
            return;
        }
        List associatedDateCodes = itemCacheList.stream().map(SubComActivityDesignDetailDto::getAssociatedDateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List detailPlanItemVos = this.activityDetailPlanItemSdkService.findByItemCodes(associatedDateCodes);
        Map detailPlanItemVoMap = detailPlanItemVos.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
        for (int i2 = 0; i2 < itemCacheList.size(); ++i2) {
            SubComActivityDesignDetailDto item2 = itemCacheList.get(i2);
            if (UndertakingModeTypeEnum.FULL_ACCEPT.getCode().equals(item2.getUndertakingMode())) {
                ActivityDetailPlanItemVo detailPlanItem = detailPlanItemVoMap.getOrDefault(item2.getAssociatedDateCode(), new ActivityDetailPlanItemVo());
                Validate.isTrue((boolean)Optional.ofNullable(item2.getProductCode()).orElse("").equals(detailPlanItem.getProductCode()), (String)("\u7b2c\u3010" + (i2 + 1) + "\u3011\u884c\uff0c\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + item2.getAssociatedDateCode() + "]"), (Object[])new Object[0]);
                Validate.isTrue((boolean)Optional.ofNullable(item2.getProductName()).orElse("").equals(Optional.ofNullable(detailPlanItem.getProductName()).orElse("")), (String)("\u7b2c\u3010" + (i2 + 1) + "\u3011\u884c\uff0c\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + item2.getAssociatedDateCode() + "]"), (Object[])new Object[0]);
                Validate.isTrue((boolean)Optional.ofNullable(item2.getGiftProductCode()).orElse("").equals(Optional.ofNullable(detailPlanItem.getGiftCode()).orElse("")), (String)("\u7b2c\u3010" + (i2 + 1) + "\u3011\u884c\uff0c\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u8d60\u54c1\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + item2.getAssociatedDateCode() + "]"), (Object[])new Object[0]);
                if ("ZS01".equals(item2.getActivityFormCode()) || "ZS02".equals(item2.getActivityFormCode())) {
                    Validate.isTrue((Optional.ofNullable(item2.getGiftProductNumber()).orElse(BigDecimal.ZERO).intValue() == Optional.ofNullable(detailPlanItem.getGiftQuantity()).orElse(0).intValue() ? 1 : 0) != 0, (String)("\u7b2c\u3010" + (i2 + 1) + "\u3011\u884c\uff0c\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u8d60\u54c1\u6570\u91cf\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + item2.getAssociatedDateCode() + "]"), (Object[])new Object[0]);
                    Validate.isTrue((Optional.ofNullable(item2.getOriginalProductNumber()).orElse(BigDecimal.ZERO).intValue() == Optional.ofNullable(detailPlanItem.getProductQuantity()).orElse(0).intValue() ? 1 : 0) != 0, (String)("\u7b2c\u3010" + (i2 + 1) + "\u3011\u884c\uff0c\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u672c\u54c1\u6570\u91cf\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + item2.getAssociatedDateCode() + "]"), (Object[])new Object[0]);
                }
                if ("ZS03".equals(item2.getActivityFormCode())) {
                    BigDecimal activityIntensity;
                    BigDecimal thisIntensity = Optional.ofNullable(item2.getOriginalProductPrice()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(item2.getActivityPrice()).orElse(BigDecimal.ZERO));
                    String activityIntensityStr = Optional.ofNullable(detailPlanItem.getActivityIntensity()).orElse("0");
                    try {
                        activityIntensity = new BigDecimal(activityIntensityStr);
                    }
                    catch (Exception ignore) {
                        activityIntensity = BigDecimal.ZERO;
                    }
                    Validate.isTrue((thisIntensity.compareTo(activityIntensity) == 0 ? 1 : 0) != 0, (String)("\u7b2c\u3010" + (i2 + 1) + "\u3011\u884c\uff0c\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u539f\u4ef7-\u6d3b\u52a8\u4ef7\u4e0e\u529b\u5ea6\u4e0d\u4e00\u81f4\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + item2.getAssociatedDateCode() + "]"), (Object[])new Object[0]);
                }
            }
            if (!AuditConditionEnum.whxtj.getCode().equals(item2.getAuditCondition())) continue;
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)item2.getAuditConditionCode()), (String)"\u6838\u9500\u65b9\u5f0f\u4e3a\u65e0\u6838\u9500\u6761\u4ef6\u65f6\u65f6\uff0c\u6838\u9500\u7f16\u7801\u5fc5\u987b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        HashSet budgetItemCodeSet = new HashSet();
        upList.forEach(item -> {
            if (CollectionUtils.isNotEmpty((Collection)item.getBudgetList())) {
                Set budgetItemCodes = item.getBudgetList().stream().map(SubComActivityDesignBudgetDto::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
                budgetItemCodeSet.addAll(budgetItemCodes);
            }
        });
        Set yearMonthSet = upList.stream().map(i -> DateUtil.format((Date)i.getFeeYearMonth(), (String)"yyyy-MM")).collect(Collectors.toSet());
        List budgetItemMainItemVos = this.budgetItemMainItemService.listByMainBudgetItemCodeList(new ArrayList(budgetItemCodeSet));
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setYearMonthList(new ArrayList(yearMonthSet));
        subComBudgetForecastDto.setOrgCode(dto.getOrgCode());
        subComBudgetForecastDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComBudgetForecastDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        List subComBudgetForecastVoList = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        if (CollectionUtils.isEmpty((Collection)subComBudgetForecastVoList)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u67e5\u8be2\u5931\u8d25\uff01");
        }
        Map<String, List<SubComBudgetForecastVo>> budgetForecastListMap = subComBudgetForecastVoList.stream().collect(Collectors.groupingBy(f -> f.getYearMonthLy() + f.getBudgetItemCode() + f.getFeeSourceCode()));
        log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u4fdd\u5b58,budgetForecastListMap:{}", (Object)JSONObject.toJSONString(budgetForecastListMap));
        upList.forEach(item -> {
            String undertakingMode = item.getUndertakingMode();
            Validate.isTrue((boolean)UndertakingModeTypeEnum.contains((String)undertakingMode), (String)"\u672a\u77e5\u7684\u627f\u63a5\u65b9\u5f0f", (Object[])new Object[0]);
            Validate.notNull((Object)item.getActivityBeginTime(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String beginTime = DateUtil.format((Date)item.getActivityBeginTime(), (String)"yyyy-MM");
            if (CollectionUtils.isEmpty((Collection)item.getBudgetList())) {
                return;
            }
            item.getBudgetList().forEach(budget -> {
                boolean b2;
                BudgetItemMainItemVo budgetItemMainItemVo = budgetItemMainItemVos.stream().filter(b -> b.getMainBudgetItemCode().equals(budget.getBudgetItemCode())).findFirst().orElse(null);
                boolean bl = b2 = !FeeSourceEnum.AUTO_FEE.getCode().equals(budget.getFeeSourceCode());
                if (null == budgetItemMainItemVo && b2) {
                    throw new RuntimeException("\u672a\u67e5\u8be2\u5230,\u6d3b\u52a8\u7ec6\u6848" + budget.getPlanDetailCode() + "\u5173\u8054\u7684\u5206\u5b50\u9884\u7b97\u9879\u76ee");
                }
                String budgetItemCode = b2 ? budgetItemMainItemVo.getBudgetItemCode() : budget.getBudgetItemCode();
                String key = budget.getYearMonthLy() + budgetItemCode + budget.getFeeSourceCode();
                log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u4fdd\u5b58key:{},budget:{}", (Object)key, (Object)JSONObject.toJSONString((Object)budget));
                List subComBudgetForecastVos = (List)budgetForecastListMap.get(key);
                Validate.notEmpty((Collection)subComBudgetForecastVos, (String)("\u672a\u67e5\u8be2\u5230,\u6d3b\u52a8\u7ec6\u6848" + budget.getPlanDetailCode() + "\u5173\u8054\u7684\u9884\u7b97\u9884\u6d4b"), (Object[])new Object[0]);
                SubComBudgetForecastVo subComBudgetForecastVo = subComBudgetForecastVos.stream().filter(Objects::nonNull).findFirst().orElse(null);
                if (null == subComBudgetForecastVo) {
                    throw new RuntimeException("\u672a\u67e5\u8be2\u5230,\u6d3b\u52a8\u7ec6\u6848" + budget.getPlanDetailCode() + "\u5173\u8054\u7684\u9884\u7b97\u9884\u6d4b");
                }
                budget.setBudgetForecastCode(subComBudgetForecastVo.getBudgetForecastCode());
                Validate.isTrue((boolean)beginTime.equals(subComBudgetForecastVo.getYearMonthLy()), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u548c\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e3a\u540c\u4e00\u6708\uff01", (Object[])new Object[0]);
                if (!FeeSourceEnum.AUTO_FEE.getCode().equals(subComBudgetForecastVo.getFeeSourceCode())) {
                    BigDecimal budgetAmount;
                    if (UndertakingModeTypeEnum.FULL_ACCEPT.getCode().equals(item.getUndertakingMode())) {
                        BigDecimal surplusWholeUndertakeAmt = Optional.ofNullable(subComBudgetForecastVo.getSurplusWholeUndertakeAmt()).orElse(BigDecimal.ZERO);
                        if (surplusWholeUndertakeAmt.compareTo(budgetAmount = Optional.ofNullable(budget.getBudgetAmount()).orElse(BigDecimal.ZERO)) < 0) {
                            throw new IllegalArgumentException("\u6d3b\u52a8\u7ec6\u6848[" + budget.getPlanDetailCode() + "],\u5173\u8054\u7684\u9884\u7b97\u9884\u6d4b[" + budgetItemMainItemVo.getBudgetItemCode() + "]\uff0c\u5269\u4f59\u5b8c\u5168\u627f\u63a5\u8d39\u7528\u4e0d\u8db3");
                        }
                        subComBudgetForecastVo.setSurplusWholeUndertakeAmt(surplusWholeUndertakeAmt.subtract(budgetAmount));
                    }
                    if (UndertakingModeTypeEnum.PART_ACCEPT.getCode().equals(item.getUndertakingMode())) {
                        BigDecimal surplusPartUndertakeAmt = Optional.ofNullable(subComBudgetForecastVo.getSurplusPartUndertakeAmt()).orElse(BigDecimal.ZERO);
                        if (surplusPartUndertakeAmt.compareTo(budgetAmount = Optional.ofNullable(budget.getBudgetAmount()).orElse(BigDecimal.ZERO)) < 0) {
                            throw new IllegalArgumentException("\u6d3b\u52a8\u7ec6\u6848[" + budget.getPlanDetailCode() + "],\u5173\u8054\u7684\u9884\u7b97\u9884\u6d4b[" + budgetItemMainItemVo.getBudgetItemCode() + "]\uff0c\u5269\u4f59\u90e8\u5206\u627f\u63a5\u8d39\u7528\u4e0d\u8db3");
                        }
                        subComBudgetForecastVo.setSurplusPartUndertakeAmt(surplusPartUndertakeAmt.subtract(budgetAmount));
                    }
                } else {
                    BigDecimal budgetAmount;
                    BigDecimal remainderAmount = Optional.ofNullable(subComBudgetForecastVo.getRemainderAmount()).orElse(BigDecimal.ZERO);
                    if (remainderAmount.compareTo(budgetAmount = Optional.ofNullable(budget.getBudgetAmount()).orElse(BigDecimal.ZERO)) < 0 && !"A023".equals(budget.getBudgetItemCode())) {
                        throw new IllegalArgumentException("\u9884\u7b97\u9884\u6d4b[" + budget.getBudgetItemCode() + "]\uff0c\u5269\u4f59\u8d39\u7528\u4e0d\u8db3");
                    }
                    subComBudgetForecastVo.setRemainderAmount(remainderAmount.subtract(budgetAmount));
                }
            });
        });
    }

    private void validationList(SubComActivityDesignDto designDto, List<SubComActivityDesignDetailDto> dtoList) {
        Set productCodeSet;
        List templateList;
        Validate.notEmpty(dtoList, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashSet templateConfigCodeSet = Sets.newHashSet();
        Set feeYearMonthSet = dtoList.stream().map(SubComActivityDesignDetailDto::getFeeYearMonth).collect(Collectors.toSet());
        Validate.isTrue((feeYearMonthSet.size() == 1 ? 1 : 0) != 0, (String)"\u540c\u4e00\u4e2a\u89c4\u5212\u4e2d\uff0c\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u9700\u8981\u76f8\u540c", (Object[])new Object[0]);
        for (SubComActivityDesignDetailDto dto : dtoList) {
            Validate.notBlank((CharSequence)dto.getTemplateConfigCode(), (String)"\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
            Validate.notBlank((CharSequence)dto.getAuditType(), (String)"\u6838\u9500\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (BigDecimal.ZERO.compareTo(Optional.ofNullable(dto.getTotalCost()).orElse(BigDecimal.ZERO)) > 0) {
                throw new RuntimeException("\u8d39\u7528\u5408\u8ba1\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
            }
            Validate.isTrue((designDto.getFeeYearMonth().compareTo(dto.getFeeYearMonth()) == 0 ? 1 : 0) != 0, (String)"\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u5e74\u6708\u4e0e\u660e\u7ec6\u884c\u7684\u8d39\u7528\u5e74\u6708\u7684\u503c\u9700\u4fdd\u6301\u4e00\u81f4\uff01", (Object[])new Object[0]);
            this.validateTotalQuantityOrNot(dto);
            dto.setIsUnderRedLinePrice(BooleanEnum.FALSE.getCapital());
            if (!SubComActivityValidationFormCodeEnum.ZS02.name().equals(dto.getActivityFormCode())) continue;
            BigDecimal originalProductPrice = Optional.ofNullable(dto.getOriginalProductPrice()).orElse(BigDecimal.ZERO);
            BigDecimal originalProductNumber = Optional.ofNullable(dto.getOriginalProductNumber()).orElse(BigDecimal.ZERO);
            BigDecimal giftProductNumber = Optional.ofNullable(dto.getGiftProductNumber()).orElse(BigDecimal.ZERO);
            BigDecimal giftProductPrice = Optional.ofNullable(dto.getGiftProductPrice()).orElse(BigDecimal.ZERO);
            BigDecimal divide = giftProductNumber.add(originalProductNumber).multiply(originalProductPrice);
            BigDecimal originalProductActivityPrice = originalProductPrice.subtract(giftProductNumber.multiply(giftProductPrice).multiply(originalProductPrice).divide(divide, 2, RoundingMode.HALF_UP));
            dto.setOriginalProductActivityPrice(originalProductActivityPrice);
        }
        List isSupplyAmountList = dtoList.stream().filter(e -> BooleanEnum.TRUE.getCapital().equals(e.getIsSupplyAmount())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(isSupplyAmountList)) {
            Map<String, List<SubComActivityDesignDetailDto>> isSupplyAmountMap = isSupplyAmountList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailDto::getActivityNumber));
            isSupplyAmountMap.forEach((k, v) -> {
                BigDecimal activityPrice = Optional.ofNullable(((SubComActivityDesignDetailDto)v.get(0)).getActivityPrice()).orElse(BigDecimal.ZERO);
                BigDecimal giftProductNumber = Optional.ofNullable(((SubComActivityDesignDetailDto)v.get(0)).getGiftProductNumber()).orElse(BigDecimal.ZERO);
                BigDecimal originalProductNumber = Optional.ofNullable(((SubComActivityDesignDetailDto)v.get(0)).getOriginalProductNumber()).orElse(BigDecimal.ZERO);
                for (SubComActivityDesignDetailDto vo : v) {
                    if ("ZS03".equals(vo.getActivityFormCode())) {
                        Validate.isTrue((activityPrice.compareTo(Optional.ofNullable(vo.getActivityPrice()).orElse(BigDecimal.ZERO)) == 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u4ef7\u5fc5\u987b\u76f8\u540c", (Object[])new Object[0]);
                        continue;
                    }
                    if (!"ZS02".equals(vo.getActivityFormCode())) continue;
                    Validate.isTrue((giftProductNumber.compareTo(Optional.ofNullable(vo.getGiftProductNumber()).orElse(BigDecimal.ZERO)) == 0 ? 1 : 0) != 0, (String)"\u8d60\u54c1\u6570\u91cf\u5fc5\u987b\u76f8\u540c", (Object[])new Object[0]);
                    Validate.isTrue((originalProductNumber.compareTo(Optional.ofNullable(vo.getOriginalProductNumber()).orElse(BigDecimal.ZERO)) == 0 ? 1 : 0) != 0, (String)"\u539f\u54c1\u6570\u91cf\u5fc5\u987b\u76f8\u540c", (Object[])new Object[0]);
                }
            });
        }
        if ((templateList = this.activitiesTemplateSdkService.findByCodeList((List)com.google.common.collect.Lists.newArrayList((Iterable)templateConfigCodeSet))).size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u6a21\u677f\u6570\u636e\u6709\u8bef\uff01");
        }
        Map templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<SubComActivityDesignDetailDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailDto::getTemplateConfigCode));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(SubComActivityDesignDetailDto.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (Map.Entry<String, List<SubComActivityDesignDetailDto>> dtoEntry : dtoMap.entrySet()) {
            List<SubComActivityDesignDetailDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = (ActivitiesTemplateConfigVo)templateMap.get(dtoEntry.getKey());
            for (ActivitiesTemplateConfigDetailVo activitiesTemplateConfigDetailVo : templateConfigVo.getDetails()) {
                if (null == activitiesTemplateConfigDetailVo.getRequired() || !activitiesTemplateConfigDetailVo.getRequired().booleanValue()) continue;
                if (!propertyMap.containsKey(activitiesTemplateConfigDetailVo.getField())) {
                    throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + activitiesTemplateConfigDetailVo.getTitle() + "]\u914d\u7f6e\u6709\u8bef");
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(activitiesTemplateConfigDetailVo.getField());
                if (null != propertyDescriptor) {
                    for (SubComActivityDesignDetailDto dto : thisDtoList) {
                        try {
                            Object invoke = propertyDescriptor.getReadMethod().invoke((Object)dto, new Object[0]);
                            if (null != invoke && !StringUtils.isEmpty((CharSequence)invoke.toString())) continue;
                            throw new RuntimeException("[" + activitiesTemplateConfigDetailVo.getTitle() + "]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        catch (IllegalAccessException | InvocationTargetException e2) {
                            throw new RuntimeException("[" + activitiesTemplateConfigDetailVo.getTitle() + "]\u8bfb\u53d6\u5931\u8d25\uff01");
                        }
                    }
                    continue;
                }
                throw new RuntimeException("[" + activitiesTemplateConfigDetailVo.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        List updateRedPriceList = dtoList.stream().filter(item -> SubComActivityValidationFormCodeEnum.ZS02.name().equals(item.getActivityFormCode()) || SubComActivityValidationFormCodeEnum.ZS03.name().equals(item.getActivityFormCode())).collect(Collectors.toList());
        if (!CollectionUtil.isEmpty(updateRedPriceList) && !CollectionUtil.isEmpty(productCodeSet = updateRedPriceList.stream().map(SubComActivityDesignDetailDto::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet()))) {
            Set channelCodeSet = updateRedPriceList.stream().map(SubComActivityDesignDetailDto::getDistributionChannelCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
            if (!CollectionUtil.isEmpty(productCodeSet)) {
                Map<String, List<SubComActivityDesignDetailDto>> channelDesignDetailMap = updateRedPriceList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailDto::getDistributionChannelCode));
                for (Map.Entry entry : channelDesignDetailMap.entrySet()) {
                    SearchPriceDto searchPriceDto = new SearchPriceDto();
                    searchPriceDto.setPriceTypeCode(PriceTypeEnum.FZ_RED_LINE_PRICE.getDictCode());
                    SearchPriceDimensionItemDto searchPriceDimensionItemDto = new SearchPriceDimensionItemDto();
                    searchPriceDimensionItemDto.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
                    searchPriceDimensionItemDto.setRelateCodeSet((Set)Sets.newHashSet(productCodeSet));
                    SearchPriceDimensionItemDto dimensionItemDto3 = new SearchPriceDimensionItemDto();
                    dimensionItemDto3.setDimensionCode(PriceDimensionEnum.DISTRIBUTION_CHANNEL.getDictCode());
                    dimensionItemDto3.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{(String)entry.getKey()}));
                    searchPriceDto.setDimensionItems((List)com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList((Object[])new SearchPriceDimensionItemDto[]{searchPriceDimensionItemDto, dimensionItemDto3}));
                    Map stringPriceModelVoMap = this.priceModelVoService.handleSearchPrice(searchPriceDto);
                    for (SubComActivityDesignDetailDto subComActivityDesignDetailDto : (List)entry.getValue()) {
                        PriceModelVo priceModelVo;
                        if (StringUtils.isEmpty((CharSequence)subComActivityDesignDetailDto.getProductCode()) || null == (priceModelVo = (PriceModelVo)stringPriceModelVoMap.get(subComActivityDesignDetailDto.getProductCode()))) continue;
                        subComActivityDesignDetailDto.setOriginalProductRedLinePrice(priceModelVo.getPrice());
                        if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(subComActivityDesignDetailDto.getActivityFormCode())) {
                            if (subComActivityDesignDetailDto.getOriginalProductActivityPrice().compareTo(priceModelVo.getPrice()) >= 0) continue;
                            subComActivityDesignDetailDto.setIsUnderRedLinePrice(BooleanEnum.TRUE.getCapital());
                            continue;
                        }
                        if (subComActivityDesignDetailDto.getActivityPrice().compareTo(priceModelVo.getPrice()) >= 0) continue;
                        subComActivityDesignDetailDto.setIsUnderRedLinePrice(BooleanEnum.TRUE.getCapital());
                    }
                }
            }
        }
    }

    public SubComActivityDesignVo findById(String id) {
        Validate.notEmpty((CharSequence)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SubComActivityDesignEntity subComActivityDesignEntity = this.subComActivityDesignRepository.findById(id);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)((Object)subComActivityDesignEntity))) {
            throw new RuntimeException("\u6d3b\u52a8\u89c4\u5212\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        SubComActivityDesignVo subComActivityDesignVo = (SubComActivityDesignVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDesignEntity, SubComActivityDesignVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return subComActivityDesignVo;
    }

    public List<SubComActivityDesignDto> listByYearMonthAndOrg(SubComActivityDesignDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getFeeYearMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComActivityDesignEntity> subComActivityDesignEntityList = this.subComActivityDesignRepository.listByYearMonthAndOrg(dto.getFeeYearMonth(), dto.getOrgCode());
        if (CollectionUtils.isEmpty(subComActivityDesignEntityList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(subComActivityDesignEntityList, SubComActivityDesignEntity.class, SubComActivityDesignDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void submitBatch(List<SubComActivityDesignDto> dtoList, String processNo) {
        List<String> activityDesignCodeList = dtoList.stream().map(SubComActivityDesignDto::getActivityDesignCode).collect(Collectors.toList());
        this.subComActivityDesignRepository.updateProcessStatusAndProcessNoByTable(activityDesignCodeList, ProcessStatusEnum.COMMIT.getDictCode(), processNo);
    }

    public void rejectBatch(SubComActivityDesignDto dto) {
        this.subComActivityDesignRepository.updateBatchProcessStatus(dto.getProcessNo(), dto.getProcessStatus());
    }

    @Transactional(rollbackFor={Exception.class})
    public void passBatch(String processNo, String tableId) {
        log.info("\u6d3b\u52a8\u5957\u8868\u5ba1\u6279\u901a\u8fc7\u5f00\u59cb\u5904\u7406\uff0cprocessNo:{}", (Object)processNo);
        Validate.notEmpty((CharSequence)processNo, (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        List<SubComActivityDesignEntity> subComActivityDesignEntities = this.subComActivityDesignRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComActivityDesignEntities)) {
            throw new RuntimeException("\u672a\u627e\u5230" + processNo + "\u5bf9\u5e94\u6d3b\u52a8\u89c4\u5212\u6570\u636e\uff01");
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.subComActivityDesignRepository.updateBatchProcessStatus(processNo, ProcessStatusEnum.PASS.getDictCode());
        this.subComActivityDesignDetailRepository.updateBatchProcessStatus(processNo, ProcessStatusEnum.PASS.getDictCode());
        stopWatch.stop();
        log.info("----\u6d3b\u52a8\u89c4\u5212\u5957\u8868\u5ba1\u6279\u901a\u8fc7----\u5f00\u59cb\u66f4\u65b0\u5206\u5b50\u516c\u53f8\u89c4\u5212\u5ba1\u6279\u72b6\u6001\uff0c\u8017\u65f6\uff1a" + DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        this.generateDataAsync.generateData(processNo, loginUser, tableId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void activityDesignPassBatch(String processNo) {
        Validate.notEmpty((CharSequence)processNo, (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.subComActivityDesignRepository.updateBatchProcessStatus(processNo, ProcessStatusEnum.PASS.getDictCode());
        this.subComActivityDesignDetailRepository.updateBatchProcessStatus(processNo, ProcessStatusEnum.PASS.getDictCode());
        this.generateDataAsync.generateData(processNo, (UserIdentity)this.loginUserService.getAbstractLoginUser());
    }

    public void processRejectAndRecover(ProcessStatusDto dto) {
        Validate.notNull((Object)dto, (String)"\u6d41\u7a0b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.subComActivityDesignRepository.updateBatchProcessStatus(dto.getProcessNo(), dto.getProcessStatus());
        this.subComActivityDesignDetailRepository.updateBatchProcessStatus(dto.getProcessNo(), dto.getProcessStatus());
    }

    private void validate(SubComActivityDesignDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getActivityDesignName(), (String)"\u6d3b\u52a8\u89c4\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getActivityDesignName().length() <= 60 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u89c4\u5212\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc760\u5b57", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getFeeYearMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgErpCode(), (String)"\u9500\u552e\u7ec4\u7ec7erp\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgName(), (String)"\u9500\u552e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public String saveSubComActivityDesignAndDetail(SubComActivityDesignDto dto, List<SubComActivityDesignDetailDto> itemCacheList, List<SubComActivityPlanItemFeeDto> subPlanItemFeeList) {
        boolean updateFlag;
        SubComActivityDesignEntity entity = null;
        boolean bl = updateFlag = !StringUtils.isBlank((CharSequence)dto.getId());
        if (!updateFlag) {
            entity = (SubComActivityDesignEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComActivityDesignEntity.class, HashSet.class, ArrayList.class, new String[0]));
            String code = (String)this.generateCodeService.generateCode("FZDX", 1, Integer.valueOf(10), 2L, TimeUnit.DAYS).get(0);
            entity.setActivityDesignCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            this.subComActivityDesignRepository.save((Object)entity);
            dto.setId(entity.getId());
            dto.setActivityDesignCode(code);
        } else {
            SubComActivityDesignEntity oldEntity = (SubComActivityDesignEntity)((Object)this.subComActivityDesignRepository.getById((Serializable)((Object)dto.getId())));
            Validate.isTrue((ProcessStatusEnum.PREPARE.getDictCode().equals(oldEntity.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(oldEntity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(oldEntity.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u4fee\u6539\u5904\u4e8e\u9a73\u56de\uff0c\u8ffd\u56de\uff0c\u5f85\u63d0\u4ea4\u72b6\u6001\u7684\u5206\u5b50\u6d3b\u52a8\u89c4\u5212", (Object[])new Object[0]);
            dto.setActivityDesignCode(oldEntity.getActivityDesignCode());
            dto.setTenantCode(oldEntity.getTenantCode());
            entity = (SubComActivityDesignEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComActivityDesignEntity.class, HashSet.class, ArrayList.class, new String[0]));
            this.subComActivityDesignRepository.updateById((Object)entity);
        }
        this.buildCommonCode(dto, itemCacheList, subPlanItemFeeList);
        this.subComActivityDesignDetailService.saveSubComActivityDesignDetailList(dto, updateFlag, itemCacheList);
        this.subComActivityDesignProductService.saveSubComActivityDesignProductList(dto, updateFlag, itemCacheList);
        this.subComActivityDesignFeeDetailService.saveSubComActivityDesignFeeDetailList(dto, updateFlag, itemCacheList);
        this.subComActivityDesignPlanService.saveSubComActivityDesignPlanList(dto, updateFlag, itemCacheList);
        ArrayList codeList = com.google.common.collect.Lists.newArrayList((Object[])new String[]{dto.getActivityDesignCode()});
        this.subComActivityDesignBudgetService.saveSubComActivityDesignBudgetList(dto, updateFlag, itemCacheList);
        this.subComActivityDesignBudgetService.useSubComBudgetForecastByCode((List)codeList);
        if (!CollectionUtils.isEmpty(subPlanItemFeeList)) {
            log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u5f00\u59cb\u4fdd\u5b58\u5173\u8054\u65b9\u6848\u4f7f\u7528\u660e\u7ec6");
            this.subComActivityPlanItemService.useSubPlanItemFee(subPlanItemFeeList);
        }
        if (BooleanEnum.TRUE.getCapital().equals(dto.getUnderFlag())) {
            // empty if block
        }
        if (!updateFlag) {
            SubComActivityDesignLogEventDto logEventDto = new SubComActivityDesignLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = SubComActivityDesignLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComActivityDesignLogEventListener.class, (SerializableBiConsumer)onCreate);
        }
        return entity.getActivityDesignCode();
    }

    private void validateTotalQuantityOrNot(SubComActivityDesignDetailDto detailDto) {
        if (TotalQuantityOrNotEnum.N.getCode().equals(detailDto.getIsSupplyAmount()) || TotalQuantityOrNotEnum.Y.getCode().equals(detailDto.getIsSupplyAmount())) {
            String[] split;
            if (StringUtils.isNotBlank((CharSequence)detailDto.getCustomerCode())) {
                split = detailDto.getCustomerCode().split(",");
                detailDto.setCustomerCode(split[0]);
            }
            if (StringUtils.isNotBlank((CharSequence)detailDto.getCustomerName())) {
                split = detailDto.getCustomerName().split(",");
                detailDto.setCustomerName(split[0]);
            }
        }
    }

    private SubComActivityDesignDto findDtoById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        SubComActivityDesignVo subComActivityDesignVo = this.findById(id);
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)subComActivityDesignVo)) {
            SubComActivityDesignDto subComActivityDesignDto = (SubComActivityDesignDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDesignVo, SubComActivityDesignDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            SubComActivityDesignDetailDto subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
            subComActivityDesignDetailDto.setActivityDesignCode(subComActivityDesignDto.getActivityDesignCode());
            List dtoList = this.subComActivityDesignDetailService.findDtoList(subComActivityDesignDetailDto);
            subComActivityDesignDto.setDetailList(dtoList);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void refreshPlan(SubComActivityDesignDto dto, List<SubComActivityDesignDetailDto> itemCacheList, List<SubComActivityDesignBudgetVo> oldBudgetList) {
        if (CollectionUtils.isEmpty(oldBudgetList)) {
            oldBudgetList = Lists.newArrayList();
        }
        Map<String, List<SubComActivityDesignBudgetVo>> oldBudgetMap = oldBudgetList.stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetVo::getActivityDesignDetailCode));
        HashMap operationPlanBudgetMap = new HashMap(8);
        HashMap operationDetailPlanBudgetMap = new HashMap(8);
        itemCacheList.forEach(itemCache -> {
            List budgetList;
            List subComActivityDesignBudgetVoList = Optional.ofNullable(oldBudgetMap.get(itemCache.getActivityDesignDetailCode())).orElse(new ArrayList());
            Map oldMap = subComActivityDesignBudgetVoList.stream().collect(Collectors.toMap(vo -> vo.getPlanDetailCode() + vo.getFeeSourceCode(), Function.identity()));
            if (RelationTypeEnum.UP_RELATION_PLAN.getCode().equals(itemCache.getAssociationType())) {
                budgetList = itemCache.getBudgetList();
                budgetList.forEach(budget -> {
                    if (FeeSourceEnum.AUTO_FEE.getCode().equals(budget.getFeeSourceCode())) {
                        return;
                    }
                    String key = budget.getPlanDetailCode() + budget.getFeeSourceCode();
                    ActivityPlanBudgetDto activityPlanBudgetDto = operationPlanBudgetMap.getOrDefault(key, new ActivityPlanBudgetDto());
                    if (oldMap.containsKey(key)) {
                        BigDecimal oldBudgetAmount = ((SubComActivityDesignBudgetVo)oldMap.get(key)).getBudgetAmount();
                        activityPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).add(budget.getBudgetAmount().subtract(oldBudgetAmount)));
                        oldMap.remove(key);
                    } else {
                        activityPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).add(budget.getBudgetAmount()));
                    }
                    activityPlanBudgetDto.setPlanItemCode(budget.getPlanDetailCode());
                    operationPlanBudgetMap.put(key, activityPlanBudgetDto);
                });
                if (MapUtils.isNotEmpty(oldMap)) {
                    oldMap.forEach((key, value) -> {
                        if (!FeeSourceEnum.AUTO_FEE.getCode().equals(value.getFeeSourceCode())) {
                            ActivityPlanBudgetDto activityPlanBudgetDto = new ActivityPlanBudgetDto();
                            activityPlanBudgetDto.setPlanItemCode(value.getPlanDetailCode());
                            activityPlanBudgetDto.setThisDownAmount(BigDecimal.ZERO.subtract(value.getBudgetAmount()));
                            operationPlanBudgetMap.put(key, activityPlanBudgetDto);
                        }
                    });
                }
            }
            if (RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(itemCache.getAssociationType())) {
                budgetList = itemCache.getBudgetList();
                budgetList.forEach(budget -> {
                    if (FeeSourceEnum.AUTO_FEE.getCode().equals(budget.getFeeSourceCode())) {
                        return;
                    }
                    String key = budget.getPlanDetailCode() + budget.getFeeSourceCode();
                    ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto = operationDetailPlanBudgetMap.getOrDefault(key, new ActivityDetailPlanBudgetDto());
                    if (oldMap.containsKey(key)) {
                        BigDecimal oldBudgetAmount = ((SubComActivityDesignBudgetVo)oldMap.get(key)).getBudgetAmount();
                        activityDetailPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityDetailPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).add(budget.getBudgetAmount().subtract(oldBudgetAmount)));
                        oldMap.remove(key);
                    } else {
                        activityDetailPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityDetailPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).add(budget.getBudgetAmount()));
                    }
                    activityDetailPlanBudgetDto.setDetailPlanItemCode(budget.getPlanDetailCode());
                    operationDetailPlanBudgetMap.put(key, activityDetailPlanBudgetDto);
                });
                if (MapUtils.isNotEmpty(oldMap)) {
                    oldMap.forEach((key, value) -> {
                        if (!FeeSourceEnum.AUTO_FEE.getCode().equals(value.getFeeSourceCode())) {
                            ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto = new ActivityDetailPlanBudgetDto();
                            activityDetailPlanBudgetDto.setDetailPlanItemCode(value.getPlanDetailCode());
                            activityDetailPlanBudgetDto.setThisDownAmount(BigDecimal.ZERO.subtract(value.getBudgetAmount()));
                            operationDetailPlanBudgetMap.put(key, activityDetailPlanBudgetDto);
                        }
                    });
                }
            }
        });
        if (MapUtils.isNotEmpty(operationPlanBudgetMap)) {
            this.activityPlanItemSdkService.operationBudget(new ArrayList(operationPlanBudgetMap.values()));
        }
        if (MapUtils.isNotEmpty(operationDetailPlanBudgetMap)) {
            this.activityDetailPlanItemSdkService.operationBudget(new ArrayList(operationDetailPlanBudgetMap.values()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAndUseBudgetForecast(SubComActivityDesignDto dto, List<SubComActivityDesignDetailDto> itemCacheList, List<SubComActivityDesignForecastVo> oldForecastList) {
        Set yearMonthSet = itemCacheList.stream().map(itemCache -> DateUtil.format((Date)itemCache.getFeeYearMonth(), (String)"yyyy-MM")).collect(Collectors.toSet());
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setOrgCode(dto.getOrgCode());
        subComBudgetForecastDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComBudgetForecastDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        subComBudgetForecastDto.setYearMonthList(new ArrayList(yearMonthSet));
        List subComBudgetForecastVoList = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        if (CollectionUtils.isEmpty((Collection)subComBudgetForecastVoList)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u67e5\u8be2\u5931\u8d25\uff01");
        }
        Map<String, List<SubComBudgetForecastVo>> budgetForecastListMap = subComBudgetForecastVoList.stream().collect(Collectors.groupingBy(SubComBudgetForecastVo::getYearMonthLy));
        Map budgetForecastMap = subComBudgetForecastVoList.stream().collect(Collectors.toMap(SubComBudgetForecastVo::getBudgetForecastCode, Function.identity()));
        Map<String, List<SubComActivityDesignForecastVo>> oldBudgetForecastMap = oldForecastList.stream().collect(Collectors.groupingBy(SubComActivityDesignForecastVo::getActivityDesignDetailCode));
        HashMap operationBudgetForecastMap = new HashMap(8);
        ArrayList thisForecastList = new ArrayList();
        ArrayList feeDetailList = new ArrayList();
        itemCacheList.forEach(itemCache -> {
            String feeYearMonth;
            SubComActivityDesignFeeDetailEntity feeDetail = new SubComActivityDesignFeeDetailEntity();
            feeDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            feeDetail.setTenantCode(TenantUtils.getTenantCode());
            feeDetail.setActivityDesignCode(itemCache.getActivityDesignCode());
            feeDetail.setActivityDesignDetailCode(itemCache.getActivityDesignDetailCode());
            HashMap<String, SubComActivityDesignForecastVo> oldMap = new HashMap();
            if (oldBudgetForecastMap.containsKey(itemCache.getActivityDesignDetailCode())) {
                List subComActivityDesignForecastVos = (List)oldBudgetForecastMap.get(itemCache.getActivityDesignDetailCode());
                oldMap = subComActivityDesignForecastVos.stream().collect(Collectors.toMap(SubComActivityDesignForecastVo::getBudgetForecastCode, Function.identity()));
            }
            if (!budgetForecastListMap.containsKey(feeYearMonth = DateUtil.format((Date)itemCache.getFeeYearMonth(), (String)"yyyy-MM"))) {
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230" + feeYearMonth + "\u9884\u7b97\u9884\u6d4b\u6570\u636e\uff01");
            }
            List budgetForecastList = (List)budgetForecastListMap.get(feeYearMonth);
            AtomicReference<BigDecimal> totalCost = new AtomicReference<BigDecimal>(itemCache.getTotalCost());
            List<SubComBudgetForecastVo> offList = budgetForecastList.stream().filter(budgetForecast -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budgetForecast.getFeeSourceCode())).collect(Collectors.toList());
            List<SubComBudgetForecastVo> internalList = budgetForecastList.stream().filter(budgetForecast -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budgetForecast.getFeeSourceCode())).collect(Collectors.toList());
            List<SubComBudgetForecastVo> autoList = budgetForecastList.stream().filter(budgetForecast -> FeeSourceEnum.AUTO_FEE.getCode().equals(budgetForecast.getFeeSourceCode())).collect(Collectors.toList());
            this.useBudgetForecast(offList, oldMap, operationBudgetForecastMap, feeDetail, totalCost);
            this.useBudgetForecast(internalList, oldMap, operationBudgetForecastMap, feeDetail, totalCost);
            this.useBudgetForecast(autoList, oldMap, operationBudgetForecastMap, feeDetail, totalCost);
            if (totalCost.get().compareTo(BigDecimal.ZERO) > 0) {
                String offStr = offList.stream().map(SubComBudgetForecastVo::getBudgetForecastCode).collect(Collectors.joining(","));
                String internalStr = internalList.stream().map(SubComBudgetForecastVo::getBudgetForecastCode).collect(Collectors.joining(","));
                String autoStr = autoList.stream().map(SubComBudgetForecastVo::getBudgetForecastCode).collect(Collectors.joining(","));
                throw new RuntimeException("\u9884\u7b97\u9884\u6d4b" + offStr + "," + internalStr + "," + autoStr + "\u6838\u51c6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            thisForecastList.addAll(this.buildDesignForecast(operationBudgetForecastMap, budgetForecastMap, (SubComActivityDesignDetailDto)itemCache, feeDetail));
            feeDetailList.add(feeDetail);
            if (MapUtils.isNotEmpty(oldMap)) {
                oldMap.forEach((key, value) -> {
                    SubComBudgetForecastDetailDto orDefault = new SubComBudgetForecastDetailDto();
                    orDefault.setBudgetForecastCode(key);
                    orDefault.setCurOperationAmount(BigDecimal.ZERO.subtract(value.getThisUseAmount()));
                    operationBudgetForecastMap.put(key, orDefault);
                });
            }
        });
        if (MapUtils.isNotEmpty(operationBudgetForecastMap)) {
            this.subComBudgetForecastService.operationBudgetForecast(new ArrayList(operationBudgetForecastMap.values()));
        }
        this.subComActivityDesignFeeDetailRepository.deleteByActivityCode(dto.getActivityDesignCode());
        this.subComActivityDesignFeeDetailRepository.saveBatch(feeDetailList);
        this.subComActivityDesignForecastRepository.deleteByActivityCode(dto.getActivityDesignCode());
        this.subComActivityDesignForecastRepository.saveBatch(thisForecastList);
    }

    private List<SubComActivityDesignForecastEntity> buildDesignForecast(Map<String, SubComBudgetForecastDetailDto> operationBudgetForecastMap, Map<String, SubComBudgetForecastVo> budgetForecastMap, SubComActivityDesignDetailDto itemCache, SubComActivityDesignFeeDetailEntity feeDetail) {
        ArrayList<SubComActivityDesignForecastEntity> thisForecastList = new ArrayList<SubComActivityDesignForecastEntity>();
        operationBudgetForecastMap.values().forEach(operationBudgetForecast -> {
            SubComActivityDesignForecastEntity subComActivityDesignForecastEntity = (SubComActivityDesignForecastEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(budgetForecastMap.get(operationBudgetForecast.getBudgetForecastCode()), SubComActivityDesignForecastEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            subComActivityDesignForecastEntity.setId(null);
            subComActivityDesignForecastEntity.setActivityDesignCode(itemCache.getActivityDesignCode());
            subComActivityDesignForecastEntity.setActivityDesignDetailCode(itemCache.getActivityDesignDetailCode());
            subComActivityDesignForecastEntity.setThisUseAmount(operationBudgetForecast.getCurOperationAmount());
            feeDetail.setThisUseAmount(Optional.ofNullable(feeDetail.getThisUseAmount()).orElse(BigDecimal.ZERO).add(subComActivityDesignForecastEntity.getThisUseAmount()));
            thisForecastList.add(subComActivityDesignForecastEntity);
        });
        return thisForecastList;
    }

    private void useBudgetForecast(List<SubComBudgetForecastVo> budgetForecastList, Map<String, SubComActivityDesignForecastVo> oldMap, Map<String, SubComBudgetForecastDetailDto> operationBudgetForecastMap, SubComActivityDesignFeeDetailEntity feeDetail, AtomicReference<BigDecimal> totalCost) {
        if (totalCost.get().compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        budgetForecastList.forEach(budgetForecast -> {
            SubComBudgetForecastDetailDto orDefault = operationBudgetForecastMap.getOrDefault(budgetForecast.getBudgetForecastCode(), new SubComBudgetForecastDetailDto());
            BigDecimal oldThisUseAmount = BigDecimal.ZERO;
            if (oldMap.containsKey(budgetForecast.getBudgetForecastCode())) {
                oldMap.remove(budgetForecast.getBudgetForecastCode());
                oldThisUseAmount = ((SubComActivityDesignForecastVo)oldMap.get(budgetForecast.getBudgetForecastCode())).getThisUseAmount();
            }
            BigDecimal canDesignAmount = BigDecimal.ZERO;
            canDesignAmount = budgetForecast.getApprovedAmount() != null ? budgetForecast.getApprovedAmount().subtract(Optional.ofNullable(budgetForecast.getDesignAmount()).orElse(BigDecimal.ZERO)) : budgetForecast.getBudgetAmount().subtract(Optional.ofNullable(budgetForecast.getDesignAmount()).orElse(BigDecimal.ZERO));
            if (BigDecimal.ZERO.compareTo(canDesignAmount) >= 0) {
                return;
            }
            if (((BigDecimal)totalCost.get()).compareTo(canDesignAmount) > 0) {
                orDefault.setCurOperationAmount(Optional.ofNullable(orDefault.getCurOperationAmount()).orElse(BigDecimal.ZERO).add(((BigDecimal)totalCost.get()).subtract(canDesignAmount).subtract(oldThisUseAmount)));
                totalCost.set(((BigDecimal)totalCost.get()).subtract(canDesignAmount));
            } else {
                orDefault.setCurOperationAmount(Optional.ofNullable(orDefault.getCurOperationAmount()).orElse(BigDecimal.ZERO).add((BigDecimal)totalCost.get()).subtract(oldThisUseAmount));
                totalCost.set(BigDecimal.ZERO);
            }
            if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budgetForecast.getFeeSourceCode())) {
                feeDetail.setOffAmount(Optional.ofNullable(feeDetail.getOffAmount()).orElse(BigDecimal.ZERO).add(orDefault.getCurOperationAmount()));
            }
            if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budgetForecast.getFeeSourceCode())) {
                feeDetail.setInternalAmount(Optional.ofNullable(feeDetail.getInternalAmount()).orElse(BigDecimal.ZERO).add(orDefault.getCurOperationAmount()));
            }
            if (FeeSourceEnum.AUTO_FEE.getCode().equals(budgetForecast.getFeeSourceCode())) {
                feeDetail.setAutoAmount(Optional.ofNullable(feeDetail.getAutoAmount()).orElse(BigDecimal.ZERO).add(orDefault.getCurOperationAmount()));
            }
            orDefault.setBudgetForecastCode(budgetForecast.getBudgetForecastCode());
            operationBudgetForecastMap.put(budgetForecast.getBudgetForecastCode(), orDefault);
        });
    }

    private void buildCommonCode(SubComActivityDesignDto dto, List<SubComActivityDesignDetailDto> itemCacheList, List<SubComActivityPlanItemFeeDto> subPlanItemFeeList) {
        long count = itemCacheList.stream().filter(itemCache -> StringUtils.isEmpty((CharSequence)itemCache.getActivityDesignDetailCode())).count();
        String tenantCode = TenantUtils.getTenantCode();
        itemCacheList.forEach(itemCache -> {
            String activityDesignDetailCode = itemCache.getActivityDesignDetailCode();
            itemCache.setActivityDesignCode(dto.getActivityDesignCode());
            itemCache.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            itemCache.setTenantCode(tenantCode);
            itemCache.setActivityDetailStatus(ActivityStatusEnum.CREATE_AND_BUDGET.getCode());
            if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)itemCache.getFeeDetail())) {
                itemCache.getFeeDetail().setActivityDesignCode(dto.getActivityDesignCode());
                itemCache.getFeeDetail().setActivityDesignDetailCode(activityDesignDetailCode);
                itemCache.getFeeDetail().setTenantCode(tenantCode);
                itemCache.getFeeDetail().setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)itemCache.getPlanList())) {
                itemCache.getPlanList().forEach(plan -> {
                    plan.setActivityDesignCode(dto.getActivityDesignCode());
                    plan.setActivityDesignDetailCode(activityDesignDetailCode);
                    plan.setAssociationType(itemCache.getAssociationType());
                    plan.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    plan.setTenantCode(tenantCode);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)itemCache.getProductList())) {
                itemCache.getProductList().forEach(product -> {
                    product.setActivityDesignCode(dto.getActivityDesignCode());
                    product.setActivityDesignDetailCode(activityDesignDetailCode);
                    product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    product.setTenantCode(tenantCode);
                });
            }
            if (!CollectionUtils.isNotEmpty((Collection)itemCache.getBudgetList())) {
                throw new RuntimeException("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u65b0\u589e\u5f02\u5e38\uff0c\u6d3b\u52a8\u660e\u7ec6\u3010\u4fbf\u7b7e\u53f7" + itemCache.getActivityNumber() + "\u3011,\u672a\u5360\u7528\u5230\u9884\u7b97\uff01");
            }
            itemCache.getBudgetList().forEach(budget -> {
                budget.setActivityDesignCode(dto.getActivityDesignCode());
                budget.setActivityDesignDetailCode(activityDesignDetailCode);
                budget.setUndertakingMode(itemCache.getUndertakingMode());
                budget.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                budget.setTenantCode(tenantCode);
            });
            if (CollectionUtils.isNotEmpty((Collection)itemCache.getForecastList())) {
                itemCache.getForecastList().forEach(forecast -> {
                    forecast.setActivityDesignCode(dto.getActivityDesignCode());
                    forecast.setActivityDesignDetailCode(activityDesignDetailCode);
                    forecast.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    forecast.setTenantCode(tenantCode);
                });
            }
        });
        dto.setDetailList(itemCacheList);
        if (!CollectionUtils.isEmpty(subPlanItemFeeList)) {
            subPlanItemFeeList.forEach(planItemFee -> {
                planItemFee.setActivityDesignCode(dto.getActivityDesignCode());
                planItemFee.setActivityDesignName(dto.getActivityDesignName());
            });
        }
    }

    public Page<SubComActivityDesignPlanVo> findCanRelationPlanListPage(Pageable pageable, final SubComActivityDesignPlanDto dto) {
        ActivityPlanItemDto activityPlanDto;
        Page planPage;
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (ActivityPlanRelationTypeEnum.up.getCode().equals(dto.getAssociationType())) {
            List<String> relatedUpCustomerCode;
            ActivityDetailPlanItemDto searchDto = new ActivityDetailPlanItemDto(){
                {
                    this.setDetailPlanCode(dto.getPlanCode());
                    this.setDetailPlanName(dto.getPlanName());
                    this.setDetailPlanItemCode(dto.getPlanDetailCode());
                    this.setActivityBeginDateStr(dto.getActivityBeginDate());
                    this.setActivityEndDateStr(dto.getActivityEndDate());
                    this.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    this.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    this.setTenantCode(TenantUtils.getTenantCode());
                    this.setIsClose(BooleanEnum.FALSE.getCapital());
                }
            };
            if (!StringUtils.isBlank((CharSequence)dto.getSalesInstitutionCode()) && !CollectionUtils.isEmpty(relatedUpCustomerCode = this.findRelatedUpCustomerCode(dto.getSalesInstitutionCode()))) {
                searchDto.setCustomerCodes(relatedUpCustomerCode);
                searchDto.setCustomerCode(null);
                searchDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                searchDto.setIsClose(BooleanEnum.FALSE.getCapital());
            }
            Page detailPlanPage = this.activityDetailPlanItemSdkService.findByConditions(pageable, searchDto);
            page.setTotal(detailPlanPage.getTotal());
            if (CollectionUtils.isNotEmpty((Collection)detailPlanPage.getRecords())) {
                List list = detailPlanPage.getRecords().stream().map(item -> new SubComActivityDesignPlanVo((ActivityDetailPlanItemVo)item){
                    final /* synthetic */ ActivityDetailPlanItemVo val$item;
                    {
                        this.val$item = activityDetailPlanItemVo;
                        this.setPlanCode(this.val$item.getDetailPlanCode());
                        this.setPlanName(this.val$item.getDetailPlanName());
                        this.setPlanDetailCode(this.val$item.getDetailPlanItemCode());
                    }
                }).collect(Collectors.toList());
                page.setRecords(list);
            }
        } else if (ActivityPlanRelationTypeEnum.region.getCode().equals(dto.getAssociationType()) && CollectionUtils.isNotEmpty((Collection)(planPage = this.activityPlanItemSdkService.findByConditions(pageable, activityPlanDto = new ActivityPlanItemDto(){
            {
                this.setPlanCode(dto.getPlanCode());
                this.setPlanName(dto.getPlanName());
                this.setPlanItemCode(dto.getPlanDetailCode());
                this.setActivityBeginDateStr(dto.getActivityBeginDate());
                this.setActivityEndDateStr(dto.getActivityEndDate());
            }
        })).getRecords())) {
            List list = planPage.getRecords().stream().map(item -> new SubComActivityDesignPlanVo((ActivityPlanItemVo)item){
                final /* synthetic */ ActivityPlanItemVo val$item;
                {
                    this.val$item = activityPlanItemVo;
                    this.setPlanCode(this.val$item.getPlanCode());
                    this.setPlanName(this.val$item.getPlanName());
                    this.setPlanDetailCode(this.val$item.getPlanItemCode());
                }
            }).collect(Collectors.toList());
            page.setRecords(list);
        }
        return page;
    }

    private List<String> findRelatedUpCustomerCode(String orgCode) {
        Validate.notBlank((CharSequence)orgCode, (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList<String> list = new ArrayList<String>();
        list.add(orgCode);
        Map erpSaleOrgCodeMap = this.salesOrgVoService.findSapCodesBySalesOrgCodes(list);
        if (Objects.isNull(erpSaleOrgCodeMap)) {
            return Lists.newArrayList();
        }
        String erpCode = (String)erpSaleOrgCodeMap.get(orgCode);
        List subComOrgVos = this.salesOrgSubComOrgService.findBySaleOrgErpCode(erpCode);
        if (CollectionUtils.isEmpty((Collection)subComOrgVos)) {
            return Lists.newArrayList();
        }
        List customerMdgCodes = subComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerMdgCodes)) {
            return Lists.newArrayList();
        }
        List customerList = this.customerVoService.findByCustomerMdgCodes(customerMdgCodes);
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            return Lists.newArrayList();
        }
        List<String> customerCodes = customerList.stream().map(CustomerVo::getCustomerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return customerCodes;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u6570\u636e\uff01");
        }
        List<SubComActivityDesignEntity> subComActivityDesignEntityList = this.subComActivityDesignRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(subComActivityDesignEntityList)) {
            return;
        }
        FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String account = loginUserDetails.getAccount();
        String name = loginUserDetails.getUsername();
        List passList = subComActivityDesignEntityList.stream().filter(x -> ProcessStatusEnum.PASS.getDictCode().equals(x.getProcessStatus()) || ProcessStatusEnum.COMMIT.getDictCode().equals(x.getProcessStatus())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(passList), (String)"\u5ba1\u6279\u901a\u8fc7\u3001\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\uff01\uff01\uff01", (Object[])new Object[0]);
        List<String> activityDesignCodeList = subComActivityDesignEntityList.stream().map(SubComActivityDesignEntity::getActivityDesignCode).collect(Collectors.toList());
        subComActivityDesignEntityList.forEach(subComActivityDesignEntity -> {
            subComActivityDesignEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            if (!StringUtils.isBlank((CharSequence)account)) {
                Validate.isTrue((boolean)account.equals(subComActivityDesignEntity.getCreateAccount()), (String)("\u53ea\u6709\u521b\u5efa\u4eba[" + name + "],\u624d\u53ef\u5220\u9664\u8be5\u89c4\u5212[" + subComActivityDesignEntity.getActivityDesignCode() + "]"), (Object[])new Object[0]);
            }
        });
        this.subComActivityDesignBudgetService.returnSubComBudgetForecastByCode(activityDesignCodeList);
        List<SubComActivityDesignBudgetEntity> designBudgetEntities = this.subComActivityDesignBudgetRepository.listByActivityDesignCodeList(activityDesignCodeList);
        this.subComActivityDesignRepository.updateBatchById(subComActivityDesignEntityList);
        this.subComActivityDesignFeeDetailRepository.deleteByActivityCodes(activityDesignCodeList);
        this.subComActivityDesignPlanRepository.deleteByActivityCodes(activityDesignCodeList);
        this.subComActivityDesignForecastRepository.deleteByActivityCodes(activityDesignCodeList);
        this.subComActivityDesignBudgetRepository.deleteByActivityCodes(activityDesignCodeList);
        this.subComActivityDesignDetailRepository.deleteByActivityCodes(activityDesignCodeList);
        this.subComActivityDesignProductRepository.deleteByActivityCodes(activityDesignCodeList);
    }

    public SubComActivityDesignVo summationAmount(SubComActivityDesignDto dto) {
        return this.subComActivityDesignRepository.summationAmount(dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(SubComActivityDesignApproveSubmitDto dto) {
        Set designCodes;
        List<SubComActivityDesignDetailEntity> detailEntities;
        boolean bl;
        List<SubComActivityDesignVo> designVoList = this.listByIdsOrProcessNoAndYearMonthFromDetail(dto.getIds());
        Validate.isTrue((!CollectionUtils.isEmpty(designVoList) ? 1 : 0) != 0, (String)"\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\uff01", (Object[])new Object[0]);
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        HashSet codeSet = new HashSet();
        designVoList.forEach(item -> {
            Assert.hasLength((String)item.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasLength((String)item.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasLength((String)item.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.notNull((Object)item.getFeeYearMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            codeSet.add(item.getBusinessFormatCode() + item.getBusinessUnitCode() + DateUtil.format((Date)item.getYearMonthLy(), (String)"yyyyMM") + item.getOrgCode() + yearMonthFormat.format(item.getFeeYearMonth()));
            Assert.isTrue((codeSet.size() == 1 ? 1 : 0) != 0, (String)"\u8bf7\u6ce8\u610f\u63d0\u4ea4\u7684\u6d3b\u52a8\uff1a\u4e1a\u6001\u3001\u4e1a\u52a1\u5355\u5143\u3001\u5e74\u6708\u3001\u7ec4\u7ec7\u7f16\u7801\u9700\u8981\u5b8c\u5168\u76f8\u540c\uff01");
        });
        Map<String, List<SubComActivityDesignVo>> designVoMap = designVoList.stream().collect(Collectors.groupingBy(k -> yearMonthFormat.format(k.getYearMonthLy()) + "&" + k.getOrgCode() + "&" + yearMonthFormat.format(k.getFeeYearMonth())));
        for (String string : designVoMap.keySet()) {
            SelectActivityPlanTableEventVo activityPlanTableEventVo;
            SelectActivityPlanTableEventDto selectActivityPlanTableEventDto = new SelectActivityPlanTableEventDto();
            String[] split = string.split("&");
            selectActivityPlanTableEventDto.setTableVersion(TableVersionEnum.PROCESS_COMMIT_VERSION.getCode());
            selectActivityPlanTableEventDto.setYearAndMonth(split[0]);
            selectActivityPlanTableEventDto.setOrgCode(split[1]);
            SerializableBiConsumer & Serializable selectTableEventDto = SelectActivityPlanTableEventListener::selectTableByYearMonthAndOrg;
            EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)selectActivityPlanTableEventDto, SelectActivityPlanTableEventListener.class, (SerializableBiConsumer)selectTableEventDto);
            if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)eventResponse) || (!StringUtils.isNotEmpty((CharSequence)(activityPlanTableEventVo = (SelectActivityPlanTableEventVo)eventResponse).getActivityPlanTableCode()) || !ProcessStatusEnum.PREPARE.getKey().equals(activityPlanTableEventVo.getProcessStatus())) && !ProcessStatusEnum.REJECT.getKey().equals(activityPlanTableEventVo.getProcessStatus()) && !ProcessStatusEnum.RECOVER.getKey().equals(activityPlanTableEventVo.getProcessStatus()) && !ProcessStatusEnum.COMMIT.getKey().equals(activityPlanTableEventVo.getProcessStatus())) continue;
            throw new RuntimeException("\u6d3b\u52a8\u89c4\u5212\u5957\u8868[" + activityPlanTableEventVo.getActivityPlanTableCode() + "]\u5904\u4e8e\u2018\u5f85\u63d0\u4ea4\u2019\u3001\u2018\u5ba1\u6279\u4e2d\u2019\u3001\u2018\u5ba1\u6279\u9a73\u56de\u2019\u3001\u2018\u6d41\u7a0b\u8ffd\u56de\u2019\u72b6\u6001\uff0c\u89c4\u5212\u4e0d\u53ef\u63d0\u4ea4!");
        }
        BigDecimal subComAutoAmountTotal = BigDecimal.ZERO;
        for (SubComActivityDesignVo subComActivityDesignVo : designVoList) {
            if (!(ProcessStatusEnum.PREPARE.getKey().equals(subComActivityDesignVo.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(subComActivityDesignVo.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(subComActivityDesignVo.getProcessStatus()))) {
                throw new RuntimeException("\u8bf7\u6ce8\u610f\u6d3b\u52a8[" + subComActivityDesignVo.getActivityDesignCode() + "]\u7684\u5ba1\u6279\u72b6\u6001\uff01");
            }
            subComAutoAmountTotal = subComAutoAmountTotal.add(Optional.ofNullable(subComActivityDesignVo.getSubComAutoAmountTotal()).orElse(BigDecimal.ZERO));
        }
        dto.setSubComAutoAmountTotal(subComAutoAmountTotal);
        boolean bl2 = false;
        for (String key : designVoMap.keySet()) {
            String[] split = key.split("&");
            String yearMonthLy = split[0];
            String orgCode = split[1];
            SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
            subComBudgetForecastDto.setYearMonthLy(yearMonthLy);
            subComBudgetForecastDto.setOrgCode(orgCode);
            subComBudgetForecastDto.setFeeSourceCode(com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.AUTO_FEE.getCode());
            List subComBudgetForecastVos = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)subComBudgetForecastVos)) {
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u9884\u7b97\u5269\u4f59\u91d1\u989d!");
            }
            SubComBudgetForecastVo subComBudgetForecastVo = (SubComBudgetForecastVo)subComBudgetForecastVos.get(0);
            dto.setRemainderAmount(subComBudgetForecastVo.getRemainderAmount());
            BigDecimal remAmount = Optional.ofNullable(dto.getRemainderAmount()).orElse(BigDecimal.ZERO);
            for (SubComActivityDesignVo detail : designVoMap.get(key)) {
                BigDecimal subAutoAmountTotal = Optional.ofNullable(detail.getSubComAutoAmountTotal()).orElse(BigDecimal.ZERO);
                if (subAutoAmountTotal.compareTo(BigDecimal.ZERO) <= 0 || remAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                bl = true;
            }
        }
        dto.setIsOverBudgetAndSpecial(BooleanEnum.FALSE.getCapital());
        if (bl) {
            dto.setIsOverBudgetAndSpecial(BooleanEnum.TRUE.getCapital());
        }
        List<String> list = designVoList.stream().map(SubComActivityDesignVo::getActivityDesignCode).collect(Collectors.toList());
        SubComActivityDesignApproveSubmitDto businessFormDto = this.subComActivityDesignDetailRepository.getProcessBusinessForm(list);
        dto.setIsUnderRedLinePrice(Optional.ofNullable(businessFormDto.getIsUnderRedLinePrice()).orElse(BooleanEnum.FALSE.getCapital()));
        ProcessBusinessVo processBusinessVo = this.commitProcess(dto);
        if (StringUtils.isNotBlank((CharSequence)processBusinessVo.getProcessNo()) && CollectionUtils.isNotEmpty(detailEntities = this.subComActivityDesignDetailRepository.listByActivityDesignCodeList(new ArrayList<String>(designCodes = designVoList.stream().map(SubComActivityDesignVo::getActivityDesignCode).collect(Collectors.toSet()))))) {
            Set deetailCodes = detailEntities.stream().map(SubComActivityDesignDetailEntity::getActivityDesignDetailCode).collect(Collectors.toSet());
            this.subComBudgetForecastDetailSdkService.writeBackProcessNo(processBusinessVo.getProcessNo(), new ArrayList(deetailCodes));
        }
    }

    private List<SubComActivityDesignVo> listByIdsOrProcessNoAndYearMonthFromDetail(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignEntity> list = this.subComActivityDesignRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            String processNo = ids.get(0);
            list = this.subComActivityDesignRepository.listByProcessNo(processNo);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        List designVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityDesignEntity.class, SubComActivityDesignVo.class, HashSet.class, ArrayList.class, new String[0]);
        designVoList.forEach(i -> {
            SubComActivityDesignDetailEntity detail = this.subComActivityDesignDetailRepository.getOneByCode(i.getActivityDesignCode());
            if (Objects.isNull((Object)detail)) {
                throw new IllegalArgumentException("\u89c4\u5212\u3010" + i.getActivityDesignName() + i.getActivityDesignCode() + "\u3011,\u660e\u7ec6\u7684\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e3a\u7a7a!");
            }
            i.setYearMonthLy(detail.getFeeYearMonth());
        });
        return designVoList;
    }

    private ProcessBusinessVo commitProcess(SubComActivityDesignApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNoList(dto.getIds());
        String businessNo = UUID.randomUUID().toString().replace("-", "");
        processBusiness.setBusinessNo(businessNo);
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("ACTIVITY_CONST_DESGIN_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        this.subComActivityDesignRepository.updateProcessStatusAndProcessNo(dto.getIds(), ProcessStatusEnum.COMMIT.getDictCode(), processBusinessVo.getProcessNo(), dto.getIsOverBudgetAndSpecial(), dto.getRemainderAmount());
        this.subComActivityDesignDetailRepository.updateBatchProcessStatus(processBusinessVo.getProcessNo(), ProcessStatusEnum.COMMIT.getDictCode());
        return processBusinessVo;
    }

    private void buildNoRelationAmount(SubComActivityDesignDto dto, List<SubComActivityDesignDetailDto> newList) {
        if (org.springframework.util.CollectionUtils.isEmpty(newList)) {
            return;
        }
        List<SubComActivityDesignDetailDto> nonList = newList.stream().filter(n -> RelationTypeEnum.NO_RELATION.getCode().equals(n.getAssociationType()) && UndertakingModeTypeEnum.NO_ACCEPT.getCode().equals(n.getUndertakingMode())).collect(Collectors.toList());
        if (org.springframework.util.CollectionUtils.isEmpty(nonList)) {
            return;
        }
        Set yearMonthSet = nonList.stream().map(i -> DateUtil.format((Date)i.getFeeYearMonth(), (String)"yyyy-MM")).collect(Collectors.toSet());
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setOrgCode(dto.getOrgCode());
        subComBudgetForecastDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComBudgetForecastDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        subComBudgetForecastDto.setYearMonthList(new ArrayList(yearMonthSet));
        List subComBudgetForecastVoList = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)subComBudgetForecastVoList)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u67e5\u8be2\u5931\u8d25\uff01");
        }
        Map<String, List<SubComBudgetForecastVo>> budgetForecastListMap = subComBudgetForecastVoList.stream().collect(Collectors.groupingBy(f -> f.getYearMonthLy() + f.getFeeSourceCode()));
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        nonList.forEach(detailDto -> {
            if (RelationTypeEnum.NO_RELATION.getCode().equals(detailDto.getAssociationType()) && UndertakingModeTypeEnum.NO_ACCEPT.getCode().equals(detailDto.getUndertakingMode())) {
                BigDecimal surAmount;
                BigDecimal surplusPartUndertakeAmt;
                BigDecimal surplusWholeUndertakeAmt;
                BigDecimal remainderAmount;
                SubComActivityDesignBudgetDto designBudgetDto;
                String autoKey;
                List autoForecastVos;
                String internalKey;
                List internalForecastVos;
                log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u65b0\u589e,\u4fbf\u7b7e\u53f7:{}\u4e0d\u5173\u8054\u4e0d\u627f\u63a5,\u5f00\u59cb\u5212\u5206\u8d39\u7528", (Object)detailDto.getActivityNumber());
                Validate.notNull((Object)detailDto.getFeeYearMonth(), (String)"\u660e\u7ec6\u7684\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                String feeYearMonth = sif.format(detailDto.getFeeYearMonth());
                String beginTime = sif.format(detailDto.getActivityBeginTime());
                Validate.isTrue((boolean)feeYearMonth.equals(beginTime), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u548c\u8d39\u7528\u5e74\u6708\u3001\u4f7f\u7528\u9884\u7b97\u7684\u5e74\u6708\u5c5e\u4e8e\u540c\u4e00\u6708\uff01", (Object[])new Object[0]);
                SubComBudgetForecastVo offPointForecast = null;
                SubComBudgetForecastVo internalForecast = null;
                SubComBudgetForecastVo autoForecast = null;
                String offPointKey = feeYearMonth + FeeSourceEnum.OFF_POINT_FEE.getCode();
                List offPointForecastVos = (List)budgetForecastListMap.get(offPointKey);
                if (CollectionUtils.isNotEmpty((Collection)offPointForecastVos)) {
                    offPointForecast = offPointForecastVos.stream().filter(f -> detailDto.getBudgetItemCode().equals(f.getBudgetItemCode())).findFirst().orElse(null);
                }
                if (CollectionUtils.isNotEmpty((Collection)(internalForecastVos = (List)budgetForecastListMap.get(internalKey = feeYearMonth + FeeSourceEnum.INTERNAL_POINT_FEE.getCode())))) {
                    internalForecast = internalForecastVos.stream().filter(f -> detailDto.getBudgetItemCode().equals(f.getBudgetItemCode())).findFirst().orElse(null);
                }
                if (CollectionUtils.isNotEmpty((Collection)(autoForecastVos = (List)budgetForecastListMap.get(autoKey = feeYearMonth + FeeSourceEnum.AUTO_FEE.getCode())))) {
                    if (ObjectUtils.isEmpty((Object)offPointForecast) && ObjectUtils.isEmpty((Object)internalForecast)) {
                        autoForecast = autoForecastVos.stream().filter(f -> detailDto.getBudgetItemCode().equals(f.getBudgetItemCode()) && FeeSourceEnum.AUTO_FEE.getCode().equals(f.getFeeSourceCode())).findFirst().orElse(null);
                    } else if (CollectionUtils.isNotEmpty((Collection)autoForecastVos)) {
                        autoForecast = autoForecastVos.stream().filter(f -> FeeSourceEnum.AUTO_FEE.getCode().equals(f.getFeeSourceCode())).findFirst().orElse(null);
                    }
                }
                if (!ObjectUtils.isEmpty((Object)offPointForecast)) {
                    log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u65b0\u589e,\u4fbf\u7b7e\u53f7:{},\u70b9\u5916\u7f16\u7801:{},\u70b9\u5916\u9884\u7b97\u9879\u76ee:{}", (Object)offPointForecast.getBudgetForecastCode(), (Object)offPointForecast.getBudgetItemCode());
                    detailDto.setBudgetItemName(offPointForecast.getBudgetItemName());
                } else if (!ObjectUtils.isEmpty((Object)internalForecast)) {
                    log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u65b0\u589e,\u4fbf\u7b7e\u53f7:{},\u70b9\u5185\u7f16\u7801:{},\u70b9\u5185\u9884\u7b97\u9879\u76ee:{}", (Object)internalForecast.getBudgetForecastCode(), (Object)internalForecast.getBudgetItemCode());
                    detailDto.setBudgetItemName(internalForecast.getBudgetItemName());
                } else if (!ObjectUtils.isEmpty(autoForecast)) {
                    log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u65b0\u589e,\u4fbf\u7b7e\u53f7:{},\u81ea\u6295\u7f16\u7801:{},\u81ea\u6295\u9884\u7b97\u9879\u76ee:{}", (Object)autoForecast.getBudgetForecastCode(), (Object)autoForecast.getBudgetItemCode());
                    detailDto.setBudgetItemName(autoForecast.getBudgetItemName());
                } else {
                    throw new IllegalArgumentException("\u6839\u636e[\u5e74\u6708/\u4e1a\u6001/\u4e1a\u52a1\u5355\u5143/\u7ec4\u7ec7\u7f16\u7801/\u9884\u7b97\u9879\u76ee\u7f16\u7801'" + detailDto.getBudgetItemCode() + "']\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5206\u5b50\u9884\u7b97\u9884\u6d4b");
                }
                ArrayList<SubComActivityDesignBudgetDto> designForecastDtoList = new ArrayList<SubComActivityDesignBudgetDto>();
                SubComActivityDesignFeeDetailDto feeDetail = new SubComActivityDesignFeeDetailDto();
                feeDetail.setAssociationType(detailDto.getAssociationType());
                feeDetail.setThisUseAmount(detailDto.getTotalCost());
                AtomicReference<BigDecimal> totalCostAmount = new AtomicReference<BigDecimal>(detailDto.getTotalCost());
                if (!ObjectUtils.isEmpty((Object)offPointForecast)) {
                    designBudgetDto = new SubComActivityDesignBudgetDto();
                    designBudgetDto.setBudgetForecastCode(offPointForecast.getBudgetForecastCode());
                    remainderAmount = Optional.ofNullable(offPointForecast.getRemainderAmount()).orElse(BigDecimal.ZERO);
                    surplusWholeUndertakeAmt = Optional.ofNullable(offPointForecast.getSurplusWholeUndertakeAmt()).orElse(BigDecimal.ZERO);
                    surplusPartUndertakeAmt = Optional.ofNullable(offPointForecast.getSurplusPartUndertakeAmt()).orElse(BigDecimal.ZERO);
                    surAmount = remainderAmount.subtract(surplusWholeUndertakeAmt).subtract(surplusPartUndertakeAmt);
                    if (totalCostAmount.get().compareTo(surAmount) >= 0) {
                        totalCostAmount.set(totalCostAmount.get().subtract(surAmount));
                        offPointForecast.setDesignAmount(Optional.ofNullable(offPointForecast.getDesignAmount()).orElse(BigDecimal.ZERO).add(surAmount));
                        offPointForecast.setRemainderAmount(remainderAmount.subtract(surAmount));
                        designBudgetDto.setBudgetAmount(surAmount);
                        designBudgetDto.setIsAllDown(BooleanEnum.TRUE.getCapital());
                        feeDetail.setOffAmount(surAmount);
                    } else {
                        offPointForecast.setDesignAmount(Optional.ofNullable(offPointForecast.getDesignAmount()).orElse(BigDecimal.ZERO).add(totalCostAmount.get()));
                        offPointForecast.setRemainderAmount(remainderAmount.subtract(totalCostAmount.get()));
                        designBudgetDto.setBudgetAmount(totalCostAmount.get());
                        designBudgetDto.setIsAllDown(BooleanEnum.FALSE.getCapital());
                        feeDetail.setOffAmount(totalCostAmount.get());
                        totalCostAmount.set(BigDecimal.ZERO);
                    }
                    designBudgetDto.setBusinessFormatCode(offPointForecast.getBusinessFormatCode());
                    designBudgetDto.setYearMonthLy(offPointForecast.getYearMonthLy());
                    designBudgetDto.setBudgetItemCode(offPointForecast.getBudgetItemCode());
                    designBudgetDto.setBudgetItemName(offPointForecast.getBudgetItemName());
                    designBudgetDto.setFeeSourceCode(offPointForecast.getFeeSourceCode());
                    designForecastDtoList.add(designBudgetDto);
                }
                if (totalCostAmount.get().compareTo(BigDecimal.ZERO) >= 0 && !ObjectUtils.isEmpty((Object)internalForecast)) {
                    designBudgetDto = new SubComActivityDesignBudgetDto();
                    designBudgetDto.setBudgetForecastCode(internalForecast.getBudgetForecastCode());
                    remainderAmount = Optional.ofNullable(internalForecast.getRemainderAmount()).orElse(BigDecimal.ZERO);
                    surplusWholeUndertakeAmt = Optional.ofNullable(internalForecast.getSurplusWholeUndertakeAmt()).orElse(BigDecimal.ZERO);
                    surplusPartUndertakeAmt = Optional.ofNullable(internalForecast.getSurplusPartUndertakeAmt()).orElse(BigDecimal.ZERO);
                    surAmount = remainderAmount.subtract(surplusWholeUndertakeAmt).subtract(surplusPartUndertakeAmt);
                    if (totalCostAmount.get().compareTo(surAmount) >= 0) {
                        totalCostAmount.set(totalCostAmount.get().subtract(surAmount));
                        internalForecast.setDesignAmount(Optional.ofNullable(internalForecast.getDesignAmount()).orElse(BigDecimal.ZERO).add(surAmount));
                        internalForecast.setRemainderAmount(remainderAmount.subtract(surAmount));
                        designBudgetDto.setBudgetAmount(surAmount);
                        designBudgetDto.setIsAllDown(BooleanEnum.TRUE.getCapital());
                        feeDetail.setInternalAmount(surAmount);
                    } else {
                        internalForecast.setDesignAmount(Optional.ofNullable(internalForecast.getDesignAmount()).orElse(BigDecimal.ZERO).add(totalCostAmount.get()));
                        internalForecast.setRemainderAmount(remainderAmount.subtract(totalCostAmount.get()));
                        designBudgetDto.setBudgetAmount(totalCostAmount.get());
                        designBudgetDto.setIsAllDown(BooleanEnum.FALSE.getCapital());
                        feeDetail.setInternalAmount(totalCostAmount.get());
                        totalCostAmount.set(BigDecimal.ZERO);
                    }
                    designBudgetDto.setBusinessFormatCode(internalForecast.getBusinessFormatCode());
                    designBudgetDto.setYearMonthLy(internalForecast.getYearMonthLy());
                    designBudgetDto.setBudgetItemCode(internalForecast.getBudgetItemCode());
                    designBudgetDto.setBudgetItemName(internalForecast.getBudgetItemName());
                    designBudgetDto.setFeeSourceCode(internalForecast.getFeeSourceCode());
                    designForecastDtoList.add(designBudgetDto);
                }
                if (totalCostAmount.get().compareTo(BigDecimal.ZERO) >= 0 && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)autoForecast)) {
                    designBudgetDto = new SubComActivityDesignBudgetDto();
                    designBudgetDto.setBudgetForecastCode(autoForecast.getBudgetForecastCode());
                    remainderAmount = Optional.ofNullable(autoForecast.getRemainderAmount()).orElse(BigDecimal.ZERO);
                    log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\uff0c\u4e0d\u5173\u8054\u4e0d\u627f\u63a5\uff0c\u9884\u7b97\u9884\u6d4b\u81ea\u6295\u9884\u7b97\u9879\u76ee\u7f16\u7801:{}", (Object)autoForecast.getBudgetItemCode());
                    if (totalCostAmount.get().compareTo(remainderAmount) > 0 && !"A023".equals(autoForecast.getBudgetItemCode())) {
                        throw new IllegalArgumentException("\u9884\u7b97\u9879\u76ee[" + detailDto.getBudgetItemCode() + "]\uff0c\u8d39\u7528\u4e0d\u8db3\uff01");
                    }
                    autoForecast.setDesignAmount(Optional.ofNullable(autoForecast.getDesignAmount()).orElse(BigDecimal.ZERO).add(totalCostAmount.get()));
                    autoForecast.setRemainderAmount(remainderAmount.subtract(totalCostAmount.get()));
                    designBudgetDto.setBudgetAmount(totalCostAmount.get());
                    designBudgetDto.setIsAllDown(BooleanEnum.FALSE.getCapital());
                    feeDetail.setAutoAmount(totalCostAmount.get());
                    totalCostAmount.set(BigDecimal.ZERO);
                    designBudgetDto.setBusinessFormatCode(autoForecast.getBusinessFormatCode());
                    designBudgetDto.setYearMonthLy(autoForecast.getYearMonthLy());
                    designBudgetDto.setBudgetItemCode(autoForecast.getBudgetItemCode());
                    designBudgetDto.setBudgetItemName(autoForecast.getBudgetItemName());
                    designBudgetDto.setFeeSourceCode(autoForecast.getFeeSourceCode());
                    designForecastDtoList.add(designBudgetDto);
                } else if (totalCostAmount.get().compareTo(BigDecimal.ZERO) > 0) {
                    throw new IllegalArgumentException("\u672a\u627e\u5230\u5e74\u6708[" + feeYearMonth + "]\u4e1a\u6001[" + dto.getBusinessFormatCode() + "]\u4e1a\u52a1\u5355\u5143[" + dto.getBusinessUnitCode() + "]\u7ec4\u7ec7\u7f16\u7801[" + dto.getOrgCode() + "]\u7ef4\u5ea6\uff0c\u8d39\u7528\u6765\u6e90\u4e3a\u2019\u81ea\u6295\u8d39\u7528\u2018\u7684\u5206\u5b50\u9884\u7b97\u9884\u6d4b");
                }
                detailDto.setFeeDetail(feeDetail);
                detailDto.setBudgetList(designForecastDtoList);
            }
        });
    }

    public String createActivityPlanSonCompany(SubComActivityDesignDto designDto) {
        List itemCacheList = designDto.getDetailList();
        Set activityFormCodeList = itemCacheList.stream().map(SubComActivityDesignDetailDto::getActivityFormCode).collect(Collectors.toSet());
        Map<Object, Object> activityFormVoMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(activityFormCodeList)) {
            List activityFormByCode = this.activityFormService.findActivityFormByCode(activityFormCodeList);
            activityFormVoMap = activityFormByCode.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
            List templateConfigCodeList = activityFormByCode.stream().map(ActivityFormVo::getThinProjectTemplate).distinct().collect(Collectors.toList());
            designDto.setTemplateConfigCode(String.join((CharSequence)",", templateConfigCodeList));
        }
        for (SubComActivityDesignDetailDto itemDto : itemCacheList) {
            ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(itemDto.getActivityFormCode());
            if (null == activityFormVo) continue;
            itemDto.setTemplateConfigCode(activityFormVo.getThinProjectTemplate());
        }
        this.subComActivityDesignDetailService.generatePromotionNo(itemCacheList);
        this.buildNoRelationAmount(designDto, itemCacheList);
        List<SubComActivityPlanItemFeeDto> subPlanItemFeeList = this.buildRelationSubPlanBudgetAmount(designDto, itemCacheList);
        this.divideExpenses(designDto, itemCacheList);
        this.sumAmount(designDto, itemCacheList);
        String activityDesignCode = this.saveSubComActivityDesignAndDetail(designDto, itemCacheList, subPlanItemFeeList);
        return activityDesignCode;
    }

    public Page<SubComActivityDesignBudgetVo> findUseBudgetDetailByDesignCode(Pageable pageable, String activityDesignCode) {
        if (StringUtils.isBlank((CharSequence)activityDesignCode)) {
            return null;
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComActivityDesignBudgetRepository.findByActivityDesignCode((Page<SubComActivityDesignPlanVo>)page, activityDesignCode);
    }

    public List<SubComActivityDesignVo> findByDesignCodes(List<String> designCodes) {
        if (CollectionUtils.isEmpty(designCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignEntity> list = this.subComActivityDesignRepository.findByDesignCodes(designCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityDesignEntity.class, SubComActivityDesignVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Page<SubComActivityDesignBudgetVo> findBudgetByProcessNoConditionsCreate(Pageable pageable, SubComActivityDesignBudgetDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Validate.notBlank((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SubComActivityDesignBudgetVo> resultPage = this.subComActivityDesignBudgetRepository.findBudgetByProcessNoConditionsCreate((Page<SubComActivityDesignBudgetVo>)page, dto);
        if (Objects.isNull(resultPage) || CollectionUtils.isEmpty((Collection)resultPage.getRecords())) {
            return resultPage;
        }
        List forecastCodes = resultPage.getRecords().stream().map(SubComActivityDesignBudgetVo::getBudgetForecastCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List budgetForecastVoList = this.subComBudgetForecastService.findListByCodes(forecastCodes);
        if (CollectionUtils.isEmpty((Collection)budgetForecastVoList)) {
            return resultPage;
        }
        Map budgetForecastVoMap = budgetForecastVoList.stream().collect(Collectors.toMap(SubComBudgetForecastVo::getBudgetForecastCode, Function.identity()));
        resultPage.getRecords().forEach(x -> {
            SubComBudgetForecastVo forecastVo = (SubComBudgetForecastVo)budgetForecastVoMap.get(x.getBudgetForecastCode());
            if (!Objects.isNull(forecastVo)) {
                x.setFirstBudgetAmount(forecastVo.getFirstBudgetAmount());
                x.setRemainderAmount(forecastVo.getRemainderAmount());
                x.setUsedAmount(forecastVo.getUsedAmount());
            }
        });
        return resultPage;
    }

    public SummationAmountForSubmitApprovaVo summationAmountForSubmitApproval(SummationAmountForSubmitApprovalDto dto) {
        SummationAmountForSubmitApprovaVo vo = new SummationAmountForSubmitApprovaVo();
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getIds())) {
            return vo;
        }
        String flag = Optional.ofNullable(dto.getSubmitOrBpm()).orElse(BooleanEnum.TRUE.getCapital());
        List<SubComActivityDesignVo> designVoList = this.listByIdsOrProcessNoAndYearMonthFromDetail(dto.getIds());
        Validate.isTrue((!CollectionUtils.isEmpty(designVoList) ? 1 : 0) != 0, (String)"\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\uff01", (Object[])new Object[0]);
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        Map<String, List<SubComActivityDesignVo>> designVoMap = designVoList.stream().collect(Collectors.groupingBy(k -> yearMonthFormat.format(k.getYearMonthLy()) + "&" + k.getOrgCode() + "&" + yearMonthFormat.format(k.getFeeYearMonth())));
        Validate.isTrue((designVoMap.keySet().size() == 1 ? 1 : 0) != 0, (String)"\u8bf7\u6ce8\u610f\u63d0\u4ea4\u7684\u6d3b\u52a8\uff1a\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u3001\u7ec4\u7ec7\u7f16\u7801\u3001\u5e74\u6708\u9700\u8981\u5b8c\u5168\u76f8\u540c\uff01", (Object[])new Object[0]);
        for (String yearmonthAndOrg : designVoMap.keySet()) {
            SelectActivityPlanTableEventVo activityPlanTableEventVo;
            SelectActivityPlanTableEventDto selectTableDto = new SelectActivityPlanTableEventDto();
            String[] split = yearmonthAndOrg.split("&");
            selectTableDto.setTableVersion(TableVersionEnum.PROCESS_COMMIT_VERSION.getCode());
            selectTableDto.setYearAndMonth(split[0]);
            selectTableDto.setOrgCode(split[1]);
            SerializableBiConsumer & Serializable selectTableEventDto = SelectActivityPlanTableEventListener::selectTableByYearMonthAndOrg;
            EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)selectTableDto, SelectActivityPlanTableEventListener.class, (SerializableBiConsumer)selectTableEventDto);
            if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)eventResponse) || (!StringUtils.isNotEmpty((CharSequence)(activityPlanTableEventVo = (SelectActivityPlanTableEventVo)eventResponse).getActivityPlanTableCode()) || !ProcessStatusEnum.PREPARE.getKey().equals(activityPlanTableEventVo.getProcessStatus())) && !ProcessStatusEnum.REJECT.getKey().equals(activityPlanTableEventVo.getProcessStatus()) && !ProcessStatusEnum.RECOVER.getKey().equals(activityPlanTableEventVo.getProcessStatus()) && !ProcessStatusEnum.COMMIT.getKey().equals(activityPlanTableEventVo.getProcessStatus())) continue;
            throw new RuntimeException("\u6d3b\u52a8\u89c4\u5212\u5957\u8868[" + activityPlanTableEventVo.getActivityPlanTableCode() + "]\u5904\u4e8e\u2018\u5f85\u63d0\u4ea4\u2019\u3001\u2018\u5ba1\u6279\u4e2d\u2019\u3001\u2018\u5ba1\u6279\u9a73\u56de\u2019\u3001\u2018\u6d41\u7a0b\u8ffd\u56de\u2019\u72b6\u6001\uff0c\u89c4\u5212\u4e0d\u53ef\u63d0\u4ea4!");
        }
        BigDecimal subComAutoAmountTotal = BigDecimal.ZERO;
        SubComActivityDesignVo one = designVoList.get(0);
        String validateString = one.getBusinessFormatCode() + one.getBusinessUnitCode() + DateUtil.format((Date)one.getFeeYearMonth(), (String)"yyyyMM") + one.getOrgCode() + DateUtil.format((Date)one.getYearMonthLy(), (String)"yyyyMM");
        for (SubComActivityDesignVo entity : designVoList) {
            if (BooleanEnum.TRUE.getCapital().equals(flag)) {
                if (!(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()))) {
                    throw new RuntimeException("\u8bf7\u6ce8\u610f\u6d3b\u52a8[" + entity.getActivityDesignCode() + "]\u7684\u5ba1\u6279\u72b6\u6001\uff01");
                }
                String vaString = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + DateUtil.format((Date)entity.getFeeYearMonth(), (String)"yyyyMM") + entity.getOrgCode() + DateUtil.format((Date)one.getYearMonthLy(), (String)"yyyyMM");
                if (StringUtil.isBlank((CharSequence)validateString) || !validateString.equals(vaString)) {
                    throw new RuntimeException("\u8bf7\u6ce8\u610f\u63d0\u4ea4\u7684\u6d3b\u52a8\uff1a\u4e1a\u6001\u3001\u4e1a\u52a1\u5355\u5143\u3001\u5e74\u6708\u3001\u7ec4\u7ec7\u7f16\u7801\u3001\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u9700\u8981\u5b8c\u5168\u76f8\u540c\uff01");
                }
            }
            subComAutoAmountTotal = subComAutoAmountTotal.add(Optional.ofNullable(entity.getSubComAutoAmountTotal()).orElse(BigDecimal.ZERO));
        }
        vo.setSubComAutoAmountTotal(subComAutoAmountTotal);
        boolean isOverBudgetAndSpecial = false;
        for (String key : designVoMap.keySet()) {
            String[] split = key.split("&");
            String yearMonthLy = split[0];
            String orgCode = split[1];
            SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
            subComBudgetForecastDto.setYearMonthLy(yearMonthLy);
            subComBudgetForecastDto.setOrgCode(orgCode);
            subComBudgetForecastDto.setFeeSourceCode(com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.AUTO_FEE.getCode());
            List subComBudgetForecastVos = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)subComBudgetForecastVos)) {
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u9884\u7b97\u5269\u4f59\u91d1\u989d!");
            }
            SubComBudgetForecastVo subComBudgetForecastVo = (SubComBudgetForecastVo)subComBudgetForecastVos.get(0);
            vo.setRemainderAmount(subComBudgetForecastVo.getRemainderAmount());
            BigDecimal remAmount = Optional.ofNullable(vo.getRemainderAmount()).orElse(BigDecimal.ZERO);
            for (SubComActivityDesignVo detail : designVoMap.get(key)) {
                BigDecimal subAutoAmountTotal = Optional.ofNullable(detail.getSubComAutoAmountTotal()).orElse(BigDecimal.ZERO);
                if (subAutoAmountTotal.compareTo(BigDecimal.ZERO) <= 0 || remAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                isOverBudgetAndSpecial = true;
            }
        }
        if (!BooleanEnum.TRUE.getCapital().equals(flag)) {
            vo.setIsOverBudgetAndSpecial(one.getIsOverBudgetAndSpecial());
            vo.setRemainderAmount(one.getBpmRemainderAmount());
        } else {
            vo.setIsOverBudgetAndSpecial(BooleanEnum.FALSE.getCapital());
            if (isOverBudgetAndSpecial) {
                vo.setIsOverBudgetAndSpecial(BooleanEnum.TRUE.getCapital());
            }
        }
        return vo;
    }
}

