/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.PushSubActivityDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.PrePaySubComActivityDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.PrePaySubComActivityVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848"})
@RestController
@RequestMapping(value={"/v1/subComActivityDetailPlan/subComActivityDetailPlan"})
public class SubComActivityDetailPlanController {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanController.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService activityConstituentDetailPlanVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private PushSubActivityDetailService pushSubActivityDetailService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<SubComActivityDetailPlanVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, SubComActivityDetailPlanDto paginationDto) {
        try {
            Page result = this.activityConstituentDetailPlanVoService.findByConditions(pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u9884\u4ed8\u83b7\u53d6\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u660e\u7ec6(\u5206\u9875)")
    @GetMapping(value={"/findSubComActivityDetailPage"})
    public Result<Page<PrePaySubComActivityVo>> findSubComActivityDetailPage(@PageableDefault(value=50) Pageable pageable, PrePaySubComActivityDto paginationDto) {
        try {
            Page result = this.activityConstituentDetailPlanVoService.findSubComActivityDetailPage(pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8425\u9500\u7b56\u7565\u5360\u7528\u6708\u5ea6\u9884\u7b97\u91d1\u989d")
    @PostMapping(value={"findAllDetailPlanAndItemByPlanCode"})
    public Result<List<SubComActivityDetailPlanVo>> findAllDetailPlanAndItemByPlanCode(@RequestBody List<String> CodeList) {
        try {
            List voList = this.activityConstituentDetailPlanVoService.findAllDetailPlanAndItemByPlanCode(CodeList);
            return Result.ok((Object)voList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<SubComActivityDetailPlanVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            SubComActivityDetailPlanVo activityConstituentDetailPlanVo = this.activityConstituentDetailPlanVoService.findDetailById(id);
            return Result.ok((Object)activityConstituentDetailPlanVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result create(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @RequestBody SubComActivityDetailPlanDto dto) {
        try {
            this.activityConstituentDetailPlanVoService.create(cacheKey, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<?> update(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @RequestBody SubComActivityDetailPlanDto activityConstituentDetailPlanVo) {
        try {
            this.activityConstituentDetailPlanVoService.update(cacheKey, activityConstituentDetailPlanVo);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.activityConstituentDetailPlanVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.activityConstituentDetailPlanVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"/submit"})
    public Result submit(@RequestBody SubComActivityDetailPlanDto dto) {
        boolean lockSuccess = false;
        try {
            Assert.notNull((Object)dto, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            Assert.hasLength((String)dto.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            lockSuccess = this.redisLockService.tryLock("sub_com_activity_detail_plan:lock:approve:" + dto.getId(), TimeUnit.MINUTES, 5L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.activityConstituentDetailPlanVoService.submit(dto);
            Result result = Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("sub_com_activity_detail_plan:lock:approve:" + dto.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result submitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b\uff0c\u6309\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\u3001\u5f52\u5c5e\u90e8\u95e8\u3001\u7b56\u7565\u7c7b\u578b\u3001\u7b56\u7565\u5e74\u5ea6\u63d0\u4ea4") @RequestBody SubComActivityDetailPlanApproveSubmitDto dto) {
        List idList = null;
        boolean lockSuccess = false;
        try {
            Assert.notNull((Object)dto, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            idList = dto.getIds();
            Assert.notEmpty((Collection)idList, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            lockSuccess = this.redisLockService.batchLock("sub_com_activity_detail_plan:lock:approve:", idList, TimeUnit.MINUTES, 5);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.activityConstituentDetailPlanVoService.submitApproval(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (CollectionUtil.isNotEmpty((Collection)idList) && lockSuccess) {
                this.redisLockService.batchUnLock("sub_com_activity_detail_plan:lock:approve:", idList);
            }
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.activityConstituentDetailPlanVoService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u5173\u95ed")
    @PatchMapping(value={"/close"})
    public Result close(@RequestBody List<SubComActivityDetailPlanItemDto> list) {
        try {
            Map msgMap = this.activityConstituentDetailPlanVoService.closeBatch(list);
            if (CollectionUtil.isEmpty((Map)msgMap)) {
                return Result.ok((String)"\u5173\u95ed\u6210\u529f!");
            }
            StringBuffer errorMsg = new StringBuffer();
            msgMap.forEach((key, msg) -> {
                errorMsg.append("\u7ec6\u6848\u7f16\u7801[");
                errorMsg.append((String)key);
                errorMsg.append("]\u5173\u95ed\u5931\u8d25:");
                errorMsg.append((String)msg);
                errorMsg.append(" | ");
            });
            return Result.error((String)errorMsg.toString());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u53ef\u4ee5\u5173\u8054\u7684\u65b9\u6848\u3001\u7ec6\u6848")
    @GetMapping(value={"findCanRelationPlanListPage"})
    public Result<Page<SubComActivityDetailPlanPlanVo>> findCanRelationPlanListPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u67e5\u8be2\u53c2\u6570") SubComActivityDetailPlanPlanDto dto) {
        try {
            Validate.notBlank((CharSequence)dto.getAssociationType(), (String)"\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Page page = this.activityConstituentDetailPlanVoService.findCanRelationPlanListPage(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u6267\u884c\u63a8\u9001")
    @PostMapping(value={"passPushMq"})
    public Result passPushMq(String businessNo) {
        try {
            this.pushSubActivityDetailService.passPushMq(Collections.singletonList(businessNo));
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

