/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.ie.sdk.process.MnExportProcess;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.DetailedAccountOfActivityVo;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DetailedAccountOfActivityExportsProcess
extends MnExportProcess {
    private static final Logger log = LoggerFactory.getLogger(DetailedAccountOfActivityExportsProcess.class);
    @Autowired(required=false)
    private ColumnConfigVoService columnConfigVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    protected static final ThreadLocal<List<ColumnConfigVo>> templateConfigVoThreadLocal = new ThreadLocal();

    protected void convertDictData(Collection<DetailedAccountOfActivityVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<ColumnConfigVo> columnConfigVoList = templateConfigVoThreadLocal.get();
        List dictFieldList = columnConfigVoList.stream().filter(item -> StringUtil.isNotEmpty((CharSequence)item.getDictCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dictFieldList)) {
            return;
        }
        List dictCodes = dictFieldList.stream().map(ColumnConfigVo::getDictCode).distinct().collect(Collectors.toList());
        Map dictMap = this.dictDataVoService.findByDictTypeCodeList(dictCodes);
        Map<String, Map> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(DetailedAccountOfActivityVo.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (DetailedAccountOfActivityVo data : list) {
            for (ColumnConfigVo configVo : dictFieldList) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(configVo.getField());
                if (null == propertyDescriptor) continue;
                try {
                    Object originValue = propertyDescriptor.getReadMethod().invoke((Object)data, new Object[0]);
                    if (null == originValue) continue;
                    String originStrValue = originValue.toString();
                    Map thisDictMap = dictMapMap.get(configVo.getDictCode());
                    propertyDescriptor.getWriteMethod().invoke((Object)data, thisDictMap.getOrDefault(originStrValue, originStrValue));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public List<List<String>> findHead(ExportTaskProcessVo task, Map<String, Object> paramsMap) {
        List columnConfigVoList = this.columnConfigVoService.findByParentCodeAndFunctionCodeOrderByFormorder(task.getParentCode(), task.getFunctionCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)columnConfigVoList)) {
            throw new RuntimeException("\u9875\u9762\u914d\u7f6e\u672a\u67e5\u8be2\u5230");
        }
        templateConfigVoThreadLocal.set(columnConfigVoList);
        ArrayList result = Lists.newArrayList();
        for (ColumnConfigVo detail : columnConfigVoList) {
            if (null == detail.getVisible() || !detail.getVisible().booleanValue()) continue;
            result.add(Lists.newArrayList((Object[])new String[]{detail.getTitle()}));
        }
        return result;
    }

    public List<String> findCrmExcelColumnField(ExportTaskProcessVo task, Map<String, Object> paramsMap) {
        List<ColumnConfigVo> configVoList = templateConfigVoThreadLocal.get();
        ArrayList list = Lists.newArrayList();
        for (ColumnConfigVo detail : configVoList) {
            if (null == detail.getVisible() || !detail.getVisible().booleanValue()) continue;
            list.add(detail.getField());
        }
        return list;
    }

    public Integer getTotal(Map<String, Object> params) {
        DetailedAccountOfActivityVo dto;
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page detailedAccountOfActivityPage = this.subComActivityDetailPlanItemVoService.findDetailedAccountOfActivityPage((Pageable)pageable, dto = this.convertParams(params));
        Integer total = Math.toIntExact(detailedAccountOfActivityPage.getTotal());
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        try {
            PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
            DetailedAccountOfActivityVo dto = this.convertParams(params);
            Page detailedAccountOfActivityPage = this.subComActivityDetailPlanItemVoService.findDetailedAccountOfActivityPage((Pageable)pageable, dto);
            if (detailedAccountOfActivityPage.getTotal() == 0L) {
                return new JSONArray();
            }
            List records = detailedAccountOfActivityPage.getRecords();
            this.convertDictData(records);
            return JSON.parseArray((String)JSON.toJSONString((Object)records, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private DetailedAccountOfActivityVo convertParams(Map<String, Object> params) {
        return (DetailedAccountOfActivityVo)JSON.parseObject((String)JSON.toJSONString(params), DetailedAccountOfActivityVo.class);
    }

    public String getBusinessCode() {
        return "DETAILED_ACCOUNT_OF_ACTIVITY_EXPORTS_PROCESS";
    }

    public String getBusinessName() {
        return "\u5206\u5b50\u6d3b\u52a8\u660e\u7ec6\u7ec6\u6848\u53f0\u8d26\u5bfc\u51fa";
    }
}

