/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.exports.vo.SubComActivityDetailPlanItemExportsVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.mapper.SubComActivityDetailPlanItemMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDetailPlanItemExportsProcess
implements ExportProcess<SubComActivityDetailPlanItemExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanItemExportsProcess.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanItemMapper subComActivityDetailPlanItemMapper;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    private static final String DICT_CACHE_KEY = "SUB_COM_ACTIVITY_DETAIL_PLAN_ITEM_DICT_CACHE_KEY:";

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params, (String)"\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Object constituentDetailPlanCode = params.get("constituentDetailPlanCode");
        Validate.notNull((Object)constituentDetailPlanCode, (String)"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848\u7f16\u7801[constituentDetailPlanCode]\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)constituentDetailPlanCode.toString(), (String)"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848\u7f16\u7801[constituentDetailPlanCode]\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer total = this.subComActivityDetailPlanItemMapper.exportsCount(constituentDetailPlanCode.toString(), TenantUtils.getTenantCode());
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Integer offset = this.getPageSize() * vo.getPageNo();
        Integer pageSize = this.getPageSize();
        log.info("offset=====\u300b{}\uff0cpageSize=====\u300b{}", (Object)offset, (Object)pageSize);
        List<SubComActivityDetailPlanItemExportsVo> data = this.subComActivityDetailPlanItemMapper.findExportsData(params.get("constituentDetailPlanCode").toString(), offset, pageSize, TenantUtils.getTenantCode());
        this.convertData(data);
        return JSON.parseArray((String)JSON.toJSONString(data));
    }

    public Class<SubComActivityDetailPlanItemExportsVo> findCrmExcelVoClass() {
        return SubComActivityDetailPlanItemExportsVo.class;
    }

    public String getBusinessCode() {
        return "SUB_COM_ACTIVITY_DETAIL_PLAN_ITEM_EXPORTS";
    }

    public String getBusinessName() {
        return "TPM-\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u5bfc\u51fa";
    }

    private void convertData(List<SubComActivityDetailPlanItemExportsVo> data) {
        Map map;
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Map<String, String> businessFormatMap = this.getDictMap("mdm_business_format", "businessFormatMap");
        Map<String, String> yesOrNoMap = this.getDictMap("yesOrNo", "yesOrNoMap");
        Map<String, String> associationTypeMap = this.getDictMap("tpm_sub_com_activity_association_type", "associationTypeMap");
        Map<String, String> undertakingModeMap = this.getDictMap("accept_type", "undertakingModeMap");
        Map<String, String> auditTypeMap = this.getDictMap("audit_type", "auditTypeMap");
        Map<String, String> displayTypeMap = this.getDictMap("dis_Type", "displayTypeMap");
        Map<String, String> personTypeMap = this.getDictMap("ocm_user_category", "personTypeMap");
        Map<String, String> procurementTypeMap = this.getDictMap("isTypeOfPurchaseNo", "procurementTypeMap");
        Map<String, String> auditConditionMap = this.getDictMap("tpm_audit_type", "auditConditionMap");
        Map<String, String> isBigDateMap = this.getDictMap("isBigDateOrNo", "isBigDateMap");
        Map<String, String> whetherScheduleTimeMap = this.getDictMap("whetherScheduleTimeNo", "whetherScheduleTimeMap");
        Map<String, String> isPriceRelationMap = this.getDictMap("isPriceRelatedNo", "isPriceRelationMap");
        Map<String, String> isPatrolOperationsMap = this.getDictMap("isPatrolOperationsNo", "isPatrolOperationsMap");
        Map<String, String> auditFormMap = this.getDictMap("tpm_audit_form", "auditFormMap");
        Map<String, String> paymentMethodMap = this.getDictMap("tpm_payment_method", "paymentMethodMap");
        HashMap orgNameMap = new HashMap();
        HashSet orgCodes = new HashSet();
        data.stream().forEach(e -> {
            if (StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCode())) {
                orgCodes.add(e.getSalesOrgCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getSalesInstitutionCode())) {
                orgCodes.add(e.getSalesInstitutionCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getDepartmentCode())) {
                orgCodes.add(e.getDepartmentCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getSalesGroupCode())) {
                orgCodes.add(e.getSalesGroupCode());
            }
        });
        if (orgCodes.size() > 0 && Objects.nonNull(map = this.salesOrgVoService.findNameBySalesOrgCodes(Lists.partition((List)Lists.newArrayList(orgCodes), (int)500)))) {
            orgNameMap.putAll(map);
        }
        data.forEach(e -> {
            e.setBusinessFormatCode(this.getMapValue(e.getBusinessFormatCode(), businessFormatMap));
            e.setIsSupplyAmount(this.getMapValue(e.getIsSupplyAmount(), yesOrNoMap));
            e.setAssociationType(this.getMapValue(e.getAssociationType(), associationTypeMap));
            e.setUndertakingMode(this.getMapValue(e.getUndertakingMode(), undertakingModeMap));
            e.setAuditType(this.getMapValue(e.getAuditType(), auditTypeMap));
            e.setIsAssPromotion(this.getMapValue(e.getIsAssPromotion(), yesOrNoMap));
            e.setDisplayType(this.getMapValue(e.getDisplayType(), displayTypeMap));
            e.setPersonType(this.getMapValue(e.getPersonType(), personTypeMap));
            e.setProcurementType(this.getMapValue(e.getProcurementType(), procurementTypeMap));
            e.setAuditCondition(this.getMapValue(e.getAuditCondition(), auditConditionMap));
            e.setIsBigDate(this.getMapValue(e.getIsBigDate(), isBigDateMap));
            e.setWhetherScheduleTime(this.getMapValue(e.getWhetherScheduleTime(), whetherScheduleTimeMap));
            e.setIsPriceRelation(this.getMapValue(e.getIsPriceRelation(), isPriceRelationMap));
            e.setIsPatrolOperations(this.getMapValue(e.getIsPatrolOperations(), isPatrolOperationsMap));
            e.setUseStatus(this.getMapValue(e.getUseStatus(), yesOrNoMap));
            e.setAuditForm(this.getMapValue(e.getAuditForm(), auditFormMap));
            e.setPaymentMethod(this.getMapValue(e.getPaymentMethod(), paymentMethodMap));
            e.setYearMonthStr(this.replaceDate2Str(e.getYearMonthLy(), "yyyy-MM"));
            e.setFeeYearMonthStr(this.replaceDate2Str(e.getFeeYearMonth(), "yyyy-MM"));
            e.setActivityBeginTimeStr(this.replaceDate2Str(e.getActivityBeginTime(), "yyyy-MM-dd"));
            e.setActivityEndTimeStr(this.replaceDate2Str(e.getActivityEndTime(), "yyyy-MM-dd"));
            e.setOrderStartDateStr(this.replaceDate2Str(e.getOrderStartDate(), "yyyy-MM-dd"));
            e.setOrderEndDateStr(this.replaceDate2Str(e.getOrderEndDate(), "yyyy-MM-dd"));
            e.setSalesOrgName(this.getMapValue(e.getSalesOrgCode(), orgNameMap));
            e.setSalesInstitutionName(this.getMapValue(e.getSalesInstitutionCode(), orgNameMap));
            e.setDepartmentName(this.getMapValue(e.getDepartmentCode(), orgNameMap));
            e.setSalesGroupName(this.getMapValue(e.getSalesGroupCode(), orgNameMap));
        });
    }

    private Map<String, String> getDictMap(String dictTypeCode, String mapName) {
        Object o;
        String cacheKey1 = DICT_CACHE_KEY + mapName;
        if (this.redisService.hasKey(cacheKey1).booleanValue() && Objects.nonNull(o = this.redisService.get(cacheKey1))) {
            return (Map)JSONObject.parseObject((String)o.toString(), Map.class);
        }
        Map dictMap = this.dictToolkitService.findMapByDictTypeCode(dictTypeCode);
        if (Objects.isNull(dictMap)) {
            dictMap = Maps.newHashMap();
        }
        this.redisService.set(cacheKey1, (Object)JSONObject.toJSONString((Object)dictMap), 600L);
        return dictMap;
    }

    public String getMapValue(String code, Map<String, String> map) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        return map.getOrDefault(code, code);
    }

    public String replaceDate2Str(Date date, String format) {
        if (Objects.nonNull(date)) {
            return DateUtil.format((Date)date, (String)format);
        }
        return null;
    }
}

