/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemRepository;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SubComActivityDetailPlanXxlJob {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanXxlJob.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SubComActivityDesignDetailService subComActivityDesignDetailService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemRepository subComActivityDetailPlanItemRepository;

    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u5b9a\u65f6\u66f4\u65b0\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u72b6\u6001")
    public void autoUpdateActivityStatusXxlJob() {
        this.loginUserService.refreshAuthentication(null);
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("lock_sub_com_activity_auto_update_status:", TimeUnit.HOURS, 2L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.autoUpdateStatus();
        }
        catch (Exception e) {
            log.error("=====>   \u5b9a\u65f6\u66f4\u65b0\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u72b6\u6001   <=====");
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("lock_sub_com_activity_auto_update_status:");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void autoUpdateStatus() {
        this.subComActivityDetailPlanItemRepository.autoUpdateActivityStatus(ProcessStatusEnum.PASS.getDictCode(), ActivityStatusEnum.END.getCode());
        this.subComActivityDesignDetailService.autoUpdateActivityDetailStatus(ProcessStatusEnum.PASS.getDictCode(), ActivityStatusEnum.END.getCode());
    }
}

