/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.listener;

import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetLockService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.PushSubActivityDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemBudgetShareVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class SubActivityDetailPlanCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(SubActivityDetailPlanCompleteListener.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemRepository activityConstituentDetailPlanItemRepository;
    @Autowired(required=false)
    private PushSubActivityDetailService pushSubActivityDetailService;
    @Autowired(required=false)
    private SubComActivityDetailPlanRepository subComActivityDetailPlanRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareVoService subComActivityDetailPlanItemBudgetShareVoService;
    @Autowired(required=false)
    private SubComMonthBudgetLockService subComMonthBudgetLockService;

    public String getBusinessCode() {
        return "ACTIVITY_CONST_DETAIL_PLAN_PROCESS_CODE";
    }

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        ArrayList<String> businessNoList = dto.getBusinessNoList();
        if (CollectionUtils.isEmpty((Collection)businessNoList)) {
            if (StringUtils.isEmpty((CharSequence)dto.getBusinessNo())) {
                return;
            }
            businessNoList = new ArrayList<String>();
            businessNoList.add(dto.getBusinessNo());
            dto.setBusinessNoList(businessNoList);
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(businessNoList, (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279 \u4e1a\u52a1\u7f16\u53f7{}", businessNoList);
        List planVoList = this.subComActivityDetailPlanVoService.findDetailByIdList(businessNoList);
        Validate.notEmpty((Collection)planVoList, (String)"\u6d3b\u52a8\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b9e\u4f8b", (Object[])new Object[0]);
        List<String> constituentDetailPlanCodeList = planVoList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getConstituentDetailPlanCode())).map(SubComActivityDetailPlanVo::getConstituentDetailPlanCode).distinct().collect(Collectors.toList());
        log.info("\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279 \u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848\u7f16\u7801{}", constituentDetailPlanCodeList);
        this.activityConstituentDetailPlanItemRepository.updateProcessStatus(constituentDetailPlanCodeList, processStatus);
        this.subComActivityDetailPlanRepository.updateProcessStatus(constituentDetailPlanCodeList, processStatus);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.pushSubActivityDetailService.passPushMq(constituentDetailPlanCodeList);
        } else if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            List monthBudgetCodeList = this.subComActivityDetailPlanItemBudgetShareVoService.returnMonthBudgetByPlanCodeList(constituentDetailPlanCodeList);
            this.subComMonthBudgetLockService.unlock(monthBudgetCodeList);
        }
    }
}

