/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetLockService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignNetEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SubComActivityDesignNetEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItemBudgetShare;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemBudgetShareRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignNetEventListenerImpl
implements SubComActivityDesignNetEventListener {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignNetEventListenerImpl.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService activityConstituentDetailPlanItemVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SubComMonthBudgetLockService subComMonthBudgetLockService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareRepository subComActivityDetailPlanItemBudgetShareRepository;

    public void onClose(SubComActivityDesignNetEventDto dto) {
        List activityDesignDetailCodes = dto.getDesignDetailDtos().stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map designDetailDtoMap = dto.getDesignDetailDtos().stream().collect(Collectors.toMap(SubComActivityDesignDetailDto::getActivityDesignDetailCode, Function.identity()));
        List activityDetailPlanItemList = this.activityConstituentDetailPlanItemVoService.findItemsByPlanItemCodes(activityDesignDetailCodes);
        ArrayList detailPlanItemDtos = new ArrayList();
        ArrayList ids = new ArrayList();
        activityDetailPlanItemList.forEach(item -> {
            SubComActivityDesignDetailDto detailDto = (SubComActivityDesignDetailDto)designDetailDtoMap.get(item.getConstituentDetailPlanItemCode());
            if (null != detailDto) {
                SubComActivityDetailPlanItemDto itemDto = new SubComActivityDetailPlanItemDto();
                ids.add(item.getId());
                itemDto.setId(item.getId());
                itemDto.setRefundAmount(detailDto.getRefundAmount());
                itemDto.setDealThings(dto.isDealThings());
                itemDto.setReturnAmount(detailDto.getReturnAmount());
                itemDto.setWillRefundAmount(detailDto.getWillRefundAmount());
                detailPlanItemDtos.add(itemDto);
            }
        });
        if (CollectionUtil.isNotEmpty(detailPlanItemDtos)) {
            List<SubComActivityDetailPlanItemBudgetShare> budgetShareList = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCodeList(new ArrayList<String>(designDetailDtoMap.keySet()));
            List monthBudgetCodeList = budgetShareList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getMonthBudgetCode())).map(SubComActivityDetailPlanItemBudgetShare::getMonthBudgetCode).distinct().collect(Collectors.toList());
            boolean lockSuccess = this.subComMonthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.MINUTES, 5);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            try {
                detailPlanItemDtos.forEach(itemDto -> this.activityConstituentDetailPlanItemVoService.closeById(itemDto));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw e;
            }
            finally {
                this.subComMonthBudgetLockService.unlock(monthBudgetCodeList);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void onModify(SubComActivityDesignNetEventDto dto) {
        log.info("\u89c4\u5212\u53d8\u66f4\uff0c\u66f4\u65b0\u5206\u5b50\u7ec6\u6848\u6570\u636e");
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getDesignDetailDtos())) {
            log.info("\u89c4\u5212\u53d8\u66f4\uff0c\u66f4\u65b0\u5206\u5b50\u7ec6\u6848\u6570\u636e\uff0c\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        ArrayList<SubComActivityDetailPlanItemDto> itemList = new ArrayList<SubComActivityDetailPlanItemDto>(dto.getDesignDetailDtos().size());
        for (SubComActivityDesignDetailDto designDetailDto : dto.getDesignDetailDtos()) {
            SubComActivityDetailPlanItemDto itemDto = new SubComActivityDetailPlanItemDto();
            itemDto.setConstituentDetailPlanItemCode(designDetailDto.getActivityDesignDetailCode());
            itemDto.setActivityBeginTime(designDetailDto.getActivityBeginTime());
            itemDto.setActivityEndTime(designDetailDto.getActivityEndTime());
            itemDto.setOrderStartDate(designDetailDto.getOrderStartDate());
            itemDto.setOrderEndDate(designDetailDto.getOrderEndDate());
            itemDto.setCustomerCode(designDetailDto.getCustomerCode());
            itemDto.setCustomerName(designDetailDto.getCustomerName());
            itemDto.setPromoteSales(designDetailDto.getPromoteSales());
            itemDto.setPromotionAmount(designDetailDto.getPromotionAmount());
            itemDto.setTotalCost(designDetailDto.getTotalCost());
            itemDto.setProductCode(designDetailDto.getProductCode());
            itemDto.setProductName(designDetailDto.getProductName());
            itemDto.setCurrModifyCode(designDetailDto.getCurrModifyCode());
            itemList.add(itemDto);
        }
        this.activityConstituentDetailPlanItemVoService.updateItemByDesignModify(itemList);
    }
}

