/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.consumer;

import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.SubComActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailPlanModifyPassMqTagEnum;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PASS_UPDATE_PLAN", consumerGroup="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PASS_UPDATE_PLAN${rocketmq.environment}", consumeMode=ConsumeMode.ORDERLY, messageModel=MessageModel.CLUSTERING)
public class SubComActivityDetailPlanModifyPassUpdatePlanConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanModifyPassUpdatePlanConsumer.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanItemModifyService subComActivityDetailPlanItemModifyService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    protected Object handleMessage(MqMessageVo message) {
        log.info(SubComActivityDetailPlanModifyPassMqTagEnum.PASS_UPDATE_PLAN.getName() + " order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            String businessNo = message.getMsgBody();
            this.subComActivityDetailPlanItemModifyService.doUpdatePlanData(businessNo);
            this.passPushMq(businessNo);
        }
        catch (Exception e) {
            log.error(SubComActivityDetailPlanModifyPassMqTagEnum.PASS_UPDATE_PLAN.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private void passPushMq(String businessNo) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        for (SubComActivityDetailPlanModifyPassMqTagEnum mqTagEnum : SubComActivityDetailPlanModifyPassMqTagEnum.values()) {
            if (!SubComActivityDetailPlanModifyPassMqTagEnum.PushType.after_update_plan.equals((Object)mqTagEnum.getPushType())) continue;
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic("TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            this.rocketMqProducer.sendMqOrderMsg(mqMessageVo, businessNo, 10L);
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }
}

