/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.listener;

import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.SubComActivityDetailPlanModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailPlanModifyPassMqTagEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubActivityDetailPlanModifyCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(SubActivityDetailPlanModifyCompleteListener.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanModifyService subComActivityDetailPlanModifyService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    public String getBusinessCode() {
        return "ACTIVITY_CONST_DETAIL_PLAN_MODIFY_PROCESS_CODE";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.subComActivityDetailPlanModifyService.processPass(dto);
            this.passPushMq(dto.getBusinessNo());
        } else if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.subComActivityDetailPlanModifyService.processRejectAndRecover(dto);
        }
    }

    private void passPushMq(String businessNo) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        for (SubComActivityDetailPlanModifyPassMqTagEnum mqTagEnum : SubComActivityDetailPlanModifyPassMqTagEnum.values()) {
            if (!SubComActivityDetailPlanModifyPassMqTagEnum.PushType.code.equals((Object)mqTagEnum.getPushType())) continue;
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic("TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            this.rocketMqProducer.sendMqOrderMsg(mqMessageVo, businessNo, 10L);
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }
}

