/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.dto.SubComActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.entity.SubComActivityDetailPlanItemModify;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.mapper.SubComActivityDetailPlanItemBudgetShareModifyMapper;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.mapper.SubComActivityDetailPlanItemModifyMapper;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemBudgetShareDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDetailPlanItemModifyRepository
extends ServiceImpl<SubComActivityDetailPlanItemModifyMapper, SubComActivityDetailPlanItemModify> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemModifyMapper subComActivityDetailPlanItemModifyMapper;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareModifyMapper subComActivityDetailPlanItemBudgetShareModifyMapper;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemRepository subComActivityDetailPlanItemRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Page<SubComActivityDetailPlanItemVo> findToModifyList(Pageable pageable, SubComActivityDetailPlanItemDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SubComActivityDetailPlanItemVo> pageList = this.subComActivityDetailPlanItemModifyMapper.findToModifyList((Page<SubComActivityDetailPlanItemVo>)page, dto);
        return pageList;
    }

    public List<SubComActivityDetailPlanItemModifyDto> findDtoListByModifyCode(String modifyCode) {
        List<SubComActivityDetailPlanItemModify> list = this.findListByModifyCode(modifyCode);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, SubComActivityDetailPlanItemModify.class, SubComActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SubComActivityDetailPlanItemModifyDto> findDtoAndAttachListByDetailPlanCode(String modifyCode) {
        List<SubComActivityDetailPlanItemModify> modifyItemList = this.findListByModifyCode(modifyCode);
        if (CollectionUtils.isEmpty(modifyItemList)) {
            return Lists.newArrayList();
        }
        List<String> itemCodeList = modifyItemList.stream().map(SubComActivityDetailPlanItemModify::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List<SubComActivityDetailPlanItem> itemList = this.subComActivityDetailPlanItemRepository.findItemsByPlanItemCodes(itemCodeList);
        Map originMap = itemList.stream().collect(Collectors.toMap(SubComActivityDetailPlanItem::getConstituentDetailPlanItemCode, Function.identity(), (o, n) -> n));
        ArrayList dtoList = Lists.newArrayList();
        for (SubComActivityDetailPlanItemModify modifyItem : modifyItemList) {
            SubComActivityDetailPlanItem originItem = (SubComActivityDetailPlanItem)((Object)originMap.get(modifyItem.getConstituentDetailPlanItemCode()));
            SubComActivityDetailPlanItemModifyDto dto = new SubComActivityDetailPlanItemModifyDto();
            BeanUtils.copyProperties((Object)((Object)originItem), (Object)((Object)dto));
            BeanUtils.copyProperties((Object)((Object)modifyItem), (Object)((Object)dto));
            dtoList.add(dto);
        }
        List<SubComActivityDetailPlanItemBudgetShareDto> budgetList = this.subComActivityDetailPlanItemBudgetShareModifyMapper.listDtoListByModifyCode(modifyCode);
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.convertMonthBudgetProperty(budgetList);
            Map<String, List<SubComActivityDetailPlanItemBudgetShareDto>> budgetMap = budgetList.stream().filter(item -> com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)item.getConstituentDetailPlanItemCode())).collect(Collectors.groupingBy(SubComActivityDetailPlanItemBudgetShareDto::getConstituentDetailPlanItemCode));
            for (SubComActivityDetailPlanItemModifyDto itemDto : dtoList) {
                if (!budgetMap.containsKey(itemDto.getConstituentDetailPlanItemCode())) continue;
                itemDto.setBudgetShares(budgetMap.get(itemDto.getConstituentDetailPlanItemCode()));
            }
        }
        return dtoList;
    }

    private void convertMonthBudgetProperty(List<SubComActivityDetailPlanItemBudgetShareDto> budgetList) {
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_source");
                if (!CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                this.log.error("\u5206\u516c\u53f8\u8d39\u7528\u6765\u6e90\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (SubComActivityDetailPlanItemBudgetShareDto budgetShare : budgetList) {
            if (!StringUtils.isNotEmpty((CharSequence)budgetShare.getFeeSourceCode())) continue;
            budgetShare.setFeeSourceName(feeSourceMap.getOrDefault(budgetShare.getFeeSourceCode(), budgetShare.getFeeSourceCode()));
        }
    }

    public List<SubComActivityDetailPlanItemModify> findListByModifyCode(String modifyCode) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)modifyCode)) {
            return null;
        }
        SubComActivityDetailPlanItemModifyDto dto = new SubComActivityDetailPlanItemModifyDto();
        dto.setModifyCode(modifyCode);
        return this.findList(dto);
    }

    public List<SubComActivityDetailPlanItemModify> findList(SubComActivityDetailPlanItemModifyDto dto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SubComActivityDetailPlanItemModify.class).eq(com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)dto.getModifyCode()), SubComActivityDetailPlanItemModify::getModifyCode, (Object)dto.getModifyCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        return this.list((Wrapper)wrapper);
    }

    public void deleteByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByModifyCodeList(List<String> modifyCodeList) {
        if (CollectionUtils.isEmpty(modifyCodeList)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(SubComActivityDetailPlanItemModify::getModifyCode, modifyCodeList);
        this.update((Wrapper)updateWrapper);
    }
}

