/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.dto.SubComActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItemBudgetShare;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.entity.SubComActivityDetailPlanItemBudgetShareModify;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.entity.SubComActivityDetailPlanItemModify;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.entity.SubComActivityDetailPlanModify;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.repository.SubComActivityDetailPlanItemBudgetShareModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.repository.SubComActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.SubComActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemBudgetShareRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.vo.SubComActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityDetailPlanItemModifyServiceImpl
extends MnPageCacheServiceImpl<SubComActivityDetailPlanItemModifyVo, SubComActivityDetailPlanItemModifyDto>
implements SubComActivityDetailPlanItemModifyService {
    @Autowired(required=false)
    private SubComActivityDetailPlanItemModifyRepository subComActivityDetailPlanItemModifyRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareModifyRepository subComActivityDetailPlanItemBudgetShareModifyRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemRepository subComActivityDetailPlanItemRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareRepository subComActivityDetailPlanItemBudgetShareRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;

    @Override
    public Page<SubComActivityDetailPlanItemVo> findToModifyList(Pageable pageable, SubComActivityDetailPlanItemDto dto) {
        return this.subComActivityDetailPlanItemModifyRepository.findToModifyList(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveItemList(SubComActivityDetailPlanModify entity, boolean update, List<SubComActivityDetailPlanItemModifyDto> itemList) {
        itemList.forEach(this::createValidate);
        this.backupInitVersionData(itemList);
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<SubComActivityDetailPlanItemModify> oldList = this.subComActivityDetailPlanItemModifyRepository.findListByModifyCode(entity.getModifyCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDetailPlanItemModifyDto itemDto : itemList) {
            SubComActivityDetailPlanItemModify item = (SubComActivityDetailPlanItemModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)itemDto, SubComActivityDetailPlanItemModify.class, HashSet.class, ArrayList.class, new String[0]));
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setModifyCode(entity.getModifyCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDetailPlanItemModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDetailPlanItemModifyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityDetailPlanItemModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    private void backupInitVersionData(List<SubComActivityDetailPlanItemModifyDto> itemList) {
        List itemCodeList = itemList.stream().map(SubComActivityDetailPlanItemDto::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List noModifyList = this.subComActivityDetailPlanItemRepository.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SubComActivityDetailPlanItem::getConstituentDetailPlanItemCode, itemCodeList)).and(w -> {
            w.eq(SubComActivityDetailPlanItem::getHasModify, (Object)BooleanEnum.FALSE.getCapital());
            w.or();
            w.isNull(SubComActivityDetailPlanItem::getHasModify);
        }));
        if (CollectionUtils.isEmpty((Collection)noModifyList)) {
            return;
        }
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)noModifyList, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemModify.class, HashSet.class, ArrayList.class, new String[0]);
        this.subComActivityDetailPlanItemModifyRepository.saveBatch(entityList);
        List<String> noModifyCodeList = noModifyList.stream().map(SubComActivityDetailPlanItem::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        this.subComActivityDetailPlanItemRepository.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SubComActivityDetailPlanItem::getHasModify, (Object)BooleanEnum.TRUE.getCapital())).in(SubComActivityDetailPlanItem::getConstituentDetailPlanItemCode, noModifyCodeList));
        List<SubComActivityDetailPlanItemBudgetShare> budgetList = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCodeList(noModifyCodeList);
        if (!CollectionUtils.isEmpty(budgetList)) {
            List budgetModifyList = (List)this.nebulaToolkitService.copyCollectionByBlankList(budgetList, SubComActivityDetailPlanItemBudgetShare.class, SubComActivityDetailPlanItemBudgetShareModify.class, HashSet.class, ArrayList.class, new String[0]);
            this.subComActivityDetailPlanItemBudgetShareModifyRepository.saveBatch(budgetModifyList);
        }
    }

    private void createValidate(SubComActivityDetailPlanItemModifyDto dto) {
    }

    @Override
    public void deleteByModifyCodeList(List<String> modifyCodeList) {
        this.subComActivityDetailPlanItemModifyRepository.deleteByModifyCodeList(modifyCodeList);
    }

    @Override
    public void useMonthBudgetByModifyCode(String modifyCode) {
        List<SubComActivityDetailPlanItemModify> modifyItemList = this.subComActivityDetailPlanItemModifyRepository.findListByModifyCode(modifyCode);
        List<SubComActivityDetailPlanItemBudgetShareModify> modifyItemBudgetList = this.subComActivityDetailPlanItemBudgetShareModifyRepository.listByModifyCode(modifyCode);
        List<String> itemCodeList = modifyItemList.stream().map(SubComActivityDetailPlanItemModify::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List<SubComActivityDetailPlanItemBudgetShare> originBudgetList = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCodeList(itemCodeList);
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> item.getConstituentDetailPlanItemCode() + item.getMonthBudgetCode(), SubComActivityDetailPlanItemBudgetShare::getUseAmount));
        ArrayList budgetOperateList = Lists.newArrayList();
        for (final SubComActivityDetailPlanItemBudgetShareModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            final BigDecimal originUseAmount = originBudgetMap.getOrDefault(budgetShareModify.getConstituentDetailPlanItemCode() + budgetShareModify.getMonthBudgetCode(), BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0) continue;
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getConstituentDetailPlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                }
            };
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.subComMonthBudgetService.operateBudget((List)budgetOperateList);
        }
    }

    @Override
    public void returnMonthBudgetByModifyCode(String modifyCode) {
        List<SubComActivityDetailPlanItemModify> modifyItemList = this.subComActivityDetailPlanItemModifyRepository.findListByModifyCode(modifyCode);
        List<SubComActivityDetailPlanItemBudgetShareModify> modifyItemBudgetList = this.subComActivityDetailPlanItemBudgetShareModifyRepository.listByModifyCode(modifyCode);
        List<String> itemCodeList = modifyItemList.stream().map(SubComActivityDetailPlanItemModify::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List<SubComActivityDetailPlanItemBudgetShare> originBudgetList = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCodeList(itemCodeList);
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> item.getConstituentDetailPlanItemCode() + item.getMonthBudgetCode(), SubComActivityDetailPlanItemBudgetShare::getUseAmount));
        ArrayList budgetOperateList = Lists.newArrayList();
        for (final SubComActivityDetailPlanItemBudgetShareModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            final BigDecimal originUseAmount = originBudgetMap.getOrDefault(budgetShareModify.getConstituentDetailPlanItemCode() + budgetShareModify.getMonthBudgetCode(), BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0) continue;
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getConstituentDetailPlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                }
            };
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.subComMonthBudgetService.operateBudget((List)budgetOperateList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doUpdatePlanData(String modifyCode) {
        List<SubComActivityDetailPlanItemModify> modifyItemList = this.subComActivityDetailPlanItemModifyRepository.findListByModifyCode(modifyCode);
        List<SubComActivityDetailPlanItemBudgetShareModify> modifyItemBudgetList = this.subComActivityDetailPlanItemBudgetShareModifyRepository.listByModifyCode(modifyCode);
        this.passReturnMonthBudgetByModifyCode(modifyItemList, modifyItemBudgetList);
        Map modifyMap = modifyItemList.stream().collect(Collectors.toMap(SubComActivityDetailPlanItemModify::getConstituentDetailPlanItemCode, Function.identity()));
        List<String> itemCodeList = modifyItemList.stream().map(SubComActivityDetailPlanItemModify::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List<SubComActivityDetailPlanItem> itemList = this.subComActivityDetailPlanItemRepository.findItemsByPlanItemCodes(itemCodeList);
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantFlagOpEntity.class);
        String[] ignoreFieldArr = (String[])Arrays.stream(propertyDescriptors).map(FeatureDescriptor::getName).toArray(String[]::new);
        for (SubComActivityDetailPlanItem item : itemList) {
            SubComActivityDetailPlanItemModify modifyItem = (SubComActivityDetailPlanItemModify)((Object)modifyMap.get(item.getConstituentDetailPlanItemCode()));
            ArrayList orderShareInterfaceState = Lists.newArrayList();
            if (!Optional.ofNullable(modifyItem.getCustomerCode()).orElse("").equals(item.getCustomerCode())) {
                orderShareInterfaceState.add(InterfacePushStateEnum.UPDATE_CUSTOMER.getCode());
            }
            if (Optional.ofNullable(modifyItem.getTotalCost()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(item.getTotalCost()).orElse(BigDecimal.ZERO)) != 0 || Optional.ofNullable(modifyItem.getPromoteSales()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(item.getPromoteSales()).orElse(BigDecimal.ZERO)) != 0) {
                orderShareInterfaceState.add(InterfacePushStateEnum.UPDATE_QUANTITY_OR_FEE.getCode());
            }
            if (modifyItem.getOrderStartDate().compareTo(item.getOrderStartDate()) != 0 || modifyItem.getOrderEndDate().compareTo(item.getOrderEndDate()) != 0 || modifyItem.getActivityBeginTime().compareTo(item.getActivityBeginTime()) != 0 || modifyItem.getActivityEndTime().compareTo(item.getActivityEndTime()) != 0) {
                orderShareInterfaceState.add(InterfacePushStateEnum.UPDATE_STATE_OR_DATE.getCode());
            }
            BeanUtils.copyProperties((Object)((Object)modifyItem), (Object)((Object)item), (String[])ignoreFieldArr);
            item.setCurrModifyCode(modifyItem.getModifyCode());
            item.setOrderShareInterfaceState(String.join((CharSequence)",", orderShareInterfaceState));
        }
        this.subComActivityDetailPlanItemRepository.updateBatchById(itemList);
        this.subComActivityDetailPlanItemBudgetShareRepository.updateDelFlagByPlanItemCodeList(itemCodeList);
        if (!CollectionUtils.isEmpty(modifyItemBudgetList)) {
            Collection budgetShareList = this.nebulaToolkitService.copyCollectionByBlankList(modifyItemBudgetList, SubComActivityDetailPlanItemBudgetShareModify.class, SubComActivityDetailPlanItemBudgetShare.class, HashSet.class, ArrayList.class, new String[0]);
            this.subComActivityDetailPlanItemBudgetShareRepository.saveBatch(budgetShareList);
        }
    }

    public void passReturnMonthBudgetByModifyCode(List<SubComActivityDetailPlanItemModify> modifyItemList, List<SubComActivityDetailPlanItemBudgetShareModify> modifyItemBudgetList) {
        List<String> itemCodeList = modifyItemList.stream().map(SubComActivityDetailPlanItemModify::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List<SubComActivityDetailPlanItemBudgetShare> originBudgetList = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCodeList(itemCodeList);
        Map<String, BigDecimal> modifyBudgetMap = modifyItemBudgetList.stream().collect(Collectors.toMap(item -> item.getConstituentDetailPlanItemCode() + item.getMonthBudgetCode(), SubComActivityDetailPlanItemBudgetShareModify::getUseAmount));
        ArrayList budgetOperateList = Lists.newArrayList();
        for (final SubComActivityDetailPlanItemBudgetShare budgetShare : originBudgetList) {
            if (null == budgetShare.getUseAmount() || budgetShare.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            final BigDecimal modifyUseAmount = modifyBudgetMap.getOrDefault(budgetShare.getConstituentDetailPlanItemCode() + budgetShare.getMonthBudgetCode(), BigDecimal.ZERO);
            if (budgetShare.getUseAmount().compareTo(modifyUseAmount) <= 0) continue;
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                {
                    this.setBusinessCode(budgetShare.getConstituentDetailPlanItemCode());
                    this.setMonthBudgetCode(budgetShare.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShare.getUseAmount().subtract(modifyUseAmount));
                }
            };
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.subComMonthBudgetService.operateBudget((List)budgetOperateList);
        }
    }
}

