/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.dto.SubComActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.repository.SubComActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.vo.SubComActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemBudgetShareDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemProductShareDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemBudgetShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemProductShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDetailPlanModifyPageCacheHelper
extends MnPageCacheHelper<SubComActivityDetailPlanItemModifyVo, SubComActivityDetailPlanItemModifyDto> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemModifyRepository subComActivityDetailPlanItemModifyRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    public String getCacheKeyPrefix() {
        return "activity_const_detail_plan:item_modify_cache:";
    }

    public Class<SubComActivityDetailPlanItemModifyDto> getDtoClass() {
        return SubComActivityDetailPlanItemModifyDto.class;
    }

    public Class<SubComActivityDetailPlanItemModifyVo> getVoClass() {
        return SubComActivityDetailPlanItemModifyVo.class;
    }

    public List<SubComActivityDetailPlanItemModifyDto> findDtoListFromRepository(SubComActivityDetailPlanItemModifyDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getModifyCode())) {
            return Lists.newArrayList();
        }
        return this.subComActivityDetailPlanItemModifyRepository.findDtoAndAttachListByDetailPlanCode(dto.getModifyCode());
    }

    public List<SubComActivityDetailPlanItemModifyDto> newItem(String cacheKey, List<SubComActivityDetailPlanItemModifyDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        List checkedList = itemList.stream().filter(item -> BooleanEnum.TRUE.getNumStr().equals(item.getChecked())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(checkedList)) {
            return Lists.newArrayList();
        }
        List itemCodeList = checkedList.stream().map(SubComActivityDetailPlanItemDto::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List oldItemList = this.subComActivityDetailPlanItemVoService.findDetailByItemCodeList(itemCodeList);
        ArrayList newList = Lists.newArrayList();
        for (SubComActivityDetailPlanItemVo itemVo : oldItemList) {
            SubComActivityDetailPlanItemModifyDto newDto = (SubComActivityDetailPlanItemModifyDto)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)itemVo, SubComActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]));
            if (!CollectionUtils.isEmpty((Collection)itemVo.getBudgetShares())) {
                List budgetShareDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemVo.getBudgetShares(), SubComActivityDetailPlanItemBudgetShareVo.class, SubComActivityDetailPlanItemBudgetShareDto.class, HashSet.class, ArrayList.class, new String[0]);
                newDto.setBudgetShares(budgetShareDtos);
            }
            if (!CollectionUtils.isEmpty((Collection)itemVo.getProductShares())) {
                List productShareDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemVo.getProductShares(), SubComActivityDetailPlanItemProductShareVo.class, SubComActivityDetailPlanItemProductShareDto.class, HashSet.class, ArrayList.class, new String[0]);
                newDto.setProductShares(productShareDtos);
            }
            newList.add(newDto);
        }
        newList.forEach(item -> {
            item.setId(UUID.randomUUID().toString().replace("-", ""));
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        return newList;
    }

    public List<SubComActivityDetailPlanItemModifyDto> copyItem(String cacheKey, List<SubComActivityDetailPlanItemModifyDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        List copyList = itemList.stream().filter(item -> BooleanEnum.TRUE.getNumStr().equals(item.getChecked())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(copyList)) {
            return Lists.newArrayList();
        }
        List newList = (List)this.nebulaToolkitService.copyCollectionByBlankList(copyList, SubComActivityDetailPlanItemModifyDto.class, SubComActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        newList.forEach(item -> {
            item.setId(UUID.randomUUID().toString().replace("-", ""));
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        return newList;
    }

    public void updateItem(String cacheKey, List<SubComActivityDetailPlanItemModifyDto> itemList) {
        super.updateItem(cacheKey, itemList);
        for (SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto : itemList) {
            if (CollectionUtils.isEmpty((Collection)subComActivityDetailPlanItemDto.getBudgetShares())) continue;
            BigDecimal headFeeAmount = BigDecimal.ZERO;
            BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
            for (SubComActivityDetailPlanItemBudgetShareDto budgetDto : subComActivityDetailPlanItemDto.getBudgetShares()) {
                if (StringUtils.isEmpty((CharSequence)budgetDto.getFeeSourceCode()) || null == budgetDto.getUseAmount()) continue;
                if (FeeSourceEnum.AUTO_FEE.getCode().equals(budgetDto.getFeeSourceCode())) {
                    regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(budgetDto.getUseAmount());
                    continue;
                }
                if (!FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budgetDto.getFeeSourceCode()) && !FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budgetDto.getFeeSourceCode())) continue;
                headFeeAmount = headFeeAmount.add(budgetDto.getUseAmount());
            }
            subComActivityDetailPlanItemDto.setHeadquartersSupportedAmount(headFeeAmount);
            subComActivityDetailPlanItemDto.setSubComAutoAmount(regionAutomaticFeeAmount);
            subComActivityDetailPlanItemDto.setTotalCost(headFeeAmount.add(regionAutomaticFeeAmount));
        }
    }

    public Object getDtoKey(SubComActivityDetailPlanItemModifyDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(SubComActivityDetailPlanItemModifyDto dto) {
        return dto.getChecked();
    }

    public void fillVoListProperties(List<SubComActivityDetailPlanItemModifyVo> records) {
        super.fillVoListProperties(records);
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        for (SubComActivityDetailPlanItemModifyVo record : records) {
            record.setChecked(BooleanEnum.FALSE.getNumStr());
        }
    }
}

