/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.dto.SubComActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.dto.SubComActivityDetailPlanModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.entity.SubComActivityDetailPlanModify;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.repository.SubComActivityDetailPlanModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.SubComActivityDetailPlanItemBudgetShareModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.SubComActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.modify.service.SubComActivityDetailPlanModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.vo.SubComActivityDetailPlanModifyVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityDetailPlanModifyServiceImpl
implements SubComActivityDetailPlanModifyService {
    @Autowired(required=false)
    private SubComActivityDetailPlanModifyRepository subComActivityDetailPlanModifyRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemModifyService subComActivityDetailPlanItemModifyService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareModifyService subComActivityDetailPlanItemBudgetShareModifyService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;

    @Override
    @Transactional
    public void create(String cacheKey, SubComActivityDetailPlanModifyDto dto) {
        boolean update;
        List itemList = this.subComActivityDetailPlanItemModifyService.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u53d8\u66f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.createValidate(dto, itemList);
        SubComActivityDetailPlanModify entity = null;
        boolean bl = update = !StringUtils.isBlank((CharSequence)dto.getId());
        if (!update) {
            entity = (SubComActivityDetailPlanModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComActivityDetailPlanModify.class, HashSet.class, ArrayList.class, new String[0]));
            String code = (String)this.generateCodeService.generateCode("FZDC", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            entity.setModifyCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            this.subComActivityDetailPlanModifyRepository.save((Object)entity);
        } else {
            SubComActivityDetailPlanModify oldEntity = (SubComActivityDetailPlanModify)((Object)this.subComActivityDetailPlanModifyRepository.getById((Serializable)((Object)dto.getId())));
            entity = (SubComActivityDetailPlanModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComActivityDetailPlanModify.class, HashSet.class, ArrayList.class, new String[0]));
            entity.setModifyCode(oldEntity.getModifyCode());
            entity.setTenantCode(oldEntity.getTenantCode());
            entity.setCreateName(oldEntity.getCreateName());
            entity.setPositionCode(oldEntity.getPositionCode());
            entity.setPositionName(oldEntity.getPositionName());
            entity.setOrgCode(oldEntity.getOrgCode());
            entity.setOrgName(oldEntity.getOrgName());
            this.subComActivityDetailPlanModifyRepository.updateById((Object)entity);
        }
        this.subComActivityDetailPlanItemModifyService.saveItemList(entity, update, itemList);
        this.subComActivityDetailPlanItemBudgetShareModifyService.saveSubComActivityDetailPlanItemBudgetShareModifyList(entity, update, itemList);
    }

    private void createValidate(SubComActivityDetailPlanModifyDto dto, List<SubComActivityDetailPlanItemModifyDto> itemList) {
    }

    @Override
    public SubComActivityDetailPlanModifyVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        SubComActivityDetailPlanModify entity = (SubComActivityDetailPlanModify)((Object)this.subComActivityDetailPlanModifyRepository.getById((Serializable)((Object)id)));
        if (null != entity) {
            SubComActivityDetailPlanModifyVo vo = (SubComActivityDetailPlanModifyVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, SubComActivityDetailPlanModifyVo.class, HashSet.class, ArrayList.class, new String[0]));
            return vo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(SubComActivityDetailPlanModifyDto dto) {
        Validate.notNull((Object)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SubComActivityDetailPlanModify entity = (SubComActivityDetailPlanModify)((Object)this.subComActivityDetailPlanModifyRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\uff01", (Object[])new Object[0]);
        if (!(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()))) {
            throw new RuntimeException("\u5206\u5b50\u53d8\u66f4\u7ec6\u6848[" + entity.getModifyCode() + "]\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
        }
        dto.setModifyCode(entity.getModifyCode());
        dto.setPlanModifyName(entity.getPlanModifyName());
        this.subComActivityDetailPlanItemModifyService.useMonthBudgetByModifyCode(entity.getModifyCode());
        this.commitProcess(dto);
    }

    private void commitProcess(SubComActivityDetailPlanModifyDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNo(dto.getModifyCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("ACTIVITY_CONST_DETAIL_PLAN_MODIFY_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        dto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        this.subComActivityDetailPlanModifyRepository.updateProcessStatusAndProcessNo(dto.getModifyCode(), ProcessStatusEnum.COMMIT.getKey(), processBusinessVo.getProcessNo());
    }

    @Override
    public void processPass(ProcessStatusDto dto) {
        this.subComActivityDetailPlanModifyRepository.updateProcessStatus(dto.getBusinessNo(), dto.getProcessStatus());
    }

    @Override
    public void processRejectAndRecover(ProcessStatusDto dto) {
        this.subComActivityDetailPlanItemModifyService.returnMonthBudgetByModifyCode(dto.getBusinessNo());
        this.subComActivityDetailPlanModifyRepository.updateProcessStatus(dto.getBusinessNo(), dto.getProcessStatus());
    }

    @Override
    public void delete(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = this.subComActivityDetailPlanModifyRepository.listByIds(ids);
        for (SubComActivityDetailPlanModify entity : list) {
            Validate.isTrue((ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) ? 1 : 0) != 0, (String)("\u5206\u5b50\u516c\u53f8\u53d8\u66f4\u7ec6\u6848[" + entity.getModifyCode() + "]\u4e0d\u662f\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u6216\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01"), (Object[])new Object[0]);
        }
        this.subComActivityDetailPlanModifyRepository.deleteByIds(ids);
        List<String> modifyCodeList = list.stream().map(SubComActivityDetailPlanModify::getModifyCode).collect(Collectors.toList());
        this.subComActivityDetailPlanItemModifyService.deleteByModifyCodeList(modifyCodeList);
    }
}

