/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanBudget;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.mapper.SubComActivityDetailPlanBudgetMapper;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanBudgetVo;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class SubComActivityDetailPlanBudgetRepository
extends ServiceImpl<SubComActivityDetailPlanBudgetMapper, SubComActivityDetailPlanBudget> {
    public Page<SubComActivityDetailPlanBudgetVo> findByConditions(Page<SubComActivityDetailPlanBudgetVo> page, SubComActivityDetailPlanBudgetDto dto) {
        return ((SubComActivityDetailPlanBudgetMapper)this.baseMapper).findByConditions(page, dto);
    }

    public SubComActivityDetailPlanBudget findById(String id) {
        return (SubComActivityDetailPlanBudget)((Object)((SubComActivityDetailPlanBudgetMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<SubComActivityDetailPlanBudget> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateDelFlagByPlanCode(String planCode) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(SubComActivityDetailPlanBudget::getConstituentDetailPlanCode, (Object)planCode)).remove();
    }

    public List<SubComActivityDetailPlanBudget> findDetailByPlanCode(String constituentDetailPlanCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(SubComActivityDetailPlanBudget::getConstituentDetailPlanCode, (Object)constituentDetailPlanCode)).list();
    }

    public List<SubComActivityDetailPlanBudget> findDetailByPlanCodes(List<String> constituentDetailPlanCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(SubComActivityDetailPlanBudget::getConstituentDetailPlanCode, constituentDetailPlanCodes)).list();
    }
}

