/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.ProgressReferendumCostPlanForm;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.ProgressReferendumCostPlanFormRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.ProgressReferendumCostPlanFormService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class ProgressReferendumCostPlanFormServiceImpl
implements ProgressReferendumCostPlanFormService {
    private static final Logger log = LoggerFactory.getLogger(ProgressReferendumCostPlanFormServiceImpl.class);
    private static final String RTMSON = "son_company";
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private ProgressReferendumCostPlanFormRepository progressReferendumCostPlanFormRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void createOrUpdateProgressReferendumCostPlanFormAsync(String yearMonth, AbstractCrmUserIdentity userIdentity) {
        Assert.hasLength((String)yearMonth, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!");
        boolean lockSuccess = this.redisLockService.tryLock("tpm:progress_referendum_cost_plan:lock:" + yearMonth, TimeUnit.HOURS, 2L);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            this.loginUserService.refreshAuthentication((Object)userIdentity);
            this.createOrUpdateProgressReferendumCostPlanForm(yearMonth);
        }
        finally {
            this.redisLockService.unlock("tpm:progress_referendum_cost_plan:lock:" + yearMonth);
        }
    }

    @Override
    public void createOrUpdateProgressReferendumCostPlanForm(String yearMonth) {
        boolean isLock = this.redisLockService.isLock("tpm:progress_referendum_cost_plan:lock:" + yearMonth);
        Assert.isTrue((boolean)isLock, (String)"\u672a\u52a0\u9501,\u672c\u6b21\u4e0d\u6267\u884c!");
        Assert.hasLength((String)yearMonth, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!");
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        DetailedForecastDto forecastDto = new DetailedForecastDto();
        forecastDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        forecastDto.setDelFlag(delFlag);
        forecastDto.setEnableStatus(delFlag);
        forecastDto.setTenantCode(tenantCode);
        forecastDto.setRtmMode(RTMSON);
        forecastDto.setYearMonthStr(yearMonth);
        PageRequest pageable = PageRequest.of((int)1, (int)600);
        Page voPage = null;
        log.info("=====>    \u672c\u6b21\u516c\u6295\u8d39\u7528\u89c4\u5212\u8fdb\u5ea6[{}]  start   <=====", (Object)JSON.toJSONString((Object)forecastDto));
        SubComActivityDetailPlanItemDto dto = new SubComActivityDetailPlanItemDto();
        do {
            List auditCustomerDetailList;
            voPage = this.detailedForecastService.findByForecasts((Pageable)pageable, forecastDto);
            log.info("=====>    \u672c\u6b21\u516c\u6295\u8d39\u7528\u89c4\u5212\u8fdb\u5ea6[{}] [{}/{}]\u9875    <=====", new Object[]{voPage.getCurrent(), voPage.getPages(), yearMonth});
            pageable = pageable.next();
            List detailedForecastVoList = voPage.getRecords();
            if (CollectionUtils.isEmpty((Collection)detailedForecastVoList)) {
                return;
            }
            List activityDetailItemCodeList = detailedForecastVoList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getActivityDetailItemCode())).map(DetailedForecastVo::getActivityDetailItemCode).distinct().collect(Collectors.toList());
            HashMap subComDetailPlanItemVoMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty(activityDetailItemCodeList)) {
                dto.setAssociatedDateCodes(activityDetailItemCodeList);
                List subComDetailPlanItemVos = Optional.ofNullable(this.subComActivityDetailPlanItemVoService.findSupportedAmount(dto)).orElse(new ArrayList());
                if (CollectionUtil.isNotEmpty((Collection)subComDetailPlanItemVos)) {
                    subComDetailPlanItemVoMap.putAll(subComDetailPlanItemVos.stream().filter(k -> StringUtil.isNotEmpty((String)k.getAssociatedDateCode())).collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getAssociatedDateCode)));
                }
            }
            HashMap auditDetailVoMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty(activityDetailItemCodeList) && CollectionUtil.isNotEmpty((Collection)(auditCustomerDetailList = (List)Optional.ofNullable(this.progressReferendumCostPlanFormRepository.findByDetailPlanItemCodes(new HashSet<String>(activityDetailItemCodeList))).orElse(new ArrayList())))) {
                auditDetailVoMap.putAll(auditCustomerDetailList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getActivityDetailCode())).collect(Collectors.groupingBy(AuditCustomerDetailCollectionVo::getActivityDetailCode)));
            }
            List<ProgressReferendumCostPlanForm> entityList = this.buildEntityList(detailedForecastVoList, subComDetailPlanItemVoMap, auditDetailVoMap, tenantCode, delFlag);
            this.saveOrUpdate(entityList);
        } while (voPage.hasNext());
        log.info("=====>    \u672c\u6b21\u516c\u6295\u8d39\u7528\u89c4\u5212\u8fdb\u5ea6[{}]  end   <=====", (Object)JSON.toJSONString((Object)forecastDto));
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void saveOrUpdate(List<ProgressReferendumCostPlanForm> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        this.progressReferendumCostPlanFormRepository.saveOrUpdateBatch(entityList, 200);
    }

    private List<ProgressReferendumCostPlanForm> buildEntityList(List<DetailedForecastVo> detailedForecastVoList, Map<String, List<SubComActivityDetailPlanItemVo>> subComActivityDetailPlanItemVoMap, Map<String, List<AuditCustomerDetailCollectionVo>> auditDetailVoMap, String tenantCode, String delFlag) {
        List subComOrgVos;
        ArrayList<ProgressReferendumCostPlanForm> progressReferendumCostPlanFormList = new ArrayList<ProgressReferendumCostPlanForm>();
        Map<Object, Object> subComOrgVoMap = new HashMap();
        List customerErpCodeList = detailedForecastVoList.stream().map(DetailedForecastVo::getCustomerErpCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerErpCodeList) && !CollectionUtils.isEmpty((Collection)(subComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList(customerErpCodeList)))) {
            subComOrgVoMap = subComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity()));
        }
        for (DetailedForecastVo forecastVo : detailedForecastVoList) {
            AuditCustomerDetailCollectionVo detailCollectionVo;
            ProgressReferendumCostPlanForm entity = new ProgressReferendumCostPlanForm();
            entity.setId(forecastVo.getActivityDetailItemCode());
            entity.setBusinessFormatCode(forecastVo.getBusinessFormatCode());
            entity.setBusinessUnitCode(forecastVo.getBusinessUnitCode());
            entity.setYearAndMonth(forecastVo.getYearMonthStr());
            entity.setActivityDetailCode(forecastVo.getDetailedCaseCode());
            entity.setActivityDetailName(forecastVo.getDetailedCaseName());
            entity.setConstituentDetailPlanItemCode(forecastVo.getActivityDetailItemCode());
            entity.setCustomerCode(forecastVo.getCustomerCode());
            entity.setCustomerName(forecastVo.getCustomer());
            entity.setCustomerErpCode(forecastVo.getCustomerErpCode());
            if (StringUtil.isNotEmpty((String)forecastVo.getCustomerErpCode())) {
                SalesOrgSubComOrgVo salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)subComOrgVoMap.get(forecastVo.getCustomerErpCode());
                entity.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                entity.setOrgName(salesOrgSubComOrgVo.getOrgName());
            }
            entity.setSalesInstitutionCode(forecastVo.getSalesInstitutionCode());
            entity.setSalesInstitutionErpCode(forecastVo.getSalesInstitutionErpCode());
            entity.setSalesInstitutionName(forecastVo.getSalesInstitutionName());
            entity.setSalesOrgCode(forecastVo.getSalesOrgCode());
            entity.setSalesOrgErpCode(forecastVo.getSalesOrgErpCode());
            entity.setSalesOrgName(forecastVo.getSalesOrgName());
            entity.setSalesGroupCode(forecastVo.getSalesGroupCode());
            entity.setSalesGroupErpCode(forecastVo.getSalesGroupErpCode());
            entity.setSalesGroupName(forecastVo.getSalesGroupName());
            entity.setActivityBeginTime(forecastVo.getActivityStartTime());
            entity.setActivityEndTime(forecastVo.getActivityEndTime());
            entity.setActivityTypeCode(forecastVo.getActivityTypeCode());
            entity.setActivityTypeName(forecastVo.getActivityTypeName());
            entity.setActivityFormCode(forecastVo.getActivityFormCode());
            entity.setActivityFormName(forecastVo.getActivityFormName());
            entity.setProductCode(forecastVo.getProductCodeEx());
            entity.setProductName(forecastVo.getProductNameEx());
            entity.setProductBrandCode(forecastVo.getProductBrandCode());
            entity.setProductBrandName(forecastVo.getProductBrandName());
            entity.setProductCategoryCode(forecastVo.getProductCategoryCode());
            entity.setProductCategoryName(forecastVo.getProductCategoryName());
            entity.setProductItemCode(forecastVo.getProductItemCode());
            entity.setProductItemName(forecastVo.getProductItemName());
            entity.setChannelCode(forecastVo.getChannelCode());
            entity.setChannelName(forecastVo.getChannelName());
            entity.setTenantCode(tenantCode);
            entity.setDelFlag(delFlag);
            BooleanEnum booleanEnum = BooleanEnum.FALSE;
            if (MapUtils.isNotEmpty(auditDetailVoMap) && Objects.nonNull(detailCollectionVo = (AuditCustomerDetailCollectionVo)auditDetailVoMap.getOrDefault(entity.getConstituentDetailPlanItemCode(), Collections.emptyList()).stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getWholeAudit())).findFirst().orElse(null))) {
                booleanEnum = BooleanEnum.TRUE;
            }
            entity.setAllSettlement(booleanEnum.getCapital());
            entity.setApplyAmount(Optional.ofNullable(forecastVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(forecastVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO)));
            if (BooleanEnum.TRUE.getCapital().equals(entity.getAllSettlement())) {
                entity.setUpAuditAmount(forecastVo.getWriteOffAmount());
            } else {
                entity.setUpAuditAmount(forecastVo.getEstimatedWriteOffAmount());
            }
            BigDecimal downPlanAmount = BigDecimal.ZERO;
            BigDecimal actualDownAuditAmount = BigDecimal.ZERO;
            if (MapUtils.isNotEmpty(subComActivityDetailPlanItemVoMap)) {
                List subComActivityDetailPlanItemVos = Optional.ofNullable(subComActivityDetailPlanItemVoMap.get(entity.getConstituentDetailPlanItemCode())).orElse(new ArrayList());
                for (SubComActivityDetailPlanItemVo detailPlanItemVo : subComActivityDetailPlanItemVos) {
                    if (StringUtil.isEmpty((String)entity.getContractWay())) {
                        entity.setContractWay(detailPlanItemVo.getUndertakingMode());
                    }
                    downPlanAmount = downPlanAmount.add(Optional.ofNullable(detailPlanItemVo.getHeadquartersSupportedAmount()).orElse(BigDecimal.ZERO));
                    actualDownAuditAmount = actualDownAuditAmount.add(Optional.ofNullable(detailPlanItemVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO));
                }
            }
            entity.setDownPlanAmount(downPlanAmount);
            entity.setActualDownAuditAmount(actualDownAuditAmount);
            if (BooleanEnum.FALSE.getCapital().equals(entity.getAllSettlement())) {
                entity.setActualDownPlanAmount(Optional.ofNullable(entity.getApplyAmount()).orElse(BigDecimal.ZERO));
            } else {
                entity.setActualDownPlanAmount(Optional.ofNullable(forecastVo.getWriteOffAmount()).orElse(BigDecimal.ZERO));
            }
            entity.setActualDownUnPlanAmount(entity.getActualDownPlanAmount().subtract(entity.getDownPlanAmount()));
            progressReferendumCostPlanFormList.add(entity);
        }
        return progressReferendumCostPlanFormList;
    }
}

