/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItemBudgetShare;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemBudgetShareRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemBudgetShareDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.log.SubComActivityDetailPlanItemBudgetShareLogEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.SubComActivityDetailPlanItemBudgetShareEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.log.SubComActivityDetailPlanItemBudgetShareLogEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemBudgetShareVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemBudgetShareVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="subComActivityDetailPlanItemBudgetShareService")
public class SubComActivityDetailPlanItemBudgetShareVoServiceImpl
implements SubComActivityDetailPlanItemBudgetShareVoService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanItemBudgetShareVoServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareRepository subComActivityDetailPlanItemBudgetShareRepository;
    @Autowired(required=false)
    private List<SubComActivityDetailPlanItemBudgetShareEventListener> eventListeners;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;
    @Autowired(required=false)
    private SubComMonthBudgetLockService subComMonthBudgetLockService;

    public Page<SubComActivityDetailPlanItemBudgetShareVo> findByConditions(Pageable pageable, SubComActivityDetailPlanItemBudgetShareDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityDetailPlanItemBudgetShareDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComActivityDetailPlanItemBudgetShareRepository.findByConditions((Page<SubComActivityDetailPlanItemBudgetShareVo>)page, dto);
    }

    public SubComActivityDetailPlanItemBudgetShareVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SubComActivityDetailPlanItemBudgetShare subComActivityDetailPlanItemBudgetShare = this.subComActivityDetailPlanItemBudgetShareRepository.findById(id);
        if (subComActivityDetailPlanItemBudgetShare == null) {
            return null;
        }
        return (SubComActivityDetailPlanItemBudgetShareVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDetailPlanItemBudgetShare, SubComActivityDetailPlanItemBudgetShareVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SubComActivityDetailPlanItemBudgetShareVo> findDetailByPlanItemCode(String itemPlanCode) {
        if (StringUtils.isBlank((CharSequence)itemPlanCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItemBudgetShare> itemBudgetShares = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCode(itemPlanCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemBudgetShares)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(itemBudgetShares, SubComActivityDetailPlanItemBudgetShare.class, SubComActivityDetailPlanItemBudgetShareVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(SubComActivityDetailPlanItemBudgetShareDto subComActivityDetailPlanItemBudgetShareVo) {
        this.createValidation(subComActivityDetailPlanItemBudgetShareVo);
        subComActivityDetailPlanItemBudgetShareVo.setTenantCode(TenantUtils.getTenantCode());
        subComActivityDetailPlanItemBudgetShareVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        subComActivityDetailPlanItemBudgetShareVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        SubComActivityDetailPlanItemBudgetShare subComActivityDetailPlanItemBudgetShare = (SubComActivityDetailPlanItemBudgetShare)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDetailPlanItemBudgetShareVo, SubComActivityDetailPlanItemBudgetShare.class, HashSet.class, ArrayList.class, new String[0]));
        this.subComActivityDetailPlanItemBudgetShareRepository.saveOrUpdate((Object)subComActivityDetailPlanItemBudgetShare);
        subComActivityDetailPlanItemBudgetShareVo.setId(subComActivityDetailPlanItemBudgetShare.getId());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityDetailPlanItemBudgetShareEventListener subComActivityDetailPlanItemBudgetShareEventListener : this.eventListeners) {
                subComActivityDetailPlanItemBudgetShareEventListener.onCreate(subComActivityDetailPlanItemBudgetShareVo);
            }
        }
        SubComActivityDetailPlanItemBudgetShareLogEventDto logEventDto = new SubComActivityDetailPlanItemBudgetShareLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(subComActivityDetailPlanItemBudgetShareVo);
        SerializableBiConsumer & Serializable onCreate = SubComActivityDetailPlanItemBudgetShareLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComActivityDetailPlanItemBudgetShareLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(SubComActivityDetailPlanItemBudgetShareDto subComActivityDetailPlanItemBudgetShareVo) {
        this.updateValidation(subComActivityDetailPlanItemBudgetShareVo);
        String currentId = subComActivityDetailPlanItemBudgetShareVo.getId();
        SubComActivityDetailPlanItemBudgetShare current = this.subComActivityDetailPlanItemBudgetShareRepository.findById(currentId);
        current = (SubComActivityDetailPlanItemBudgetShare)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        SubComActivityDetailPlanItemBudgetShareVo oldVo = (SubComActivityDetailPlanItemBudgetShareVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, SubComActivityDetailPlanItemBudgetShareVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.subComActivityDetailPlanItemBudgetShareRepository.saveOrUpdate((Object)current);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityDetailPlanItemBudgetShareEventListener subComActivityDetailPlanItemBudgetShareEventListener : this.eventListeners) {
                subComActivityDetailPlanItemBudgetShareEventListener.onUpdate(oldVo, subComActivityDetailPlanItemBudgetShareVo);
            }
        }
        SubComActivityDetailPlanItemBudgetShareLogEventDto logEventDto = new SubComActivityDetailPlanItemBudgetShareLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(subComActivityDetailPlanItemBudgetShareVo);
        SerializableBiConsumer & Serializable onUpdate = SubComActivityDetailPlanItemBudgetShareLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComActivityDetailPlanItemBudgetShareLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemBudgetShareRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemBudgetShareRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemBudgetShareRepository.updateDelFlagByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByPlanCode(String planCode) {
        Validate.notBlank((CharSequence)planCode, (String)"\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemBudgetShareRepository.updateDelFlagByPlanCode(planCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByPlanItemCode(String planItemCode) {
        Validate.notBlank((CharSequence)planItemCode, (String)"\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemBudgetShareRepository.updateDelFlagByPlanItemCode(planItemCode);
    }

    public List<SubComActivityDetailPlanItemBudgetShareVo> findConstituentDetailPlanCode(String constituentDetailPlanCode) {
        Validate.notBlank((CharSequence)constituentDetailPlanCode, (String)"\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)this.subComActivityDetailPlanItemBudgetShareRepository.lambdaQuery().eq(SubComActivityDetailPlanItemBudgetShare::getConstituentDetailPlanCode, (Object)constituentDetailPlanCode)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            Collection subComActivityDetailPlanItemBudgetShareVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, SubComActivityDetailPlanItemBudgetShare.class, SubComActivityDetailPlanItemBudgetShareVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)subComActivityDetailPlanItemBudgetShareVos;
        }
        return new ArrayList<SubComActivityDetailPlanItemBudgetShareVo>();
    }

    private void createValidation(SubComActivityDetailPlanItemBudgetShareDto subComActivityDetailPlanItemBudgetShareVo) {
        this.validation(subComActivityDetailPlanItemBudgetShareVo);
    }

    private void updateValidation(SubComActivityDetailPlanItemBudgetShareDto subComActivityDetailPlanItemBudgetShareVo) {
        this.validation(subComActivityDetailPlanItemBudgetShareVo);
    }

    private void validation(SubComActivityDetailPlanItemBudgetShareDto subComActivityDetailPlanItemBudgetShareVo) {
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> useMonthBudgetByCode(List<String> constituentDetailPlanCodeList) {
        List<SubComActivityDetailPlanItemBudgetShare> activityPlanBudgets = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanCodeList(constituentDetailPlanCodeList);
        List<String> monthBudgetCodeList = activityPlanBudgets.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getMonthBudgetCode())).map(SubComActivityDetailPlanItemBudgetShare::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean lockSuccess = this.subComMonthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lockSuccess, (String)("\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97" + monthBudgetCodeList + "\u52a0\u9501\u5931\u8d25,\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c!"));
        this.useMonthBudget(activityPlanBudgets);
        return monthBudgetCodeList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void useMonthBudget(List<SubComActivityDetailPlanItemBudgetShare> budgetList) {
        List budgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0).map(item -> new OperateMonthBudgetDto((SubComActivityDetailPlanItemBudgetShare)((Object)item)){
            final /* synthetic */ SubComActivityDetailPlanItemBudgetShare val$item;
            {
                this.val$item = subComActivityDetailPlanItemBudgetShare;
                this.setBusinessCode(this.val$item.getConstituentDetailPlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(budgetOperateList)) {
            this.subComMonthBudgetService.operateBudget(budgetOperateList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> returnMonthBudgetByPlanCodeList(List<String> constituentDetailPlanCodeList) {
        if (CollectionUtil.isEmpty(constituentDetailPlanCodeList)) {
            return Collections.emptyList();
        }
        List<SubComActivityDetailPlanItemBudgetShare> activityPlanBudgets = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanCodeList(constituentDetailPlanCodeList);
        List<String> monthBudgetCodeList = activityPlanBudgets.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getMonthBudgetCode())).map(SubComActivityDetailPlanItemBudgetShare::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean lockSuccess = this.subComMonthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lockSuccess, (String)("\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97" + monthBudgetCodeList + "\u52a0\u9501\u5931\u8d25,\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c!"));
        this.returnMonthBudget(activityPlanBudgets);
        return monthBudgetCodeList;
    }

    public List<SubComActivityDetailPlanItemBudgetShareVo> findDetailByPlanItemCodes(List<String> detailItemCodes) {
        List<SubComActivityDetailPlanItemBudgetShare> subComActivityDetailPlanItemBudgetShares = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCodeList(detailItemCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(subComActivityDetailPlanItemBudgetShares)) {
            return Lists.newArrayList();
        }
        Collection subComActivityDetailPlanItemBudgetShareVos = this.nebulaToolkitService.copyCollectionByWhiteList(subComActivityDetailPlanItemBudgetShares, SubComActivityDetailPlanItemBudgetShare.class, SubComActivityDetailPlanItemBudgetShareVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)subComActivityDetailPlanItemBudgetShareVos;
    }

    @Transactional(rollbackFor={Exception.class})
    public void returnMonthBudget(List<SubComActivityDetailPlanItemBudgetShare> budgetList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(budgetList)) {
            return;
        }
        List budgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0).map(item -> new OperateMonthBudgetDto((SubComActivityDetailPlanItemBudgetShare)((Object)item)){
            final /* synthetic */ SubComActivityDetailPlanItemBudgetShare val$item;
            {
                this.val$item = subComActivityDetailPlanItemBudgetShare;
                this.setBusinessCode(this.val$item.getConstituentDetailPlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(budgetOperateList)) {
            this.subComMonthBudgetService.operateBudget(budgetOperateList);
        }
    }
}

