/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemBudgetShareDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDetailPlanItemPageCacheHelper
extends MnPageCacheHelper<SubComActivityDetailPlanItemVo, SubComActivityDetailPlanItemDto> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService activityConstituentDetailPlanItemVoService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public String getCacheKeyPrefix() {
        return "activity_const_detail_plan:item_cache:";
    }

    public Class<SubComActivityDetailPlanItemDto> getDtoClass() {
        return SubComActivityDetailPlanItemDto.class;
    }

    public Class<SubComActivityDetailPlanItemVo> getVoClass() {
        return SubComActivityDetailPlanItemVo.class;
    }

    public List<SubComActivityDetailPlanItemDto> findDtoListFromRepository(SubComActivityDetailPlanItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getConstituentDetailPlanCode())) {
            return Lists.newArrayList();
        }
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List allVoList = this.activityConstituentDetailPlanItemVoService.findDetailByPlanCode(dto.getConstituentDetailPlanCode());
        Collection allDtoList = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)allVoList, SubComActivityDetailPlanItemVo.class, SubComActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<SubComActivityDetailPlanItemDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemDto::getActivityTemplateCode));
        for (Map.Entry<String, List<SubComActivityDetailPlanItemDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode, entry.getKey());
            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode, entry.getKey());
            Map newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            this.redisService.lPushAll(thisRedisIdCacheKey, Long.valueOf(this.getExpireTime()), entry.getValue().stream().map(this::getDtoKey).toArray());
            this.redisTemplate.opsForHash().putAll((Object)thisRedisDataCacheKey, newItemMap);
            this.redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }
        return allMap.get(templateCode);
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<SubComActivityDetailPlanItemDto> newItem(String cacheKey, List<SubComActivityDetailPlanItemDto> itemList) {
        SubComActivityDetailPlanItemDto newItem = new SubComActivityDetailPlanItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        newItem.setActivityTemplateCode(templateCode);
        return Lists.newArrayList((Object[])new SubComActivityDetailPlanItemDto[]{newItem});
    }

    public List<SubComActivityDetailPlanItemDto> copyItem(String cacheKey, List<SubComActivityDetailPlanItemDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, SubComActivityDetailPlanItemDto.class, SubComActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (SubComActivityDetailPlanItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setConstituentDetailPlanItemCode(null);
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<SubComActivityDetailPlanItemDto> itemList) {
        super.updateItem(cacheKey, itemList);
        for (SubComActivityDetailPlanItemDto itemDto : itemList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            BigDecimal headFeeAmount = BigDecimal.ZERO;
            BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
            for (SubComActivityDetailPlanItemBudgetShareDto budgetDto : itemDto.getBudgetShares()) {
                if (StringUtils.isEmpty((CharSequence)budgetDto.getFeeSourceCode()) || null == budgetDto.getUseAmount()) continue;
                if (FeeSourceEnum.AUTO_FEE.getCode().equals(budgetDto.getFeeSourceCode())) {
                    regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(budgetDto.getUseAmount());
                    continue;
                }
                if (!FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budgetDto.getFeeSourceCode()) && !FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budgetDto.getFeeSourceCode())) continue;
                headFeeAmount = headFeeAmount.add(budgetDto.getUseAmount());
            }
            itemDto.setHeadquartersSupportedAmount(headFeeAmount);
            itemDto.setSubComAutoAmount(regionAutomaticFeeAmount);
            itemDto.setTotalCost(headFeeAmount.add(regionAutomaticFeeAmount));
        }
    }

    public Object getDtoKey(SubComActivityDetailPlanItemDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(SubComActivityDetailPlanItemDto dto) {
        return dto.getChecked();
    }

    public void fillVoListProperties(List<SubComActivityDetailPlanItemVo> records) {
        super.fillVoListProperties(records);
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        for (SubComActivityDetailPlanItemVo record : records) {
            record.setChecked(BooleanEnum.FALSE.getNumStr());
        }
    }

    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        return redisCacheInitKey.replace(templateCode, "");
    }
}

