/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItemProductShare;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemProductShareRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemProductShareDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.log.SubComActivityDetailPlanItemProductShareLogEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.SubComActivityDetailPlanItemProductShareEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.log.SubComActivityDetailPlanItemProductShareLogEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemProductShareVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemBudgetShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemProductShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="subComActivityDetailPlanItemProductShareService")
public class SubComActivityDetailPlanItemProductShareVoServiceImpl
implements SubComActivityDetailPlanItemProductShareVoService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanItemProductShareVoServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanItemProductShareRepository subComActivityDetailPlanItemProductShareRepository;
    @Autowired(required=false)
    private List<SubComActivityDetailPlanItemProductShareEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;

    public Page<SubComActivityDetailPlanItemProductShareVo> findByConditions(Pageable pageable, SubComActivityDetailPlanItemProductShareDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityDetailPlanItemProductShareDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComActivityDetailPlanItemProductShareRepository.findByConditions((Page<SubComActivityDetailPlanItemProductShareVo>)page, dto);
    }

    public SubComActivityDetailPlanItemProductShareVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SubComActivityDetailPlanItemProductShare subComActivityDetailPlanItemProductShare = this.subComActivityDetailPlanItemProductShareRepository.findById(id);
        if (subComActivityDetailPlanItemProductShare == null) {
            return null;
        }
        return (SubComActivityDetailPlanItemProductShareVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDetailPlanItemProductShare, SubComActivityDetailPlanItemProductShareVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SubComActivityDetailPlanItemProductShareVo> findDetailByPlanItemCode(String itemPlanCode) {
        if (StringUtils.isBlank((CharSequence)itemPlanCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItemProductShare> itemProductShares = this.subComActivityDetailPlanItemProductShareRepository.findByPlanItemCode(itemPlanCode);
        if (CollectionUtils.isEmpty(itemProductShares)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(itemProductShares, SubComActivityDetailPlanItemProductShare.class, SubComActivityDetailPlanItemProductShareVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Transactional
    public void create(SubComActivityDetailPlanItemProductShareDto subComActivityDetailPlanItemProductShareVo) {
        this.createValidation(subComActivityDetailPlanItemProductShareVo);
        subComActivityDetailPlanItemProductShareVo.setTenantCode(TenantUtils.getTenantCode());
        subComActivityDetailPlanItemProductShareVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        subComActivityDetailPlanItemProductShareVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        SubComActivityDetailPlanItemProductShare subComActivityDetailPlanItemProductShare = (SubComActivityDetailPlanItemProductShare)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDetailPlanItemProductShareVo, SubComActivityDetailPlanItemProductShare.class, HashSet.class, ArrayList.class, new String[0]));
        this.subComActivityDetailPlanItemProductShareRepository.saveOrUpdate((Object)subComActivityDetailPlanItemProductShare);
        subComActivityDetailPlanItemProductShareVo.setId(subComActivityDetailPlanItemProductShare.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityDetailPlanItemProductShareEventListener subComActivityDetailPlanItemProductShareEventListener : this.eventListeners) {
                subComActivityDetailPlanItemProductShareEventListener.onCreate(subComActivityDetailPlanItemProductShareVo);
            }
        }
        SubComActivityDetailPlanItemProductShareLogEventDto logEventDto = new SubComActivityDetailPlanItemProductShareLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(subComActivityDetailPlanItemProductShareVo);
        SerializableBiConsumer & Serializable onCreate = SubComActivityDetailPlanItemProductShareLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComActivityDetailPlanItemProductShareLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    @Transactional
    public void update(SubComActivityDetailPlanItemProductShareDto subComActivityDetailPlanItemProductShareVo) {
        this.updateValidation(subComActivityDetailPlanItemProductShareVo);
        String currentId = subComActivityDetailPlanItemProductShareVo.getId();
        SubComActivityDetailPlanItemProductShare current = this.subComActivityDetailPlanItemProductShareRepository.findById(currentId);
        current = (SubComActivityDetailPlanItemProductShare)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        SubComActivityDetailPlanItemProductShareVo oldVo = (SubComActivityDetailPlanItemProductShareVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, SubComActivityDetailPlanItemProductShareVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.subComActivityDetailPlanItemProductShareRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityDetailPlanItemProductShareEventListener subComActivityDetailPlanItemProductShareEventListener : this.eventListeners) {
                subComActivityDetailPlanItemProductShareEventListener.onUpdate(oldVo, subComActivityDetailPlanItemProductShareVo);
            }
        }
        SubComActivityDetailPlanItemProductShareLogEventDto logEventDto = new SubComActivityDetailPlanItemProductShareLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(subComActivityDetailPlanItemProductShareVo);
        SerializableBiConsumer & Serializable onUpdate = SubComActivityDetailPlanItemProductShareLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComActivityDetailPlanItemProductShareLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemProductShareRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemProductShareRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemProductShareRepository.updateDelFlagByIds(ids);
    }

    public void updateDelFlagByPlanCode(String planCode) {
        Validate.notBlank((CharSequence)planCode, (String)"\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemProductShareRepository.updateDelFlagByPlanCode(planCode);
    }

    public void updateDelFlagByPlanItemCode(String planItemCode) {
        Validate.notBlank((CharSequence)planItemCode, (String)"\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityDetailPlanItemProductShareRepository.updateDelFlagByPlanItemCode(planItemCode);
    }

    public List<SubComActivityDetailPlanItemProductShareVo> findListByItem(SubComActivityDetailPlanItemVo item) {
        if (item != null) {
            ProductDto productDto = new ProductDto();
            productDto.setProductBrandCode(item.getProductBrandCode());
            productDto.setProductCategoryCode(item.getProductCategoryCode());
            productDto.setProductLevelCode(item.getProductItemCode());
            productDto.setProductCode(item.getProductCode());
            List productVoList = this.productVoService.queryCondition(productDto);
            if (CollectionUtils.isNotEmpty((Collection)productVoList)) {
                return this.fullShareVos(productVoList, item);
            }
        }
        return new ArrayList<SubComActivityDetailPlanItemProductShareVo>();
    }

    private List<SubComActivityDetailPlanItemProductShareVo> fullShareVos(List<ProductVo> productVoList, SubComActivityDetailPlanItemVo item) {
        List<SubComActivityDetailPlanItemProductShareVo> shareVos = this.buildPlanItemVoByProduct(productVoList);
        this.getProductShareRatio(shareVos, item);
        this.calAmount(shareVos, item);
        return shareVos;
    }

    public Page<SubComActivityDetailPlanItemProductShareVo> findListByItemPage(Pageable pageable, SubComActivityDetailPlanItemVo item) {
        Validate.notNull((Object)item, (String)"\u4ea7\u54c1\u884c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page();
        ProductPaginationDto productDto = new ProductPaginationDto();
        productDto.setProductBrandCode(item.getProductBrandCode());
        productDto.setProductCategoryCode(item.getProductCategoryCode());
        productDto.setProductLevelCode(item.getProductItemCode());
        productDto.setProductCode(item.getProductCode());
        Page productVoPage = this.productVoService.findByConditions(pageable, productDto);
        page.setTotal(productVoPage.getTotal());
        page.setPages(productVoPage.getPages());
        page.setSize(productVoPage.getSize());
        if (CollectionUtils.isNotEmpty((Collection)productVoPage.getRecords())) {
            page.setRecords(this.fullShareVos(productVoPage.getRecords(), item));
        }
        return page;
    }

    public List<SubComActivityDetailPlanItemProductShareVo> findApportionProductByActivityDetailCodes(Set<String> activityDetailCodeSet) {
        List<SubComActivityDetailPlanItemProductShare> subComActivityDetailPlanItemProductShareList = this.subComActivityDetailPlanItemProductShareRepository.findApportionProductByActivityDetailCodes(activityDetailCodeSet);
        if (CollectionUtils.isNotEmpty(subComActivityDetailPlanItemProductShareList)) {
            Collection subComActivityDetailPlanItemProductShareVos = this.nebulaToolkitService.copyCollectionByBlankList(subComActivityDetailPlanItemProductShareList, SubComActivityDetailPlanItemProductShare.class, SubComActivityDetailPlanItemProductShareVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)subComActivityDetailPlanItemProductShareVos;
        }
        return new ArrayList<SubComActivityDetailPlanItemProductShareVo>();
    }

    private List<SubComActivityDetailPlanItemProductShareVo> buildPlanItemVoByProduct(List<ProductVo> productVoList) {
        ArrayList<SubComActivityDetailPlanItemProductShareVo> shareVos = new ArrayList<SubComActivityDetailPlanItemProductShareVo>(productVoList.size());
        productVoList.forEach(productVo -> {
            SubComActivityDetailPlanItemProductShareVo subComActivityDetailPlanItemProductShareVo = new SubComActivityDetailPlanItemProductShareVo();
            subComActivityDetailPlanItemProductShareVo.setProductCode(productVo.getProductCode());
            subComActivityDetailPlanItemProductShareVo.setProductName(productVo.getProductName());
            shareVos.add(subComActivityDetailPlanItemProductShareVo);
        });
        return shareVos;
    }

    private void getProductShareRatio(List<SubComActivityDetailPlanItemProductShareVo> shareVos, SubComActivityDetailPlanItemVo item) {
        List productCodes = shareVos.stream().map(SubComActivityDetailPlanItemProductShareVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toList());
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setSalesProductCodeList(productCodes);
        List salesPlanVos = this.salesPlanService.findByConditions(salesPlanDto);
        if (CollectionUtils.isNotEmpty((Collection)salesPlanVos)) {
            String thisSalesOrganizationCode = this.findSalesOrganizationCode(item.getOrgCode());
            if (StringUtils.isEmpty((CharSequence)thisSalesOrganizationCode)) {
                return;
            }
            BigDecimal totalSalesPlanAmount = salesPlanVos.stream().map(SalesPlanVo::getPlanAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            Map<String, List<SalesPlanVo>> salesGroup = salesPlanVos.stream().collect(Collectors.groupingBy(x -> x.getProductCode() + x.getYearMonthLy() + x.getCustomerCode() + x.getSalesInstitutionCode()));
            for (SubComActivityDetailPlanItemProductShareVo shareVo : shareVos) {
                String key = shareVo.getProductCode() + DateUtil.format((Date)item.getFeeYearMonth(), (String)"yyyy-MM") + item.getCustomerCode() + thisSalesOrganizationCode;
                Optional<List<SalesPlanVo>> optionalSalesPlanVos = Optional.ofNullable(salesGroup.get(key));
                optionalSalesPlanVos.ifPresent(planVos -> {
                    BigDecimal thisProductPlanAmount = planVos.stream().map(SalesPlanVo::getPlanAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    shareVo.setProductRatio(NumberUtil.div((BigDecimal)totalSalesPlanAmount, (BigDecimal)thisProductPlanAmount, (int)6, (RoundingMode)RoundingMode.HALF_UP).toString());
                });
            }
            NumberUtil.div((Number)item.getTotalCost(), (Number)totalSalesPlanAmount, (int)2);
        }
    }

    private String findSalesOrganizationCode(String orgCode) {
        if (StringUtils.isEmpty((CharSequence)orgCode)) {
            return "";
        }
        OrgVo orgVo = this.orgVoService.findByOrgCode(orgCode);
        if (orgVo == null) {
            return "";
        }
        SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(orgVo.getSalesOrgCode());
        if (salesOrgVo == null) {
            return "";
        }
        if (Objects.equals(salesOrgVo.getSalesOrgLevel(), SalesOrgLevelTypeEnum.MECHANISM.getCode())) {
            return salesOrgVo.getSalesOrgCode();
        }
        if (orgVo.getParent() == null) {
            return "";
        }
        return this.findSalesOrganizationCode(orgVo.getParent().getOrgCode());
    }

    private void calAmount(List<SubComActivityDetailPlanItemProductShareVo> shareVos, SubComActivityDetailPlanItemVo item) {
        if (CollectionUtils.isNotEmpty((Collection)item.getBudgetShares())) {
            Map<String, List<SubComActivityDetailPlanItemBudgetShareVo>> budgetGroup = item.getBudgetShares().stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemBudgetShareVo::getFeeSourceCode));
            BigDecimal internalFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.INTERNAL_POINT_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDetailPlanItemBudgetShareVo::getUseAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal offFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.OFF_POINT_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDetailPlanItemBudgetShareVo::getUseAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal autoFee = ((List)Optional.ofNullable(budgetGroup.get(FeeSourceEnum.AUTO_FEE.getCode())).orElse(new ArrayList(0))).stream().map(SubComActivityDetailPlanItemBudgetShareVo::getUseAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (SubComActivityDetailPlanItemProductShareVo shareVo : shareVos) {
                if (!StringUtils.isNotBlank((CharSequence)shareVo.getProductRatio())) continue;
                BigDecimal ratio = NumberUtil.div((Number)new BigDecimal(shareVo.getProductRatio()), (Number)new BigDecimal("100"));
                shareVo.setOffAmount(NumberUtil.mul((Number)offFee, (Number)ratio));
                shareVo.setInternalAmount(NumberUtil.mul((Number)internalFee, (Number)ratio));
                shareVo.setAutoAmount(NumberUtil.mul((Number)autoFee, (Number)ratio));
                shareVo.setTotalAmount(NumberUtil.add((BigDecimal[])new BigDecimal[]{shareVo.getOffAmount(), shareVo.getInternalAmount(), shareVo.getAutoAmount()}));
            }
        }
    }

    private void createValidation(SubComActivityDetailPlanItemProductShareDto subComActivityDetailPlanItemProductShareVo) {
        this.validation(subComActivityDetailPlanItemProductShareVo);
    }

    private void updateValidation(SubComActivityDetailPlanItemProductShareDto subComActivityDetailPlanItemProductShareVo) {
        this.validation(subComActivityDetailPlanItemProductShareVo);
    }

    private void validation(SubComActivityDetailPlanItemProductShareDto subComActivityDetailPlanItemProductShareVo) {
        Validate.notNull((Object)subComActivityDetailPlanItemProductShareVo.getConstituentDetailPlanItemCode(), (String)"\u5173\u8054\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)subComActivityDetailPlanItemProductShareVo.getConstituentDetailPlanCode(), (String)"\u5173\u8054\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

