/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.form.sdk.enums.SubComActivityValidationFormCodeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanStatusEnum;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ShareTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.SubComActivityDesignDetailAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlan;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItemBudgetShare;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemBudgetShareRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.SubComActivityDetailPlanItemVoCacheService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.log.SubComActivityDetailPlanItemLogEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.SubComActivityDetailPlanItemEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.log.ActivityConstituentDetailPlanItemLogEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.PushSubActivityToThirdSystemService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemBudgetShareVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemFileVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemProductShareVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.ActivityDetailManageActivityTypeFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.ActivityDetailManageChannelFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.ActivityDetailManageOneProductFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.AuditDetailSonCompanyBudgetWarnVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.DetailedAccountOfActivityVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemBudgetShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanMonitorVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityConstituentDetailPlanItemService")
public class SubComActivityDetailPlanItemVoServiceImpl
implements SubComActivityDetailPlanItemVoService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanItemVoServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanItemRepository activityConstituentDetailPlanItemRepository;
    @Autowired(required=false)
    private List<SubComActivityDetailPlanItemEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private MnPageCacheHelper<SubComActivityDetailPlanItemVo, SubComActivityDetailPlanItemDto> helper;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemFileVoService activityConstituentDetailPlanItemFileVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareVoService subComActivityDetailPlanItemBudgetShareVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemProductShareVoService subComActivityDetailPlanItemProductShareVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoCacheService subComActivityDetailPlanItemVoCacheService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareRepository subComActivityDetailPlanItemBudgetShareRepository;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;
    @Autowired(required=false)
    private PushSubActivityToThirdSystemService pushSubActivityToThirdSystemService;
    @Autowired(required=false)
    private SubComActivityDetailPlanRepository subComActivityDetailPlanRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    public Page<SubComActivityDetailPlanItemVo> findByConditions(Pageable pageable, SubComActivityDetailPlanItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityDetailPlanItemDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SubComActivityDetailPlanItemVo> planItemVoPage = this.activityConstituentDetailPlanItemRepository.findByConditions((Page<SubComActivityDetailPlanItemVo>)page, dto);
        List records = planItemVoPage.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List<SubComActivityDetailPlanItemBudgetShareVo> planItemBudgetShareVos;
            ArrayList<SubComActivityDetailPlanItemVo> planItemVos = new ArrayList<SubComActivityDetailPlanItemVo>(records.size());
            List<String> list = records.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list) && org.apache.commons.collections.CollectionUtils.isNotEmpty(planItemBudgetShareVos = this.subComActivityDetailPlanItemBudgetShareRepository.findAmount(list))) {
                Map<String, List<SubComActivityDetailPlanItemBudgetShareVo>> map = planItemBudgetShareVos.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemBudgetShareVo::getConstituentDetailPlanItemCode));
                for (SubComActivityDetailPlanItemVo record : records) {
                    List<SubComActivityDetailPlanItemBudgetShareVo> budgetShareVos = map.get(record.getConstituentDetailPlanItemCode());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(budgetShareVos) && budgetShareVos.size() > 0) {
                        SubComActivityDetailPlanItemBudgetShareVo subComActivityDetailPlanItemBudgetShareVo = budgetShareVos.get(0);
                        record.setExtraBudgetaryAmount(subComActivityDetailPlanItemBudgetShareVo.getExtraBudgetaryAmount());
                        record.setInternalBudgetAmount(subComActivityDetailPlanItemBudgetShareVo.getInternalBudgetAmount());
                        record.setSelfInvestedBudgetAmount(subComActivityDetailPlanItemBudgetShareVo.getSelfInvestedBudgetAmount());
                        record.setInPointBudget(subComActivityDetailPlanItemBudgetShareVo.getInPointBudget());
                        record.setInPointBudgetItems(subComActivityDetailPlanItemBudgetShareVo.getInPointBudgetItems());
                        record.setOffPointBudget(subComActivityDetailPlanItemBudgetShareVo.getOffPointBudget());
                        record.setOffPointBudgetItems(subComActivityDetailPlanItemBudgetShareVo.getOffPointBudgetItems());
                        record.setSelfInvestmentBudget(subComActivityDetailPlanItemBudgetShareVo.getSelfInvestmentBudget());
                        record.setSelfInvestedBudgetItems(subComActivityDetailPlanItemBudgetShareVo.getSelfInvestedBudgetItems());
                    }
                    planItemVos.add(record);
                }
                return planItemVoPage.setRecords(planItemVos);
            }
        }
        return planItemVoPage;
    }

    public SubComActivityDetailPlanItemVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SubComActivityDetailPlanItem activityConstituentDetailPlanItem = this.activityConstituentDetailPlanItemRepository.findById(id);
        if (activityConstituentDetailPlanItem == null) {
            return null;
        }
        SubComActivityDetailPlanItemVo subComActivityDetailPlanItemVo = (SubComActivityDetailPlanItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityConstituentDetailPlanItem, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fullDetail(subComActivityDetailPlanItemVo);
        return subComActivityDetailPlanItemVo;
    }

    public SubComActivityDetailPlanItemVo findDetailByItemCode(String itemCode) {
        if (StringUtils.isBlank((CharSequence)itemCode)) {
            return null;
        }
        SubComActivityDetailPlanItemVo subComActivityDetailPlanItemVo = this.activityConstituentDetailPlanItemRepository.findDetailByItemCode(itemCode);
        if (Objects.isNull(subComActivityDetailPlanItemVo)) {
            return null;
        }
        this.fullDetail(subComActivityDetailPlanItemVo);
        return subComActivityDetailPlanItemVo;
    }

    public List<SubComActivityDetailPlanItemVo> findDetailByPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItem> activityConstituentDetailPlanItems = this.activityConstituentDetailPlanItemRepository.findByPlanCode(planCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(activityConstituentDetailPlanItems)) {
            return Lists.newArrayList();
        }
        ArrayList activityConstituentDetailPlanItemVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList(activityConstituentDetailPlanItems, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]));
        activityConstituentDetailPlanItemVos.forEach(this::fullDetail);
        this.convertSubComActivityDetailPlanItemProperty(activityConstituentDetailPlanItemVos);
        return activityConstituentDetailPlanItemVos;
    }

    public List<SubComActivityDetailPlanItemVo> findDetailByPlanCodes(List<String> planCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItem> activityConstituentDetailPlanItems = this.activityConstituentDetailPlanItemRepository.findByPlanCodes(planCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(activityConstituentDetailPlanItems)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList(activityConstituentDetailPlanItems, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<SubComActivityDetailPlanItemVo> findDetailByItemCodeList(List<String> itemCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodeList)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItem> activityConstituentDetailPlanItems = this.activityConstituentDetailPlanItemRepository.findItemsByPlanItemCodes(itemCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(activityConstituentDetailPlanItems)) {
            return Lists.newArrayList();
        }
        ArrayList activityConstituentDetailPlanItemVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList(activityConstituentDetailPlanItems, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]));
        activityConstituentDetailPlanItemVos.forEach(this::fullDetail);
        this.convertSubComActivityDetailPlanItemProperty(activityConstituentDetailPlanItemVos);
        return activityConstituentDetailPlanItemVos;
    }

    public void convertSubComActivityDetailPlanItemProperty(List<SubComActivityDetailPlanItemVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_source");
                if (!CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                log.error("\u5206\u516c\u53f8\u8d39\u7528\u6765\u6e90\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (SubComActivityDetailPlanItemVo vo : list) {
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)vo.getBudgetShares())) continue;
            for (SubComActivityDetailPlanItemBudgetShareVo budgetShare : vo.getBudgetShares()) {
                if (!StringUtils.isNotEmpty((CharSequence)budgetShare.getFeeSourceCode())) continue;
                budgetShare.setFeeSourceName(feeSourceMap.getOrDefault(budgetShare.getFeeSourceCode(), budgetShare.getFeeSourceCode()));
            }
        }
    }

    public List<SubComActivityDetailPlanItemVo> findDetailByPlanItemCode(String detailPlanCode) {
        if (StringUtils.isBlank((CharSequence)detailPlanCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItem> planItems = this.activityConstituentDetailPlanItemRepository.findByPlanItemCode(detailPlanCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(planItems)) {
            return Lists.newArrayList();
        }
        ArrayList activityConstituentDetailPlanItemVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList(planItems, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]));
        activityConstituentDetailPlanItemVos.forEach(this::fullDetail);
        return activityConstituentDetailPlanItemVos;
    }

    public List<SubComActivityDetailPlanItemVo> findItemsByPlanItemCodes(List<String> detailPlanItemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItem> detailPlanItemList = this.activityConstituentDetailPlanItemRepository.findItemsByPlanItemCodes(detailPlanItemCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailPlanItemList)) {
            return Lists.newArrayList();
        }
        List itemVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(detailPlanItemList, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDetailPlanName(itemVoList);
        return itemVoList;
    }

    private void fullDetail(SubComActivityDetailPlanItemVo activityConstituentDetailPlanItemVo) {
        activityConstituentDetailPlanItemVo.setFileList(this.activityConstituentDetailPlanItemFileVoService.findDetailByPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode()));
        activityConstituentDetailPlanItemVo.setBudgetShares(this.subComActivityDetailPlanItemBudgetShareVoService.findDetailByPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode()));
        activityConstituentDetailPlanItemVo.setProductShares(this.subComActivityDetailPlanItemProductShareVoService.findDetailByPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode()));
    }

    @Transactional
    public void create(SubComActivityDetailPlanItemDto activityConstituentDetailPlanItemVo) {
        this.validation(activityConstituentDetailPlanItemVo);
        this.validationTotalQuantityOrNot(activityConstituentDetailPlanItemVo);
        activityConstituentDetailPlanItemVo.setTenantCode(TenantUtils.getTenantCode());
        activityConstituentDetailPlanItemVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityConstituentDetailPlanItemVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        activityConstituentDetailPlanItemVo.setOrderShareInterfaceState(InterfacePushStateEnum.NOT_PUSH.getCode());
        activityConstituentDetailPlanItemVo.setSapInterfaceState(InterfacePushStateEnum.NOT_PUSH.getCode());
        SubComActivityDetailPlanItem activityConstituentDetailPlanItem = (SubComActivityDetailPlanItem)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityConstituentDetailPlanItemVo, SubComActivityDetailPlanItem.class, HashSet.class, ArrayList.class, new String[0]));
        this.activityConstituentDetailPlanItemRepository.saveOrUpdate((Object)activityConstituentDetailPlanItem);
        activityConstituentDetailPlanItemVo.setId(activityConstituentDetailPlanItem.getId());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityDetailPlanItemEventListener activityConstituentDetailPlanItemEventListener : this.eventListeners) {
                activityConstituentDetailPlanItemEventListener.onCreate(activityConstituentDetailPlanItemVo);
            }
        }
        this.buildDetail(activityConstituentDetailPlanItemVo);
        SubComActivityDetailPlanItemLogEventDto logEventDto = new SubComActivityDetailPlanItemLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(activityConstituentDetailPlanItemVo);
        SerializableBiConsumer & Serializable onCreate = ActivityConstituentDetailPlanItemLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityConstituentDetailPlanItemLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    private void validationTotalQuantityOrNot(SubComActivityDetailPlanItemDto newItem) {
        if (TotalQuantityOrNotEnum.N.getCode().equals(newItem.getIsSupplyAmount()) || TotalQuantityOrNotEnum.Y.getCode().equals(newItem.getIsSupplyAmount())) {
            String[] split;
            if (StringUtils.isNotBlank((CharSequence)newItem.getCustomerCode())) {
                split = newItem.getCustomerCode().split(",");
                newItem.setCustomerCode(split[0]);
            }
            if (StringUtils.isNotBlank((CharSequence)newItem.getCustomerName())) {
                split = newItem.getCustomerName().split(",");
                newItem.setCustomerName(split[0]);
            }
        }
    }

    @Transactional
    public void update(SubComActivityDetailPlanItemDto activityConstituentDetailPlanItemVo) {
        this.updateValidation(activityConstituentDetailPlanItemVo);
        this.validationTotalQuantityOrNot(activityConstituentDetailPlanItemVo);
        String currentId = activityConstituentDetailPlanItemVo.getId();
        SubComActivityDetailPlanItem current = this.activityConstituentDetailPlanItemRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SubComActivityDetailPlanItemVo oldVo = (SubComActivityDetailPlanItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.activityConstituentDetailPlanItemRepository.saveOrUpdate((Object)current);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityDetailPlanItemEventListener activityConstituentDetailPlanItemEventListener : this.eventListeners) {
                activityConstituentDetailPlanItemEventListener.onUpdate(oldVo, activityConstituentDetailPlanItemVo);
            }
        }
        this.activityConstituentDetailPlanItemFileVoService.removeByPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode());
        this.subComActivityDetailPlanItemBudgetShareVoService.updateDelFlagByPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode());
        this.subComActivityDetailPlanItemProductShareVoService.updateDelFlagByPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode());
        this.buildDetail(activityConstituentDetailPlanItemVo);
        SubComActivityDetailPlanItemLogEventDto logEventDto = new SubComActivityDetailPlanItemLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(activityConstituentDetailPlanItemVo);
        SerializableBiConsumer & Serializable onUpdate = ActivityConstituentDetailPlanItemLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityConstituentDetailPlanItemLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.activityConstituentDetailPlanItemRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.activityConstituentDetailPlanItemRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.activityConstituentDetailPlanItemRepository.updateDelFlagByIds(ids);
    }

    public void closeById(SubComActivityDetailPlanItemDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<SubComActivityDetailPlanItem> dtoList = this.activityConstituentDetailPlanItemRepository.findByIds(Lists.newArrayList((Object[])new String[]{dto.getId()}));
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(dtoList), (String)"\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u660e\u7ec6\u5b9e\u4f8b\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        SubComActivityDetailPlanItemVo detailPlanItemVo = (SubComActivityDetailPlanItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dtoList.get(0), SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        detailPlanItemVo.setReturnAmount(dto.getReturnAmount());
        Date now = DateUtil.getDate((SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        int startCompare = now.compareTo(detailPlanItemVo.getActivityBeginTime());
        int endCompare = now.compareTo(detailPlanItemVo.getActivityEndTime());
        String detailPlanStatus = detailPlanItemVo.getActivityStatus();
        if (!dto.isDealThings() && (ActivityPlanStatusEnum.allClose.getCode().equals(detailPlanStatus) || ActivityPlanStatusEnum.closed.getCode().equals(detailPlanStatus))) {
            throw new RuntimeException("\u6d3b\u52a8\u660e\u7ec6\u3010" + detailPlanItemVo.getConstituentDetailPlanItemCode() + "\u3011\u5df2\u5173\u95ed");
        }
        ArrayList<Object> voList = new ArrayList<Object>();
        List<Object> promotionNoList = new ArrayList();
        if (startCompare < 0) {
            if (TotalQuantityOrNotEnum.N.getCode().equals(detailPlanItemVo.getIsSupplyAmount())) {
                promotionNoList = this.activityConstituentDetailPlanItemRepository.findByPromotionNo(dto);
                promotionNoList.forEach(e -> {
                    e.setReturnAmount(e.getTotalCost());
                    e.setCloseAmount(e.getTotalCost());
                });
                voList.addAll(promotionNoList);
            }
            detailPlanItemVo.setReturnAmount(detailPlanItemVo.getTotalCost());
        } else if (endCompare <= 0) {
            Validate.notNull((Object)detailPlanItemVo.getReturnAmount(), (String)"\u91ca\u653e\u91d1\u989d\u5fc5\u586b\uff01", (Object[])new Object[0]);
            detailPlanItemVo.setActivityEndTime(now);
        }
        detailPlanItemVo.setActivityStatus(ActivityPlanStatusEnum.closed.getCode());
        BigDecimal returnAmount = dto.getReturnAmount();
        if (!dto.isDealThings()) {
            returnAmount = dto.getWillRefundAmount();
        }
        if (Objects.nonNull(returnAmount) && Objects.nonNull(detailPlanItemVo.getTotalCost()) && returnAmount.compareTo(detailPlanItemVo.getTotalCost()) < 0) {
            detailPlanItemVo.setActivityDetailStatus(ActivityStatusEnum.CLOSE_SOME_REBUDGET.getCode());
        } else {
            detailPlanItemVo.setActivityDetailStatus(ActivityStatusEnum.CLOSE_FULL_REBUDGET.getCode());
        }
        detailPlanItemVo.setCloseAmount(detailPlanItemVo.getReturnAmount());
        detailPlanItemVo.setCloseDate(new Date());
        voList.add(detailPlanItemVo);
        this.activityConstituentDetailPlanItemRepository.saveOrUpdateBatch(this.nebulaToolkitService.copyCollectionByBlankList(voList, SubComActivityDetailPlanItemVo.class, SubComActivityDetailPlanItem.class, HashSet.class, ArrayList.class, new String[0]));
        List<Object> returnBudgetList = Lists.newArrayList();
        if (!dto.isDealThings()) {
            returnBudgetList = voList.stream().filter(item -> !Objects.equals(item.getAuditType(), SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode())).collect(Collectors.toList());
        }
        this.returnBudget(returnBudgetList);
        this.pushSubActivityToThirdSystemService.closePushThirdSystemAsync((List)Lists.newArrayList((Object[])new String[]{detailPlanItemVo.getConstituentDetailPlanItemCode()}));
    }

    public void returnBudget(List<SubComActivityDetailPlanItemVo> voList) {
        if (CollectionUtil.isEmpty(voList)) {
            return;
        }
        List<String> itemCodeList = voList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List<SubComActivityDetailPlanItemBudgetShare> budgetShareList = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCodeList(itemCodeList);
        ArrayList operateMonthBudgetList = new ArrayList();
        Map<String, List<SubComActivityDetailPlanItemBudgetShare>> budgetShareMap = budgetShareList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemBudgetShare::getConstituentDetailPlanItemCode));
        voList.forEach(e -> {
            List shareList = (List)budgetShareMap.get(e.getConstituentDetailPlanItemCode());
            Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shareList), (String)("\u672a\u627e\u5230\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u3010" + e.getConstituentDetailPlanItemCode() + "\u3011\u6240\u5bf9\u5e94\u7684\u5206\u644a\u9884\u7b97\u4fe1\u606f"), (Object[])new Object[0]);
            String shareType = ((SubComActivityDetailPlanItemBudgetShare)((Object)((Object)shareList.get(0)))).getShareType();
            if (ShareTypeEnum.ratio.getCode().equals(shareType)) {
                shareList.forEach(share -> {
                    Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)share.getRatio()), (String)("\u660e\u7ec6\u7f16\u7801\u3010" + share.getConstituentDetailPlanItemCode() + "\u3011\u5206\u644a\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
                    OperateMonthBudgetDto operate = new OperateMonthBudgetDto();
                    operate.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operate.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    operate.setMonthBudgetCode(share.getMonthBudgetCode());
                    operate.setBusinessCode(share.getConstituentDetailPlanItemCode());
                    BigDecimal ratio = new BigDecimal(share.getRatio().replace("%", "")).divide(new BigDecimal(100), 4, RoundingMode.HALF_UP);
                    BigDecimal amount = e.getReturnAmount().multiply(ratio);
                    operate.setOperationAmount(amount);
                    operateMonthBudgetList.add(operate);
                    share.setCloseAmount(amount);
                });
                this.subComActivityDetailPlanItemBudgetShareRepository.saveOrUpdateBatch(shareList);
            } else {
                BigDecimal used = BigDecimal.ZERO;
                List sort = shareList.stream().sorted(Comparator.comparing(SubComActivityDetailPlanItemBudgetShare::getPriorityLevel).reversed()).collect(Collectors.toList());
                for (SubComActivityDetailPlanItemBudgetShare share2 : sort) {
                    BigDecimal amount;
                    OperateMonthBudgetDto operate = new OperateMonthBudgetDto();
                    operate.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operate.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    operate.setMonthBudgetCode(share2.getMonthBudgetCode());
                    operate.setBusinessCode(share2.getConstituentDetailPlanItemCode());
                    used = used.add(share2.getUseAmount());
                    if (used.compareTo(e.getReturnAmount()) < 0) {
                        amount = share2.getUseAmount();
                    } else {
                        BigDecimal newAmount = used.subtract(e.getReturnAmount());
                        amount = share2.getUseAmount().subtract(newAmount);
                    }
                    operate.setOperationAmount(amount);
                    share2.setCloseAmount(amount);
                    operateMonthBudgetList.add(operate);
                }
                this.subComActivityDetailPlanItemBudgetShareRepository.saveOrUpdateBatch(sort);
            }
        });
        this.subComMonthBudgetService.operateBudget(operateMonthBudgetList);
    }

    public void changeSonActivityDetailAuditInfo(List<SubComActivityDetailPlanItemDto> dtoList) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(dtoList), (String)"\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Set detailCodes = dtoList.stream().map(SubComActivityDetailPlanItemDto::getConstituentDetailPlanItemCode).collect(Collectors.toSet());
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(detailCodes), (String)"\u672a\u627e\u5230\u660e\u7ec6\u6570\u636e", (Object[])new Object[0]);
        List queryList = ((LambdaQueryChainWrapper)this.activityConstituentDetailPlanItemRepository.lambdaQuery().in(SubComActivityDetailPlanItem::getConstituentDetailPlanItemCode, detailCodes)).list();
        Map subComActivityDetailPlanItemMap = queryList.stream().collect(Collectors.toMap(SubComActivityDetailPlanItem::getConstituentDetailPlanItemCode, Function.identity()));
        ArrayList subComActivityDetailPlanItemList = new ArrayList();
        dtoList.forEach(item -> {
            SubComActivityDetailPlanItem subComActivityDetailPlanItem = (SubComActivityDetailPlanItem)((Object)((Object)subComActivityDetailPlanItemMap.get(item.getConstituentDetailPlanItemCode())));
            Validate.notNull((Object)((Object)subComActivityDetailPlanItem), (String)"\u672a\u67e5\u8be2\u5230\u660e\u7ec6\u7f16\u7801\u3010%s\u3011\u7684\u6570\u636e", (Object[])new Object[]{item.getConstituentDetailPlanItemCode()});
            SubComActivityDetailPlanItem subComActivityDetailPlanItem1 = new SubComActivityDetailPlanItem();
            subComActivityDetailPlanItem1.setId(subComActivityDetailPlanItem.getId());
            subComActivityDetailPlanItem1.setWholeAudit(item.getWholeAudit());
            if (YesOrNoEnum.YES.getCode().equals(item.getWholeAudit())) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                subComActivityDetailPlanItem1.setWholeAuditDate(df.format(new Date()));
            }
            subComActivityDetailPlanItem1.setAlreadyAuditAmount(Optional.ofNullable(subComActivityDetailPlanItem.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO).add(item.getAlreadyAuditAmount()));
            subComActivityDetailPlanItemList.add(subComActivityDetailPlanItem1);
        });
        this.activityConstituentDetailPlanItemRepository.updateBatchById(subComActivityDetailPlanItemList);
    }

    public int getMonitorDataCount(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return 0;
        }
        return this.activityConstituentDetailPlanItemRepository.getMonitorDataCount(tenantCode);
    }

    public Page<SubComActivityDetailPlanMonitorVo> getMonitorData(Pageable pageable, String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.getMonitorData((Page<SubComActivityDetailPlanMonitorVo>)page, tenantCode);
    }

    public void updatePlanItemPushOrderShareStatus(List<String> itemCodes, boolean success) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        this.activityConstituentDetailPlanItemRepository.updateDetailPlanItemPushStatus(itemCodes, success);
    }

    public void updateDetailPlanItemPushSapStatus(String itemCode, boolean success) {
        if (StringUtils.isBlank((CharSequence)itemCode)) {
            return;
        }
        this.activityConstituentDetailPlanItemRepository.updateDetailPlanItemPushSapStatus(itemCode, success);
    }

    private void updateValidation(SubComActivityDetailPlanItemDto activityConstituentDetailPlanItemVo) {
        this.validation(activityConstituentDetailPlanItemVo);
    }

    private void validation(SubComActivityDetailPlanItemDto activityConstituentDetailPlanItemVo) {
        Validate.notBlank((CharSequence)activityConstituentDetailPlanItemVo.getConstituentDetailPlanCode(), (String)"\u5173\u8054\u5206\u5b50\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityConstituentDetailPlanItemVo.getActivityTemplateCode(), (String)"\u5173\u8054\u6d3b\u52a8\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public Set<String> findCustomer(SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto) {
        List customerList;
        if (Objects.isNull(subComActivityDetailPlanItemDto)) {
            return Sets.newHashSet();
        }
        Validate.notNull((Object)subComActivityDetailPlanItemDto.getActivityBeginTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)subComActivityDetailPlanItemDto.getActivityEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)subComActivityDetailPlanItemDto.getBusinessFormatCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)subComActivityDetailPlanItemDto.getBusinessUnitCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<SubComActivityDetailPlanItem> detailPlanItems = this.activityConstituentDetailPlanItemRepository.findByCondition(subComActivityDetailPlanItemDto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailPlanItems)) {
            return Sets.newHashSet();
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailPlanItems = detailPlanItems.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getCustomerCode())).collect(Collectors.toList()))) {
            return Sets.newHashSet();
        }
        Set customerSet = detailPlanItems.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getCustomerCode())).filter(k -> StringUtils.isEmpty((CharSequence)k.getSalesInstitutionErpCode())).map(SubComActivityDetailPlanItem::getCustomerCode).collect(Collectors.toSet());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerSet) && CollectionUtil.isNotEmpty((Collection)(customerList = this.customerVoService.findByErpCodeList(new ArrayList(customerSet))))) {
            Map<String, CustomerVo> customerMap = customerList.stream().collect(Collectors.toMap(CustomerVo::getErpCode, v -> v, (oldValue, newValue) -> newValue));
            detailPlanItems.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getCustomerCode())).filter(k -> StringUtils.isEmpty((CharSequence)k.getSalesInstitutionErpCode())).forEach(vo -> vo.setSalesInstitutionErpCode(customerMap.getOrDefault(vo.getCustomerCode(), new CustomerVo()).getSalesInstitutionErpCode()));
        }
        return detailPlanItems.stream().map(e -> e.getCustomerCode() + "-" + e.getSalesInstitutionErpCode()).collect(Collectors.toSet());
    }

    public List<SubComActivityDetailPlanItemVo> findByCustomerCode(SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto) {
        if (Objects.isNull(subComActivityDetailPlanItemDto)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItem> subComActivityDetailPlanItems = this.activityConstituentDetailPlanItemRepository.findByCondition(subComActivityDetailPlanItemDto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(subComActivityDetailPlanItems)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(subComActivityDetailPlanItems, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public void validationList(List<SubComActivityDetailPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        HashSet templateConfigCodeSet = Sets.newHashSet();
        for (SubComActivityDetailPlanItemDto dto : dtoList) {
            Validate.notBlank((CharSequence)dto.getActivityTemplateCode(), (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            templateConfigCodeSet.add(dto.getActivityTemplateCode());
        }
        List templateList = this.activitiesTemplateSdkService.findByCodeList((List)Lists.newArrayList((Iterable)templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u6a21\u677f\u6570\u636e\u6709\u8bef\uff01");
        }
        Map templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<SubComActivityDetailPlanItemDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemDto::getActivityTemplateCode));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(SubComActivityDetailPlanItemDto.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (Map.Entry<String, List<SubComActivityDetailPlanItemDto>> dtoEntry : dtoMap.entrySet()) {
            List<SubComActivityDetailPlanItemDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = (ActivitiesTemplateConfigVo)templateMap.get(dtoEntry.getKey());
            for (SubComActivityDetailPlanItemDto dto : thisDtoList) {
                this.validation(dto);
                if (SubComActivityValidationFormCodeEnum.ZS42.name().equals(dto.getActivityFormCode()) || SubComActivityValidationFormCodeEnum.ZS11.name().equals(dto.getActivityFormCode()) || SubComActivityValidationFormCodeEnum.ZS30.name().equals(dto.getActivityFormCode()) || SubComActivityValidationFormCodeEnum.ZS15.name().equals(dto.getActivityFormCode())) continue;
                if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(dto.getActivityFormCode())) {
                    Validate.isTrue((null == dto.getActivityPrice() ? 1 : 0) != 0, (String)("[" + dto.getActivityFormCode() + "]\u6d3b\u52a8\u4ef7\u4e0d\u80fd\u586b\u5199"), (Object[])new Object[0]);
                    continue;
                }
                if (!SubComActivityValidationFormCodeEnum.ZS03.name().equals(dto.getActivityFormCode())) continue;
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)dto.getGiftProductCode()), (String)("[" + dto.getActivityFormCode() + "]\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u586b\u5199"), (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)dto.getGiftProductName()), (String)("[" + dto.getActivityFormCode() + "]\u8d60\u54c1\u540d\u79f0\u4e0d\u80fd\u586b\u5199"), (Object[])new Object[0]);
                Validate.isTrue((null == dto.getGiftProductPrice() ? 1 : 0) != 0, (String)("[" + dto.getActivityFormCode() + "]\u8d60\u54c1\u5355\u4ef7\u4e0d\u80fd\u586b\u5199"), (Object[])new Object[0]);
                Validate.isTrue((null == dto.getGiftProductNumber() ? 1 : 0) != 0, (String)("[" + dto.getActivityFormCode() + "]\u8d60\u54c1\u6570\u91cf\u4e0d\u80fd\u586b\u5199"), (Object[])new Object[0]);
                Validate.isTrue((null == dto.getQuantity() ? 1 : 0) != 0, (String)("[" + dto.getActivityFormCode() + "]\u6d3b\u52a8\u4ef7\u4e0d\u80fd\u586b\u5199"), (Object[])new Object[0]);
            }
            for (ActivitiesTemplateConfigDetailVo configDetail : templateConfigVo.getDetails()) {
                if (null == configDetail.getRequired() || !configDetail.getRequired().booleanValue()) continue;
                if (!propertyMap.containsKey(configDetail.getField())) {
                    throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + configDetail.getTitle() + "]\u914d\u7f6e\u6709\u8bef");
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(configDetail.getField());
                if (null != propertyDescriptor) {
                    for (SubComActivityDetailPlanItemDto dto : thisDtoList) {
                        try {
                            Object invoke = propertyDescriptor.getReadMethod().invoke((Object)dto, new Object[0]);
                            if (null != invoke && !StringUtils.isEmpty((CharSequence)invoke.toString())) continue;
                            throw new RuntimeException("[" + configDetail.getTitle() + "]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("[" + configDetail.getTitle() + "]\u8bfb\u53d6\u5931\u8d25\uff01");
                        }
                    }
                    continue;
                }
                throw new RuntimeException("[" + configDetail.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    private void buildDetail(SubComActivityDetailPlanItemDto activityConstituentDetailPlanItemVo) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activityConstituentDetailPlanItemVo.getFileList())) {
            activityConstituentDetailPlanItemVo.getFileList().forEach(fileVo -> {
                fileVo.setId(null);
                fileVo.setConstituentDetailPlanCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanCode());
                fileVo.setConstituentDetailPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode());
                this.activityConstituentDetailPlanItemFileVoService.create(fileVo);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activityConstituentDetailPlanItemVo.getBudgetShares())) {
            activityConstituentDetailPlanItemVo.getBudgetShares().forEach(budgetShareVo -> {
                budgetShareVo.setId(null);
                budgetShareVo.setConstituentDetailPlanCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanCode());
                budgetShareVo.setConstituentDetailPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode());
                this.subComActivityDetailPlanItemBudgetShareVoService.create(budgetShareVo);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activityConstituentDetailPlanItemVo.getProductShares())) {
            activityConstituentDetailPlanItemVo.getProductShares().forEach(productShareVo -> {
                productShareVo.setId(null);
                productShareVo.setConstituentDetailPlanCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanCode());
                productShareVo.setConstituentDetailPlanItemCode(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemCode());
                productShareVo.setConstituentDetailPlanItemName(activityConstituentDetailPlanItemVo.getConstituentDetailPlanItemName());
                this.subComActivityDetailPlanItemProductShareVoService.create(productShareVo);
            });
        }
    }

    public void deleteByPlanCodeAndIdNotIn(String constituentDetailPlanCode, List<String> idList) {
        if (StringUtils.isEmpty((CharSequence)constituentDetailPlanCode)) {
            return;
        }
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        this.activityConstituentDetailPlanItemRepository.deleteByPlanCodeAndIdNotIn(constituentDetailPlanCode, idList);
    }

    public Page<SubComActivityDetailPlanItemVo> findForWithholding(Pageable subComPageable, SubComActivityDetailPlanItemDto downwardDto) {
        Page page = new Page((long)subComPageable.getPageNumber(), (long)subComPageable.getPageSize());
        String processStatus = ProcessStatusEnum.PASS.getDictCode();
        String unFinishUpAccount = BooleanEnum.FALSE.getCapital();
        return this.activityConstituentDetailPlanItemRepository.findForWithholding((Page<SubComActivityDetailPlanItemVo>)page, downwardDto, processStatus, unFinishUpAccount);
    }

    public List<SubComActivityDetailPlanItemVo> findDetailByPlanItemCodeList(Set<String> downwardDetailItemCodeSet) {
        return this.activityConstituentDetailPlanItemRepository.findByPlanItemCodeSet(downwardDetailItemCodeSet);
    }

    public List<SubComActivityDetailPlanItemVo> findItemsByDetailPlanCodes(List<String> detailPlanCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailPlanCodes)) {
            return new ArrayList<SubComActivityDetailPlanItemVo>();
        }
        List<SubComActivityDetailPlanItem> itemList = this.activityConstituentDetailPlanItemRepository.findItemsByDetailPlanCodes(detailPlanCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemList)) {
            return new ArrayList<SubComActivityDetailPlanItemVo>();
        }
        List itemVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDetailPlanName(itemVoList);
        return itemVoList;
    }

    private void fillDetailPlanName(List<SubComActivityDetailPlanItemVo> itemVoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemVoList)) {
            return;
        }
        List detailPlanCodeList = itemVoList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailPlanCodeList)) {
            return;
        }
        List detailPlanList = this.subComActivityDetailPlanRepository.list((Wrapper)Wrappers.lambdaQuery(SubComActivityDetailPlan.class).in(SubComActivityDetailPlan::getConstituentDetailPlanCode, detailPlanCodeList));
        Map detailPlanMap = detailPlanList.stream().collect(Collectors.toMap(SubComActivityDetailPlan::getConstituentDetailPlanCode, Function.identity()));
        for (SubComActivityDetailPlanItemVo itemVo : itemVoList) {
            SubComActivityDetailPlan activityDetailPlan = (SubComActivityDetailPlan)((Object)detailPlanMap.get(itemVo.getConstituentDetailPlanCode()));
            itemVo.setConstituentDetailPlanItemName(activityDetailPlan.getConstituentDetailPlanName());
            itemVo.setBusinessFormatCode(activityDetailPlan.getBusinessFormatCode());
        }
    }

    public BigDecimal getApplyAmount(String cacheKey, String constituentDetailPlanCode) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        Set idKeys = this.redisTemplate.keys((Object)(redisCacheIdKey + "*"));
        ArrayList dataList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)idKeys)) {
            for (String idKey : idKeys) {
                String dataKey = idKey.replace("id:", "data:");
                List idList = this.redisService.lRange(idKey, 0L, -1L);
                dataList.addAll(this.redisTemplate.opsForHash().multiGet((Object)dataKey, (Collection)idList));
            }
            ArrayList dtoList = new ArrayList();
            dataList.forEach(data -> {
                SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto = (SubComActivityDetailPlanItemDto)data;
                dtoList.add(subComActivityDetailPlanItemDto);
            });
            if (!CollectionUtils.isEmpty(dtoList)) {
                BigDecimal reduce = dtoList.stream().map(SubComActivityDetailPlanItemDto::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                return reduce;
            }
        } else if (!StringUtils.isEmpty((CharSequence)constituentDetailPlanCode)) {
            List<SubComActivityDetailPlanItem> listByCode = this.activityConstituentDetailPlanItemRepository.findByPlanCode(constituentDetailPlanCode);
            if (CollectionUtils.isEmpty(listByCode)) {
                return BigDecimal.ZERO;
            }
            BigDecimal reduce = listByCode.stream().map(SubComActivityDetailPlanItem::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            return reduce;
        }
        return BigDecimal.ZERO;
    }

    public List<SubComActivityDetailPlanItemVo> findItemsByPromotionNos(Set<String> promotionNoSet) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(promotionNoSet)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItem> list = this.activityConstituentDetailPlanItemRepository.findItemsByPromotionNos(promotionNoSet);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, List<SubComActivityDetailPlanItemVo>> findSameActivityWithNumber(List<String> numberList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(numberList)) {
            return Maps.newHashMap();
        }
        List<SubComActivityDetailPlanItem> itemList = this.activityConstituentDetailPlanItemRepository.findSameActivityWithNumber(numberList);
        List itemVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, SubComActivityDetailPlanItem.class, SubComActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemList)) {
            return Maps.newHashMap();
        }
        Map<String, List<SubComActivityDetailPlanItemVo>> activityMap = itemVoList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getActivityNumber));
        return activityMap;
    }

    public int findTotalByConditions(SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto) {
        return this.activityConstituentDetailPlanItemRepository.getTotalSubCom(subComActivityDetailPlanItemDto);
    }

    public List<SubComActivityDetailPlanItemBudgetShareVo> findDetailBudgetByItemCodeList(List<String> detailItemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailItemCodes)) {
            return Lists.newArrayList();
        }
        return this.subComActivityDetailPlanItemBudgetShareVoService.findDetailByPlanItemCodes(detailItemCodes);
    }

    public Page<SubComActivityDetailPlanItemVo> findCanAutoAuditSubComItemPage(Pageable pageable, AutoAuditParamsDto autoAuditParams) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.findCanAutoAuditSubComItemPage((Page<SubComActivityDetailPlanItemVo>)page, autoAuditParams);
    }

    public Integer getExtractAuditDetailPlanCheckDataTotal(SubComActivityDetailPlanItemDto selectDto) {
        if (Objects.isNull(selectDto)) {
            return 0;
        }
        return this.activityConstituentDetailPlanItemRepository.getExtractAuditDetailPlanCheckDataTotal(selectDto);
    }

    public List<SubComActivityDetailPlanItemVo> extractAuditDetailPlanCheckData(SubComActivityDetailPlanItemDto selectDto, int pageNumber, int pageSize) {
        if (Objects.isNull(selectDto)) {
            return Lists.newArrayList();
        }
        return this.activityConstituentDetailPlanItemRepository.extractAuditDetailPlanCheckData(selectDto, pageNumber *= pageSize, pageSize);
    }

    public Page<SubComActivityDetailPlanItemVo> findDetailPlanItemForKmsReconciliation(Pageable pageable, String customerCode) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)20);
        }
        Date dNow = new Date();
        Date dBefore = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dNow);
        calendar.add(2, -3);
        dBefore = calendar.getTime();
        String feeYearMonth = DateUtil.format((Date)dBefore, (String)"yyyy-MM");
        return this.activityConstituentDetailPlanItemRepository.findDetailPlanItemForKmsReconciliation(pageable, customerCode, feeYearMonth, TenantUtils.getTenantCode());
    }

    public Page<DetailedAccountOfActivityVo> findDetailedAccountOfActivityPage(Pageable pageable, DetailedAccountOfActivityVo dto) {
        return this.activityConstituentDetailPlanItemRepository.findDetailedAccountOfActivityPage(pageable, dto);
    }

    public Page<SubComActivityDetailPlanItemVo> findByConditionsForPromotionExecuteMonitoring(Pageable pageable, SubComActivityDetailPlanItemDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SubComActivityDetailPlanItemDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.findByConditionsForPromotionExecuteMonitoring((Page<SubComActivityDetailPlanItemVo>)page, dto);
    }

    public List<SubComActivityDetailPlanItemVo> findSupportedAmount(SubComActivityDetailPlanItemDto dto) {
        return this.activityConstituentDetailPlanItemRepository.findSupportedAmount(dto);
    }

    public Page<SubComActivityDetailPlanItemVo> saleAndFeeMonitoringByConditions(Pageable pageable, SubComActivityDetailPlanItemDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (StringUtil.isNotEmpty((CharSequence)(dto = (SubComActivityDetailPlanItemDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SubComActivityDetailPlanItemDto())).getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.saleAndFeeMonitoringByConditions((Page<SubComActivityDetailPlanItemVo>)page, dto);
    }

    public void updateItemByDesignModify(List<SubComActivityDetailPlanItemDto> itemList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List<String> itemCodes = itemList.stream().map(SubComActivityDetailPlanItemDto::getConstituentDetailPlanItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            log.error("\u89c4\u5212\u53d8\u66f4\uff0c\u66f4\u65b0\u7ec6\u6848\u65f6\uff0c\u660e\u7ec6\u7f16\u7801\u4e3a\u7a7a! itemList===>", itemList);
            return;
        }
        List<SubComActivityDetailPlanItem> oldList = this.activityConstituentDetailPlanItemRepository.findItemsByPlanItemCodes(itemCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(oldList)) {
            log.error("\u89c4\u5212\u53d8\u66f4\uff0c\u66f4\u65b0\u7ec6\u6848\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8981\u53d8\u66f4\u7684\u7ec6\u6848\u6570\u636e\uff01");
            return;
        }
        Map entityMap = oldList.stream().collect(Collectors.toMap(SubComActivityDetailPlanItem::getConstituentDetailPlanItemCode, Function.identity()));
        ArrayList<SubComActivityDetailPlanItem> updateList = new ArrayList<SubComActivityDetailPlanItem>(itemList.size());
        for (SubComActivityDetailPlanItemDto itemDto : itemList) {
            ArrayList orderShareInterfaceState = Lists.newArrayList();
            SubComActivityDetailPlanItem old = (SubComActivityDetailPlanItem)((Object)entityMap.get(itemDto.getConstituentDetailPlanItemCode()));
            if (Objects.isNull((Object)old)) {
                log.error("\u89c4\u5212\u53d8\u66f4\uff0c\u66f4\u65b0\u7ec6\u6848\u65f6\uff0c\u53d8\u66f4\u6570\u636e\u672a\u627e\u5230\u5bf9\u5e94\u8981\u53d8\u66f4\u7684\u7ec6\u6848\uff01 ===>\u7ec6\u6848\u660e\u7ec6\u7f16\u7801" + itemDto.getConstituentDetailPlanItemCode());
                continue;
            }
            SubComActivityDetailPlanItem item = new SubComActivityDetailPlanItem();
            item.setId(old.getId());
            if (!Optional.ofNullable(itemDto.getCustomerCode()).orElse("").equals(old.getCustomerCode())) {
                orderShareInterfaceState.add(InterfacePushStateEnum.UPDATE_CUSTOMER.getCode());
                item.setCustomerCode(itemDto.getCustomerCode());
                item.setCustomerName(itemDto.getCustomerName());
            }
            if (Optional.ofNullable(itemDto.getTotalCost()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(old.getTotalCost()).orElse(BigDecimal.ZERO)) != 0 || Optional.ofNullable(itemDto.getPromoteSales()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(old.getPromoteSales()).orElse(BigDecimal.ZERO)) != 0) {
                orderShareInterfaceState.add(InterfacePushStateEnum.UPDATE_QUANTITY_OR_FEE.getCode());
                item.setTotalCost(Optional.ofNullable(itemDto.getTotalCost()).orElse(BigDecimal.ZERO));
                item.setPromoteSales(Optional.ofNullable(itemDto.getPromoteSales()).orElse(BigDecimal.ZERO));
            }
            if (null != old.getOrderStartDate() && itemDto.getOrderStartDate().compareTo(old.getOrderStartDate()) != 0 || null != old.getOrderEndDate() && itemDto.getOrderEndDate().compareTo(old.getOrderEndDate()) != 0 || itemDto.getActivityBeginTime().compareTo(old.getActivityBeginTime()) != 0 || itemDto.getActivityEndTime().compareTo(old.getActivityEndTime()) != 0) {
                item.setOrderStartDate(itemDto.getOrderStartDate());
                item.setOrderEndDate(itemDto.getOrderEndDate());
                item.setActivityBeginTime(itemDto.getActivityBeginTime());
                item.setActivityEndTime(itemDto.getActivityEndTime());
                orderShareInterfaceState.add(InterfacePushStateEnum.UPDATE_STATE_OR_DATE.getCode());
            }
            item.setCurrModifyCode(itemDto.getCurrModifyCode());
            item.setPromotionAmount(itemDto.getPromotionAmount());
            item.setProductCode(itemDto.getProductCode());
            item.setProductName(itemDto.getProductName());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderShareInterfaceState)) {
                item.setOrderShareInterfaceState(String.join((CharSequence)",", orderShareInterfaceState));
            }
            updateList.add(item);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateList)) {
            this.activityConstituentDetailPlanItemRepository.updateBatchById(updateList);
        }
    }

    public Page<String> findByDtoForPrediction(Pageable pageable, SubComActivityDetailPlanItemDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getActivityBeginTime()) || Objects.isNull(dto.getActivityEndTime())) {
            return null;
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.findByDtoForPrediction((Page<String>)page, dto);
    }

    public void useProductNumber(SubComActivityDetailPlanItemVo item) {
        if (Objects.isNull(item) || StringUtil.isEmpty((CharSequence)item.getConstituentDetailPlanItemCode()) || Objects.isNull(item.getPromoteSalesUse())) {
            return;
        }
        this.activityConstituentDetailPlanItemRepository.useProductNumber(item);
    }

    public Page<ActivityDetailManageOneProductFeeVo> findPageItemForManageOneProductFee(Pageable pageable, int year, String companyCode, String productCode) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.findPageItemForManageOneProductFee((Page<ActivityDetailManageOneProductFeeVo>)page, year, companyCode, productCode);
    }

    public Page<ActivityDetailManageActivityTypeFeeVo> findPageItemForManageActivityTypeFee(Pageable pageable, int year) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.findPageItemForManageActivityTypeFee((Page<ActivityDetailManageActivityTypeFeeVo>)page, year);
    }

    public Page<ActivityDetailManageChannelFeeVo> findPageItemForManageChannelFee(Pageable pageable, int year) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.findPageItemForManageChannelFee((Page<ActivityDetailManageChannelFeeVo>)page, year);
    }

    public Page<AuditDetailSonCompanyBudgetWarnVo> findPageItemForSonCompanyBudgetWarn(Pageable pageable, int year, int month) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanItemRepository.findPageItemForSonCompanyBudgetWarn((Page<AuditDetailSonCompanyBudgetWarnVo>)page, year, month);
    }
}

