/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityPlanRelationTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetLockService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlan;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlanItemBudgetShare;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemBudgetShareRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.SubComActivityDetailPlanItemVoCacheService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.PrePaySubComActivityDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.log.SubComActivityDetailPlanLogEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.SubComActivityDetailPlanEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.log.ActivityConstituentDetailPlanLogEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanBudgetVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemBudgetShareVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemFileVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemProductShareVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.PrePaySubComActivityVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemBudgetShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="activityConstituentDetailPlanService")
public class SubComActivityDetailPlanVoServiceImpl
implements SubComActivityDetailPlanVoService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanVoServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanRepository activityConstituentDetailPlanRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemRepository subComActivityDetailPlanItemRepository;
    @Autowired(required=false)
    private List<SubComActivityDetailPlanEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired
    private SubComActivityDetailPlanItemVoCacheService subComActivityDetailPlanItemVoCacheService;
    @Autowired
    private SubComActivityDetailPlanItemVoService activityConstituentDetailPlanItemVoService;
    @Autowired
    private SubComActivityDetailPlanBudgetVoService activityConstituentDetailPlanBudgetVoService;
    @Autowired
    private SubComActivityDetailPlanItemBudgetShareVoService activityDetailPlanItemBudgetShareVoService;
    @Autowired
    private SubComActivityDetailPlanItemFileVoService activityConstituentDetailPlanItemFileVoService;
    @Autowired
    private SubComActivityDetailPlanItemProductShareVoService subComActivityDetailPlanItemProductShareVoService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareRepository subComActivityDetailPlanItemBudgetShareRepository;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SubComMonthBudgetLockService subComMonthBudgetLockService;
    private static final int MAX_SIZE = 100;

    public Page<SubComActivityDetailPlanVo> findByConditions(Pageable pageable, SubComActivityDetailPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityDetailPlanDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityConstituentDetailPlanRepository.findByConditions((Page<SubComActivityDetailPlanVo>)page, dto);
    }

    public Page<PrePaySubComActivityVo> findSubComActivityDetailPage(Pageable pageable, PrePaySubComActivityDto dto) {
        List salesOrgVoList;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new PrePaySubComActivityDto());
        Page<PrePaySubComActivityVo> page = new Page<PrePaySubComActivityVo>((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Set salesInstitutionCodeSet = (page = this.activityConstituentDetailPlanRepository.findSubComActivityDetailPage(page, dto)).getRecords().stream().filter(o -> StringUtils.isEmpty((CharSequence)o.getSalesInstitutionName())).map(PrePaySubComActivityVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(salesInstitutionCodeSet) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(new ArrayList(salesInstitutionCodeSet))))) {
            Map salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            for (PrePaySubComActivityVo vo : page.getRecords()) {
                if (!StringUtils.isNotEmpty((CharSequence)vo.getSalesOrgCode()) || salesOrgMap.get(vo.getSalesOrgCode()) == null) continue;
                vo.setSalesInstitutionName(((SalesOrgVo)salesOrgMap.get(vo.getSalesOrgCode())).getSalesOrgName());
            }
        }
        return page;
    }

    public SubComActivityDetailPlanVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SubComActivityDetailPlan activityConstituentDetailPlan = this.activityConstituentDetailPlanRepository.findById(id);
        if (activityConstituentDetailPlan == null) {
            return null;
        }
        SubComActivityDetailPlanVo activityConstituentDetailPlanVo = (SubComActivityDetailPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityConstituentDetailPlan, SubComActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fullDetail(activityConstituentDetailPlanVo);
        return activityConstituentDetailPlanVo;
    }

    public List<SubComActivityDetailPlanVo> findDetailByIdList(List<String> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }
        List result = this.activityConstituentDetailPlanRepository.listByIds(idList);
        if (CollectionUtil.isEmpty((Collection)result)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)result, SubComActivityDetailPlan.class, SubComActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public SubComActivityDetailPlanVo findDetailByPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return null;
        }
        SubComActivityDetailPlan activityConstituentDetailPlan = this.activityConstituentDetailPlanRepository.findByPlanCode(planCode);
        if (activityConstituentDetailPlan == null) {
            return null;
        }
        SubComActivityDetailPlanVo activityConstituentDetailPlanVo = (SubComActivityDetailPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityConstituentDetailPlan, SubComActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fullDetail(activityConstituentDetailPlanVo);
        return activityConstituentDetailPlanVo;
    }

    public List<SubComActivityDetailPlanVo> findDetailByPlanCodes(List<String> planCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(planCodes)) {
            return null;
        }
        List<SubComActivityDetailPlan> planList = this.activityConstituentDetailPlanRepository.findByPlanCodes(planCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(planList)) {
            return null;
        }
        List detailPlanVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(planList, SubComActivityDetailPlan.class, SubComActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        List budgetVos = this.activityConstituentDetailPlanBudgetVoService.findDetailByPlanCodes(planCodes);
        List itemVos = this.activityConstituentDetailPlanItemVoService.findDetailByPlanCodes(planCodes);
        Map<String, List<SubComActivityDetailPlanBudgetVo>> budgetVosMap = budgetVos.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanBudgetVo::getConstituentDetailPlanCode));
        Map<String, List<SubComActivityDetailPlanItemVo>> detilVosMap = itemVos.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getConstituentDetailPlanCode));
        detailPlanVos.forEach(v -> {
            v.setBudgetList((List)budgetVosMap.get(v.getConstituentDetailPlanCode()));
            v.setItemList((List)detilVosMap.get(v.getConstituentDetailPlanCode()));
        });
        return detailPlanVos;
    }

    public List<SubComActivityDetailPlanVo> findDetailPlanAndItemByPlanCode(List<String> planCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(planCodes)) {
            return null;
        }
        List<SubComActivityDetailPlan> list = this.activityConstituentDetailPlanRepository.findByPlanCodes(planCodes);
        if (list == null) {
            return null;
        }
        List detailPlanVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityDetailPlan.class, SubComActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        detailPlanVoList.forEach(this::fullDetailPlanItem);
        return detailPlanVoList;
    }

    public List<SubComActivityDetailPlanVo> findAllDetailPlanAndItemByPlanCode(List<String> planCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(planCodes)) {
            return null;
        }
        List<SubComActivityDetailPlan> list = this.activityConstituentDetailPlanRepository.findAllByPlanCodes(planCodes);
        if (list == null) {
            return null;
        }
        List detailPlanVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityDetailPlan.class, SubComActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        detailPlanVoList.forEach(this::fullDetailPlanItem);
        return detailPlanVoList;
    }

    private void fullDetail(SubComActivityDetailPlanVo activityConstituentDetailPlanVo) {
        activityConstituentDetailPlanVo.setBudgetList(this.activityConstituentDetailPlanBudgetVoService.findDetailByPlanCode(activityConstituentDetailPlanVo.getConstituentDetailPlanCode()));
        activityConstituentDetailPlanVo.setItemList(this.activityConstituentDetailPlanItemVoService.findDetailByPlanCode(activityConstituentDetailPlanVo.getConstituentDetailPlanCode()));
    }

    private void fullDetailPlanItem(SubComActivityDetailPlanVo activityConstituentDetailPlanVo) {
        activityConstituentDetailPlanVo.setItemList(this.activityConstituentDetailPlanItemVoService.findDetailByPlanCode(activityConstituentDetailPlanVo.getConstituentDetailPlanCode()));
    }

    @Transactional
    public String create(String cacheKey, SubComActivityDetailPlanDto activityConstituentDetailPlanVo) {
        List itemList = new ArrayList();
        itemList = StrUtil.isNotEmpty((CharSequence)cacheKey) ? this.subComActivityDetailPlanItemVoCacheService.findCacheList(cacheKey) : activityConstituentDetailPlanVo.getItemList();
        String code = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemList)) {
            code = this.create(activityConstituentDetailPlanVo, itemList);
        }
        this.subComActivityDetailPlanItemVoCacheService.clearCache(cacheKey);
        return code;
    }

    @Transactional
    public String create(SubComActivityDetailPlanDto activityConstituentDetailPlanVo, List<SubComActivityDetailPlanItemDto> itemList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemList)) {
            throw new RuntimeException("\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        activityConstituentDetailPlanVo.setItemList(itemList);
        if (StringUtils.isNotBlank((CharSequence)activityConstituentDetailPlanVo.getConstituentDetailPlanName())) {
            Validate.isTrue((activityConstituentDetailPlanVo.getConstituentDetailPlanName().length() <= 60 ? 1 : 0) != 0, (String)"\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc760\u5b57", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)activityConstituentDetailPlanVo.getConstituentDetailPlanCode())) {
            String code = (String)this.generateCodeService.generateCode("FZDP", 1, Integer.valueOf(6), 2L, TimeUnit.DAYS).get(0);
            activityConstituentDetailPlanVo.setConstituentDetailPlanCode(code);
        }
        if (!BooleanEnum.FALSE.getCapital().equals(activityConstituentDetailPlanVo.getValidateFlag())) {
            this.createValidation(activityConstituentDetailPlanVo);
        }
        activityConstituentDetailPlanVo.setTenantCode(TenantUtils.getTenantCode());
        activityConstituentDetailPlanVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityConstituentDetailPlanVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StrUtil.isEmpty((CharSequence)activityConstituentDetailPlanVo.getProcessStatus())) {
            activityConstituentDetailPlanVo.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        }
        SubComActivityDetailPlan activityConstituentDetailPlan = (SubComActivityDetailPlan)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityConstituentDetailPlanVo, SubComActivityDetailPlan.class, HashSet.class, ArrayList.class, new String[0]));
        this.activityConstituentDetailPlanRepository.saveOrUpdate((Object)activityConstituentDetailPlan);
        activityConstituentDetailPlanVo.setId(activityConstituentDetailPlan.getId());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityDetailPlanEventListener activityConstituentDetailPlanEventListener : this.eventListeners) {
                activityConstituentDetailPlanEventListener.onCreate(activityConstituentDetailPlanVo);
            }
        }
        this.buildAssInfo(activityConstituentDetailPlanVo, false);
        if (activityConstituentDetailPlanVo.getProcessBusiness() != null) {
            this.commitProcess(activityConstituentDetailPlanVo);
        }
        SubComActivityDetailPlanLogEventDto logEventDto = new SubComActivityDetailPlanLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(activityConstituentDetailPlanVo);
        SerializableBiConsumer & Serializable onCreate = ActivityConstituentDetailPlanLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityConstituentDetailPlanLogEventListener.class, (SerializableBiConsumer)onCreate);
        return activityConstituentDetailPlanVo.getConstituentDetailPlanCode();
    }

    @Transactional
    public void update(String cacheKey, SubComActivityDetailPlanDto activityConstituentDetailPlanVo) {
        List itemList = this.subComActivityDetailPlanItemVoCacheService.findCacheList(cacheKey);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemList)) {
            throw new RuntimeException("\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        activityConstituentDetailPlanVo.setItemList(itemList);
        this.updateValidation(activityConstituentDetailPlanVo);
        String currentId = activityConstituentDetailPlanVo.getId();
        SubComActivityDetailPlan current = this.activityConstituentDetailPlanRepository.findById(currentId);
        current = (SubComActivityDetailPlan)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        SubComActivityDetailPlanVo oldVo = (SubComActivityDetailPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, SubComActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        current.setActivityTemplateCode(activityConstituentDetailPlanVo.getActivityTemplateCode());
        current.setConstituentDetailPlanName(activityConstituentDetailPlanVo.getConstituentDetailPlanName());
        current.setBusinessFormatCode(activityConstituentDetailPlanVo.getBusinessFormatCode());
        current.setSalesInstitutionCode(activityConstituentDetailPlanVo.getSalesInstitutionCode());
        current.setSalesInstitutionName(activityConstituentDetailPlanVo.getSalesInstitutionName());
        current.setSalesOrgCode(activityConstituentDetailPlanVo.getSalesOrgCode());
        current.setSalesOrgName(activityConstituentDetailPlanVo.getSalesOrgName());
        current.setSalesGroupCode(activityConstituentDetailPlanVo.getSalesGroupCode());
        current.setSalesGroupName(activityConstituentDetailPlanVo.getSalesGroupName());
        current.setTotalApplyAmount(activityConstituentDetailPlanVo.getTotalApplyAmount());
        this.activityConstituentDetailPlanRepository.saveOrUpdate((Object)current);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityDetailPlanEventListener activityConstituentDetailPlanEventListener : this.eventListeners) {
                activityConstituentDetailPlanEventListener.onUpdate(oldVo, activityConstituentDetailPlanVo);
            }
        }
        this.buildAssInfo(activityConstituentDetailPlanVo, true);
        this.subComActivityDetailPlanItemVoCacheService.clearCache(cacheKey);
        if (activityConstituentDetailPlanVo.getProcessBusiness() != null) {
            this.commitProcess(activityConstituentDetailPlanVo);
        }
        SubComActivityDetailPlanLogEventDto logEventDto = new SubComActivityDetailPlanLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(activityConstituentDetailPlanVo);
        SerializableBiConsumer & Serializable onUpdate = ActivityConstituentDetailPlanLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityConstituentDetailPlanLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.activityConstituentDetailPlanRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.activityConstituentDetailPlanRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return;
        }
        FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String account = loginUserDetails.getAccount();
        String name = loginUserDetails.getUsername();
        List entityList = this.activityConstituentDetailPlanRepository.listByIds(ids);
        for (SubComActivityDetailPlan entity : entityList) {
            Validate.isTrue((ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) ? 1 : 0) != 0, (String)("\u5206\u5b50\u516c\u53f8\u7ec6\u6848[" + entity.getConstituentDetailPlanCode() + "]\u4e0d\u662f\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u6216\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01"), (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)account)) continue;
            Validate.isTrue((boolean)account.equals(entity.getCreateAccount()), (String)("\u53ea\u6709\u521b\u5efa\u4eba[" + name + "],\u624d\u53ef\u5220\u9664\u8be5\u6761\u7ec6\u6848[" + entity.getConstituentDetailPlanCode() + "]"), (Object[])new Object[0]);
        }
        this.activityConstituentDetailPlanRepository.updateDelFlagByIds(ids);
        List<String> codeList = entityList.stream().map(SubComActivityDetailPlan::getConstituentDetailPlanCode).collect(Collectors.toList());
        this.subComActivityDetailPlanItemRepository.updateDelFlagByConstituentDetailPlanCodeList(codeList);
    }

    public Map<String, String> closeBatch(List<SubComActivityDetailPlanItemDto> list) {
        Assert.notEmpty(list, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Assert.hasLength((String)list.get(i).getId(), (String)("\u7b2c[" + (i + 1) + "]\u884cID\u4e0d\u80fd\u4e3a\u7a7a!"));
            idList.add(list.get(i).getId());
        }
        List<SubComActivityDetailPlanItem> detailPlanVoList = this.subComActivityDetailPlanItemRepository.findByIds(idList);
        Assert.notEmpty(detailPlanVoList, (String)"\u7ec6\u6848\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        Map<String, String> idCodeMap = detailPlanVoList.stream().collect(Collectors.toMap(UuidEntity::getId, SubComActivityDetailPlanItem::getConstituentDetailPlanItemCode, (n, o) -> n));
        List<SubComActivityDetailPlanItemBudgetShare> budgetShareList = this.subComActivityDetailPlanItemBudgetShareRepository.findByPlanItemCodeList(new ArrayList<String>(idCodeMap.values()));
        List monthBudgetCodeList = budgetShareList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getMonthBudgetCode())).map(SubComActivityDetailPlanItemBudgetShare::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean lockSuccess = this.subComMonthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.MINUTES, 5);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        LinkedHashMap msgMap = Maps.newLinkedHashMap();
        try {
            list.forEach(itemDto -> {
                try {
                    this.activityConstituentDetailPlanItemVoService.closeById(itemDto);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    msgMap.put(idCodeMap.get(itemDto.getId()), e.getMessage());
                }
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.subComMonthBudgetLockService.unlock(monthBudgetCodeList);
        }
        return msgMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void submit(SubComActivityDetailPlanDto dto) {
        Validate.notNull((Object)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SubComActivityDetailPlan entity = this.activityConstituentDetailPlanRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)entity), (String)"\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\uff01", (Object[])new Object[0]);
        if (!(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()))) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848[" + entity.getConstituentDetailPlanCode() + "]\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
        }
        List monthBudgetCodeList = new ArrayList();
        try {
            monthBudgetCodeList = this.activityDetailPlanItemBudgetShareVoService.useMonthBudgetByCode(Collections.singletonList(entity.getConstituentDetailPlanCode()));
            this.commitProcess(dto);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (CollectionUtil.isNotEmpty(monthBudgetCodeList)) {
                this.subComMonthBudgetLockService.unlock(monthBudgetCodeList);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(SubComActivityDetailPlanApproveSubmitDto dto) {
        Assert.notNull((Object)dto, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
        Assert.notEmpty((Collection)dto.getIds(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01");
        List entityList = this.activityConstituentDetailPlanRepository.listByIds(dto.getIds());
        Assert.notEmpty((Collection)entityList, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        for (SubComActivityDetailPlan entity : entityList) {
            if (ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus())) continue;
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848[" + entity.getConstituentDetailPlanCode() + "]\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
        }
        List constituentDetailPlanCodeList = entityList.stream().map(SubComActivityDetailPlan::getConstituentDetailPlanCode).collect(Collectors.toList());
        List monthBudgetCodeList = new ArrayList();
        try {
            monthBudgetCodeList = this.activityDetailPlanItemBudgetShareVoService.useMonthBudgetByCode(constituentDetailPlanCodeList);
            this.commitProcess(dto);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (CollectionUtil.isNotEmpty(monthBudgetCodeList)) {
                this.subComMonthBudgetLockService.unlock(monthBudgetCodeList);
            }
        }
    }

    private void createValidation(SubComActivityDetailPlanDto activityConstituentDetailPlanVo) {
        this.validation(activityConstituentDetailPlanVo);
    }

    private void updateValidation(SubComActivityDetailPlanDto activityConstituentDetailPlanVo) {
        Validate.notBlank((CharSequence)activityConstituentDetailPlanVo.getId(), (String)"\u4fee\u6539\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        this.validation(activityConstituentDetailPlanVo);
    }

    private void validation(SubComActivityDetailPlanDto dto) {
        Validate.notBlank((CharSequence)dto.getConstituentDetailPlanCode(), (String)"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getConstituentDetailPlanName(), (String)"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u7ec6\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getItemList()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        dto.getItemList().forEach(item -> {
            item.setConstituentDetailPlanCode(dto.getConstituentDetailPlanCode());
            item.setConstituentDetailPlanName(dto.getConstituentDetailPlanName());
        });
        this.activityConstituentDetailPlanItemVoService.validationList(dto.getItemList());
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dto.getItemList())) {
            totalAmount = dto.getItemList().stream().map(SubComActivityDetailPlanItemDto::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        dto.setTotalApplyAmount(totalAmount);
    }

    private void commitProcess(SubComActivityDetailPlanDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("ACTIVITY_CONST_DETAIL_PLAN_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        this.activityConstituentDetailPlanRepository.updateProcessStatusAndProcessNo(dto.getConstituentDetailPlanCode(), ProcessStatusEnum.COMMIT.getDictCode(), processBusinessVo.getProcessNo());
    }

    private void commitProcess(SubComActivityDetailPlanApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNoList(dto.getIds());
        processBusiness.setBusinessNo(UuidCrmUtil.general());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("ACTIVITY_CONST_DETAIL_PLAN_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        this.activityConstituentDetailPlanRepository.updateProcessStatusAndProcessNo(dto.getIds(), ProcessStatusEnum.COMMIT.getDictCode(), processBusinessVo.getProcessNo());
    }

    private void buildAssInfo(SubComActivityDetailPlanDto dto, boolean update) {
        if (update) {
            this.activityConstituentDetailPlanBudgetVoService.updateDelFlagByPlanCode(dto.getConstituentDetailPlanCode());
            this.activityConstituentDetailPlanItemFileVoService.removeByPlanCode(dto.getConstituentDetailPlanCode());
            this.activityDetailPlanItemBudgetShareVoService.updateDelFlagByPlanCode(dto.getConstituentDetailPlanCode());
            this.subComActivityDetailPlanItemProductShareVoService.updateDelFlagByPlanCode(dto.getConstituentDetailPlanCode());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getItemList())) {
            this.generatePromotionNo(dto);
            dto.getItemList().forEach(itemVo -> {
                itemVo.setConstituentDetailPlanCode(dto.getConstituentDetailPlanCode());
                itemVo.setConstituentDetailPlanName(dto.getConstituentDetailPlanName());
                itemVo.setBusinessFormatCode(dto.getBusinessFormatCode());
                itemVo.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                itemVo.setProcessStatus(dto.getProcessStatus());
                this.activityConstituentDetailPlanItemVoService.create(itemVo);
            });
            if (update) {
                List idList = dto.getItemList().stream().map(UuidDto::getId).filter(Objects::nonNull).collect(Collectors.toList());
                this.activityConstituentDetailPlanItemVoService.deleteByPlanCodeAndIdNotIn(dto.getConstituentDetailPlanCode(), idList);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getBudgetList())) {
            dto.getBudgetList().forEach(budgetVo -> {
                budgetVo.setConstituentDetailPlanCode(dto.getConstituentDetailPlanCode());
                this.activityConstituentDetailPlanBudgetVoService.create(budgetVo);
            });
        }
    }

    public void validateActivityNumber(SubComActivityDetailPlanItemDto itemDto) {
        Validate.isTrue((boolean)TotalQuantityOrNotEnum.contains((String)itemDto.getIsSupplyAmount()), (String)"\u672a\u77e5\u7684\u5171\u7528\u91cf\u7c7b\u578b\uff01", (Object[])new Object[0]);
        int quantity = this.subComActivityDetailPlanItemRepository.findOthersActivityByActivityNumber(itemDto);
        Validate.isTrue((quantity <= 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u4fbf\u7b7e\u53f7\u5728\u5176\u4ed6\u7ec6\u6848\u4e2d\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
    }

    private void generatePromotionNo(SubComActivityDetailPlanDto dto) {
        int i2;
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getItemList())) {
            return;
        }
        List itemNList = dto.getItemList().stream().filter(k -> TotalQuantityOrNotEnum.N.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        List itemYList = dto.getItemList().stream().filter(k -> TotalQuantityOrNotEnum.Y.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        List itemZList = dto.getItemList().stream().filter(k -> TotalQuantityOrNotEnum.Z.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        List notZNumbers = dto.getItemList().stream().filter(i -> !TotalQuantityOrNotEnum.Z.getCode().equals(i.getIsSupplyAmount())).map(SubComActivityDetailPlanItemDto::getActivityNumber).filter(Objects::nonNull).collect(Collectors.toList());
        Set<String> zNumbers = dto.getItemList().stream().filter(i -> TotalQuantityOrNotEnum.Z.getCode().equals(i.getIsSupplyAmount())).map(SubComActivityDetailPlanItemDto::getActivityNumber).filter(Objects::nonNull).collect(Collectors.toSet());
        zNumbers.forEach(number -> Validate.isTrue((!notZNumbers.contains(number) ? 1 : 0) != 0, (String)"Z\u5171\u7528\u91cf'\u6d3b\u52a8\u4fbf\u7b7e\u53f7\u2018\u4e0d\u53ef\u91cd\u590d\uff01", (Object[])new Object[0]));
        Validate.isTrue((itemZList.size() == zNumbers.size() ? 1 : 0) != 0, (String)"Z\u5171\u7528\u91cf'\u6d3b\u52a8\u4fbf\u7b7e\u53f7\u2018\u4e0d\u53ef\u91cd\u590d\uff01", (Object[])new Object[0]);
        String rule = "P-";
        Map<String, List<SubComActivityDetailPlanItemDto>> itemNMap = itemNList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemDto::getActivityNumber));
        Set<String> nSet = itemNMap.keySet();
        for (String number2 : nSet) {
            List<SubComActivityDetailPlanItemDto> nItemList = itemNMap.get(number2);
            boolean noNumber = nItemList.stream().anyMatch(item -> StringUtils.isBlank((CharSequence)item.getConstituentDetailPlanItemCode()));
            String promotionNo = null;
            if (noNumber) {
                promotionNo = (String)this.generateCodeService.generateCode(rule, 1, Integer.valueOf(8), -1L, TimeUnit.DAYS).get(0);
            }
            i2 = 0;
            Iterator<Object> iterator = nItemList.iterator();
            while (iterator.hasNext()) {
                SubComActivityDetailPlanItemDto item2 = (SubComActivityDetailPlanItemDto)iterator.next();
                if (!StringUtils.isBlank((CharSequence)item2.getConstituentDetailPlanItemCode())) continue;
                item2.setPromotionNo(promotionNo);
                item2.setConstituentDetailPlanItemCode(promotionNo + String.format("%04d", ++i2));
            }
        }
        Map<String, List<SubComActivityDetailPlanItemDto>> itemYMap = itemYList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemDto::getActivityNumber));
        Set<String> ySet = itemYMap.keySet();
        for (String number3 : ySet) {
            List<SubComActivityDetailPlanItemDto> yItemList = itemYMap.get(number3);
            i2 = 0;
            for (SubComActivityDetailPlanItemDto item2 : yItemList) {
                if (!StringUtils.isBlank((CharSequence)item2.getConstituentDetailPlanItemCode())) continue;
                String promotionNo = (String)this.generateCodeService.generateCode(rule, 1, Integer.valueOf(8), -1L, TimeUnit.DAYS).get(0);
                item2.setPromotionNo(promotionNo);
                item2.setConstituentDetailPlanItemCode(promotionNo + String.format("%04d", ++i2));
            }
        }
        int i3 = 0;
        for (SubComActivityDetailPlanItemDto item3 : itemZList) {
            if (!StringUtils.isBlank((CharSequence)item3.getConstituentDetailPlanItemCode())) continue;
            String promotionNo = (String)this.generateCodeService.generateCode(rule, 1, Integer.valueOf(8), -1L, TimeUnit.DAYS).get(0);
            item3.setPromotionNo(promotionNo);
            item3.setConstituentDetailPlanItemCode(promotionNo + String.format("%04d", ++i3));
        }
    }

    public Page<SubComActivityDetailPlanPlanVo> findCanRelationPlanListPage(Pageable pageable, final SubComActivityDetailPlanPlanDto dto) {
        ActivityPlanItemDto activityPlanDto;
        Page planPage;
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (ActivityPlanRelationTypeEnum.up.getCode().equals(dto.getAssociationType())) {
            ActivityDetailPlanItemDto searchDto = new ActivityDetailPlanItemDto(){
                {
                    this.setDetailPlanCode(dto.getPlanCode());
                    this.setDetailPlanName(dto.getPlanName());
                    this.setDetailPlanItemCode(dto.getPlanDetailCode());
                    this.setActivityBeginDateStr(dto.getBeginDateStr());
                    this.setActivityEndDateStr(dto.getEndDateStr());
                }
            };
            Page detailPlanPage = this.activityDetailPlanItemSdkService.findByConditions(pageable, searchDto);
            page.setTotal(detailPlanPage.getTotal());
            if (CollectionUtils.isNotEmpty((Collection)detailPlanPage.getRecords())) {
                List list = detailPlanPage.getRecords().stream().map(item -> new SubComActivityDetailPlanPlanVo((ActivityDetailPlanItemVo)item){
                    final /* synthetic */ ActivityDetailPlanItemVo val$item;
                    {
                        this.val$item = activityDetailPlanItemVo;
                        this.setPlanCode(this.val$item.getDetailPlanCode());
                        this.setPlanName(this.val$item.getDetailPlanName());
                        this.setPlanDetailCode(this.val$item.getDetailPlanItemCode());
                    }
                }).collect(Collectors.toList());
                page.setRecords(list);
            }
        } else if (ActivityPlanRelationTypeEnum.region.getCode().equals(dto.getAssociationType()) && CollectionUtils.isNotEmpty((Collection)(planPage = this.activityPlanItemSdkService.findByConditions(pageable, activityPlanDto = new ActivityPlanItemDto(){
            {
                this.setPlanCode(dto.getPlanCode());
                this.setPlanName(dto.getPlanName());
                this.setPlanItemCode(dto.getPlanDetailCode());
                this.setActivityBeginDateStr(dto.getBeginDateStr());
                this.setActivityEndDateStr(dto.getEndDateStr());
            }
        })).getRecords())) {
            List list = planPage.getRecords().stream().map(item -> new SubComActivityDetailPlanPlanVo((ActivityPlanItemVo)item){
                final /* synthetic */ ActivityPlanItemVo val$item;
                {
                    this.val$item = activityPlanItemVo;
                    this.setPlanCode(this.val$item.getPlanCode());
                    this.setPlanName(this.val$item.getPlanName());
                    this.setPlanDetailCode(this.val$item.getPlanItemCode());
                }
            }).collect(Collectors.toList());
            page.setRecords(list);
        }
        return page;
    }

    public List<SubComActivityDetailPlanVo> findSubComAutoAudits(Page<SubComActivityDetailPlanVo> page, String autoDate) {
        List<SubComActivityDetailPlanVo> list = this.subComActivityDetailPlanItemRepository.findSubComAutoAudit(page, autoDate);
        if (list == null || list.isEmpty()) {
            return null;
        }
        List<String> codes = list.stream().map(SubComActivityDetailPlanVo::getConstituentDetailPlanCode).collect(Collectors.toList());
        List<SubComActivityDetailPlanItemVo> itemList = this.subComActivityDetailPlanItemRepository.findSubComDetailPlanItemByCodes(codes, autoDate);
        if (itemList != null && itemList.size() > 0) {
            Map<String, List<SubComActivityDetailPlanItemVo>> itemMap = itemList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getConstituentDetailPlanCode));
            list.forEach(subCom -> {
                String constituentDetailPlanCode = subCom.getConstituentDetailPlanCode();
                List subComActivityDetailPlanItemVos = (List)itemMap.get(constituentDetailPlanCode);
                if (subComActivityDetailPlanItemVos != null && subComActivityDetailPlanItemVos.size() > 0) {
                    subCom.setItemList(subComActivityDetailPlanItemVos);
                }
            });
        }
        return list;
    }

    public int getSubComTotal(String autoDate) {
        return this.subComActivityDetailPlanItemRepository.getSubComActivityCanAutoAuditNumber(autoDate);
    }

    public void updateSubComAutoAudit(List<String> codeList, String autoAudit) {
        this.subComActivityDetailPlanItemRepository.updateAutoAudit(codeList, autoAudit);
    }

    public List<SubComActivityDetailPlanVo> findDetailByPlanCodeList(Collection<String> collect) {
        HashSet<String> detailPlanCodeList = new HashSet<String>(collect);
        List<SubComActivityDetailPlan> planList = this.activityConstituentDetailPlanRepository.findDetailByPlanCodeList(detailPlanCodeList);
        return new ArrayList<SubComActivityDetailPlanVo>(this.nebulaToolkitService.copyCollectionByWhiteList(planList, SubComActivityDetailPlan.class, SubComActivityDetailPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAccountAndName(String code, String createAccount, String createName) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        this.activityConstituentDetailPlanRepository.updateAccountAndName(code, createAccount, createName);
        this.subComActivityDetailPlanItemRepository.updateAccountAndName(code, createAccount, createName);
    }

    public List<SubComActivityDetailPlanVo> findListByDetailCodes(Set<String> activityCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(activityCodes)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        List<SubComActivityDetailPlan> subComActivityDetailPlanList = this.activityConstituentDetailPlanRepository.findListByDetailCodes(activityCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(subComActivityDetailPlanList)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        Collection subComActivityDetailPlanVos = this.nebulaToolkitService.copyCollectionByWhiteList(subComActivityDetailPlanList, SubComActivityDetailPlan.class, SubComActivityDetailPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)subComActivityDetailPlanVos;
    }

    public Page<String> findByDtoForPrediction(Pageable pageable, SubComActivityDetailPlanDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getActivityBeginTime()) || Objects.isNull(dto.getActivityEndTime())) {
            return null;
        }
        SubComActivityDetailPlanItemDto itemDto = new SubComActivityDetailPlanItemDto();
        itemDto.setActivityBeginTime(dto.getActivityBeginTime());
        itemDto.setActivityEndTime(dto.getActivityEndTime());
        itemDto.setProcessStatus(dto.getProcessStatus());
        return this.activityConstituentDetailPlanItemVoService.findByDtoForPrediction(pageable, itemDto);
    }

    public BigDecimal findEstimatedWriteOffAmountByItemCode(String constituentDetailPlanItemCode) {
        if (StringUtils.isEmpty((CharSequence)constituentDetailPlanItemCode)) {
            return BigDecimal.ZERO;
        }
        return this.subComActivityDetailPlanItemRepository.findEstimatedWriteOffAmountByItemCode(constituentDetailPlanItemCode);
    }

    public List<SubComActivityDetailPlanItemBudgetShareVo> findInOutSelfByItemCodes(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        List<SubComActivityDetailPlanItemBudgetShareVo> planItemBudgetShareVos = this.subComActivityDetailPlanItemBudgetShareRepository.findAmount(itemCodes);
        return planItemBudgetShareVos;
    }
}

