/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityDetailPlan;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.entity.SubComActivityProductStatisticalInfo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityDetailPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.repository.SubComActivityProductStatisticalInfoRepository;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.log.SubComActivityProductStatisticalInfoLogEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.SubComActivityProductStatisticalInfoEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event.log.SubComActivityProductStatisticalInfoLogEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemBudgetShareVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityProductStatisticalInfoVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemProductShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityProductStatisticalInfoVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityProductStatisticalItemInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="subComActivityProductStatisticalInfoService")
public class SubComActivityProductStatisticalInfoVoServiceImpl
implements SubComActivityProductStatisticalInfoVoService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityProductStatisticalInfoVoServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityProductStatisticalInfoRepository subComActivityProductStatisticalInfoRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanRepository subComActivityDetailPlanRepository;
    @Autowired(required=false)
    private List<SubComActivityProductStatisticalInfoEventListener> eventListeners;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemBudgetShareVoService subComActivityDetailPlanItemBudgetShareVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    @Transactional
    public SubComActivityProductStatisticalInfoVo create(SubComActivityProductStatisticalInfoVo subComActivityProductStatisticalInfoVo) {
        this.createValidation(subComActivityProductStatisticalInfoVo);
        subComActivityProductStatisticalInfoVo.setTenantCode(TenantUtils.getTenantCode());
        subComActivityProductStatisticalInfoVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        subComActivityProductStatisticalInfoVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        SubComActivityProductStatisticalInfo subComActivityProductStatisticalInfo = (SubComActivityProductStatisticalInfo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityProductStatisticalInfoVo, SubComActivityProductStatisticalInfo.class, HashSet.class, ArrayList.class, new String[0]));
        this.subComActivityProductStatisticalInfoRepository.saveOrUpdate((Object)subComActivityProductStatisticalInfo);
        subComActivityProductStatisticalInfoVo.setId(subComActivityProductStatisticalInfo.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (SubComActivityProductStatisticalInfoEventListener subComActivityProductStatisticalInfoEventListener : this.eventListeners) {
                subComActivityProductStatisticalInfoEventListener.onCreate(subComActivityProductStatisticalInfoVo);
            }
        }
        SubComActivityProductStatisticalInfoLogEventDto logEventDto = new SubComActivityProductStatisticalInfoLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(subComActivityProductStatisticalInfoVo);
        SerializableBiConsumer & Serializable onCreate = SubComActivityProductStatisticalInfoLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComActivityProductStatisticalInfoLogEventListener.class, (SerializableBiConsumer)onCreate);
        return subComActivityProductStatisticalInfoVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityProductStatisticalInfoRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityProductStatisticalInfoRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.subComActivityProductStatisticalInfoRepository.updateDelFlagByIds(ids);
    }

    public List<SubComActivityProductStatisticalInfoVo> findDetailByPlanCode(Pageable pageable, List<String> planCodes) {
        List<SubComActivityDetailPlan> detailPlanProcessNoList;
        List<SubComActivityDetailPlan> detailPlanIdList;
        if (CollectionUtil.isEmpty(planCodes)) {
            return Collections.emptyList();
        }
        ArrayList<SubComActivityDetailPlan> entityList = new ArrayList<SubComActivityDetailPlan>();
        List<SubComActivityDetailPlan> detailPlanCodeList = this.subComActivityDetailPlanRepository.findDetailByPlanCodeList(new HashSet<String>(planCodes));
        if (CollectionUtil.isNotEmpty(detailPlanCodeList)) {
            entityList.addAll(detailPlanCodeList);
        }
        if (CollectionUtil.isNotEmpty(detailPlanIdList = this.subComActivityDetailPlanRepository.findByIds(planCodes))) {
            entityList.addAll(detailPlanIdList);
        }
        if (CollectionUtil.isNotEmpty(detailPlanProcessNoList = this.subComActivityDetailPlanRepository.findByProcessNoList(planCodes))) {
            entityList.addAll(detailPlanProcessNoList);
        }
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        List constituentDetailPlanCodeList = entityList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getConstituentDetailPlanCode())).map(SubComActivityDetailPlan::getConstituentDetailPlanCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(constituentDetailPlanCodeList)) {
            return Collections.emptyList();
        }
        List itemVoList = this.subComActivityDetailPlanItemVoService.findDetailByPlanCodes(constituentDetailPlanCodeList);
        HashMap<String, List<Object>> detailPlanItemMap = new HashMap<String, List<Object>>(constituentDetailPlanCodeList.size());
        if (CollectionUtil.isNotEmpty((Collection)itemVoList)) {
            detailPlanItemMap.putAll(itemVoList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getConstituentDetailPlanCode())).collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getConstituentDetailPlanCode)));
        }
        ArrayList<SubComActivityProductStatisticalInfoVo> infoVoList = new ArrayList<SubComActivityProductStatisticalInfoVo>();
        for (SubComActivityDetailPlan entity : entityList) {
            SubComActivityProductStatisticalInfoVo infoVo = new SubComActivityProductStatisticalInfoVo();
            List itemVos = detailPlanItemMap.getOrDefault(entity.getConstituentDetailPlanCode(), new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)itemVos)) {
                SubComActivityDetailPlanDto subComActivityDetailPlanDto = (SubComActivityDetailPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, SubComActivityDetailPlanDto.class, null, null, new String[0]);
                infoVo = this.findDetailByItemVos(pageable, itemVos, subComActivityDetailPlanDto);
            }
            infoVo.setId(entity.getId());
            infoVo.setConstituentDetailPlanCode(entity.getConstituentDetailPlanCode());
            infoVo.setConstituentDetailPlanName(entity.getConstituentDetailPlanName());
            infoVo.setOrgCode(entity.getOrgCode());
            infoVo.setOrgName(entity.getOrgName());
            infoVo.setYearMonthly(entity.getFeeYearMonth());
            infoVoList.add(infoVo);
        }
        return infoVoList;
    }

    public SubComActivityProductStatisticalInfoVo findDetailByItemVos(Pageable pageable, List<SubComActivityDetailPlanItemVo> planItemVos, SubComActivityDetailPlanDto dto) {
        if (CollectionUtils.isEmpty(planItemVos)) {
            return null;
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page statisticalItemInfoVoPage = new Page();
        List needPlanItems = planItemVos.stream().filter(x -> YesOrNoEnum.YES.getCode().equals(x.getIsPriceRelation())).collect(Collectors.toList());
        ArrayList statisticalItemInfoVos = new ArrayList();
        if (CollectionUtils.isNotEmpty(needPlanItems)) {
            Map subComActivityDetailPlanItemVoMap = needPlanItems.stream().collect(Collectors.toMap(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode, Function.identity()));
            List productShareVos = needPlanItems.stream().map(SubComActivityDetailPlanItemVo::getProductShares).collect(Collectors.toList());
            List<SubComActivityDetailPlanItemProductShareVo> itemProductShareVos = productShareVos.stream().flatMap(Collection::stream).collect(Collectors.toList());
            Set productCodeSet = itemProductShareVos.stream().map(SubComActivityDetailPlanItemProductShareVo::getProductCode).collect(Collectors.toSet());
            SalesPlanDto salesPlanDto = new SalesPlanDto();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            salesPlanDto.setYearMonthLy(df.format(dto.getFeeYearMonth()));
            OrgVo orgVo = this.orgVoService.findByOrgCode(dto.getOrgCode());
            Validate.notNull((Object)orgVo, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u7f16\u7801\u3010%s\u3011\u7ec4\u7ec7\u6570\u636e", (Object[])new Object[]{dto.getOrgCode()});
            salesPlanDto.setSalesInstitutionCode(orgVo.getSalesOrgCode());
            salesPlanDto.setSalesProductCodeList(new ArrayList(productCodeSet));
            List salesPlanVoList = this.salesPlanService.findByConditions(salesPlanDto);
            Map salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.toMap(SalesPlanVo::getProductCode, Function.identity()));
            itemProductShareVos.forEach(productVo -> {
                SubComActivityProductStatisticalItemInfoVo statisticalItemInfoVo = new SubComActivityProductStatisticalItemInfoVo();
                statisticalItemInfoVo.setConstituentDetailPlanItemCode(productVo.getConstituentDetailPlanItemCode());
                statisticalItemInfoVo.setConstituentDetailPlanItemName(productVo.getConstituentDetailPlanItemName());
                statisticalItemInfoVo.setProductCode(productVo.getProductCode());
                statisticalItemInfoVo.setProductName(productVo.getProductName());
                SubComActivityDetailPlanItemVo subComActivityDetailPlanItemVo = (SubComActivityDetailPlanItemVo)subComActivityDetailPlanItemVoMap.get(productVo.getConstituentDetailPlanItemCode());
                if (subComActivityDetailPlanItemVo != null) {
                    statisticalItemInfoVo.setForecastSales(Optional.ofNullable(subComActivityDetailPlanItemVo.getPromoteSales()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(Optional.ofNullable(productVo.getProductRatio()).orElse("0"))));
                    SalesPlanVo salesPlanVo = (SalesPlanVo)salesPlanVoMap.get(productVo.getProductCode());
                    if (salesPlanVo != null) {
                        statisticalItemInfoVo.setForecastCost(statisticalItemInfoVo.getForecastSales().multiply(salesPlanVo.getCifPrice()));
                        statisticalItemInfoVo.setStandardSupplyPrice(salesPlanVo.getStandardSupplyPrice());
                        statisticalItemInfoVo.setPromotionPrice(Optional.ofNullable(salesPlanVo.getStandardSupplyPrice()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(productVo.getDiscountAmount()).orElse(BigDecimal.ZERO)));
                    }
                    statisticalItemInfoVo.setForecastSalesVolume(Optional.ofNullable(subComActivityDetailPlanItemVo.getPromotionAmount()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(Optional.ofNullable(productVo.getProductRatio()).orElse("0"))));
                    statisticalItemInfoVo.setForecastGrossProfit(statisticalItemInfoVo.getForecastSalesVolume().subtract(Optional.ofNullable(statisticalItemInfoVo.getForecastCost()).orElse(BigDecimal.ZERO)));
                }
                statisticalItemInfoVos.add(statisticalItemInfoVo);
            });
            statisticalItemInfoVoPage.setSize((long)pageable.getPageSize());
            statisticalItemInfoVoPage.setPages((long)pageable.getPageNumber());
            statisticalItemInfoVoPage.setTotal((long)itemProductShareVos.size());
            List productShareVosPage = statisticalItemInfoVos.stream().skip((long)(pageable.getPageSize() - 1) * (long)pageable.getPageNumber()).limit(pageable.getPageSize()).collect(Collectors.toList());
            statisticalItemInfoVoPage.setRecords(productShareVosPage);
        }
        SubComActivityProductStatisticalInfoVo subComActivityProductStatisticalInfoVo = new SubComActivityProductStatisticalInfoVo();
        subComActivityProductStatisticalInfoVo.setYearMonthly(dto.getFeeYearMonth());
        subComActivityProductStatisticalInfoVo.setOrgCode(dto.getOrgCode());
        subComActivityProductStatisticalInfoVo.setOrgName(dto.getOrgName());
        subComActivityProductStatisticalInfoVo.setConstituentDetailPlanCode(dto.getConstituentDetailPlanCode());
        subComActivityProductStatisticalInfoVo.setConstituentDetailPlanName(dto.getConstituentDetailPlanName());
        BigDecimal totalForecastSales = statisticalItemInfoVos.stream().map(SubComActivityProductStatisticalItemInfoVo::getForecastSales).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        subComActivityProductStatisticalInfoVo.setTotalForecastSales(totalForecastSales);
        BigDecimal totalForecastCost = statisticalItemInfoVos.stream().map(SubComActivityProductStatisticalItemInfoVo::getForecastCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        subComActivityProductStatisticalInfoVo.setTotalForecastCost(totalForecastCost);
        BigDecimal totalForecastSalesVolume = statisticalItemInfoVos.stream().map(SubComActivityProductStatisticalItemInfoVo::getForecastSalesVolume).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        subComActivityProductStatisticalInfoVo.setTotalForecastSalesVolume(totalForecastSalesVolume);
        BigDecimal totalForecastGrossProfit = statisticalItemInfoVos.stream().map(SubComActivityProductStatisticalItemInfoVo::getForecastGrossProfit).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        subComActivityProductStatisticalInfoVo.setTotalForecastGrossProfit(totalForecastGrossProfit);
        subComActivityProductStatisticalInfoVo.setApplyFee(dto.getTotalApplyAmount());
        if (totalForecastSales.compareTo(BigDecimal.ZERO) != 0) {
            subComActivityProductStatisticalInfoVo.setProductionRatio(NumberUtil.mul((Number)NumberUtil.div((BigDecimal)dto.getTotalApplyAmount(), (BigDecimal)totalForecastSales, (int)6, (RoundingMode)RoundingMode.HALF_UP), (Number)new BigDecimal("100")));
        }
        List shareVos = this.subComActivityDetailPlanItemBudgetShareVoService.findConstituentDetailPlanCode(dto.getConstituentDetailPlanCode());
        subComActivityProductStatisticalInfoVo.setIsOverBudget("\u5426");
        if (CollectionUtils.isNotEmpty((Collection)shareVos)) {
            shareVos.forEach(item -> {
                if (Optional.ofNullable(item.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).subtract(item.getUseAmount()).compareTo(BigDecimal.ZERO) < 0) {
                    subComActivityProductStatisticalInfoVo.setIsOverBudget("\u662f");
                }
            });
        }
        subComActivityProductStatisticalInfoVo.setStatisticalItemInfos(statisticalItemInfoVoPage);
        return subComActivityProductStatisticalInfoVo;
    }

    private void createValidation(SubComActivityProductStatisticalInfoVo subComActivityProductStatisticalInfoVo) {
        this.validation(subComActivityProductStatisticalInfoVo);
    }

    private void updateValidation(SubComActivityProductStatisticalInfoVo subComActivityProductStatisticalInfoVo) {
        this.validation(subComActivityProductStatisticalInfoVo);
    }

    private void validation(SubComActivityProductStatisticalInfoVo subComActivityProductStatisticalInfoVo) {
    }
}

