/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.ActivityClientRelationDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.ActivityDetailItemRelationDetailDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.ActivityGiftRelationDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.MnCrmIf004ServiceDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.MnCrmIf005ServiceDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.MnCrmIf007ServiceDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.OperateJournalFlowDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.PromotionActivityDetailDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.SegmentedActivityTermDto;
import com.biz.crm.tpm.business.activity.form.sdk.enums.SubComActivityValidationFormCodeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.PromotionProductTypeEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.PromotionTypeEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyGiftVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyProductVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.dto.OrderSharePlatformCreateDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third.ThirdCommonMethod;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.ThirdSystemActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MakeOrderShareInterData {
    private static final Logger log = LoggerFactory.getLogger(MakeOrderShareInterData.class);
    @Autowired(required=false)
    private ThirdCommonMethod thirdCommonMethod;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public void buildYAndZDetailPlanItem(SubComActivityDetailPlanVo detailPlan, List<SubComActivityDetailPlanItemVo> DetailPlanItemVos, List<OrderSharePlatformCreateDto> orderSharePlatformCreateDtoList) {
        if (CollectionUtil.isEmpty(DetailPlanItemVos) || ObjectUtils.isEmpty((Object)detailPlan)) {
            return;
        }
        Map<String, PromotionPolicyVO> policyVoMap = this.thirdCommonMethod.getPromotionPolicyMap(DetailPlanItemVos);
        List fromCodes = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map sapCodeMap = this.activityFormService.findSapCode(fromCodes);
        List salesCodes = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map sapSalesMap = this.salesOrgVoService.findSapCodesBySalesOrgCodes(salesCodes);
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        DetailPlanItemVos.forEach(detailPlanItemVo -> {
            MnCrmIf004ServiceDto mnCrmIf004ServiceDto = new MnCrmIf004ServiceDto();
            MnCrmIf007ServiceDto mnCrmIf007ServiceDto = new MnCrmIf007ServiceDto();
            mnCrmIf004ServiceDto.setPromotionId(detailPlanItemVo.getPromotionNo());
            if (!CollectionUtils.isEmpty((Map)sapSalesMap)) {
                mnCrmIf004ServiceDto.setSaleOrganizationCode((String)sapSalesMap.get(detailPlanItemVo.getSalesInstitutionCode()));
            }
            mnCrmIf004ServiceDto.setChannelCode(detailPlanItemVo.getDistributionChannelCode());
            mnCrmIf004ServiceDto.setNoteId(detailPlanItemVo.getActivityNumber());
            mnCrmIf004ServiceDto.setNoteDesc(detailPlanItemVo.getConstituentDetailPlanName());
            if (!CollectionUtils.isEmpty((Map)sapCodeMap)) {
                mnCrmIf004ServiceDto.setActivityType((String)sapCodeMap.get(detailPlanItemVo.getActivityFormCode()));
            }
            mnCrmIf004ServiceDto.setApplyTotalFee(detailPlanItemVo.getTotalCost() != null ? String.format("%.2f", detailPlanItemVo.getTotalCost()) : "0.00");
            mnCrmIf004ServiceDto.setBeginDate(detailPlanItemVo.getActivityBeginTime() != null ? sif.format(detailPlanItemVo.getActivityBeginTime()) : "");
            mnCrmIf004ServiceDto.setEndDate(detailPlanItemVo.getActivityEndTime() != null ? sif.format(detailPlanItemVo.getActivityEndTime()) : "");
            mnCrmIf004ServiceDto.setOrderBeginDate(detailPlanItemVo.getOrderStartDate() != null ? sif.format(detailPlanItemVo.getOrderStartDate()) : "");
            mnCrmIf004ServiceDto.setOrderEndDate(detailPlanItemVo.getOrderEndDate() != null ? sif.format(detailPlanItemVo.getOrderEndDate()) : "");
            String auditType = detailPlanItemVo.getAuditType();
            mnCrmIf004ServiceDto.setConsumeMethod(SubComActivityDetailAuditTypeEnum.THINGS.getCode().equals(auditType) ? SubComActivityDetailAuditTypeEnum.THINGS.getDes() : SubComActivityDetailAuditTypeEnum.AFTER_THE_EVENT.getDes());
            mnCrmIf004ServiceDto.setStatus(ThirdSystemActivityStatusEnum.VALID.getCode());
            if (TotalQuantityOrNotEnum.Y.getCode().equals(detailPlanItemVo.getIsSupplyAmount())) {
                mnCrmIf004ServiceDto.setFlag("X");
            }
            this.buildDetailPlanItemDate(detailPlan, (SubComActivityDetailPlanItemVo)detailPlanItemVo, policyVoMap, mnCrmIf004ServiceDto, mnCrmIf007ServiceDto);
            OrderSharePlatformCreateDto orderSharePlatformCreateDto = new OrderSharePlatformCreateDto();
            orderSharePlatformCreateDto.setMnCrmIf004ServiceDto(mnCrmIf004ServiceDto);
            orderSharePlatformCreateDto.setDetailPlanItemCode(detailPlanItemVo.getConstituentDetailPlanItemCode());
            if (ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getActivityClientRelation()) || ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getActivityDetailItemRelation()) || ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getActivityGiftRelation()) || ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getOperateJournalFlow()) || ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getSegmentedActivityTerm())) {
                String commonGroup = UUID.randomUUID().toString().replace("-", "");
                orderSharePlatformCreateDto.setCommonGroup(commonGroup);
                orderSharePlatformCreateDto.setMnCrmIf007ServiceDto(mnCrmIf007ServiceDto);
            }
            if (orderSharePlatformCreateDtoList != null) {
                orderSharePlatformCreateDtoList.add(orderSharePlatformCreateDto);
            }
        });
    }

    public OrderSharePlatformCreateDto buildNDetailPlanItem(SubComActivityDetailPlanVo detailPlan, List<SubComActivityDetailPlanItemVo> DetailPlanItemVos) {
        if (ObjectUtils.isEmpty((Object)detailPlan) && CollectionUtils.isEmpty(DetailPlanItemVos) && DetailPlanItemVos.size() <= 0) {
            return null;
        }
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        List fromCodes = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map sapCodeMap = this.activityFormService.findSapCode(fromCodes);
        List salesCodes = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map sapSalesMap = this.salesOrgVoService.findSapCodesBySalesOrgCodes(salesCodes);
        Map<String, PromotionPolicyVO> policyVoMap = this.thirdCommonMethod.getPromotionPolicyMap(DetailPlanItemVos);
        MnCrmIf004ServiceDto mnCrmIf004ServiceDto = new MnCrmIf004ServiceDto();
        MnCrmIf007ServiceDto mnCrmIf007ServiceDto = new MnCrmIf007ServiceDto();
        mnCrmIf004ServiceDto.setPromotionId(DetailPlanItemVos.get(0).getPromotionNo());
        if (!CollectionUtils.isEmpty((Map)sapSalesMap)) {
            mnCrmIf004ServiceDto.setSaleOrganizationCode((String)sapSalesMap.get(DetailPlanItemVos.get(0).getSalesInstitutionCode()));
        }
        mnCrmIf004ServiceDto.setChannelCode(DetailPlanItemVos.get(0).getDistributionChannelCode());
        mnCrmIf004ServiceDto.setNoteId(DetailPlanItemVos.get(0).getActivityNumber());
        mnCrmIf004ServiceDto.setNoteDesc(DetailPlanItemVos.get(0).getConstituentDetailPlanName());
        if (!CollectionUtils.isEmpty((Map)sapCodeMap)) {
            mnCrmIf004ServiceDto.setActivityType((String)sapCodeMap.get(DetailPlanItemVos.get(0).getActivityFormCode()));
        }
        BigDecimal totalCost = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        mnCrmIf004ServiceDto.setApplyTotalFee(String.format("%.2f", totalCost));
        List beginTimes = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getActivityBeginTime).filter(Objects::nonNull).collect(Collectors.toList());
        Date beginTime = (Date)Collections.min(beginTimes);
        List endTimes = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getActivityEndTime).filter(Objects::nonNull).collect(Collectors.toList());
        Date endTime = (Date)Collections.max(endTimes);
        List obeginTimes = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getOrderStartDate).filter(Objects::nonNull).collect(Collectors.toList());
        Date obeginTime = (Date)Collections.min(obeginTimes);
        List oendTimes = DetailPlanItemVos.stream().map(SubComActivityDetailPlanItemVo::getOrderEndDate).filter(Objects::nonNull).collect(Collectors.toList());
        Date oendTime = (Date)Collections.max(oendTimes);
        mnCrmIf004ServiceDto.setBeginDate(beginTime != null ? sif.format(beginTime) : "");
        mnCrmIf004ServiceDto.setEndDate(endTime != null ? sif.format(endTime) : "");
        mnCrmIf004ServiceDto.setOrderBeginDate(obeginTime != null ? sif.format(obeginTime) : "");
        mnCrmIf004ServiceDto.setOrderEndDate(oendTime != null ? sif.format(oendTime) : "");
        String auditType = DetailPlanItemVos.get(0).getAuditType();
        mnCrmIf004ServiceDto.setConsumeMethod(StringUtils.isEmpty((CharSequence)auditType) ? "" : (SubComActivityDetailAuditTypeEnum.THINGS.getCode().equals(auditType) ? SubComActivityDetailAuditTypeEnum.THINGS.getDes() : SubComActivityDetailAuditTypeEnum.AFTER_THE_EVENT.getDes()));
        mnCrmIf004ServiceDto.setStatus(ThirdSystemActivityStatusEnum.VALID.getCode());
        if ("Y".equals(DetailPlanItemVos.get(0).getIsSupplyAmount())) {
            mnCrmIf004ServiceDto.setFlag("X");
        }
        DetailPlanItemVos.forEach(detailPlanItemVo -> this.buildDetailPlanItemDate(detailPlan, (SubComActivityDetailPlanItemVo)detailPlanItemVo, policyVoMap, mnCrmIf004ServiceDto, mnCrmIf007ServiceDto));
        List operateJournalFlow = mnCrmIf007ServiceDto.getOperateJournalFlow();
        if (!CollectionUtils.isEmpty((Collection)operateJournalFlow)) {
            BigDecimal conditionPrice = BigDecimal.ZERO;
            Map<String, List<OperateJournalFlowDto>> activityMap = operateJournalFlow.stream().collect(Collectors.groupingBy(OperateJournalFlowDto::getCommonGroup));
            for (String string : activityMap.keySet()) {
                BigDecimal price = activityMap.get(string).get(0).getSegmentedActivityUnitPricePrice();
                conditionPrice = conditionPrice.add(price);
            }
            String format = String.format("%.2f", conditionPrice);
            operateJournalFlow.forEach(operate -> operate.setConditionPrice(format));
        }
        OrderSharePlatformCreateDto orderSharePlatformCreateDto = new OrderSharePlatformCreateDto();
        orderSharePlatformCreateDto.setDetailPlanItemCode(DetailPlanItemVos.get(0).getConstituentDetailPlanItemCode());
        orderSharePlatformCreateDto.setMnCrmIf004ServiceDto(mnCrmIf004ServiceDto);
        if (ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getActivityClientRelation()) || ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getActivityDetailItemRelation()) || ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getActivityGiftRelation()) || ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getOperateJournalFlow()) || ObjectUtils.isNotEmpty((Object)mnCrmIf007ServiceDto.getSegmentedActivityTerm())) {
            String commonGroup = UUID.randomUUID().toString().replace("-", "");
            orderSharePlatformCreateDto.setCommonGroup(commonGroup);
            orderSharePlatformCreateDto.setMnCrmIf007ServiceDto(mnCrmIf007ServiceDto);
        }
        return orderSharePlatformCreateDto;
    }

    public void buildPromotionActivityDetailDto(SubComActivityDetailPlanVo detailPlan, SubComActivityDetailPlanItemVo detailPlanItemVo, PromotionActivityDetailDto promotionActivityDetailDto) {
        promotionActivityDetailDto.setPromotionId(detailPlanItemVo.getPromotionNo());
        promotionActivityDetailDto.setPromotionLineId(detailPlanItemVo.getConstituentDetailPlanItemCode());
        DictDataVo businessFormatCodeVo = this.dictDataVoService.findByDictTypeCodeAndDictCode("mdm_business_format", detailPlanItemVo.getBusinessFormatCode());
        Validate.notNull((Object)businessFormatCodeVo, (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u3010%s\u3011\u7684\u6570\u636e\u5b57\u5178", (Object[])new Object[]{detailPlanItemVo.getBusinessFormatCode()});
        Map extendMap = businessFormatCodeVo.getExtendMap();
        if (extendMap != null) {
            String businessCode = (String)extendMap.get("ZFYT");
            promotionActivityDetailDto.setBusinessState(businessCode);
        }
        promotionActivityDetailDto.setBrand(detailPlanItemVo.getProductBrandCode());
        promotionActivityDetailDto.setCategory(detailPlanItemVo.getProductCategoryCode());
        promotionActivityDetailDto.setApplyFee(detailPlanItemVo.getTotalCost() != null ? String.format("%.2f", detailPlanItemVo.getTotalCost()) : "0.00");
        promotionActivityDetailDto.setPromotionQuantity(detailPlanItemVo.getPromoteSales() != null ? String.format("%.3f", detailPlanItemVo.getPromoteSales()) : "0.00");
        promotionActivityDetailDto.setActivityExplain(detailPlanItemVo.getActivityIntensity());
        promotionActivityDetailDto.setHeadInputAmount(detailPlanItemVo.getHeadquartersSupportedAmount() != null ? String.format("%.2f", detailPlanItemVo.getHeadquartersSupportedAmount()) : "0.00");
        promotionActivityDetailDto.setInputAmount(detailPlanItemVo.getSubComAutoAmount() != null ? String.format("%.2f", detailPlanItemVo.getSubComAutoAmount()) : "0.00");
        promotionActivityDetailDto.setSpecialPrice(detailPlanItemVo.getActivityPrice() != null ? String.format("%.2f", detailPlanItemVo.getActivityPrice()) : "0.00");
        promotionActivityDetailDto.setSpecification(detailPlanItemVo.getActivityDesc());
        if (BooleanEnum.FALSE.getCapital().equals(detailPlanItemVo.getIsAssPromotion())) {
            promotionActivityDetailDto.setItemSubject(detailPlanItemVo.getProductItemCode());
            promotionActivityDetailDto.setMaterialCode(detailPlanItemVo.getProductCode());
            promotionActivityDetailDto.setQuantity(detailPlanItemVo.getOriginalProductNumber() != null ? String.format("%.3f", detailPlanItemVo.getOriginalProductNumber()) : "0.00");
            promotionActivityDetailDto.setGiftCode(detailPlanItemVo.getGiftProductCode());
            promotionActivityDetailDto.setGiftQuantity(detailPlanItemVo.getGiftProductNumber() != null ? String.format("%.3f", detailPlanItemVo.getGiftProductNumber()) : "0.00");
            promotionActivityDetailDto.setSaleUnit(detailPlanItemVo.getUnitCode());
        }
    }

    public void buildMnCrmIf007ServiceDto(MnCrmIf007ServiceDto mnCrmIf007ServiceDto, int i) {
        if (ObjectUtils.isEmpty((Object)mnCrmIf007ServiceDto)) {
            return;
        }
        switch (i) {
            case 1: {
                ArrayList activityClientRelationList = new ArrayList();
                mnCrmIf007ServiceDto.setActivityClientRelation(activityClientRelationList);
                break;
            }
            case 2: {
                ArrayList segmentedActivityTermList = new ArrayList();
                mnCrmIf007ServiceDto.setSegmentedActivityTerm(segmentedActivityTermList);
                break;
            }
            case 3: {
                ArrayList activityDetailItemRelationList = new ArrayList();
                mnCrmIf007ServiceDto.setActivityDetailItemRelation(activityDetailItemRelationList);
                break;
            }
            case 4: {
                ArrayList activityGiftRelationList = new ArrayList();
                mnCrmIf007ServiceDto.setActivityGiftRelation(activityGiftRelationList);
                break;
            }
            case 5: {
                ArrayList operateJournalFlowList = new ArrayList();
                mnCrmIf007ServiceDto.setOperateJournalFlow(operateJournalFlowList);
            }
        }
    }

    public void buildDetailPlanItemDate(SubComActivityDetailPlanVo detailPlan, SubComActivityDetailPlanItemVo detailPlanItemVo, Map<String, PromotionPolicyVO> policyVOMap, MnCrmIf004ServiceDto mnCrmIf004ServiceDto, MnCrmIf007ServiceDto mnCrmIf007ServiceDto) {
        if (ObjectUtils.isEmpty((Object)detailPlan) && ObjectUtils.isEmpty((Object)detailPlanItemVo) && ObjectUtils.isEmpty((Object)mnCrmIf004ServiceDto) && ObjectUtils.isEmpty((Object)mnCrmIf007ServiceDto)) {
            return;
        }
        PromotionActivityDetailDto promotionActivityDetailDto = new PromotionActivityDetailDto();
        this.buildPromotionActivityDetailDto(detailPlan, detailPlanItemVo, promotionActivityDetailDto);
        String customerCode = detailPlanItemVo.getCustomerCode();
        if (StringUtils.isNotBlank((CharSequence)customerCode)) {
            String[] customerCodes = customerCode.split(",");
            if (customerCodes.length > 1) {
                for (String code : customerCodes) {
                    if (StringUtils.isNotBlank((CharSequence)code) && code.length() > 10) {
                        code = code.substring(0, 10);
                    }
                    ActivityClientRelationDto activityClientRelation = new ActivityClientRelationDto();
                    activityClientRelation.setActivityId(detailPlanItemVo.getPromotionNo());
                    activityClientRelation.setClientId(code);
                    if (CollectionUtils.isEmpty((Collection)mnCrmIf007ServiceDto.getActivityClientRelation())) {
                        this.buildMnCrmIf007ServiceDto(mnCrmIf007ServiceDto, 1);
                    }
                    mnCrmIf007ServiceDto.getActivityClientRelation().add(activityClientRelation);
                }
            } else {
                String cusCode = detailPlanItemVo.getCustomerCode();
                if (StringUtils.isNotBlank((CharSequence)cusCode) && cusCode.length() > 10) {
                    cusCode = cusCode.substring(0, 10);
                }
                mnCrmIf004ServiceDto.setCustomerCode(cusCode);
                promotionActivityDetailDto.setCustomerCode(cusCode);
            }
        }
        if (BooleanEnum.TRUE.getCapital().equals(detailPlanItemVo.getIsAssPromotion())) {
            PromotionPolicyVO promotionPolicy = policyVOMap.get(detailPlanItemVo.getPromotionCode());
            if (Objects.nonNull(promotionPolicy)) {
                List promotionPolicyLadders;
                List promotionPolicyProducts = promotionPolicy.getPromotionPolicyProducts();
                if (CollectionUtil.isNotEmpty((Collection)promotionPolicyProducts)) {
                    if (PromotionTypeEnum.SPECIAL_PRICE.getCode().equals(promotionPolicy.getPromotionTypeCode()) && PromotionProductTypeEnum.GROUP_SPECIAL_PRICE.getCode().equals(promotionPolicy.getPromotionProductType())) {
                        for (int i = 1; i <= promotionPolicyProducts.size(); ++i) {
                            PromotionPolicyProductVO productVO2 = (PromotionPolicyProductVO)promotionPolicyProducts.get(i - 1);
                            if (!StringUtils.isNotBlank((CharSequence)detailPlanItemVo.getCommonGroups()) || !detailPlanItemVo.getCommonGroups().equals(productVO2.getCommonGroup())) continue;
                            OperateJournalFlowDto operateJournalFlow = new OperateJournalFlowDto();
                            operateJournalFlow.setActivityId(detailPlanItemVo.getPromotionNo());
                            operateJournalFlow.setActivityTermId(detailPlanItemVo.getConstituentDetailPlanItemCode());
                            operateJournalFlow.setSegmentedActivityId("00000001");
                            operateJournalFlow.setGiftQuantity("0.00");
                            operateJournalFlow.setOperateJournalFlowId("0000000" + i);
                            operateJournalFlow.setItemId(productVO2.getProductCode());
                            Integer quantity = productVO2.getQuantity() != null ? productVO2.getQuantity() : 0;
                            promotionActivityDetailDto.setQuantity(String.valueOf(quantity));
                            operateJournalFlow.setItemQuantity(String.valueOf(quantity));
                            BigDecimal activityPrice = detailPlanItemVo.getActivityPrice() != null ? detailPlanItemVo.getActivityPrice() : BigDecimal.ZERO;
                            operateJournalFlow.setSegmentedActivityUnitPrice(String.format("%.2f", activityPrice));
                            operateJournalFlow.setSegmentedActivityUnitPricePrice(activityPrice.multiply(new BigDecimal(quantity)));
                            operateJournalFlow.setSalesUnit(productVO2.getSaleUnit());
                            promotionActivityDetailDto.setSaleUnit(productVO2.getSaleUnit());
                            operateJournalFlow.setCommonGroup(productVO2.getCommonGroup());
                            operateJournalFlow.setTailDifference("0.00");
                            if (CollectionUtils.isEmpty((Collection)mnCrmIf007ServiceDto.getOperateJournalFlow())) {
                                this.buildMnCrmIf007ServiceDto(mnCrmIf007ServiceDto, 5);
                            }
                            mnCrmIf007ServiceDto.getOperateJournalFlow().add(operateJournalFlow);
                        }
                    } else {
                        promotionPolicyProducts.forEach(productVO -> {
                            promotionActivityDetailDto.setSaleUnit(productVO.getSaleUnit());
                            ActivityDetailItemRelationDetailDto activityDetailItemRelationDetail = new ActivityDetailItemRelationDetailDto();
                            activityDetailItemRelationDetail.setActivityId(detailPlanItemVo.getPromotionNo());
                            activityDetailItemRelationDetail.setActivityTermId(detailPlanItemVo.getConstituentDetailPlanItemCode());
                            activityDetailItemRelationDetail.setItemId(productVO.getProductCode());
                            if (CollectionUtils.isEmpty((Collection)mnCrmIf007ServiceDto.getActivityDetailItemRelation())) {
                                this.buildMnCrmIf007ServiceDto(mnCrmIf007ServiceDto, 3);
                            }
                            mnCrmIf007ServiceDto.getActivityDetailItemRelation().add(activityDetailItemRelationDetail);
                        });
                    }
                }
                if (CollectionUtil.isNotEmpty((Collection)(promotionPolicyLadders = promotionPolicy.getPromotionPolicyLadders())) && !PromotionProductTypeEnum.GROUP_SPECIAL_PRICE.getCode().equals(promotionPolicy.getPromotionProductType())) {
                    HashSet productCodes = new HashSet();
                    promotionPolicyLadders.forEach(ladderVO -> {
                        SegmentedActivityTermDto segmentedActivityTerm = new SegmentedActivityTermDto();
                        segmentedActivityTerm.setActivityId(detailPlanItemVo.getPromotionNo());
                        segmentedActivityTerm.setActivityTermId(detailPlanItemVo.getConstituentDetailPlanItemCode());
                        segmentedActivityTerm.setSegmentedActivityId(ladderVO.getSuccessively() != null ? ladderVO.getSuccessively().toString() : "");
                        segmentedActivityTerm.setWithSendNotReUsable(promotionPolicy.getLadderMultiplex());
                        segmentedActivityTerm.setItemQuantity(ladderVO.getMeetPriceOrQuantity() != null ? ladderVO.getMeetPriceOrQuantity().toString() : "0");
                        if (PromotionTypeEnum.GIFT.getCode().equals(promotionPolicy.getPromotionTypeCode())) {
                            segmentedActivityTerm.setSalesUnit(ladderVO.getUnit());
                            List giftList = ladderVO.getPromotionPolicyGiftList();
                            if (CollectionUtil.isNotEmpty((Collection)giftList)) {
                                if (giftList.size() == 1) {
                                    segmentedActivityTerm.setGiftId(((PromotionPolicyGiftVO)giftList.get(0)).getProductCode());
                                } else {
                                    giftList.forEach(gift -> productCodes.add(gift.getProductCode()));
                                }
                            }
                            segmentedActivityTerm.setGiftQuantity(ladderVO.getGivePriceOrQuantity() != null ? ladderVO.getGivePriceOrQuantity().toString() : "0");
                        } else {
                            segmentedActivityTerm.setSpecialOfferPrice(ladderVO.getGivePriceOrQuantity() != null ? ladderVO.getGivePriceOrQuantity().toString() : "");
                        }
                        if (CollectionUtils.isEmpty((Collection)mnCrmIf007ServiceDto.getSegmentedActivityTerm())) {
                            this.buildMnCrmIf007ServiceDto(mnCrmIf007ServiceDto, 2);
                        }
                        mnCrmIf007ServiceDto.getSegmentedActivityTerm().add(segmentedActivityTerm);
                    });
                    if (CollectionUtil.isNotEmpty(productCodes)) {
                        productCodes.forEach(productCode -> {
                            ActivityGiftRelationDto activityGiftRelation = new ActivityGiftRelationDto();
                            activityGiftRelation.setActivityId(detailPlanItemVo.getPromotionNo());
                            activityGiftRelation.setActivityTermId(detailPlanItemVo.getConstituentDetailPlanItemCode());
                            activityGiftRelation.setGiftId(productCode);
                            if (CollectionUtils.isEmpty((Collection)mnCrmIf007ServiceDto.getActivityGiftRelation())) {
                                this.buildMnCrmIf007ServiceDto(mnCrmIf007ServiceDto, 4);
                            }
                            mnCrmIf007ServiceDto.getActivityGiftRelation().add(activityGiftRelation);
                        });
                    }
                }
            }
        } else if (TotalQuantityOrNotEnum.Z.getCode().equals(detailPlanItemVo.getIsSupplyAmount())) {
            if (SubComActivityValidationFormCodeEnum.ZS03.name().equals(detailPlanItemVo.getActivityFormCode())) {
                OperateJournalFlowDto operateJournalFlow = new OperateJournalFlowDto();
                operateJournalFlow.setActivityId(detailPlanItemVo.getPromotionNo());
                operateJournalFlow.setActivityTermId(detailPlanItemVo.getConstituentDetailPlanItemCode());
                operateJournalFlow.setSegmentedActivityId("00000001");
                operateJournalFlow.setGiftQuantity("0.00");
                operateJournalFlow.setOperateJournalFlowId("00000001");
                operateJournalFlow.setItemId(detailPlanItemVo.getProductCode());
                Integer quantity = 0;
                promotionActivityDetailDto.setQuantity(String.valueOf(quantity));
                operateJournalFlow.setItemQuantity(String.valueOf(quantity));
                BigDecimal activityPrice = detailPlanItemVo.getActivityPrice() != null ? detailPlanItemVo.getActivityPrice() : BigDecimal.ZERO;
                operateJournalFlow.setSegmentedActivityUnitPrice(String.format("%.2f", activityPrice));
                operateJournalFlow.setSegmentedActivityUnitPricePrice(activityPrice.multiply(new BigDecimal(quantity)));
                operateJournalFlow.setSalesUnit(detailPlanItemVo.getUnitCode());
                promotionActivityDetailDto.setSaleUnit(detailPlanItemVo.getUnitCode());
                String commonGroup = UUID.randomUUID().toString().replace("-", "");
                operateJournalFlow.setCommonGroup(commonGroup);
                operateJournalFlow.setTailDifference("0.00");
                if (CollectionUtils.isEmpty((Collection)mnCrmIf007ServiceDto.getOperateJournalFlow())) {
                    this.buildMnCrmIf007ServiceDto(mnCrmIf007ServiceDto, 5);
                }
                mnCrmIf007ServiceDto.getOperateJournalFlow().add(operateJournalFlow);
            } else if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(detailPlanItemVo.getActivityFormCode())) {
                promotionActivityDetailDto.setSaleUnit(detailPlanItemVo.getUnitCode());
                ActivityDetailItemRelationDetailDto activityDetailItemRelationDetail = new ActivityDetailItemRelationDetailDto();
                activityDetailItemRelationDetail.setActivityId(detailPlanItemVo.getPromotionNo());
                activityDetailItemRelationDetail.setActivityTermId(detailPlanItemVo.getConstituentDetailPlanItemCode());
                activityDetailItemRelationDetail.setItemId(detailPlanItemVo.getProductCode());
                if (CollectionUtils.isEmpty((Collection)mnCrmIf007ServiceDto.getActivityDetailItemRelation())) {
                    this.buildMnCrmIf007ServiceDto(mnCrmIf007ServiceDto, 3);
                }
                mnCrmIf007ServiceDto.getActivityDetailItemRelation().add(activityDetailItemRelationDetail);
                SegmentedActivityTermDto segmentedActivityTerm = new SegmentedActivityTermDto();
                segmentedActivityTerm.setActivityId(detailPlanItemVo.getPromotionNo());
                segmentedActivityTerm.setActivityTermId(detailPlanItemVo.getConstituentDetailPlanItemCode());
                segmentedActivityTerm.setSegmentedActivityId("1");
                segmentedActivityTerm.setItemQuantity(detailPlanItemVo.getOriginalProductNumber() != null ? detailPlanItemVo.getOriginalProductNumber().toString() : "0");
                segmentedActivityTerm.setSalesUnit(detailPlanItemVo.getUnitCode());
                segmentedActivityTerm.setGiftId(detailPlanItemVo.getGiftProductCode());
                segmentedActivityTerm.setGiftQuantity(detailPlanItemVo.getGiftProductNumber() != null ? detailPlanItemVo.getGiftProductNumber().toString() : "0");
                if (CollectionUtils.isEmpty((Collection)mnCrmIf007ServiceDto.getSegmentedActivityTerm())) {
                    this.buildMnCrmIf007ServiceDto(mnCrmIf007ServiceDto, 2);
                }
                mnCrmIf007ServiceDto.getSegmentedActivityTerm().add(segmentedActivityTerm);
            }
        }
        if (StringUtils.isEmpty((CharSequence)promotionActivityDetailDto.getQuantity())) {
            promotionActivityDetailDto.setQuantity("0");
        }
        if (StringUtils.isEmpty((CharSequence)promotionActivityDetailDto.getGiftQuantity())) {
            promotionActivityDetailDto.setGiftQuantity("0");
        }
        if (ObjectUtils.isEmpty((Object)mnCrmIf004ServiceDto.getItems())) {
            ArrayList<PromotionActivityDetailDto> promotionActivityDetailDtoList = new ArrayList<PromotionActivityDetailDto>();
            promotionActivityDetailDtoList.add(promotionActivityDetailDto);
            mnCrmIf004ServiceDto.setItems(promotionActivityDetailDtoList);
        } else {
            mnCrmIf004ServiceDto.getItems().add(promotionActivityDetailDto);
        }
    }

    public List<MnCrmIf005ServiceDto> sumQuantityAndFee(List<SubComActivityDetailPlanItemVo> planItemList) {
        if (CollectionUtils.isEmpty(planItemList)) {
            return Lists.newArrayList();
        }
        List detailPlanItemWithYList = planItemList.stream().filter(k -> TotalQuantityOrNotEnum.Y.getCode().equals(k.getIsSupplyAmount()) && (InterfacePushStateEnum.NOT_PUSH.getCode().equals(k.getOrderShareInterfaceState()) || InterfacePushStateEnum.FAIL.getCode().equals(k.getOrderShareInterfaceState()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailPlanItemWithYList)) {
            return Lists.newArrayList();
        }
        ArrayList<MnCrmIf005ServiceDto> list = new ArrayList<MnCrmIf005ServiceDto>();
        Map<String, List<SubComActivityDetailPlanItemVo>> activityMap = detailPlanItemWithYList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getActivityNumber));
        Set<String> numberList = activityMap.keySet();
        for (String number : numberList) {
            List<SubComActivityDetailPlanItemVo> value = activityMap.get(number);
            BigDecimal totalCost = value.stream().map(SubComActivityDetailPlanItemVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal promoteSales = value.stream().map(SubComActivityDetailPlanItemVo::getPromoteSales).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            MnCrmIf005ServiceDto mnCrmIf005ServiceDto = new MnCrmIf005ServiceDto();
            mnCrmIf005ServiceDto.setActivityNoteId(number);
            mnCrmIf005ServiceDto.setApplyItemQuantity(String.format("%.3f", promoteSales));
            mnCrmIf005ServiceDto.setApplyFee(String.format("%.3f", totalCost));
            list.add(mnCrmIf005ServiceDto);
        }
        return list;
    }
}

