/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.CreatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.UpdatePromotionActivityBranchDto;
import com.biz.crm.tpm.business.activity.form.sdk.enums.SubComActivityValidationFormCodeEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.PromotionProductTypeEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.PromotionTypeEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyGiftVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyLadderVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyProductVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third.ThirdCommonMethod;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.ThirdSystemActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class MakeSapBranchInterData {
    private static final Logger log = LoggerFactory.getLogger(MakeSapBranchInterData.class);
    @Autowired(required=false)
    private ThirdCommonMethod thirdCommonMethod;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public List<CreatePromotionActivityBranchDto> buildDetailPlanItemForCreateInter(List<SubComActivityDetailPlanItemVo> detailPlanItemList) {
        CreatePromotionActivityBranchDto dto;
        List<SubComActivityDetailPlanItemVo> items;
        Map<String, List<SubComActivityDetailPlanItemVo>> activityMap;
        if (CollectionUtils.isEmpty(detailPlanItemList)) {
            return Lists.newArrayList();
        }
        Map<String, String> sapCodeMap = this.thirdCommonMethod.getSapCodeMap(detailPlanItemList);
        Map<String, PromotionPolicyVO> promotionPolicyMap = this.thirdCommonMethod.getPromotionPolicyMap(detailPlanItemList);
        List itemYList = detailPlanItemList.stream().filter(k -> TotalQuantityOrNotEnum.Y.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        List itemNList = detailPlanItemList.stream().filter(k -> TotalQuantityOrNotEnum.N.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        List<SubComActivityDetailPlanItemVo> itemZList = detailPlanItemList.stream().filter(k -> TotalQuantityOrNotEnum.Z.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        ArrayList<CreatePromotionActivityBranchDto> dtoList = new ArrayList<CreatePromotionActivityBranchDto>();
        if (!CollectionUtils.isEmpty(itemYList)) {
            activityMap = itemYList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getActivityNumber));
            for (Map.Entry<String, List<SubComActivityDetailPlanItemVo>> entry : activityMap.entrySet()) {
                items = entry.getValue();
                dto = this.takeY(items, sapCodeMap, promotionPolicyMap);
                dtoList.addAll((Collection<CreatePromotionActivityBranchDto>)dto);
            }
        }
        if (!CollectionUtils.isEmpty(itemNList)) {
            activityMap = itemNList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getPromotionNo));
            for (Map.Entry<String, List<SubComActivityDetailPlanItemVo>> entry : activityMap.entrySet()) {
                items = entry.getValue();
                dto = this.takeN(items, sapCodeMap);
                dtoList.add(dto);
            }
        }
        if (!CollectionUtils.isEmpty(itemZList)) {
            List<CreatePromotionActivityBranchDto> list = this.takeZ(itemZList, sapCodeMap, promotionPolicyMap);
            dtoList.addAll(list);
        }
        return dtoList;
    }

    private List<CreatePromotionActivityBranchDto> takeZ(List<SubComActivityDetailPlanItemVo> itemZList, Map<String, String> sapCodeMap, Map<String, PromotionPolicyVO> promotionPolicyMap) {
        ArrayList<CreatePromotionActivityBranchDto> list = new ArrayList<CreatePromotionActivityBranchDto>();
        List salesCodes = itemZList.stream().map(SubComActivityDetailPlanItemVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map sapSalesMap = this.salesOrgVoService.findSapCodesBySalesOrgCodes(salesCodes);
        itemZList.forEach(item -> {
            CreatePromotionActivityBranchDto dto = new CreatePromotionActivityBranchDto();
            dto.setITEM1(new ArrayList());
            CreatePromotionActivityBranchDto.Item1 item1 = this.takeItem1FromPlanItem((SubComActivityDetailPlanItemVo)item, sapCodeMap, sapSalesMap);
            dto.getITEM1().add(item1);
            dto.setITEM3(new ArrayList());
            CreatePromotionActivityBranchDto.Item3 item3 = this.takeItem3FromPlanItem((SubComActivityDetailPlanItemVo)item);
            dto.getITEM3().add(item3);
            List<CreatePromotionActivityBranchDto.Item6> item6List = this.takeItem6FromPlanItem((SubComActivityDetailPlanItemVo)item);
            dto.setITEM6(item6List);
            if (!CollectionUtils.isEmpty((Map)promotionPolicyMap) && BooleanEnum.TRUE.getCapital().equals(item.getIsAssPromotion())) {
                PromotionPolicyVO promotionPolicy = (PromotionPolicyVO)promotionPolicyMap.get(item.getPromotionCode());
                if (!PromotionProductTypeEnum.GROUP_SPECIAL_PRICE.getCode().equals(promotionPolicy.getPromotionProductType())) {
                    List<CreatePromotionActivityBranchDto.Item4> item4List = this.takeItem4FormPlanItem((SubComActivityDetailPlanItemVo)item, promotionPolicy);
                    List<CreatePromotionActivityBranchDto.Item5> item5List = this.takeItem5FormPlanItem((SubComActivityDetailPlanItemVo)item, promotionPolicy);
                    List<CreatePromotionActivityBranchDto.Item7> item7List = this.takeItem7FormPlanItem((SubComActivityDetailPlanItemVo)item, promotionPolicy);
                    dto.setITEM4(item4List);
                    dto.setITEM5(item5List);
                    dto.setITEM7(item7List);
                }
                item3.setVRKME(((PromotionPolicyProductVO)promotionPolicy.getPromotionPolicyProducts().get(0)).getSaleUnit());
            } else if (!BooleanEnum.TRUE.getCapital().equals(item.getIsAssPromotion()) && TotalQuantityOrNotEnum.Z.getCode().equals(item.getIsSupplyAmount())) {
                List<CreatePromotionActivityBranchDto.Item4> item4List = this.takeItem4FormPlanItem((SubComActivityDetailPlanItemVo)item, null);
                List<CreatePromotionActivityBranchDto.Item5> item5List = this.takeItem5FormPlanItem((SubComActivityDetailPlanItemVo)item, null);
                List<CreatePromotionActivityBranchDto.Item7> item7List = this.takeItem7FormPlanItem((SubComActivityDetailPlanItemVo)item, null);
                dto.setITEM4(item4List);
                dto.setITEM5(item5List);
                dto.setITEM7(item7List);
                item3.setVRKME(item.getUnitCode());
            }
            list.add(dto);
        });
        return list;
    }

    private CreatePromotionActivityBranchDto takeN(List<SubComActivityDetailPlanItemVo> itemNList, Map<String, String> sapCodeMap) {
        Map<String, PromotionPolicyVO> promotionPolicyMap = this.thirdCommonMethod.getPromotionPolicyMap(itemNList);
        SubComActivityDetailPlanItemVo itemVo = itemNList.get(0);
        CreatePromotionActivityBranchDto dto = new CreatePromotionActivityBranchDto();
        List salesCodes = itemNList.stream().map(SubComActivityDetailPlanItemVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map sapSalesMap = this.salesOrgVoService.findSapCodesBySalesOrgCodes(salesCodes);
        CreatePromotionActivityBranchDto.Item1 item1 = this.takeItem1FromPlanItem(itemVo, sapCodeMap, sapSalesMap);
        BigDecimal totalCost = itemNList.stream().map(SubComActivityDetailPlanItemVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        item1.setZFSQFY(String.format("%.2f", totalCost));
        dto.setITEM1(new ArrayList());
        dto.getITEM1().add(item1);
        dto.setITEM3(new ArrayList());
        itemNList.forEach(item -> {
            CreatePromotionActivityBranchDto.Item3 item3 = this.takeItem3FromPlanItem((SubComActivityDetailPlanItemVo)item);
            if (!CollectionUtils.isEmpty((Map)promotionPolicyMap) && BooleanEnum.TRUE.getCapital().equals(item.getIsAssPromotion())) {
                item3.setVRKME(((PromotionPolicyProductVO)((PromotionPolicyVO)promotionPolicyMap.get(item.getPromotionCode())).getPromotionPolicyProducts().get(0)).getSaleUnit());
            }
            dto.getITEM3().add(item3);
        });
        List<CreatePromotionActivityBranchDto.Item8> item8List = this.takeItem8FormPlanItem(itemNList, promotionPolicyMap);
        dto.setITEM8(item8List);
        return dto;
    }

    private List<CreatePromotionActivityBranchDto> takeY(List<SubComActivityDetailPlanItemVo> itemYList, Map<String, String> sapCodeMap, Map<String, PromotionPolicyVO> promotionPolicyMap) {
        ArrayList<CreatePromotionActivityBranchDto> list = new ArrayList<CreatePromotionActivityBranchDto>();
        List salesCodes = itemYList.stream().map(SubComActivityDetailPlanItemVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map sapSalesMap = this.salesOrgVoService.findSapCodesBySalesOrgCodes(salesCodes);
        itemYList.forEach(item -> {
            CreatePromotionActivityBranchDto dto = new CreatePromotionActivityBranchDto();
            dto.setITEM1(new ArrayList());
            CreatePromotionActivityBranchDto.Item1 item1 = this.takeItem1FromPlanItem((SubComActivityDetailPlanItemVo)item, sapCodeMap, sapSalesMap);
            dto.getITEM1().add(item1);
            dto.setITEM2(new ArrayList());
            CreatePromotionActivityBranchDto.Item2 item2 = new CreatePromotionActivityBranchDto.Item2();
            BigDecimal totalCost = itemYList.stream().map(SubComActivityDetailPlanItemVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal promoteSales = itemYList.stream().map(SubComActivityDetailPlanItemVo::getPromoteSales).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            item2.setZFHDBQ(item.getActivityNumber());
            item2.setZFSQFY(String.format("%.2f", totalCost));
            item2.setZFSQCXL(String.format("%.3f", promoteSales));
            dto.getITEM2().add(item2);
            dto.setITEM3(new ArrayList());
            CreatePromotionActivityBranchDto.Item3 item3 = this.takeItem3FromPlanItem((SubComActivityDetailPlanItemVo)item);
            dto.getITEM3().add(item3);
            if (!CollectionUtils.isEmpty((Map)promotionPolicyMap) && BooleanEnum.TRUE.getCapital().equals(item.getIsAssPromotion())) {
                PromotionPolicyVO promotionPolicy = (PromotionPolicyVO)promotionPolicyMap.get(item.getPromotionCode());
                if (!PromotionProductTypeEnum.GROUP_SPECIAL_PRICE.getCode().equals(promotionPolicy.getPromotionProductType())) {
                    List<CreatePromotionActivityBranchDto.Item4> item4List = this.takeItem4FormPlanItem((SubComActivityDetailPlanItemVo)item, promotionPolicy);
                    List<CreatePromotionActivityBranchDto.Item5> item5List = this.takeItem5FormPlanItem((SubComActivityDetailPlanItemVo)item, promotionPolicy);
                    List<CreatePromotionActivityBranchDto.Item7> item7List = this.takeItem7FormPlanItem((SubComActivityDetailPlanItemVo)item, promotionPolicy);
                    dto.setITEM4(item4List);
                    dto.setITEM5(item5List);
                    dto.setITEM7(item7List);
                }
                item3.setVRKME(((PromotionPolicyProductVO)promotionPolicy.getPromotionPolicyProducts().get(0)).getSaleUnit());
            }
            list.add(dto);
        });
        return list;
    }

    private CreatePromotionActivityBranchDto.Item1 takeItem1FromPlanItem(SubComActivityDetailPlanItemVo planItem, Map<String, String> sapCodeMap, Map<String, String> sapSalesMap) {
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        CreatePromotionActivityBranchDto.Item1 item1 = new CreatePromotionActivityBranchDto.Item1();
        item1.setZFCXHD(planItem.getPromotionNo());
        item1.setVTWEG(planItem.getDistributionChannelCode());
        if (StringUtils.isNotBlank((CharSequence)planItem.getSalesInstitutionCode())) {
            item1.setVKORG(sapSalesMap.get(planItem.getSalesInstitutionCode()));
        }
        item1.setZFHDBQ(planItem.getActivityNumber());
        item1.setZFHDFAM(planItem.getConstituentDetailPlanName());
        if (!TotalQuantityOrNotEnum.Z.getCode().equals(planItem.getIsSupplyAmount())) {
            item1.setZFCXKUN(planItem.getCustomerCode());
        }
        item1.setZFHDGROUP(TotalQuantityOrNotEnum.Y.getCode().equals(planItem.getIsSupplyAmount()) ? "X" : "");
        if (!StringUtils.isBlank((CharSequence)planItem.getActivityFormCode())) {
            item1.setZFHDXS(sapCodeMap.get(planItem.getActivityFormCode()));
        }
        item1.setZFSQFY(planItem.getTotalCost() != null ? String.format("%.2f", planItem.getTotalCost()) : null);
        item1.setWAERS("CNY");
        item1.setDATAB(planItem.getActivityBeginTime() != null ? sif.format(planItem.getActivityBeginTime()) : null);
        item1.setDATBI(planItem.getActivityEndTime() != null ? sif.format(planItem.getActivityEndTime()) : null);
        item1.setZFBEGIN(planItem.getOrderStartDate() != null ? sif.format(planItem.getOrderStartDate()) : null);
        item1.setZFEND(planItem.getOrderEndDate() != null ? sif.format(planItem.getOrderEndDate()) : null);
        item1.setZFHXFS(StringUtils.isEmpty((CharSequence)planItem.getAuditType()) ? null : (SubComActivityDetailAuditTypeEnum.THINGS.getCode().equals(planItem.getAuditType()) ? SubComActivityDetailAuditTypeEnum.THINGS.getDes() : SubComActivityDetailAuditTypeEnum.AFTER_THE_EVENT.getDes()));
        item1.setZFHDZT(ThirdSystemActivityStatusEnum.VALID.getCode());
        return item1;
    }

    private CreatePromotionActivityBranchDto.Item3 takeItem3FromPlanItem(SubComActivityDetailPlanItemVo planItem) {
        CreatePromotionActivityBranchDto.Item3 item3 = new CreatePromotionActivityBranchDto.Item3();
        item3.setZFCXHD(planItem.getPromotionNo());
        item3.setZFHDITEM(planItem.getConstituentDetailPlanItemCode());
        DictDataVo businessFormatCodeVo = this.dictDataVoService.findByDictTypeCodeAndDictCode("mdm_business_format", planItem.getBusinessFormatCode());
        Validate.notNull((Object)businessFormatCodeVo, (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u3010%s\u3011\u7684\u6570\u636e\u5b57\u5178", (Object[])new Object[]{planItem.getBusinessFormatCode()});
        Map extendMap = businessFormatCodeVo.getExtendMap();
        if (extendMap != null) {
            String zfyt = (String)extendMap.get("ZFYT");
            item3.setZFYT(zfyt);
        }
        item3.setZFXSSM(planItem.getActivityFormDesc());
        if (!TotalQuantityOrNotEnum.Z.getCode().equals(planItem.getIsSupplyAmount())) {
            item3.setZFCXKUN(planItem.getCustomerCode());
        }
        item3.setZFSQFY(planItem.getTotalCost() != null ? String.format("%.2f", planItem.getTotalCost()) : "0");
        item3.setZFSQCXL(planItem.getPromoteSales() != null ? String.format("%.3f", planItem.getPromoteSales()) : "0");
        item3.setZFHDLD(!StringUtils.isBlank((CharSequence)planItem.getActivityIntensity()) ? planItem.getActivityIntensity() : "");
        item3.setZFZBTRJE(planItem.getHeadquartersSupportedAmount() != null ? String.format("%.3f", planItem.getHeadquartersSupportedAmount()) : "0");
        item3.setZFGSZTJE(planItem.getSubComAutoAmount() != null ? String.format("%.3f", planItem.getSubComAutoAmount()) : "0");
        if (!BooleanEnum.TRUE.getCapital().equals(planItem.getIsAssPromotion()) && !TotalQuantityOrNotEnum.Z.getCode().equals(planItem.getIsSupplyAmount())) {
            item3.setZFPP(planItem.getProductBrandCode());
            item3.setZFPL(planItem.getProductCategoryCode());
            item3.setZFPX(planItem.getProductItemCode());
            item3.setMATNR(planItem.getProductCode());
            item3.setKBETR(planItem.getActivityPrice() != null ? String.format("%.2f", planItem.getActivityPrice()) : "0");
            item3.setZFYPSL(planItem.getOriginalProductNumber() != null ? String.format("%.3f", planItem.getOriginalProductNumber()) : "0");
            item3.setZFCPBM(planItem.getGiftProductCode());
            item3.setZFCPSL(planItem.getGiftProductNumber() != null ? String.format("%.3f", planItem.getGiftProductNumber()) : "0");
            item3.setVRKME(planItem.getUnitCode());
        }
        return item3;
    }

    private List<CreatePromotionActivityBranchDto.Item4> takeItem4FormPlanItem(SubComActivityDetailPlanItemVo planItem, PromotionPolicyVO promotionPolicy) {
        if (ObjectUtils.isEmpty((Object)planItem)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)promotionPolicy)) {
            if (!TotalQuantityOrNotEnum.Z.getCode().equals(planItem.getIsSupplyAmount())) {
                return null;
            }
            ArrayList<CreatePromotionActivityBranchDto.Item4> item4List = new ArrayList<CreatePromotionActivityBranchDto.Item4>();
            CreatePromotionActivityBranchDto.Item4 item4 = new CreatePromotionActivityBranchDto.Item4();
            item4.setZFCXHD(planItem.getPromotionNo());
            item4.setZFHDITEM(planItem.getConstituentDetailPlanItemCode());
            item4.setMATNR(planItem.getProductCode());
            item4List.add(item4);
            return item4List;
        }
        ArrayList<CreatePromotionActivityBranchDto.Item4> item4List = new ArrayList<CreatePromotionActivityBranchDto.Item4>();
        List productList = promotionPolicy.getPromotionPolicyProducts();
        productList.forEach(product -> {
            CreatePromotionActivityBranchDto.Item4 item4 = new CreatePromotionActivityBranchDto.Item4();
            item4.setZFCXHD(planItem.getPromotionNo());
            item4.setZFHDITEM(planItem.getConstituentDetailPlanItemCode());
            item4.setMATNR(product.getProductCode());
            item4List.add(item4);
        });
        return item4List;
    }

    private List<CreatePromotionActivityBranchDto.Item5> takeItem5FormPlanItem(SubComActivityDetailPlanItemVo planItem, PromotionPolicyVO promotionPolicy) {
        if (ObjectUtils.isEmpty((Object)planItem)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)promotionPolicy)) {
            if (!TotalQuantityOrNotEnum.Z.getCode().equals(planItem.getIsSupplyAmount())) {
                return null;
            }
            ArrayList item5List = Lists.newArrayList();
            CreatePromotionActivityBranchDto.Item5 item5 = new CreatePromotionActivityBranchDto.Item5();
            item5.setZFCXHD(planItem.getPromotionNo());
            item5.setZFHDITEM(planItem.getConstituentDetailPlanItemCode());
            item5.setZFSCALE("1");
            if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(planItem.getActivityFormCode())) {
                item5.setZFZPBM(planItem.getGiftProductCode());
                item5.setVRKME(planItem.getUnitCode());
                item5.setZFYPSL(planItem.getOriginalProductNumber() != null ? String.format("%.2f", planItem.getOriginalProductNumber()) : "0");
                item5.setZFZPSL(planItem.getGiftProductNumber() != null ? String.format("%.2f", planItem.getGiftProductNumber()) : "0");
            } else {
                item5.setKBETR(planItem.getActivityPrice() != null ? String.format("%.2f", planItem.getActivityPrice()) : "0");
                item5.setZFYPSL("1");
            }
            item5List.add(item5);
            return item5List;
        }
        List ladderList = promotionPolicy.getPromotionPolicyLadders();
        ArrayList<CreatePromotionActivityBranchDto.Item5> item5List = new ArrayList<CreatePromotionActivityBranchDto.Item5>(ladderList.size());
        ladderList.forEach(ladder -> {
            CreatePromotionActivityBranchDto.Item5 item5 = new CreatePromotionActivityBranchDto.Item5();
            item5.setZFCXHD(planItem.getPromotionNo());
            item5.setZFHDITEM(planItem.getConstituentDetailPlanItemCode());
            item5.setZFSCALE(ladder.getSuccessively() != null ? ladder.getSuccessively().toString() : null);
            item5.setZFYPSL(ladder.getMeetPriceOrQuantity() != null ? String.format("%.2f", ladder.getMeetPriceOrQuantity()) : "0");
            item5.setZFRESCALE(promotionPolicy.getLadderMultiplex());
            if (PromotionTypeEnum.GIFT.getCode().equals(promotionPolicy.getPromotionTypeCode())) {
                if (BooleanEnum.FALSE.getCapital().equals(promotionPolicy.getYesOrNo())) {
                    List giftList = ladder.getPromotionPolicyGiftList();
                    item5.setZFZPBM(((PromotionPolicyGiftVO)giftList.get(0)).getProductCode());
                }
                item5.setVRKME(ladder.getUnit());
                item5.setZFZPSL(ladder.getGivePriceOrQuantity() != null ? String.format("%.2f", ladder.getGivePriceOrQuantity()) : "0");
            } else {
                item5.setKBETR(ladder.getGivePriceOrQuantity() != null ? String.format("%.2f", ladder.getGivePriceOrQuantity()) : "0");
            }
            item5List.add(item5);
        });
        return item5List;
    }

    private List<CreatePromotionActivityBranchDto.Item6> takeItem6FromPlanItem(SubComActivityDetailPlanItemVo detailPlanItem) {
        String customerCode = detailPlanItem.getCustomerCode();
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return new ArrayList<CreatePromotionActivityBranchDto.Item6>();
        }
        String[] split = customerCode.split(",");
        ArrayList<CreatePromotionActivityBranchDto.Item6> item6List = new ArrayList<CreatePromotionActivityBranchDto.Item6>(split.length);
        for (String code : split) {
            CreatePromotionActivityBranchDto.Item6 item6 = new CreatePromotionActivityBranchDto.Item6();
            item6.setZFCXHD(detailPlanItem.getPromotionNo());
            item6.setZFCXKUN(code);
            item6List.add(item6);
        }
        return item6List;
    }

    private List<CreatePromotionActivityBranchDto.Item7> takeItem7FormPlanItem(SubComActivityDetailPlanItemVo planItem, PromotionPolicyVO promotionPolicy) {
        if (ObjectUtils.isEmpty((Object)planItem)) {
            return new ArrayList<CreatePromotionActivityBranchDto.Item7>();
        }
        if (ObjectUtils.isEmpty((Object)promotionPolicy)) {
            if (!TotalQuantityOrNotEnum.Z.getCode().equals(planItem.getIsSupplyAmount())) {
                return null;
            }
            if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(planItem.getActivityFormCode())) {
                CreatePromotionActivityBranchDto.Item7 item7 = new CreatePromotionActivityBranchDto.Item7();
                item7.setZFCXHD(planItem.getPromotionNo());
                item7.setZFHDITEM(planItem.getConstituentDetailPlanItemCode());
                item7.setMATNR(planItem.getGiftProductCode());
                return Lists.newArrayList((Object[])new CreatePromotionActivityBranchDto.Item7[]{item7});
            }
            return null;
        }
        ArrayList<CreatePromotionActivityBranchDto.Item7> item7List = new ArrayList<CreatePromotionActivityBranchDto.Item7>();
        if (PromotionTypeEnum.GIFT.getCode().equals(promotionPolicy.getPromotionTypeCode()) && BooleanEnum.TRUE.getCapital().equals(promotionPolicy.getYesOrNo())) {
            List promotionPolicyLadders = promotionPolicy.getPromotionPolicyLadders();
            List giftList = ((PromotionPolicyLadderVO)promotionPolicyLadders.get(0)).getPromotionPolicyGiftList();
            giftList.forEach(gift -> {
                CreatePromotionActivityBranchDto.Item7 item7 = new CreatePromotionActivityBranchDto.Item7();
                item7.setZFCXHD(planItem.getPromotionNo());
                item7.setZFHDITEM(planItem.getConstituentDetailPlanItemCode());
                item7.setMATNR(gift.getProductCode());
                item7List.add(item7);
            });
        }
        return item7List;
    }

    private List<CreatePromotionActivityBranchDto.Item8> takeItem8FormPlanItem(List<SubComActivityDetailPlanItemVo> itemNList, Map<String, PromotionPolicyVO> promotionPolicyMap) {
        if (CollectionUtils.isEmpty(itemNList)) {
            return Lists.newArrayList();
        }
        ArrayList<CreatePromotionActivityBranchDto.Item8> item8List = new ArrayList<CreatePromotionActivityBranchDto.Item8>();
        int zfno = 1;
        for (int i = 0; i < itemNList.size(); ++i) {
            PromotionPolicyVO promotionPolicy;
            SubComActivityDetailPlanItemVo detailPlanItem2 = itemNList.get(i);
            if (CollectionUtils.isEmpty(promotionPolicyMap) || !BooleanEnum.TRUE.getCapital().equals(detailPlanItem2.getIsAssPromotion()) || ObjectUtils.isEmpty((Object)(promotionPolicy = promotionPolicyMap.get(detailPlanItem2.getPromotionCode()))) || !PromotionProductTypeEnum.GROUP_SPECIAL_PRICE.getCode().equals(promotionPolicy.getPromotionProductType())) continue;
            List products = promotionPolicy.getPromotionPolicyProducts();
            for (PromotionPolicyProductVO product : products) {
                if (!detailPlanItem2.getCommonGroups().equals(product.getCommonGroup())) continue;
                CreatePromotionActivityBranchDto.Item8 item8 = new CreatePromotionActivityBranchDto.Item8();
                item8.setZFCXHD(detailPlanItem2.getPromotionNo());
                item8.setZFSCALE("1");
                item8.setZFNO(String.valueOf(++zfno));
                item8.setZFHDITEM(detailPlanItem2.getConstituentDetailPlanItemCode());
                item8.setMATNR(product.getProductCode());
                item8.setZFYPSL(product.getQuantity() != null ? product.getQuantity().toString() : "0");
                item8.setVRKME(product.getSaleUnit());
                item8.setZFGYZ(detailPlanItem2.getCommonGroups());
                item8.setKBETR_DJ(detailPlanItem2.getActivityPrice() != null ? String.format("%.2f", detailPlanItem2.getActivityPrice()) : "0.00");
                item8.setKBETR(promotionPolicy.getOriginalPrice() != null ? String.format("%.2f", promotionPolicy.getOriginalPrice()) : "0.00");
                item8List.add(item8);
            }
        }
        itemNList.forEach(detailPlanItem -> {});
        return item8List;
    }

    public List<UpdatePromotionActivityBranchDto> buildDetailPlanItemForUpdateInter(List<SubComActivityDetailPlanItemVo> detailPlanItemList, boolean close) {
        if (CollectionUtils.isEmpty(detailPlanItemList)) {
            return null;
        }
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        HashMap<String, BigDecimal> sumTotalCostMap = new HashMap<String, BigDecimal>();
        List nItemVoList = detailPlanItemList.stream().filter(k -> TotalQuantityOrNotEnum.N.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(nItemVoList)) {
            Set promotionNoSet = nItemVoList.stream().map(SubComActivityDetailPlanItemVo::getPromotionNo).filter(Objects::nonNull).collect(Collectors.toSet());
            List itemVoList = this.subComActivityDetailPlanItemVoService.findItemsByPromotionNos(promotionNoSet);
            Map<String, List<SubComActivityDetailPlanItemVo>> activityMap = itemVoList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getPromotionNo));
            for (Map.Entry<String, List<SubComActivityDetailPlanItemVo>> entry : activityMap.entrySet()) {
                List<SubComActivityDetailPlanItemVo> value = entry.getValue();
                String key = entry.getKey();
                BigDecimal totalCost = value.stream().map(SubComActivityDetailPlanItemVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTotalCostMap.put(key, totalCost);
            }
        }
        ArrayList<UpdatePromotionActivityBranchDto> list = new ArrayList<UpdatePromotionActivityBranchDto>();
        detailPlanItemList.forEach(detailPlanItem -> {
            UpdatePromotionActivityBranchDto updateDto = new UpdatePromotionActivityBranchDto();
            updateDto.setITEM1(new ArrayList());
            updateDto.setITEM2(new ArrayList());
            updateDto.setITEM3(new ArrayList());
            UpdatePromotionActivityBranchDto.Item1 item1 = new UpdatePromotionActivityBranchDto.Item1();
            UpdatePromotionActivityBranchDto.Item2 item2 = new UpdatePromotionActivityBranchDto.Item2();
            item1.setZFCXHD(detailPlanItem.getPromotionNo());
            item1.setDATAB(detailPlanItem.getActivityBeginTime() != null ? sif.format(detailPlanItem.getActivityBeginTime()) : "");
            item1.setZFBEGIN(detailPlanItem.getOrderStartDate() != null ? sif.format(detailPlanItem.getOrderStartDate()) : "");
            if (close) {
                item1.setDATBI(sif.format(new Date()));
                item1.setZFEND(sif.format(new Date()));
            } else {
                item1.setDATBI(detailPlanItem.getActivityEndTime() != null ? sif.format(detailPlanItem.getActivityEndTime()) : "");
                item1.setZFEND(detailPlanItem.getOrderEndDate() != null ? sif.format(detailPlanItem.getOrderEndDate()) : "");
            }
            item1.setZFHDZT(close ? ThirdSystemActivityStatusEnum.INVALID.getCode() : ThirdSystemActivityStatusEnum.VALID.getCode());
            if (TotalQuantityOrNotEnum.N.getCode().equals(detailPlanItem.getIsSupplyAmount())) {
                item1.setZFSQFY_H(String.format("%.2f", sumTotalCostMap.get(detailPlanItem.getPromotionNo())));
            } else {
                item1.setZFSQFY_H(detailPlanItem.getTotalCost() != null ? String.format("%.2f", detailPlanItem.getTotalCost()) : "0.00");
            }
            item2.setZFCXHD(detailPlanItem.getPromotionNo());
            item2.setZFHDITEM(detailPlanItem.getConstituentDetailPlanItemCode());
            item2.setZFSQFY_I(detailPlanItem.getTotalCost() != null ? String.format("%.2f", detailPlanItem.getTotalCost()) : "0.00");
            item2.setZFSQCXL(detailPlanItem.getPromoteSales() != null ? String.format("%.3f", detailPlanItem.getPromoteSales()) : "0.000");
            updateDto.getITEM1().add(item1);
            updateDto.getITEM2().add(item2);
            String customerCode = detailPlanItem.getCustomerCode();
            if (!StringUtils.isBlank((CharSequence)customerCode)) {
                String[] split;
                for (String code : split = customerCode.split(",")) {
                    UpdatePromotionActivityBranchDto.Item3 item3 = new UpdatePromotionActivityBranchDto.Item3();
                    item3.setZFCXHD(detailPlanItem.getPromotionNo());
                    item3.setZFCXKUN(code);
                    updateDto.getITEM3().add(item3);
                }
            }
            list.add(updateDto);
        });
        return list;
    }

    private List<UpdatePromotionActivityBranchDto.Item2> updateYDetailForItem2(List<SubComActivityDetailPlanItemVo> detailPlanItemList) {
        if (!CollectionUtils.isEmpty(detailPlanItemList)) {
            return new ArrayList<UpdatePromotionActivityBranchDto.Item2>();
        }
        List yUpdateItemList = detailPlanItemList.stream().filter(k -> TotalQuantityOrNotEnum.Y.getCode().equals(k.getIsSupplyAmount()) && InterfacePushStateEnum.NOT_PUSH.getCode().equals(k.getSapInterfaceState())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(yUpdateItemList)) {
            return new ArrayList<UpdatePromotionActivityBranchDto.Item2>();
        }
        Set<String> activityNumbers = yUpdateItemList.stream().map(SubComActivityDetailPlanItemVo::getActivityNumber).filter(Objects::nonNull).collect(Collectors.toSet());
        List detailPlanCodes = yUpdateItemList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanCode).filter(Objects::nonNull).collect(Collectors.toList());
        List itemCodes = yUpdateItemList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
        List ItemList = this.subComActivityDetailPlanItemVoService.findItemsByDetailPlanCodes(detailPlanCodes);
        List<SubComActivityDetailPlanItemVo> yItemList = ItemList.stream().filter(k -> TotalQuantityOrNotEnum.Y.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        Map<String, List<SubComActivityDetailPlanItemVo>> yItemMap = this.thirdCommonMethod.groupWithActivityNumber(activityNumbers, yItemList);
        ArrayList<UpdatePromotionActivityBranchDto.Item2> item2List = new ArrayList<UpdatePromotionActivityBranchDto.Item2>();
        activityNumbers.forEach(number -> {
            List list = (List)yItemMap.get(number);
            UpdatePromotionActivityBranchDto.Item2 item2 = new UpdatePromotionActivityBranchDto.Item2();
            BigDecimal applyItemQuantity = new BigDecimal(0);
            BigDecimal applyFee = new BigDecimal(0);
            for (SubComActivityDetailPlanItemVo item : list) {
                if (itemCodes.contains(item.getConstituentDetailPlanItemCode())) {
                    if (System.currentTimeMillis() > item.getActivityBeginTime().getTime()) {
                        applyItemQuantity = applyItemQuantity.add(item.getPromoteSales() != null ? item.getPromoteSales() : BigDecimal.ZERO);
                        applyFee = applyFee.add(item.getTotalCost() != null ? item.getTotalCost() : BigDecimal.ZERO);
                    }
                } else {
                    applyItemQuantity = applyItemQuantity.add(item.getPromoteSales() != null ? item.getPromoteSales() : BigDecimal.ZERO);
                    applyFee = applyFee.add(item.getTotalCost() != null ? item.getTotalCost() : BigDecimal.ZERO);
                }
                item2.setZFSQCXL(String.format("%.3f", applyItemQuantity));
                item2.setZFSQFY_I(String.format("%.2f", applyFee));
            }
            item2List.add(item2);
        });
        return item2List;
    }
}

