/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third.SubActivityPushOrderShare;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third.SubActivityPushSapBranch;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.PushSubActivityToThirdSystemService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushSubActivityToThirdSystemService")
public class PushSubActivityToThirdSystemServiceImpl
implements PushSubActivityToThirdSystemService {
    private static final Logger log = LoggerFactory.getLogger(PushSubActivityToThirdSystemServiceImpl.class);
    @Autowired(required=false)
    private SubActivityPushOrderShare subActivityPushOrderShare;
    @Autowired(required=false)
    private SubActivityPushSapBranch subActivityPushSapBranch;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public void createActivityPushOrderShare(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.subActivityPushOrderShare.createPromotionActivity(planCodes);
    }

    public void updateActivityPushOrderShare(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.subActivityPushOrderShare.updatePromotionActivity(planCodes);
    }

    public void updateActivityPushOrderShareByItemCodes(List<String> planItemCodes) {
        Validate.notEmpty(planItemCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.subActivityPushOrderShare.updatePromotionActivityByItemCodes(planItemCodes);
    }

    public void closeActivityPushOrderShare(List<String> itemCodes) {
        Validate.notEmpty(itemCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.subActivityPushOrderShare.closePromotionActivity(itemCodes);
    }

    public void createActivityPushSapBranch(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.subActivityPushSapBranch.createPromotionActivityBranch(planCodes);
    }

    public void updateActivityPushSapBranch(List<String> itemCodes, boolean close) {
        Validate.notEmpty(itemCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.subActivityPushSapBranch.updateOrClosePromotionActivityBranch(itemCodes, close);
    }

    public void closePushThirdSystemAsync(List<String> codeList) {
        CompletableFuture.runAsync(() -> {
            try {
                log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5f02\u6b65\u5173\u95ed:" + JSONObject.toJSONString((Object)codeList));
                Thread.sleep(5000L);
                this.loginUserService.refreshAuthentication(null);
                this.updateActivityPushSapBranch(codeList, true);
                this.closeActivityPushOrderShare(codeList);
                log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5f02\u6b65\u5173\u95ed\u7ed3\u675f");
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

