/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.ActivityClientRelationDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.MnCrmIf004ServiceDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.MnCrmIf005ServiceDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.MnCrmIf006ServiceDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.dto.MnCrmIf007ServiceDto;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.service.OrderSharingPlatformService;
import com.biz.crm.mn.third.system.order.sharing.platform.sdk.vo.OrderSharingPlatformVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.dto.OrderSharePlatformCreateDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third.MakeOrderShareInterData;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third.ThirdCommonMethod;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.ThirdSystemActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubActivityPushOrderShare {
    private static final Logger log = LoggerFactory.getLogger(SubActivityPushOrderShare.class);
    private static final SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private OrderSharingPlatformService orderSharingPlatformService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private MakeOrderShareInterData makeOrderShareInterData;
    @Autowired(required=false)
    private ThirdCommonMethod thirdCommonMethod;

    public void createPromotionActivity(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List activityDetailPlanVoList = this.subComActivityDetailPlanVoService.findDetailPlanAndItemByPlanCode(planCodes);
        if (CollectionUtils.isEmpty((Collection)activityDetailPlanVoList)) {
            return;
        }
        ArrayList<OrderSharePlatformCreateDto> orderSharePlatformCreateDtoList = new ArrayList<OrderSharePlatformCreateDto>();
        ArrayList<MnCrmIf005ServiceDto> mnCrmIf005ServiceDtoList = new ArrayList<MnCrmIf005ServiceDto>();
        activityDetailPlanVoList.forEach(detailPlan -> {
            if (!CollectionUtils.isEmpty((Collection)detailPlan.getItemList())) {
                List formCodes = detailPlan.getItemList().stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
                Map activityFormMap = this.activityFormService.findPushOrderSharePlatform(formCodes);
                List<SubComActivityDetailPlanItemVo> resultItemList = this.thirdCommonMethod.removeNotPushWithDetailPlanItem(detailPlan.getItemList(), activityFormMap);
                detailPlan.setItemList(resultItemList);
                List<OrderSharePlatformCreateDto> orderShareCreateDtoList = this.buildMnCrmIf004Service((SubComActivityDetailPlanVo)detailPlan, resultItemList);
                List<MnCrmIf005ServiceDto> mnCrmIf005ServiceList = this.makeOrderShareInterData.sumQuantityAndFee(resultItemList);
                if (!CollectionUtils.isEmpty(orderShareCreateDtoList)) {
                    orderSharePlatformCreateDtoList.addAll(orderShareCreateDtoList);
                }
                if (!CollectionUtils.isEmpty(mnCrmIf005ServiceList)) {
                    mnCrmIf005ServiceDtoList.addAll(mnCrmIf005ServiceList);
                }
            }
        });
        this.push004Data(orderSharePlatformCreateDtoList);
        this.push005Data(mnCrmIf005ServiceDtoList);
    }

    public void updatePromotionActivity(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List activityDetailPlanVoList = this.subComActivityDetailPlanItemVoService.findItemsByDetailPlanCodes(planCodes);
        this.doUpdatePromotionActivity(activityDetailPlanVoList);
    }

    public void updatePromotionActivityByItemCodes(List<String> planItemCodes) {
        Validate.notEmpty(planItemCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List activityDetailPlanVoList = this.subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(planItemCodes);
        this.doUpdatePromotionActivity(activityDetailPlanVoList);
    }

    public void doUpdatePromotionActivity(List<SubComActivityDetailPlanItemVo> activityDetailPlanVoList) {
        if (CollectionUtils.isEmpty(activityDetailPlanVoList)) {
            return;
        }
        List fromCodes = activityDetailPlanVoList.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map activityFormMap = this.activityFormService.findPushOrderSharePlatform(fromCodes);
        ArrayList<SubComActivityDetailPlanItemVo> updateQuantityAndFeeList = new ArrayList<SubComActivityDetailPlanItemVo>();
        ArrayList<SubComActivityDetailPlanItemVo> updateStateAndDateList = new ArrayList<SubComActivityDetailPlanItemVo>();
        ArrayList<SubComActivityDetailPlanItemVo> updateCustomerList = new ArrayList<SubComActivityDetailPlanItemVo>();
        for (SubComActivityDetailPlanItemVo detailPlanItem : activityDetailPlanVoList) {
            String[] split;
            for (String str : split = detailPlanItem.getOrderShareInterfaceState().split(",")) {
                if (InterfacePushStateEnum.UPDATE_QUANTITY_OR_FEE.getCode().equals(str)) {
                    updateQuantityAndFeeList.add(detailPlanItem);
                }
                if (InterfacePushStateEnum.UPDATE_STATE_OR_DATE.getCode().equals(str)) {
                    updateStateAndDateList.add(detailPlanItem);
                }
                if (!InterfacePushStateEnum.UPDATE_CUSTOMER.getCode().equals(str)) continue;
                updateCustomerList.add(detailPlanItem);
            }
        }
        List<MnCrmIf005ServiceDto> mnCrmIf005DtoList = this.buildMnCrmIf005Service(updateQuantityAndFeeList, activityFormMap);
        List<MnCrmIf006ServiceDto> mnCrmIf006DtoList = this.buildMnCrmIf006Service(updateStateAndDateList, activityFormMap, false);
        List<MnCrmIf007ServiceDto> mnCrmIf007DtoList = this.buildMnCrmIf007Service(updateCustomerList, activityFormMap);
        this.push005Data(mnCrmIf005DtoList);
        this.push006Data(mnCrmIf006DtoList);
        this.push007Data(mnCrmIf007DtoList);
    }

    public void closePromotionActivity(List<String> itemCodes) {
        Validate.notEmpty(itemCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List detailPlanItemList = this.subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(itemCodes);
        if (CollectionUtils.isEmpty((Collection)detailPlanItemList)) {
            return;
        }
        List fromCodes = detailPlanItemList.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map activityFormMap = this.activityFormService.findPushOrderSharePlatform(fromCodes);
        List<MnCrmIf006ServiceDto> mnCrmIf006DtoList = this.buildMnCrmIf006Service(detailPlanItemList, activityFormMap, true);
        this.push006Data(mnCrmIf006DtoList);
    }

    private List<MnCrmIf005ServiceDto> buildMnCrmIf005Service(List<SubComActivityDetailPlanItemVo> updateQuantityAndFeeList, Map<String, List<ActivityFormExeDetailVo>> activityFormMap) {
        if (CollectionUtils.isEmpty(updateQuantityAndFeeList)) {
            return null;
        }
        List itemYList = updateQuantityAndFeeList.stream().filter(k -> TotalQuantityOrNotEnum.Y.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        List numberList = itemYList.stream().map(SubComActivityDetailPlanItemVo::getActivityNumber).filter(Objects::nonNull).collect(Collectors.toList());
        Map activityMap = this.subComActivityDetailPlanItemVoService.findSameActivityWithNumber(numberList);
        Set keySet = activityMap.keySet();
        ArrayList<MnCrmIf005ServiceDto> list = new ArrayList<MnCrmIf005ServiceDto>();
        for (String number : keySet) {
            List<SubComActivityDetailPlanItemVo> resultItemList = this.thirdCommonMethod.removeNotPushWithDetailPlanItem((List)activityMap.get(number), activityFormMap);
            BigDecimal totalCost = resultItemList.stream().map(SubComActivityDetailPlanItemVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal promoteSales = resultItemList.stream().map(SubComActivityDetailPlanItemVo::getPromoteSales).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            MnCrmIf005ServiceDto mnCrmIf005ServiceDto = new MnCrmIf005ServiceDto();
            mnCrmIf005ServiceDto.setActivityNoteId(number);
            mnCrmIf005ServiceDto.setApplyItemQuantity(String.format("%.3f", promoteSales));
            mnCrmIf005ServiceDto.setApplyFee(String.format("%.2f", totalCost));
            list.add(mnCrmIf005ServiceDto);
        }
        return list;
    }

    private List<MnCrmIf005ServiceDto> updateSumQuantityAndFee(List<SubComActivityDetailPlanItemVo> yItemList) {
        if (CollectionUtils.isEmpty(yItemList)) {
            return new ArrayList<MnCrmIf005ServiceDto>();
        }
        ArrayList list = new ArrayList();
        List detailPlanCodes = yItemList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanCode).filter(Objects::nonNull).collect(Collectors.toList());
        List itemList = this.subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(detailPlanCodes);
        return null;
    }

    private List<MnCrmIf006ServiceDto> buildMnCrmIf006Service(List<SubComActivityDetailPlanItemVo> updateStateAndDateList, Map<String, List<ActivityFormExeDetailVo>> activityFormMap, boolean close) {
        if (CollectionUtils.isEmpty(updateStateAndDateList)) {
            return null;
        }
        List<SubComActivityDetailPlanItemVo> resultItemList = this.thirdCommonMethod.removeNotPushWithDetailPlanItem(updateStateAndDateList, activityFormMap);
        ArrayList<MnCrmIf006ServiceDto> list = new ArrayList<MnCrmIf006ServiceDto>();
        resultItemList.forEach(detailPlanItemVo -> {
            MnCrmIf006ServiceDto mnCrmIf006ServiceDto = new MnCrmIf006ServiceDto();
            mnCrmIf006ServiceDto.setActivityId(detailPlanItemVo.getPromotionNo());
            mnCrmIf006ServiceDto.setActivityStatus(close ? ThirdSystemActivityStatusEnum.INVALID.getCode() : ThirdSystemActivityStatusEnum.VALID.getCode());
            mnCrmIf006ServiceDto.setActivityStartDate(detailPlanItemVo.getActivityBeginTime() != null ? sif.format(detailPlanItemVo.getActivityBeginTime()) : "");
            mnCrmIf006ServiceDto.setOrderStartDate(detailPlanItemVo.getOrderStartDate() != null ? sif.format(detailPlanItemVo.getOrderStartDate()) : "");
            if (close) {
                mnCrmIf006ServiceDto.setActivityEndDate(sif.format(new Date()));
                mnCrmIf006ServiceDto.setOrderEndDate(sif.format(new Date()));
            } else {
                mnCrmIf006ServiceDto.setActivityEndDate(detailPlanItemVo.getActivityEndTime() != null ? sif.format(detailPlanItemVo.getActivityEndTime()) : "");
                mnCrmIf006ServiceDto.setOrderEndDate(detailPlanItemVo.getOrderEndDate() != null ? sif.format(detailPlanItemVo.getOrderEndDate()) : "");
            }
            list.add(mnCrmIf006ServiceDto);
        });
        return list;
    }

    private List<MnCrmIf007ServiceDto> buildMnCrmIf007Service(List<SubComActivityDetailPlanItemVo> updateCustomerList, Map<String, List<ActivityFormExeDetailVo>> activityFormMap) {
        if (CollectionUtils.isEmpty(updateCustomerList)) {
            return null;
        }
        List<SubComActivityDetailPlanItemVo> resultItemList = this.thirdCommonMethod.removeNotPushWithDetailPlanItem(updateCustomerList, activityFormMap);
        ArrayList<MnCrmIf007ServiceDto> list = new ArrayList<MnCrmIf007ServiceDto>();
        resultItemList.forEach(detailPlanItem -> {
            MnCrmIf007ServiceDto mnCrmIf007ServiceDto = new MnCrmIf007ServiceDto();
            ArrayList<ActivityClientRelationDto> activityClientRelationList = new ArrayList<ActivityClientRelationDto>();
            mnCrmIf007ServiceDto.setActivityClientRelation(activityClientRelationList);
            String customerCode = detailPlanItem.getCustomerCode();
            if (StringUtils.isNotBlank((CharSequence)customerCode)) {
                String[] customerCodes;
                for (String code : customerCodes = customerCode.split(",")) {
                    if (StringUtils.isNotBlank((CharSequence)code) && code.length() > 10) {
                        code = code.substring(0, 10);
                    }
                    ActivityClientRelationDto activityClientRelation = new ActivityClientRelationDto();
                    activityClientRelation.setActivityId(detailPlanItem.getPromotionNo());
                    activityClientRelation.setClientId(code);
                    activityClientRelationList.add(activityClientRelation);
                }
            }
            list.add(mnCrmIf007ServiceDto);
        });
        return list;
    }

    private List<OrderSharePlatformCreateDto> buildMnCrmIf004Service(SubComActivityDetailPlanVo detailPlan, List<SubComActivityDetailPlanItemVo> planItemList) {
        ArrayList<OrderSharePlatformCreateDto> orderShareCreateDtoList = new ArrayList<OrderSharePlatformCreateDto>();
        List<SubComActivityDetailPlanItemVo> planItemWithYZList = planItemList.stream().filter(k -> !TotalQuantityOrNotEnum.N.getCode().equals(k.getIsSupplyAmount()) && (InterfacePushStateEnum.NOT_PUSH.getCode().equals(k.getOrderShareInterfaceState()) || InterfacePushStateEnum.FAIL.getCode().equals(k.getOrderShareInterfaceState()))).collect(Collectors.toList());
        List<SubComActivityDetailPlanItemVo> planItemWithNList = planItemList.stream().filter(k -> TotalQuantityOrNotEnum.N.getCode().equals(k.getIsSupplyAmount()) && (InterfacePushStateEnum.NOT_PUSH.getCode().equals(k.getOrderShareInterfaceState()) || InterfacePushStateEnum.FAIL.getCode().equals(k.getOrderShareInterfaceState()))).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(planItemWithYZList)) {
            this.makeOrderShareInterData.buildYAndZDetailPlanItem(detailPlan, planItemWithYZList, orderShareCreateDtoList);
        }
        if (CollectionUtil.isNotEmpty(planItemWithNList)) {
            Set<String> activityNumbers = planItemWithNList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getActivityNumber())).map(SubComActivityDetailPlanItemVo::getActivityNumber).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, List<SubComActivityDetailPlanItemVo>> detailPlanItemMap2 = this.thirdCommonMethod.groupWithActivityNumber(activityNumbers, planItemWithNList);
            activityNumbers.forEach(activityNumber -> {
                OrderSharePlatformCreateDto orderSharePlatformCreateDto = this.makeOrderShareInterData.buildNDetailPlanItem(detailPlan, (List)detailPlanItemMap2.get(activityNumber));
                if (ObjectUtils.isNotEmpty((Object)orderSharePlatformCreateDto)) {
                    orderShareCreateDtoList.add(orderSharePlatformCreateDto);
                }
            });
        }
        if (CollectionUtils.isEmpty(orderShareCreateDtoList)) {
            List fromCodes = orderShareCreateDtoList.stream().map(item -> item.getMnCrmIf004ServiceDto().getActivityType()).filter(Objects::nonNull).collect(Collectors.toList());
            Map sapCodeMap = this.activityFormService.findSapCode(fromCodes);
            for (OrderSharePlatformCreateDto orderSharePlatformCreateDto : orderShareCreateDtoList) {
                MnCrmIf004ServiceDto mnCrmIf004ServiceDto = orderSharePlatformCreateDto.getMnCrmIf004ServiceDto();
                mnCrmIf004ServiceDto.setActivityType((String)sapCodeMap.get(mnCrmIf004ServiceDto.getActivityType()));
            }
        }
        return orderShareCreateDtoList;
    }

    private void push004Data(List<OrderSharePlatformCreateDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        ArrayList<String> successCodes = new ArrayList<String>();
        ArrayList<String> falseCodes = new ArrayList<String>();
        dtoList.forEach(dto -> {
            try {
                MnCrmIf004ServiceDto mnCrmIf004ServiceDto = dto.getMnCrmIf004ServiceDto();
                OrderSharingPlatformVo result = this.orderSharingPlatformService.mnCrmIf004Service(mnCrmIf004ServiceDto, dto.getDetailPlanItemCode(), dto.getCommonGroup());
                if (result.isSuccess()) {
                    if (!StringUtils.isBlank((CharSequence)dto.getCommonGroup())) {
                        this.orderSharingPlatformService.mnCrmIf007Service(dto.getMnCrmIf007ServiceDto(), mnCrmIf004ServiceDto.getPromotionId(), dto.getCommonGroup());
                    } else {
                        successCodes.add(dto.getDetailPlanItemCode());
                    }
                } else {
                    falseCodes.add(dto.getDetailPlanItemCode());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.thirdCommonMethod.updateOrderShareState(successCodes, falseCodes);
    }

    private void push005Data(List<MnCrmIf005ServiceDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(mnCrmIf005ServiceDto -> {
            try {
                this.orderSharingPlatformService.mnCrmIf005Service(mnCrmIf005ServiceDto);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void push006Data(List<MnCrmIf006ServiceDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(mnCrmIf006ServiceDto -> {
            try {
                this.orderSharingPlatformService.mnCrmIf006Service(mnCrmIf006ServiceDto);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void push007Data(List<MnCrmIf007ServiceDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(mnCrmIf007ServiceDto -> {
            try {
                String activityId = ((ActivityClientRelationDto)mnCrmIf007ServiceDto.getActivityClientRelation().get(0)).getActivityId();
                this.orderSharingPlatformService.mnCrmIf007Service(mnCrmIf007ServiceDto, activityId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

