/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.CreatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.UpdatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivityPushSapApiService;
import com.biz.crm.tpm.business.activity.form.sdk.enums.SubComActivityValidationFormCodeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third.MakeSapBranchInterData;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third.ThirdCommonMethod;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubActivityPushSapBranch {
    private static final Logger log = LoggerFactory.getLogger(SubActivityPushSapBranch.class);
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private ThirdCommonMethod thirdCommonMethod;
    @Autowired(required=false)
    private MakeSapBranchInterData makeSapBranchInterData;
    @Autowired(required=false)
    private ActivityPushSapApiService activityPushSapApiService;

    public void createPromotionActivityBranch(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List detailPlanItemList = this.subComActivityDetailPlanItemVoService.findItemsByDetailPlanCodes(planCodes);
        if (CollectionUtils.isEmpty((Collection)detailPlanItemList)) {
            log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001SD[{}]\u6761\u6570\u636e. \u7ec6\u6848\u7f16\u7801{}", (Object)0, planCodes);
            return;
        }
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u63a8\u9001SD[{}]\u6761\u6570\u636e.{}", (Object)detailPlanItemList.size(), planCodes);
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u63a8\u9001SD[{}]\u6761\u6570\u636e. \u7ec6\u6848\u7f16\u7801{}", (Object)detailPlanItemList.size(), planCodes);
        List formCodes = detailPlanItemList.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u63a8\u9001SD  \u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801{}, \u7ec6\u6848\u7f16\u7801{}", formCodes, planCodes);
        Map activityFormMap = this.activityFormService.findPushSap(formCodes);
        if (CollectionUtils.isEmpty((Map)activityFormMap)) {
            log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u63a8\u9001SD  \u6d3b\u52a8\u5f62\u5f0f\u65e0\u9700\u63a8\u9001SAP, \u7ec6\u6848\u7f16\u7801{}", planCodes);
            return;
        }
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u63a8\u9001SD  \u6d3b\u52a8\u5f62\u5f0f{}, \u7ec6\u6848\u7f16\u7801{}", (Object)activityFormMap, planCodes);
        List<SubComActivityDetailPlanItemVo> resultItemList = this.thirdCommonMethod.removeNotPushWithDetailPlanItem(detailPlanItemList, activityFormMap);
        if (CollectionUtils.isEmpty(resultItemList)) {
            log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u63a8\u9001SD  \u8fc7\u6ee4\u6d3b\u52a8\u5f62\u5f0f+\u6838\u9500\u65b9\u5f0f\u540e,\u65e0\u9700\u63a8\u9001 \u7ec6\u6848\u7f16\u7801{}", planCodes);
            return;
        }
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u63a8\u9001SD  \u63a8\u9001\u7684\u6d3b\u52a8\u7ec6\u6848\u4fe1\u606f{}", resultItemList);
        ArrayList newList = Lists.newArrayList();
        for (SubComActivityDetailPlanItemVo item : resultItemList) {
            if (SubComActivityValidationFormCodeEnum.ZS42.name().equals(item.getActivityFormCode()) || SubComActivityValidationFormCodeEnum.ZS11.name().equals(item.getActivityFormCode()) || SubComActivityValidationFormCodeEnum.ZS30.name().equals(item.getActivityFormCode()) || SubComActivityValidationFormCodeEnum.ZS15.name().equals(item.getActivityFormCode())) {
                SubComActivityDetailPlanItemVo newItem = new SubComActivityDetailPlanItemVo();
                newItem.setConstituentDetailPlanName(item.getConstituentDetailPlanName());
                newItem.setConstituentDetailPlanCode(item.getConstituentDetailPlanCode());
                newItem.setConstituentDetailPlanItemCode(item.getConstituentDetailPlanItemCode());
                newItem.setBusinessFormatCode(item.getBusinessFormatCode());
                newItem.setPromotionNo(item.getPromotionNo());
                newItem.setAssociationType(item.getAssociationType());
                newItem.setUndertakingMode(item.getUndertakingMode());
                newItem.setIsSupplyAmount(item.getIsSupplyAmount());
                newItem.setActivityNumber(item.getActivityNumber());
                newItem.setActivityFormCode(item.getActivityFormCode());
                newItem.setActivityFormName(item.getActivityFormName());
                newItem.setAuditType(item.getAuditType());
                newItem.setCustomerCode(item.getCustomerCode());
                newItem.setCustomerName(item.getCustomerName());
                newItem.setSalesInstitutionCode(item.getSalesInstitutionCode());
                newItem.setDistributionChannelCode(item.getDistributionChannelCode());
                newItem.setActivityBeginTime(item.getActivityBeginTime());
                newItem.setActivityEndTime(item.getActivityEndTime());
                newItem.setOrderStartDate(item.getOrderStartDate());
                newItem.setOrderEndDate(item.getOrderEndDate());
                newItem.setTotalCost(item.getTotalCost());
                newItem.setHeadquartersSupportedAmount(item.getHeadquartersSupportedAmount());
                newItem.setSubComAutoAmount(item.getSubComAutoAmount());
                newItem.setIsAssPromotion(item.getIsAssPromotion());
                newItem.setActivityFormDesc(item.getActivityFormDesc());
                newItem.setActivityDesc(item.getActivityDesc());
                newItem.setPromoteSales(item.getPromoteSales());
                newItem.setPromotionAmount(item.getPromotionAmount());
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        List<CreatePromotionActivityBranchDto> dtoList = this.makeSapBranchInterData.buildDetailPlanItemForCreateInter(newList);
        for (CreatePromotionActivityBranchDto dto : dtoList) {
            Result result = this.activityPushSapApiService.pushCreatePromotionActivityBranch(dto);
        }
    }

    public void updateOrClosePromotionActivityBranch(List<String> itemCodes, boolean close) {
        Validate.notEmpty(itemCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List detailPlanItemList = this.subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(itemCodes);
        if (CollectionUtils.isEmpty((Collection)detailPlanItemList)) {
            return;
        }
        List formCodes = detailPlanItemList.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map activityFormMap = this.activityFormService.findPushSap(formCodes);
        if (CollectionUtils.isEmpty((Map)activityFormMap)) {
            return;
        }
        List<SubComActivityDetailPlanItemVo> resultItemList = this.thirdCommonMethod.removeNotPushWithDetailPlanItem(detailPlanItemList, activityFormMap);
        List<UpdatePromotionActivityBranchDto> updateDto = this.makeSapBranchInterData.buildDetailPlanItemForUpdateInter(resultItemList, close);
        updateDto.forEach(dto -> this.activityPushSapApiService.pushUpdatePromotionActivityBranch(dto));
    }
}

