/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.local.service.third;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.promotion.policy.sdk.service.PromotionPolicyService;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ThirdCommonMethod {
    private static final Logger log = LoggerFactory.getLogger(ThirdCommonMethod.class);
    @Autowired(required=false)
    private PromotionPolicyService promotionPolicyService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    public List<SubComActivityDetailPlanItemVo> removeNotPushWithDetailPlanItem(List<SubComActivityDetailPlanItemVo> detailPlanItemList, Map<String, List<ActivityFormExeDetailVo>> activityFormMap) {
        if (CollectionUtils.isEmpty(detailPlanItemList)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(activityFormMap)) {
            return Collections.emptyList();
        }
        ArrayList<SubComActivityDetailPlanItemVo> result = new ArrayList<SubComActivityDetailPlanItemVo>();
        detailPlanItemList.forEach(item -> {
            if (StringUtils.isEmpty((CharSequence)item.getAuditType())) {
                return;
            }
            List exeDetailList = (List)activityFormMap.get(item.getActivityFormCode());
            if (CollectionUtil.isEmpty((Collection)exeDetailList)) {
                return;
            }
            for (ActivityFormExeDetailVo exeDetailVo : exeDetailList) {
                String[] split;
                String auditType = exeDetailVo.getAuditType();
                if (StringUtils.isEmpty((CharSequence)auditType)) continue;
                for (String str : split = auditType.split(",")) {
                    if (!item.getAuditType().equals(str)) continue;
                    result.add((SubComActivityDetailPlanItemVo)item);
                    return;
                }
            }
        });
        return result;
    }

    public Map<String, PromotionPolicyVO> getPromotionPolicyMap(List<SubComActivityDetailPlanItemVo> DetailPlanItemVos) {
        List promotionCodeList = DetailPlanItemVos.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getPromotionCode())).filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsAssPromotion())).map(SubComActivityDetailPlanItemVo::getPromotionCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(promotionCodeList)) {
            return null;
        }
        List promotionPolicyVoList = this.promotionPolicyService.findByPromotionCodes(promotionCodeList);
        HashMap<String, PromotionPolicyVO> policyVOMap = new HashMap<String, PromotionPolicyVO>(promotionCodeList.size());
        promotionPolicyVoList.forEach(policy -> policyVOMap.put(policy.getPromotionCode(), (PromotionPolicyVO)policy));
        return policyVOMap;
    }

    public Map<String, String> getSapCodeMap(List<SubComActivityDetailPlanItemVo> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Maps.newHashMap();
        }
        List fromCodes = itemList.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map sapCodeMap = this.activityFormService.findSapCode(fromCodes);
        return sapCodeMap;
    }

    public Map<String, List<SubComActivityDetailPlanItemVo>> groupWithActivityNumber(Set<String> activityNumbers, List<SubComActivityDetailPlanItemVo> detailPlanItemList) {
        HashMap<String, List<SubComActivityDetailPlanItemVo>> detailPlanItemVoMap = new HashMap<String, List<SubComActivityDetailPlanItemVo>>(activityNumbers.size());
        activityNumbers.forEach(activityNumber -> {
            ArrayList list = new ArrayList();
            detailPlanItemVoMap.put((String)activityNumber, list);
        });
        detailPlanItemList.forEach(detailPlanItemVo -> ((List)detailPlanItemVoMap.get(detailPlanItemVo.getActivityNumber())).add(detailPlanItemVo));
        return detailPlanItemVoMap;
    }

    public void updateOrderShareState(List<String> successCodes, List<String> falseCodes) {
        if (!CollectionUtils.isEmpty(successCodes)) {
            this.subComActivityDetailPlanItemVoService.updatePlanItemPushOrderShareStatus(successCodes, true);
        }
        if (!CollectionUtils.isEmpty(falseCodes)) {
            this.subComActivityDetailPlanItemVoService.updatePlanItemPushOrderShareStatus(falseCodes, false);
        }
    }
}

