package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName PrePaySubComActivityDto
 * @Description 活动预付获取分子公司细案Dto
 * @AUTHOR WangJJ
 * @DATE 2023/2/22 14:43
 **/
@Data
@ApiModel(value = "活动预付获取分子公司细案Dto")
public class PrePaySubComActivityDto {

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("销售组织名称")
    private String salesGroupName;

    @ApiModelProperty("零售商名称")
    private String resaleCommercialName;

    @ApiModelProperty("零售商编码")
    private String resaleCommercialCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 预付类型
     */
    @ApiModelProperty("预付类型")
    private String prepaymentType;

    /**
     * 预付类型
     */
    @ApiModelProperty("分子活动先编码")
    private String constituentDetailPlanItemCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("分子公司活动细案编码")
    private String constituentDetailPlanCode;

    @ApiModelProperty("分子公司活动细案名称")
    private String constituentDetailPlanName;
}
