package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 分子公司活动细案预算dto
 *
 * @author makejava
 * @date 2022-11-28 15:28:32
 */
@Data
@ApiModel(value = "SubComActivityDetailPlanBudgetDto", description = "分子公司活动细案预算dto")
public class SubComActivityDetailPlanBudgetDto extends TenantFlagOpDto {
    @ApiModelProperty(name = "分子公司活动细案", notes = "分子公司活动细案")
    private String constituentDetailPlanCode;


    @ApiModelProperty("费用预算编码")
    private String costBudgetCode;


    @ApiModelProperty("费用预算名称")
    private String costBudgetName;


    @ApiModelProperty("费用日期(年月)")
    private String feeDate;


    @ApiModelProperty(name = "可用金额", notes = "可用金额")
    private BigDecimal canUseAmount;


    @ApiModelProperty(name = "本次使用金额", notes = "本次使用金额")
    private BigDecimal thisUseAmount;


    @ApiModelProperty(name = "归口", notes = "归口")
    private String feeBelongCode;
}

