package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 分子公司活动细案dto
 *
 * @author makejava
 * @date 2022-11-28 15:28:18
 */
@Data
@ApiModel(value = "SubComActivityDetailPlanDto", description = "分子公司活动细案dto")
public class SubComActivityDetailPlanDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "分子公司活动细案", notes = "分子公司活动细案")
    private String constituentDetailPlanCode;


    @ApiModelProperty(name = "分子公司活动细案名称", notes = "分子公司活动细案名称")
    private String constituentDetailPlanName;

    @ApiModelProperty(name = "活动模板编码，多个逗号隔开", notes = "活动模板编码，多个逗号隔开")
    private String activityTemplateCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    private String businessFormatCode;


    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    private String orgCode;


    @ApiModelProperty(name = "orgName",value = "组织名称",notes = "组织名称")
    private String orgName;


    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;


    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;


    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码",notes = "销售部门编码")
    private String salesOrgCode;


    @ApiModelProperty(name = "salesOrgName",value = "销售部门名称",notes = "销售部门名称")
    private String salesOrgName;


    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    private String salesGroupCode;


    @ApiModelProperty(name = "salesGroupName",value = "销售组名称",notes = "销售组名称")
    private String salesGroupName;

    /**
     * 总申请金额
     */
    @ApiModelProperty(name = "salesGroupName",value = "总申请金额",notes = "总申请金额")
    private BigDecimal totalApplyAmount;


    @ApiModelProperty(name = "processStatus", notes = "审批状态", value = "审批状态")
    private String processStatus;


    @ApiModelProperty(name = "processKey", notes = "审批流程编码", value = "审批流程编码")
    private String processKey;


    @ApiModelProperty("活动状态")
    private String status;


    @ApiModelProperty("分子公司预算信息")
    private List<SubComActivityDetailPlanBudgetDto> budgetList;


    @ApiModelProperty("分子公司明细信息")
    private List<SubComActivityDetailPlanItemDto> itemList;

    @ApiModelProperty("审批流程对象")
    private ProcessBusinessDto processBusiness;

    @ApiModelProperty("是否校验")
    private String validateFlag;



    @ApiModelProperty("活动开始时间(查询用)")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginTime;


    @ApiModelProperty("活动结束时间(查询用)")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;

}

