package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 分子公司活动细案明细预算分摊明细dto
 *
 * @author makejava
 * @date 2022-11-29 16:54:05
 */
@Data
@ApiModel(value = "SubComActivityDetailPlanItemBudgetShareDto", description = "分子公司活动细案明细预算分摊明细dto")
public class SubComActivityDetailPlanItemBudgetShareDto extends TenantFlagOpDto {
    @ApiModelProperty(name = "分子公司活动细案", notes = "分子公司活动细案")
    private String constituentDetailPlanCode;


    @ApiModelProperty(name = "分子公司活动细案明细编码", notes = "分子公司活动细案明细编码")
    private String constituentDetailPlanItemCode;


    @ApiModelProperty("分摊规则")
    private String shareType;


    @ApiModelProperty("费用预算编码")
    private String monthBudgetCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(name = "预算项目编码", notes = "")
    private String budgetItemCode;


    /**
     * 预算项目名称
     */
    @ApiModelProperty(name = "预算项目名称", notes = "")
    private String budgetItemName;

    @ApiModelProperty(name = "归口", notes = "归口")
    private String feeBelongCode;

    /**
     * 销售机构
     */
    @ApiModelProperty("销售机构")
    private String marketOrganization;


    @ApiModelProperty("费用日期(年月)")
    private String yearMonthLy;


    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(name = "费用来源[数据字典:tpm_fee_source]", notes = "")
    private String feeSourceCode;

    /**
     * 归口名字
     */
    @ApiModelProperty(value = "归口名字", notes = "")
    private String feeSourceName;


    @ApiModelProperty(name = "剩余可用金额", notes = "可用金额")
    private BigDecimal currentBalanceAmount;


    @ApiModelProperty("产品编码")
    private String productCode;


    @ApiModelProperty("产品名称")
    private String productName;


    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额", notes = "")
    private BigDecimal useAmount;

    /**
     * 优先级
     */
    @ApiModelProperty(value = "优先级", notes = "")
    private String priorityLevel;


    /**
     * 优先级
     */
    @ApiModelProperty(value = "比例")
    private String ratio;

    /**
     * 关闭金额
     */
    @ApiModelProperty("关闭金额")
    private BigDecimal closeAmount;
}

