package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 分子公司活动细案明细产品分摊明细dto
 *
 * @author makejava
 * @date 2022-11-29 16:55:23
 */
@Data
@ApiModel(value = "SubComActivityDetailPlanItemProductShareDto", description = "分子公司活动细案明细产品分摊明细dto")
public class SubComActivityDetailPlanItemProductShareDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "分子公司活动细案", notes = "分子公司活动细案")
    private String constituentDetailPlanCode;



    @ApiModelProperty(name = "分子公司活动细案明细编码", notes = "分子公司活动细案明细编码")
    private String constituentDetailPlanItemCode;

    @ApiModelProperty(name = "分子公司活动细案明细名称", notes = "分子公司活动细案明细名称")
    private String constituentDetailPlanItemName;



    @ApiModelProperty("产品编码")
    private String productCode;


    @ApiModelProperty("产品名称")
    private String productName;


    /**
     * 产品比例
     */
    @ApiModelProperty(value = "产品比例")
    private String productRatio;


    /**
     * 单价优惠金额
     */
    @ApiModelProperty(value = "单价优惠金额", notes = "")
    private BigDecimal discountAmount;

    /**
     * 点外金额
     */
    @ApiModelProperty(value = "点外金额", notes = "")
    private BigDecimal offAmount;

    /**
     * 点内金额
     */
    @ApiModelProperty(value = "点内金额", notes = "")
    private BigDecimal internalAmount;

    /**
     * 自投金额
     */
    @ApiModelProperty(value = "自投金额", notes = "")
    private BigDecimal autoAmount;

    /**
     * 总金额
     */
    @ApiModelProperty(value = "总金额", notes = "")
    private BigDecimal totalAmount;
}

