package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto;


import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "SubComActivityDetailPlanPlanDto", description = "分子公司活动细案")
@Getter
@Setter
public class SubComActivityDetailPlanPlanDto extends TenantFlagOpDto {
    /**
     * 分子公司活动细案
     */
    @ApiModelProperty(name = "分子公司活动细案", notes = "分子公司活动细案")
    private String constituentDetailPlanCode;
    /**
     * 分子公司活动细案明细编码
     */
    @ApiModelProperty(name = "分子公司活动细案明细编码", notes = "分子公司活动细案明细编码")
    private String constituentDetailPlanItemCode;
    /**
     * 关联类型
     */
    @ApiModelProperty("关联类型")
    private String associationType;
    /**
     * 承接方式
     */
    @ApiModelProperty("承接方式")
    private String undertakingMode;

    /**
     * 方案编码/活动细案编码
     */
    @ApiModelProperty("方案编码/活动细案编码")
    private String planCode;
    /**
     * 方案明细编码/活动细案明细编码
     */
    @ApiModelProperty("方案明细编码/活动细案明细编码")
    private String planDetailCode;
    /**
     * 方案名称/活动细案名称
     */
    @ApiModelProperty("方案名称/活动细案名称")
    private String planName;
    /**
     * 方案名称/细案类型
     */
    @ApiModelProperty("方案名称/细案类型")
    private String planType;
    /**
     * 方案/细案开始时间
     */
    @ApiModelProperty("方案/细案开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String beginDateStr;
    /**
     * 方案/细案结束时间
     */
    @ApiModelProperty("方案/细案结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDateStr;
    /**
     * 预估费用 -我方承担金额
     */
    @ApiModelProperty("预估费用 -我方承担金额")
    private BigDecimal feeAmount;
    /**
     * 已向下规划金额
     */
    @ApiModelProperty(value = "已向下规划金额", notes = "")
    private BigDecimal downAmount;
    /**
     * 剩余向下规划金额
     */
    @ApiModelProperty(value = "剩余向下规划金额", notes = "")
    private BigDecimal reminderDownAmount;
    /**
     * 方案目的
     */
    @ApiModelProperty("方案目的")
    private String planGoal;
    /**
     * 细案说明
     */
    @ApiModelProperty("细案说明")
    private String detailPlanExplain;


}
