package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 分子公司活动细案产品统计表dto
 *
 * @author makejava
 * @date 2022-11-30 16:29:05
 */
@Data
@ApiModel(value = "SubComActivityProductStatisticalInfoDto", description = "分子公司活动细案产品统计表dto")
public class SubComActivityProductStatisticalInfoDto extends TenantFlagOpDto {

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearMonthly;


    @ApiModelProperty("组织编码")
    private String orgCode;


    @ApiModelProperty("组织名称")
    private String orgName;


    @ApiModelProperty(name = "分子公司活动细案编码", notes = "分子公司活动细案编码")
    private String constituentDetailPlanCode;


    @ApiModelProperty(name = "分子公司活动细案名称", notes = "分子公司活动细案名称")
    private String constituentDetailPlanName;


    @ApiModelProperty(value = "总预估销量", notes = "")
    private BigDecimal totalForecastSales;


    @ApiModelProperty(value = "总预估成本", notes = "")
    private BigDecimal totalForecastCost;


    @ApiModelProperty(value = "总预估销售额", notes = "")
    private BigDecimal totalForecastSalesVolume;


    @ApiModelProperty(value = "总预估毛利", notes = "")
    private BigDecimal totalForecastGrossProfit;


    @ApiModelProperty(value = "申请费用", notes = "")
    private BigDecimal applyFee;


    @ApiModelProperty(value = "投产比", notes = "")
    private BigDecimal productionRatio;


    @ApiModelProperty(value = "是否超预算", notes = "")
    private String isOverBudget;

    @ApiModelProperty(value = "产品统计明细", notes = "")
    private List<SubComActivityProductStatisticalItemInfoDto> statisticalItemInfos;
}

