package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 分子公司活动细案明细产品统计明细表dto
 *
 * @author makejava
 * @date 2022-11-30 16:30:54
 */
@Data
@ApiModel(value = "SubComActivityProductStatisticalItemInfoDto", description = "分子公司活动细案明细产品统计明细表dto")
public class SubComActivityProductStatisticalItemInfoDto extends TenantFlagOpDto {



    @ApiModelProperty(name = "分子公司活动细案编码", notes = "分子公司活动细案编码")
    private String constituentDetailPlanCode;


    @ApiModelProperty(name = "分子公司活动细案名称", notes = "分子公司活动细案名称")
    private String constituentDetailPlanName;


    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;


    @ApiModelProperty(value = "预估销量", notes = "")
    private BigDecimal forecastSales;


    @ApiModelProperty(value = "预估成本", notes = "")
    private BigDecimal forecastCost;


    @ApiModelProperty(value = "预估销售额", notes = "")
    private BigDecimal forecastSalesVolume;


    @ApiModelProperty(value = "预估毛利", notes = "")
    private BigDecimal forecastGrossProfit;


    /**
     * 标准供货价
     */
    @ApiModelProperty(value = "标准供货价", notes = "")
    private BigDecimal standardSupplyPrice;

    /**
     * 促销费用 promotion
     */

    @ApiModelProperty(name = "promotionPrice", notes = "促销价")
    private BigDecimal promotionPrice;
}

